//===============================================================
//
// 					    cs:go
//						Version 0.1
// 						by Dima-kun
//				CopyRight  SAMP-RUS TEAM 2015 
// 		    
//			      
//
//===============================================================

#if defined d_messages_included
	#endinput
#endif
#define d_messages_included

/*
	native sendMessage( playerid, string[] ); //  
	native clearMessages( playerid ); //  
	native loadTextDraws( playerid ); //  
	native unloadTextDraws( playerid ); //  
*/

//===============================================================
//
// 			      . 
//				   1 .
//
//===============================================================
#define MAX_MESSAGE_LENGTH 100

//===============================================================
//
// 			,   
//
//===============================================================
static 
	playerMessages[ MAX_PLAYERS ][ 6 ][ MAX_MESSAGE_LENGTH ],
	PlayerText: messages[ MAX_PLAYERS ][ 6 ];

//===============================================================
//
// 	: loadTextDraws( playerid ) -  .
// 		:
//			playerid - ID ,    .
//		    .
//		
//		     OnPlayerConnect
//
//===============================================================
stock bool:loadTextDraws( const playerid )
{
	for( new i = 0; i < 6; i++ )
	{
		messages[ playerid ][ i ] = CreatePlayerTextDraw( playerid, 12.000017, 275.706573 + ( i * 10 ), "" );
		PlayerTextDrawLetterSize( playerid, messages[ playerid ][ i ], 0.200799, 0.713066 );
		PlayerTextDrawAlignment( playerid, messages[ playerid ][ i ], 1 );
		PlayerTextDrawColor( playerid, messages[ playerid ][ i ], -1 );
		PlayerTextDrawUseBox( playerid, messages[ playerid ][ i ], true );
		PlayerTextDrawBoxColor( playerid, messages[ playerid ][ i ], 0 );
		PlayerTextDrawSetShadow( playerid, messages[ playerid ][ i ], 0 );
		PlayerTextDrawSetOutline( playerid, messages[ playerid ][ i ], 0 );
		PlayerTextDrawBackgroundColor( playerid, messages[ playerid ][ i ], 51 );
		PlayerTextDrawFont( playerid, messages[ playerid ][ i ], 2 );
		PlayerTextDrawSetProportional( playerid, messages[ playerid ][ i ], 1 );
	}
	return true;
}

//===============================================================
//
// 	: sendMessage( playerid, string[] ) -   
// 		:
//			playerid - ID ,    
//			string[] -  .    ~r~  .)
//		    .
//
//===============================================================
stock bool:sendMessage( const playerid, string[] )
{
	for( new i = 5; i > 0; i-- )
		strmid( playerMessages[ playerid ][ i ], playerMessages[ playerid ][ i - 1 ], 0, strlen( playerMessages[ playerid ][ i - 1 ] ), 255 );
	strmid( playerMessages[ playerid ][ 0 ], toRus( string ), 0, strlen( string ), 255 );
	for( new i = 0; i < 6; i++ )
		PlayerTextDrawSetString( playerid, messages[ playerid ][ i ], playerMessages[ playerid ][ i ] );
	return true;
}

//===============================================================
//
// 	: clearMessages( playerid ) -   
// 		:
//			playerid - ID ,    
//		    .
//
//===============================================================
stock bool:clearMessages( const playerid )
{
	for( new i = 0; i < 6; i++ )
		strmid( playerMessages[ playerid ][ i ], "", 0, 0, 255 );
    for( new i = 0; i < 6; i++ )
		PlayerTextDrawSetString( playerid, messages[ playerid ][ i ], playerMessages[ playerid ][ i ] );
	return true;
}

//===============================================================
//
// 	: unloadTextDraws( playerid ) -  .
// 		:
//			playerid - ID ,      
//		    .
//		
//		     OnPlayerDisconnect
//
//===============================================================
stock bool:unloadTextDraws( const playerid )
{
	clearMessages( playerid );
	for( new i = 0; i < 6; i++ )
	{
	    PlayerTextDrawHide( playerid, messages[ playerid ][ i ] );
		PlayerTextDrawDestroy( playerid, messages[ playerid ][ i ] );
	}
	return true;
}

//===============================================================
//
// 	: toRus( string[] )) -      
// 		:
//			string[] -  .
//		     
//
//===============================================================
stock toRus( string[] )
{
	new
		result[ 128 ];

	for ( new i = 0; i < 128; i++ )
	{
		switch ( string[ i ] )
		{
			case '','': result[ i ] = 'A';
			case '','': result[ i ] = '';
			case '','': result[ i ] = 'B';
			case '','': result[ i ] = '';
			case '','': result[ i ] = '';
			case '','': result[ i ] = 'E';
			case '','': result[ i ] = 'E';
			case '','': result[ i ] = '';
			case '','': result[ i ] = '';
			case '','': result[ i ] = '';
			case '','': result[ i ] = '';
			case '','': result[ i ] = 'K';
			case '','': result[ i ] = '';
			case '','': result[ i ] = 'M';
			case '','': result[ i ] = '';
			case '','': result[ i ] = 'O';
			case '','': result[ i ] = '';
			case '','': result[ i ] = 'P';
			case '','': result[ i ] = 'C';
			case '','': result[ i ] = '';
			case '','': result[ i ] = 'Y';
			case '','': result[ i ] = 'F';
			case '','': result[ i ] = 'X';
			case '','': result[ i ] = ' ';
			case '','': result[ i ] = '';
			case '','': result[ i ] = '';
			case '','': result[ i ] = '';
			case '','': result[ i ] = '';
			case '','': result[ i ] = '';
			case '','': result[ i ] = '';
			case '','': result[ i ] = '';
			case '','': result[ i ] = '';
			case '','': result[ i ] = '';
			default: result[ i ] = string[ i ];
		}
	}
	return result;
}