
#include <a_samp>

#undef MAX_PLAYERS
#define MAX_PLAYERS 20

#include <d_includes>

#define white 0xffffffff

enum
{
    TEST_INTEGER,
    TEST_STRING
}

public OnFilterScriptInit()
{
	print("\n--------------------------------------");
	print("     d_includes");
	print("--------------------------------------\n");

	printf( "test randomEx:%i", randomEx( 5, 15 ) );
	new
		veh = AddStaticVehicle( 560, 0, 0, 0, 0, 0, 0 );

    printf( "[TEST] IsValidVehicle(veh) = %i", IsValidVehicle( veh ) );
    DestroyVehicle( veh );
    printf( "[TEST] IsValidVehicle(veh) = %i", IsValidVehicle( veh ) );
    printf( "Heapspace: %i kilobytes", heapspace() / 1024 );
	createAvtomat( 1, "Avtomat", white, 1960.2013, 1340.4775, 15.3746, 0.0, 0.0, 0.0, 0, 5 );
	CreateVehicle( 560, 0.0, 0.0, 0.0, 0.0, 0, 0, 1000 );
	CreateVehicle( 520, 0.0, 0.0, 0.0, 0.0, 0, 0, 1000 );
	CreateVehicle( 560, 0.0, 0.0, 0.0, 0.0, 0, 0, 1000 );
	CreateVehicle( 555, 0.0, 0.0, 0.0, 0.0, 0, 0, 1000 );
	printf( "* Total avtomats: %i ", getNumAvtomats() );
	printf( "* Test getVehicleIDbyName(\"Sultan\") result- %i ", getVehicleIDbyName( "Sultan" ) );
	printf( "* Test getVehicleNumbyName(\"Sultan\") num- %i pts", getVehicleNumbyName( "Sultan" ) );
	printf( "* Test getVehicleNumbyModel(\"560\") num- %i pts", getVehicleNumbyModel( 560 ) );
	printf( "* Test getVehicleName( %s )", getVehicleName( 2 ) );
	printf( "* Total vehicles: %i ", GetVehiclePoolSize() );
	printf( "* Total objects: %i ", getObjectPoolSize() );
	printf( "* Total pickups: %i ", getPickupPoolSize() );
	printf( "* stringToInt( 'vsya' ) %i  ", stringToInt( "vsyaA" ) );
	vsi:TEST_INTEGER[ veh ] = 2522;
    printf( "[TEST] vsi:TEST_INTEGER[ veh ] = %i", vgi:TEST_INTEGER[ veh ] );
    vss:TEST_STRING[ veh ] = "DADA";
    printf( "[TEST] vss:TEST_STRING[ veh ] = %s", vgs:TEST_STRING[ veh ] );
	enebleVehicleDamage();
	maxHealth( 50.0 );
	allowAdminTeleport();
	enebleNotLoggedSpawn();
	setDisabledWeapons( 22, 28, 31 );
	setPlayerAccountDirectory( "Accounts/%s.acc" );
	setStartMoney( 1000 );
	setMinimumMapIconID( 0 );
	enebleHeadShot( true );
	addWeatherZone( 8, 141.2399, -74.5677, 231.4296, -211.8720 ); // d_weather.inc
	addWeatherZone( 18, 286.0312,-74.8772, 325.1937, -204.4950 ); // d_weather.inc
	//fmove( "pen01.cfg", "", "Test" );
	//fcopy( "sbizz.cfg", "copy.sbiz" );
	return 1;
}

public OnFilterScriptExit()
{
    destroyAllAvtomats();
    destroyWeapon( 0 );
    destroyWeapon( 1 );
	return 1;
}

public OnPlayerConnect( playerid )
{
	printf( "OnPlayerConnect * Total players: %i ", numPlayers() );
	printf( "* Total player objects: %i ", getPlayerObjectPoolSize( playerid ) );
	new
		string[ 128 ];

    printf( "* %s(ID:%i)    [IP:%s]", getPlayerName( playerid ), playerid, getPlayerIp( playerid ) );
    format( string, sizeof( string ), "* %s(ID:%i)     IP: %s\r\n", getPlayerName( playerid ), playerid, getPlayerIp( playerid ) );
    log( "logs/connect.log", string );
    if( isPlayerRegistred( playerid ) == 1 )
        SendClientMessage( playerid, COLOR_WHITE, "SERVER:  .       - {00FF00}/login []" );
	else
	    SendClientMessage( playerid, COLOR_WHITE, "SERVER:   .  {00FF00}/register [] {FFFFFF} ." );
    return 1;
}

public OnPlayerDisconnect( playerid, reason )
{
    if( isPlayherLableExists( playerid ) )
    	deletePlayer3DtextLableEx( playerid );
	return 1;
}

public OnPlayerRequestSpawn( playerid )
{
	return 1;
}

public OnPlayerSpawn( playerid )
{
    if( !isPlayherLableExists( playerid ) )
    	createPlayer3DtextLableEx( playerid, "Test lable", COLOR_GREEN );
	setPlayerCheckpoint( playerid, 1953.3220, 1322.2579, 9.2578, 3.0, 10.0, 2, MAPICON_GLOBAL );
	printf( "[debug] OnPlayerSpawn( %i )", playerid );
    TogglePlayerControllable( playerid, true );
	return 1;
}

public onPlayerSuicide( playerid, reason )
{
 	sendFormatedMessageToAll( COLOR_RED, "* %s(ID:%i) . (%s)", getPlayerName( playerid ), playerid, getDeathReason( reason ) );
 	printf( "[debug] onPlayerSuicide( playerid-%i, reason-%i )", playerid, reason );
 	asi:pdeath[ playerid ] += 1;
	return 1;
}

public OnPlayerUpdate( playerid )
{
    /*if( isPlayerJump( playerid ) )
       SendClientMessage(playerid, 0xFFFFFFFF, "JUMP" );
	if( isPlayerDropDown( playerid ) )
       SendClientMessage(playerid, 0xFFFFFFFF, "DROPDOWN" );*/
    return 1;
}

public OnPlayerPickUpPickup( playerid, pickupid )
{
    printf( "test:OnPlayerPickUpPickup %i %i", playerid, pickupid );
	return 1;
}

public OnDialogResponse( playerid, dialogid, response, listitem, inputtext[] )
{
	return 1;
}

public OnPlayerText( playerid, text[] )
{
    printf( "test:OnPlayerText %i %s", playerid, text );
    if( isAdvertising( text ) )
    {
        SendClientMessage( playerid, COLOR_WHITE, "*     !" );
        return 0;
	}
	return 1;
}

public OnPlayerCommandText( playerid, cmdtext[] )
{
	new
	    idx,
	    cmd[ 128 ],
		tmp[ 128 ];

	cmd = strcharsplit( cmdtext, idx, ' ' );
// Example to some funcs d_players.inc
    if( !strcmp( "/camup", cmd, true ) )
		return tooglePlayerCameraUp( playerid, true, 20.0 );
    if( !strcmp( "/camdown", cmd, true ) )
		return tooglePlayerCameraUp( playerid, false, 0.0 );
// Example to d_register.inc
    if( !strcmp( "/login", cmd, true ) )
	{
	    tmp = strcharsplit( cmdtext, idx, ' ' );
	    if( !strlen( tmp ) )
	        return SendClientMessage( playerid, COLOR_WHITE, ": /login []" );
		loginPlayer( playerid, tmp );
		return 1;
	}
	if( !strcmp( "/register", cmd, true ) )
	{
	    tmp = strcharsplit( cmdtext, idx, ' ' );
	    if( !strlen( tmp ) )
	        return SendClientMessage( playerid, COLOR_WHITE, ": /register []" );
		registerPlayer( playerid, tmp );
		return 1;
	}
// Example to d_admins.inc
	if( !strcmp( "/goto", cmd, true ) )
	{
	    tmp = strcharsplit( cmdtext, idx, ' ' );
	    if( !strlen( tmp ) )
	        return SendClientMessage( playerid, COLOR_WHITE, ": /goto [playerid]" );
	    new
	        targetid = strval( tmp );

        if( !IsPlayerConnected( targetid ) )
		    return SendClientMessage( playerid, COLOR_WHITE, "SERVER:   " );
		if( IsPlayerAdmin( playerid ) )
		    gotoPlayer( playerid, targetid );
	    return 1;
	}
	if( !strcmp( "/slap", cmd, true ) )
	{
	    tmp = strcharsplit( cmdtext, idx, ' ' );
	    if( !strlen( tmp ) )
	        return SendClientMessage( playerid, COLOR_WHITE, ": /slap [playerid]" );
	    new
	        targetid = strval( tmp );

        if( !IsPlayerConnected( targetid ) )
		    return SendClientMessage( playerid, COLOR_WHITE, "SERVER:   " );
		if( IsPlayerAdmin( playerid ) )
		    slapPlayer( targetid );
	    return 1;
	}
	if( !strcmp( "/gethere", cmd, true ) )
	{
	    tmp = strcharsplit( cmdtext, idx, ' ' );
	    if( !strlen( tmp ) )
	        return SendClientMessage( playerid, COLOR_WHITE, ": /gethere [playerid]" );
	    new
	        targetid = strval( tmp );

        if( !IsPlayerConnected( targetid ) )
		    return SendClientMessage( playerid, COLOR_WHITE, "SERVER:   " );
		if( IsPlayerAdmin( playerid ) )
		    getherePlayer( playerid, targetid );
	    return 1;
	}
	if( !strcmp( "/adm", cmd, true ) )
	{
	    new
	        admins[ 256 ];

		admins = showRconAdmins();
		if( !strlen( admins ) )
			format( admins, sizeof( admins ), "No Admins on server" );
	    ShowPlayerDialog( playerid, 9999, DIALOG_STYLE_MSGBOX, "Admins:", admins, "Ok", "" );
	    return 1;
	}
	if( !strcmp( "/mute", cmd, true ) )
	{
	    tmp = strcharsplit( cmdtext, idx, ' ' );
	    if( !strlen( tmp ) )
	        return SendClientMessage( playerid, COLOR_WHITE, ": /mute [playerid]" );
	    new
	        targetid = strval( tmp );

		if( IsPlayerConnected( targetid ) )
		    return SendClientMessage( playerid, COLOR_WHITE, "SERVER:   " );
		if( IsPlayerAdmin( playerid ) )
		{
		    if( isPlayerMuted( targetid ) == 1 )
		    {
		        SendClientMessage( playerid, COLOR_WHITE, "SERVER:    ID     ." );
		        setPlayerMute( targetid, 0 );
		        return 1;
		    }
		    else
		    {
		        SendClientMessage( playerid, COLOR_WHITE, "SERVER:    ID      ." );
		        setPlayerMute( targetid, 1 );
		        return 1;
		    }
		}
	    return 1;
	}
	if( !strcmp( "/freeze", cmd, true ) )
	{
	    new
			targetid,
	        freezetime;

	    tmp = strcharsplit( cmdtext, idx, ' ' );
	    if( !strlen( tmp ) )
	        return SendClientMessage( playerid, COLOR_WHITE, ": /freeze [playerid] [ ]" );
		targetid = strval( tmp );
        tmp = strcharsplit( cmdtext, idx, ' ' );
	    if( !strlen( tmp ) )
	        return SendClientMessage( playerid, COLOR_WHITE, ": /freeze [playerid] [ ]" );
		freezetime = strval( tmp );
		if( IsPlayerAdmin( playerid ) )
   			togglePlayerFreezeEx( targetid, freezetime );
   		return 1;
	}
	if( !strcmp( "/boom", cmd, true ) )
	{
	    new
			targetid;

	    tmp = strcharsplit( cmdtext, idx, ' ' );
	    if( !strlen( tmp ) )
	        return SendClientMessage( playerid, COLOR_WHITE, ": /boom [playerid]" );
		targetid = strval( tmp );
        if( IsPlayerAdmin( playerid ) )
   			BlowUpPlayer( targetid );
   		return 1;
	}
	if( !strcmp( "/cage", cmd, true ) )
	{
	    new
			targetid;

	    tmp = strcharsplit( cmdtext, idx, ' ' );
	    if( !strlen( tmp ) )
	        return SendClientMessage( playerid, COLOR_WHITE, ": /cage [playerid]" );
		targetid = strval( tmp );
        if( IsPlayerAdmin( playerid ) )
   			cagePlayer( targetid );
   		return 1;
	}
	if( !strcmp( "/uncage", cmd, true ) )
	{
	    new
			targetid;

	    tmp = strcharsplit( cmdtext, idx, ' ' );
	    if( !strlen( tmp ) )
	        return SendClientMessage( playerid, COLOR_WHITE, ": /uncage [playerid]" );
		targetid = strval( tmp );
        if( IsPlayerAdmin( playerid ) )
   			unCagePlayer( targetid );
   		return 1;
	}
	if( !strcmp( "/select", cmd, true ) )
	{
		showSelectTable( playerid, 1, 1, 10, COLOR_PINK );
		return 1;
	}
	if( !strcmp( "/crash", cmd, true ) )
	{
		crashPlayer( playerid );
		printf( "playercrashed:%i", playerid );
		return 1;
	}
	if( !strcmp( "/dialog", cmd, true ) )
	{
		ShowPlayerDialog(playerid, 1, 1, "sdf ", "sdf ", "sd ", "sdf");
		return 1;
	}
	if( !strcmp( "/close", cmd, true ) )
	{
		ShowPlayerDialog(playerid, -1, 1, " ", " ", " ", "");
		return 1;
	}
	if( !strcmp( "/changename", cmd, true ) )
	{
	    tmp = strcharsplit( cmdtext, idx, ' ' );
	    if( !strlen( tmp ) )
	        return SendClientMessage( playerid, COLOR_WHITE, ": /changename [playername]" );
		changeNickName( playerid, tmp );
   		return 1;
	}
	if( !strcmp( "/changepass", cmd, true ) )
	{
		if( !isPlayerLogged( playerid ) )
		    return SendClientMessage( playerid, COLOR_WHITE, "SERVER:      !" );
	    tmp = strcharsplit( cmdtext, idx, ' ' );
	    if( !strlen( tmp ) )
	        return SendClientMessage( playerid, COLOR_WHITE, ": /changepass [ ] [ ]" );
		if ( strcmp( gs:PASSWORD[ playerid ],  tmp,  true,  strlen( gs:PASSWORD[playerid] ) ) && strlen( tmp ) == strlen( gs:PASSWORD[playerid] ) )
		    return SendClientMessage( playerid, COLOR_WHITE, "SERVER:      !" );
        tmp = strcharsplit( cmdtext, idx, ' ' );
	    if( !strlen( tmp ) )
	        return SendClientMessage( playerid, COLOR_WHITE, ": /changepass [ ] [ ]" );
		if( changePassword( playerid, tmp ) )
		    SendClientMessage( playerid, COLOR_WHITE, "SERVER:  !" );
		else
		    SendClientMessage( playerid, COLOR_WHITE, "SERVER:       1    20 ." );
	}
	return 0;
}

public OnPlayerKeyStateChange( playerid, newkeys, oldkeys )
{
//if( PRESSED( KEY_SPRINT | KEY_JUMP ) )
	//	return SendClientMessage( playerid, COLOR_WHITE, " + " );
	if( newkeys & KEY_SPRINT )
		return SendClientMessage( playerid, COLOR_WHITE, "" );
	if( oldkeys & KEY_SPRINT )
		return SendClientMessage( playerid, COLOR_WHITE, " " );
	return 1;
}

// =============================================================================
// Custom Callbacks.
// =============================================================================
public onPlayerAFK( playerid )
{
	return 1;
}

public OnPlayerBuyDrink( playerid )
{
	printf( "Player %s[ID:%i]  .", getPlayerName( playerid ), playerid );
	return 1;
}

public OnPlayerSwiming(playerid)
{
	//   ID-playerid .
	return 1;
}

public OnPlayerTarget(playerid, targetid)
{
    printf( "Player %s[ID:%i] has target %s[ID:%i].", getPlayerName( playerid ), playerid, getPlayerName( targetid ), targetid );
	return 1;
}
// to d_pickups.inc
public OnMTApickupCreate(pickupid, pictype)
{
	//    . ( -)
	return 1;
}

public OnVehicleColoured(playerid, vehicleid, pickupid, newcolor1, newcolor2)
{
	//      ( -)
	return 1;
}

public OnVehicleBoom(playerid, vehicleid, pickupid)
{
	//     ( -)
	return 1;
}

public OnVehicleRepair(playerid, vehicleid, pickupid)
{
	//     ( -)
	return 1;
}

public OnVehicleChangeModel(playerid, vehicleid, newmodel, oldmodel)
{
	//      ( -)
	return 1;
}
// end d_pickups.inc
// to d_select.inc
public onPlayerSelectShow( playerid, selectid )
{
	printf( "public onPlayerSelectShow( playerid = %i, selectid = %i )", playerid, selectid );
	return 1;
}

public onPlayerSelect( playerid, selectid, selectpoint )
{
    printf( "public onPlayerSelect( playerid = %i, selectid =%i, selectpoint=%i )", playerid, selectid, selectpoint );
    return 1;
}

public onPlayerSelected( playerid, selectid, selectpoint )
{
    printf( "public onPlayerSelected( playerid = %i, selectid =%i, selectpoint=%i )", playerid, selectid, selectpoint );
	return 1;
}

public onPlayerCancel( playerid, oldselectid )
{
    printf( "public onPlayerCancel( playerid = %i, oldselectid = %i )", playerid, oldselectid );
	return 1;
}
// END d_select.inc
// START d_register.inc
public onPlayerLogin( playerid, result, File:account )
{
	switch( result )
	{
	    case REGISTER_ACCOUNT_LOGGIN: //   
	    {
			si:pmoney[ playerid ] = loadPlayerInfoInt( account, "Money" );
			si:pscore[ playerid ] = loadPlayerInfoInt( account, "Score" );
			si:pdeath[ playerid ] = loadPlayerInfoInt( account, "Death" );
	        setPlayerMoney( playerid, gi:pmoney[ playerid ] );
	        SetPlayerScore( playerid, gi:pscore[ playerid ] );
			SendClientMessage( playerid, COLOR_WHITE, "SERVER:      !" );
	        return 1;
	    }
		case REGISTER_ACCOUNT_WRONGPASS: //   
	        return SendClientMessage( playerid, COLOR_WHITE, "SERVER:     !" );
		case REGISTER_ACCOUNT_BLOCKED: //  
	        return SendClientMessage( playerid, COLOR_WHITE, "SERVER:   !" );
		case REGISTER_ACCOUNT_NOUSER: //    
	        return SendClientMessage( playerid, COLOR_WHITE, "SERVER:   !" );
	    case REGISTER_ACCOUNT_LOGGED:
	    	return SendClientMessage( playerid, COLOR_WHITE, "SERVER:     !" );
	    default:
	        return print( "onPlayerLogin - unknown result" );
	}
	return 1;
}

public onPlayerRegister( playerid, result, File:account )
{
	switch( result )
	{
	    case REGISTER_ACCOUNT_EXIST: // player account with this name is exist.
	    	return SendClientMessage( playerid, COLOR_WHITE, "SERVER:   !" );
		case REGISTER_ACCOUNT_TOOLONGPASS: // too long password
		    return SendClientMessage( playerid, COLOR_WHITE, "SERVER:   !" );
	    case REGISTER_ACCOUNT_DONE:// registration finished sucessfully
	    {
    		savePlayerInfoInt( account, "Money", GetPlayerMoney( playerid ) );
    		savePlayerInfoInt( account, "Score", GetPlayerScore( playerid ) );
    		savePlayerInfoInt( account, "Death", gi:pdeath[ playerid ] );
    		SendClientMessage( playerid, COLOR_WHITE, "SERVER:   !" );
	        return 1;
	    }
        default:
	        return print( "onPlayerRegister - unknown result" );
    }
	return 1;
}

public onPlayerSave( playerid, result, File:account )
{
    switch( result )
    {
        case REGISTER_ACCOUNT_SAVED:
        {
            savePlayerInfoInt( account, "Money", GetPlayerMoney( playerid ) );
    		savePlayerInfoInt( account, "Score", GetPlayerScore( playerid ) );
    		savePlayerInfoInt( account, "Death", gi:pdeath[ playerid ] );
    		printf( "[callback onPlayerSave()]: Account %s saved", getPlayerName( playerid ) );
            return 1;
        }
        case REGISTER_ACCOUNT_NOUSER:
		{
		    printf( "[callback onPlayerSave()]: Account %s's not found.", getPlayerName( playerid ) );
			return 1;
		}
        case REGISTER_ACCOUNT_NOTLOGGED:
		{
		    printf( "[callback onPlayerSave()]: %s not logged", getPlayerName( playerid ) );
			return 1;
		}
        default:
	        return print( "onPlayerRegister - unknown result" );
    }
	return 1;
}
// END d_register.inc

public onPlayerEnterCheckpoint( playerid, checkpointid )
{
	switch( checkpointid )
	{
		case 1: return SendClientMessage( playerid, 0xffffffff, "* ?? ????? ? CHECKPOINT_ONE" );
		case 2: return SendClientMessage( playerid, 0xffffffff, "* ?? ????? ? CHECKPOINT_TWO" );
		case 3: return SendClientMessage( playerid, 0xffffffff, "* ?? ????? ? CHECKPOINT_THREE" );
	    default: print( "Unknown type checkpoint" );
	}
	return 1;
}

// Friendlyfire:
public onPlayerDamagedFriend( playerid, victim, teamid, Float:damage, weaponid, bodypart )
{
	sendFormatedMessageToAll( 0x9212aa, " %s[ID:%i]    ", getPlayerName( playerid ) );
	return 1;
}

// d_buttons.inc:
BTN:fire( playerid, keyid )
{
	SendClientMessage( playerid, 0xffffffff, "" );
	return 1;
}

BTN:getin_out( playerid, keyid )
{
	SendClientMessage( playerid, 0xffffffff, "/  " );
	return 1;
}

BTN:horn( playerid, keyid )
{
	SendClientMessage( playerid, 0xffffffff, "" );
	return 1;
}

BTN:aim( playerid, keyid )
{
	SendClientMessage( playerid, 0xffffffff, "" );
	return 1;
}

BTN:ctrl_enter( playerid, keyid )
{
	SendClientMessage( playerid, 0xffffffff, "Ctrl+enter" );
	return 1;
}
