/******************************************************************************************************************************************

		-----------------------------------------------------------------------------------------------
			functions/d_admins.inc - , ,    .
		-----------------------------------------------------------------------------------------------

					-----------------------------------------------------------
						    SA-MP V0.3.7 RC2   
					-----------------------------------------------------------

------------------------------------------------------------------------------------------------------------------------------	

	  :
		V1.0 BUILD 1000  04.03.2015

------------------------------------------------------------------------------------------------------------------------------

	 :
		04.03.2015 -      
		
------------------------------------------------------------------------------------------------------------------------------

	   :
		native toggleServerLog(bool:status); //       
		native slapPlayer(playerid); //  ,     
		native gotoPlayer(playerid, targetid); //     
		native getherePlayer(playerid, targetid); //     
		native gethereAll(playerid); //     
		native setPlayerMute(playerid, bool: statu ); // /      
		native bool:isPlayerMuted(playerid); //  ""  .
		native BlowUpPlayer(targetid); //  
		native BlowUpVehicle(vehicleid); //  
		native isAdvertising(text[]); //        .
		native isIpAdress(string[]); //      IP-
		native bool:isAdminsOnline(); //    -  rcon  
		native sendMessageToAdmins( color, msg[] ); //   RCON-
		native setAdminsColor(color); //         (  RCON-  ) RCON-
		native cagePlayer(targetid); //       
		native unCagePlayer(targetid); //    
		native reloadFS(fsname[]); //  
		native runOffServer(); //  
		native restartServer(); //  
		native sendMessageAsAdmin( message[] ); //      (Admin)
		native allowAdminTeleport(); //    rcon-    .(  )
		native crashPlayer(playerid); //  crash  .
		native togglePlayerFreezeEx(playerid, time); //     

------------------------------------------------------------------------------------------------------------------------------

	    :
		      Dima-kun a.k.a Morino_Reigan
	
	 :
		   SA-MP SAMP-RUS.COM     
		SA-MP TEAM  San Andreas-MultiPlayer
		Rockstar North Games  Grand Theft Auto San Andreas

	            : http://samp-rus.com
	
*******************************************************************************************************************************************/

#if defined d_includes_admins
	#endinput
#endif
#define d_includes_admins

/*

	:
		toggleServerLog(bool:status) -       
	:
		bool:status - true -  / false -  .
	    .

*/

stock bool:toggleServerLog( bool:status )
{
	_gdebug = status;
	return true;
}

/*

	:
		slapPlayer(playerid) -  ,     
	:
		playerid - ID ,   
	    .

*/

stock bool:slapPlayer( const playerid )
{
	new
		Float: slx,
		Float: sly,
		Float: slz;

	givePlayerHealth( playerid, -5 );
	GetPlayerPos( playerid, slx, sly, slz );
	SetPlayerPos( playerid, slx, sly, slz + 5 );
	playSoundAll( 1130, slx, sly, slz + 5 );
	if( _gdebug == true ) printf( "AdmCmd: Player %s slapped ", getPlayerName( playerid ) );
	return true;
}

/*

	:
		gotoPlayer(playerid, targetid) -     
	:
		playerid - ID  
		targetid - ID       playerid
	    .

*/

stock bool:gotoPlayer( const playerid, const targetid )
{
	new
		Float: plocx,
		Float: plocy,
		Float: plocz;

	if ( IsPlayerConnected( targetid ) )
	{
		GetPlayerPos( targetid, plocx, plocy, plocz );
		if( _gdebug == true ) printf( "AdmCmd: %s teleported to  %s", getPlayerName( playerid ), getPlayerName( targetid ) );
		SetPlayerInterior( playerid, GetPlayerInterior( targetid ) );
		if ( GetPlayerState( playerid ) == PLAYER_STATE_DRIVER )
		{
			new
				tmpcar = GetPlayerVehicleID( playerid );

			SetVehiclePos( tmpcar, plocx, plocy + 4, plocz );
			PutPlayerInVehicle( playerid, tmpcar, 0 );
		}
		else
			SetPlayerPos( playerid, plocx, plocy + 2, plocz );
	}
	return true;
}

/*

	:
		getherePlayer(playerid, targetid) -     
	:
		playerid - ID       targetid
		targetid - ID  
	    .

*/

stock bool:getherePlayer( const playerid, const targetid )
{
	new
		Float: plocx,
		Float: plocy,
		Float: plocz;

	if ( IsPlayerConnected( targetid ) )
	{
		GetPlayerPos( playerid, plocx, plocy, plocz );
		if( _gdebug == true ) printf( "AdmCmd: %s teleported to  %s", getPlayerName( targetid ), getPlayerName( playerid ) );
		SetPlayerInterior( targetid, GetPlayerInterior( playerid ) );
		if ( GetPlayerState( targetid ) == PLAYER_STATE_DRIVER )
		{
			new
				tmpcar = GetPlayerVehicleID( targetid );

			SetVehiclePos( tmpcar, plocx, plocy + 4, plocz );
			PutPlayerInVehicle( targetid, tmpcar, 0 );
		}
		else
			SetPlayerPos( targetid, plocx, plocy + 2, plocz );
	}
	return true;
}

/*

	:
		gethereAll(playerid) -     
	:
		playerid - ID       
	    .

*/

stock bool:gethereAll( const playerid )
{
	new
		Float: plocx,
		Float: plocy,
		Float: plocz;

	if( _gdebug == true ) printf( "AdmCmd: %s teleported all to his", getPlayerName( playerid ) );
	for( new i = 0, j = GetPlayerPoolSize(); i <= j; i++ )
	{
		if ( IsPlayerConnected( i ) && i != playerid )
		{
			GetPlayerPos( playerid, plocx, plocy, plocz );
			SetPlayerInterior( targetid, GetPlayerInterior( playerid ) );
			if ( GetPlayerState( i ) == PLAYER_STATE_DRIVER )
			{
				new
					tmpcar = GetPlayerVehicleID( i );

				SetVehiclePos( tmpcar, plocx + ( random( 5 ) - random( 6 ) ), plocy + ( random( 5 ) - random( 6 ) ), plocz );
				PutPlayerInVehicle( i, tmpcar, 0 );
			}
			else
				SetPlayerPos( i, plocx + ( random( 5 ) - random( 6 ) ), plocy + ( random( 5 ) - random( 6 ) ), plocz );
		}
	}
	return true;
}

/*

	:
		showRconAdmins() -     
	 .
	     .   - 256 .

*/

stock showRconAdmins( )
{
	new	
		admins[ 256 ],
		str[ MAX_PLAYER_NAME + 2 ];
	
	for( new i = 0, j = GetPlayerPoolSize(); i <= j; i++ )
	{
		if( strlen( admins ) >= sizeof( admins ) ) break;
		if( IsPlayerConnected( i ) && IsPlayerAdmin( i ) )
		{
			format( str, sizeof( str ), "%s\n", getPlayerName( i ) );
			strcat( admins, str );
		}
			//strmid( admins[ idx ], getPlayerName( i ), 0, strlen( getPlayerName( i ) ), 255 );
	}
	return admins;
}

/*

	:
		setPlayerMute(playerid, bool: status) - /      ("")
	:
		playerid - ID       targetid
		bool: status  - true - ,  false -  
	    .

*/

#define setPlayerMute(%1,%2) si:plmuted[ %1 ] = %2

/*

	:
		bool:isPlayerMuted(playerid) -  ""  .
	:
		playerid - ID       targetid
	  true -   "",  false -   "".

*/

#define isPlayerMuted(%1) gi:plmuted[ %1 ]

/*

	:
		BlowUpPlayer(targetid) -  
	:
		targetid - ID    
	    .

*/

stock bool:BlowUpPlayer( const targetid )
{
	new
		Float:pos[ 3 ];

	GetPlayerPos( targetid, pos[ 0 ], pos[ 1 ], pos[ 2 ] );
	CreateExplosion( pos[ 0 ], pos[ 1 ], pos[ 2 ], 3, 6.0 );
	return true;
}

/*

	:
		BlowUpVehicle(vehicleid) -  
	:
		vehicleid - ID    
	    .

*/

stock bool:BlowUpVehicle( const vehicleid )
{
	new
		Float:pos[ 3 ];

	GetVehiclePos( vehicleid, pos[ 0 ], pos[ 1 ], pos[ 2 ] );
	CreateExplosion( pos[ 0 ], pos[ 1 ], pos[ 2 ], 3, 6.0 );
	return true;
}

/*

	:
		isAdvertising(text[]) -        .
	:
		text[] -  
	  true -       ,  false -      .

*/

stock bool:isAdvertising( const text[] )
{
    if( strfind( text , "www" , true ) != -1 || strfind( text , ".net" , true ) != -1 || strfind( text , ".ru" , true ) != -1
	|| strfind( text , ".com" , true ) != -1 || strfind( text , ". " , true ) != -1 || strfind( text , ".su" , true ) != -1
	|| strfind( text , ".biz" , true ) != -1 || strfind( text , ". ru" , true ) != -1 || strfind( text , ". net" , true ) != -1
	|| strfind( text , ". com" , true ) != -1 || strfind( text , "." , true ) != -1 ) return true;
	return false;
}

/*

	:
		isIpAdress(string[]) -      IP-
	:
		string[] -  
	  true -     IP-,  false -      IP-.

*/

stock bool:isIpAdress( const string[] )
{
	new
		i,
		digits;

	if( ( i = strfind( string, ".", false, 0 ) ) >= 0 )
	{
		for( ++i; ; i++ )
		{
			switch( string[ i ] )
			{
				case ' ': if( digits > 0 ) break; else continue;
				case '0'..'9': digits++;
				default: break;
			}
		}
		if( digits >= 2 ) return true;
	}
	return false;
}

/*
	:
		bool:isAdminsOnline() -    -  rcon  
	 true  , false  .
	
*/

stock bool:isAdminsOnline()
{
	for( new i = 0, j = GetPlayerPoolSize(); i <= j; i++ )
		if( IsPlayerConnected( i ) && IsPlayerAdmin( i ) ) return true;
	return false;
}

/*
	:
		sendMessageToAdmins( color, msg[] ) -   RCON-
	:
		 color -  
		 msg[] - 
	    
	
*/

stock bool:sendMessageToAdmins( color, msg[] )
{
	for( new i = 0, j = GetPlayerPoolSize(); i <= j; i++ )
		if( IsPlayerConnected( i ) && IsPlayerAdmin( i ) )
			SendClientMessage( i, color, msg );
	return true;
}

/*

	:
		setAdminsColor(color) -         (  RCON-  ) RCON-
	:
		color - (Hex)
	    .

*/

stock setAdminsColor( color )
{
	admincolor = color;
	for( new i = 0, j = GetPlayerPoolSize(); i <= j; i++ )
		if( IsPlayerConnected( i ) && IsPlayerAdmin( i ) ) 
			SetPlayerColor( i, color );
	return color;
}

/*

	:
		cagePlayer(targetid) -       
	:
		targetid - ID 
	    .

*/

stock bool:cagePlayer( const targetid )
{
	if( gi:plCaged[ targetid ] == 1 ) return false;
	new 
		Float:pos[ 3 ];

	GetPlayerPos( targetid, pos[ 0 ], pos[ 1 ], pos[ 2 ] );
	si:plCage1[ targetid ] = CreateObject( 985, pos[ 0 ], pos[ 1 ], pos[ 2 ] + 10.0, 0, 0, 0 );
	si:plCage2[ targetid ] = CreateObject( 985, pos[ 0 ] + 4.0 ,pos[ 1 ] - 4.0, pos[ 2 ] + 10.0, 0, 0, 90 );
	si:plCage3[ targetid ] = CreateObject( 985, pos[ 0 ] - 4.0 , pos[ 1 ] - 4.0, pos[ 2 ] + 10.0, 0, 0, 90 );
	si:plCage4[ targetid ] = CreateObject( 985, pos[ 0 ], pos[ 1 ] - 8.0, pos[ 2 ] + 10.0, 0, 0, 0 );
	si:plCage5[ targetid ] = CreateObject( 985, pos[ 0 ], pos[ 1 ] - 4.0, pos[ 2 ] + 8.2, 90, 0, 0 );
	si:plCage6[ targetid ] = CreateObject( 985, pos[ 0 ], pos[ 1 ] - 4.0, pos[ 2 ] + 8.2, 90, 0, 180 );
	SetPlayerPos( targetid, pos[ 0 ], pos[ 1 ] - 2.2, pos[ 2 ] + 11.0 );
	si:plCaged[ targetid ] = 1;
	return true;
}

/*

	:
		unCagePlayer( const targetid ) -    
	:
		targetid - ID 
	    .

*/

stock bool:unCagePlayer( const targetid )
{
	if( gi:plCaged[ targetid ] == 0 ) return false;
	new 
		Float:pos[ 3 ];

	DestroyObject( gi:plCage1[ targetid ] );
	DestroyObject( gi:plCage2[ targetid ] );
	DestroyObject( gi:plCage3[ targetid ] );
	DestroyObject( gi:plCage4[ targetid ] );
	DestroyObject( gi:plCage5[ targetid ] );
	DestroyObject( gi:plCage6[ targetid ] );
	GetPlayerPos( targetid, pos[ 0 ], pos[ 1 ], pos[ 2 ] );
	SetPlayerPos( targetid, pos[ 0 ], pos[ 1 ] + 2.2, pos[ 2 ] - 9.9 );
	si:plCaged[ targetid ] = 0;
	return true;
}

/*

	:
		reloadFS(fsname[]) -  
	:
		fsname[] -  
	    .

*/

stock bool:reloadFS( const fsname[] )
{
	new
		string[ 100 ];

	format( string, sizeof( string ), "unloadfs %s", fsname );
	SendRconCommand( string );
	format( string, sizeof( string ), "loadfs %s", fsname );
	SendRconCommand( string );
	return true;
}

/*

	:
		runOffServer() -  
	   
	    .

*/

#define runOffServer() SendRconCommand( "exit" )

/*

	:
		restartServer() -  
	   
	    .

*/

#define restartServer() SendRconCommand( "gmx" )

/*

	:
		sendMessageAsAdmin( message[] ) -      (Admin)
	:
		message[] -  
	    .

*/

stock sendMessageAsAdmin( const message[] )
{
	new 
		string[ 132 ];

	format( string, sizeof( string ), "say %s", message );
	return SendRconCommand( string );
}

/*

	:
		allowAdminTeleport() -    rcon-    .(  )
	   
	    .

*/

stock bool:allowAdminTeleport()
{
	adTeleport = true;
	return true;
}

/*

	:
		crashPlayer(playerid) -  crash  .
	:
		playerid - ID ,     .
	    .

*/

stock bool:crashPlayer( const playerid )
{
	new 
		Float: pos[ 3 ];

	GetPlayerPos( playerid, pos[ 0 ], pos[ 1 ], pos[ 2 ] );
	si:plCrashObj[ playerid ] = CreatePlayerObject( playerid, 385, pos[ 0 ], pos[ 1 ], pos[ 2 ], 0.0, 0.0, 0.0 );
	return true;
}

/*

 	: 
		togglePlayerFreezeEx(playerid, time) -     
 	:
		playerid - ID  
		time -    
	    .

*/

stock bool:togglePlayerFreezeEx( const playerid, const time )
{
	if( gi:plFreezed[ playerid ] == 1 )
		return false;
	si:plFreezed[ playerid ] = 1;
	TogglePlayerControllable( playerid, false );
	SetTimerEx( "unFreeze", time * 1000, false, "i", playerid );
	return true;
}
//===============================================================
//
// 						 
//
//===============================================================