/******************************************************************************************************************************************

		--------------------------------------------------------------------
			functions/d_avtomats.inc- СИСТЕМА ПОКУПКИ НАПИТКОВ И СИГАРЕТ 
			В АВТОМАТАХ, КОТОРЫЕ МОГУТ БЫТЬ УСТАНОВЛЕННЫ ПРАКТИЧЕСКИ ГДЕ
							УГОДНО В ГОРОДЕ.
		--------------------------------------------------------------------

			-------------------------------------------------------
				ДЛЯ РАБОТЫ НЕОБХОДИМ СЕРВЕР SA-MP V0.3.7 И ВЫШЕ 
			-------------------------------------------------------

------------------------------------------------------------------------------------------------------------------------------		

	ТЕКУЩАЯ ВЕРСИЯ СБОРНИКА:
		V2.2 BUILD 1000 ОТ 10.10.2016

------------------------------------------------------------------------------------------------------------------------------	

	ТЕКУЩАЯ ВЕРСИЯ БИБЛИОТЕКИ:
		V1.0 BUILD 1000 ОТ 02.04.2016

------------------------------------------------------------------------------------------------------------------------------

	ИСТОРИЯ СОБЫТИЙ:
		10.10.2016 - ОБНОВЛЕНИЕ СБОРНИКА БИБЛИОТЕК
		02.04.2015 - ОБНОВЛЕНИЕ СБОРНИКА БИБЛИОТЕК
		04.03.2015 - ВЫХОД ПЕРВОЙ ВЕРСИИ ДАННОГО СБОРНИКА БИБЛИОТЕК
		
------------------------------------------------------------------------------------------------------------------------------

	ФУНКЦИИ БИБЛИОТЕКИ:
		native createAvtomat( type, string[], color, Float:x, Float:y, Float:z, Float:rotx, Float:roty, Float:rotz, virtual, price ); // создает автомат
		native destroyAvtomat( avtomatid ); // удаляет автомат
		native isValidAvtomat( avtomatid ); // проверяет существует ли такой автомат или нет
		native updateAvtomat( avtomatid, newtype, newstring[], newcolor, Float:newx, Float:newy, Float:newz, Float:newrotx, Float:newroty, Float:newrotz, newvirtual, newprice ); // обновляет автомат			
		native getNumAvtomats(); // считает сколько на сервере автоматов

------------------------------------------------------------------------------------------------------------------------------

	АВТОРСКИЕ ПРАВА К СБОРТНИКУ БИБЛИОТЕК:
		ВСЕ ПРАВА НА ЭТОТ СБОРНИК ПРИНАДЛЕЖАТ Dima-kun a.k.a Morino_Reigan
	
	ОТДЕЛЬНАЯ БЛАГОДАРНОСТЬ:
		ПОРТАЛУ РУССКОГО КОМЬЮНИТИ SA-MP SAMP-RUS.COM ЗА РАСПРОСТРАНЕНИЕ ДАННОГО СБОРНИКА БИБЛИОТЕК
		SA-MP TEAM ЗА San Andreas-MultiPlayer
		Rockstar North Games ЗА Grand Theft Auto San Andreas

	РАСПРОСТРАНЕНИЕ ДАННОГО СБОРНИКА БИБЛИОТЕК ВОЗМОЖНА ТОЛЬКО С СОХРАНЕНИЕМ ИМЕНИ АВТОРА И УКАЗАНИЕМ ИСТОЧНИКА: http://samp-rus.com
	
*******************************************************************************************************************************************/

#if defined d_includes_avtomats
	#endinput
#endif
#define d_includes_avtomats 1

/*

	Функция: 
		createAvtomat( type, string[], color, Float:x, Float:y, Float:z, Float:rotx, Float:roty, Float:rotz, virtual, price ) - создает автомат
 	Параметры:
		type - Уип автомата: Пиво: AVTOMAT_TYPE_BEER; ђино:AVTOMAT_TYPE_WINE; Чода:AVTOMAT_TYPE_SPRUNK; Чигареты: AVTOMAT_TYPE_CIGGY.
		string[] - Уекст над автоматом
		color - цвет текста
		Float: x - позиция X автомата
		Float: y - позиция Y автомата
		Float: z - позиция Z автомата
		Float:rotx - угол поворота относительно оси X
		Float:roty - угол поворота относительно оси Y
		Float:rotz - угол поворота относительно оси Z
		virtual - виртуальный мир, в котором стоит автомат
		price - цена одной единицы товара
	Функция возвращает ID автомата.

*/

stock createAvtomat( type, string[], color, Float:x, Float:y, Float:z, Float:rotx, Float:roty, Float:rotz, virtual, price )
{
	avtid++;
	if( avtomatinfo[ avtid ][ avalid ] == true )
		return printf( "d_avtomats-ERROR: Avtomat ID:%i is already created.", avtid );
    if( type >= 0 && type <= 3 ) avtomatinfo[ avtid ][ atype ] = type;
    else if( type < 0 ) avtomatinfo[ avtid ][ atype ] = 0;
    else if( type > 3 ) avtomatinfo[ avtid ][ atype ] = 3;
    avtomatinfo[ avtid ][ aX ] = x;
    avtomatinfo[ avtid ][ aY ] = y;
    avtomatinfo[ avtid ][ aZ ] = z;
    avtomatinfo[ avtid ][ arotX ] = rotx;
    avtomatinfo[ avtid ][ arotY ] = roty;
    avtomatinfo[ avtid ][ arotZ ] = rotz;
    avtomatinfo[ avtid ][ avalid ] = true;
    avtomatinfo[ avtid ][ aprice] = price;
    avtomatinfo[ avtid ][ avirtual ] = virtual;
	if( type >= 0 && type <= 2 ) avtomatinfo[ avtid ][ aAvtomat ] = CreateObject( 955, x, y, z - 0.5, rotx, roty, rotz );
	else avtomatinfo[ avtid ][ aAvtomat ] = CreateObject( 956, x, y, z - 0.5, rotx, roty, rotz );
	avtomatinfo[ avtid ][ aLable ] = Create3DTextLabel( string, color, x, y, z + 1.7, 50.0, virtual, 0 );
	return avtid;
}

/*

	Функция: 
		destroyAvtomat( avtomatid ) - удаляет автомат
 	Параметры:
		avtomatid - ID автомата
	Функция не возвращает специальных значений.

*/

stock destroyAvtomat( avtomatid )
{
	if( avtomatinfo[ avtomatid ][ avalid ] == true )
	{
		DestroyObject( avtomatinfo[ avtid ][ aAvtomat ] );
		avtomatinfo[ avtomatid ][ avalid ] = false;
		Delete3DTextLabel( avtomatinfo[ avtid ][ aLable ] );
		return 1;
	}
	return printf( "d_avtomats-ERROR: Avtomat ID:%i not created yet.", avtomatid );
}

/*

	Функция: 
		isValidAvtomat( avtomatid ) - проверяет существует ли такой автомат или нет
 	Параметры:
		avtomatid - ID автомата
	Функция возвращает true - если существует, и false - если не существует

*/

#define isValidAvtomat(%1) avtomatinfo[%1][ avalid ]

/*

	Функция: 
		updateAvtomat( avtomatid, newtype, newstring[], newcolor, Float:newx, Float:newy, Float:newz, Float:newrotx, Float:newroty, Float:newrotz, newvirtual, newprice ) - обновляет автомат
 	Параметры:
		avtomatid - ID автомата
		newtype - Уип автомата: Пиво: AVTOMAT_TYPE_BEER; ђино:AVTOMAT_TYPE_WINE; Чода:AVTOMAT_TYPE_SPRUNK; Чигареты: AVTOMAT_TYPE_CIGGY.
		newstring[] - Уекст над автоматом
		newcolor - цвет текста
		Float: newx - позиция X автомата
		Float: newy - позиция Y автомата
		Float: newz - позиция Z автомата
		Float:newrotx - угол поворота относительно оси X
		Float:newroty - угол поворота относительно оси Y
		Float:newrotz - угол поворота относительно оси Z
		newvirtual - виртуальный мир, в котором стоит автомат
		newprice - цена одной единицы товара
	Функция не возвращает специальных значений

*/

stock updateAvtomat( avtomatid, newtype, newstring[], newcolor, Float:newx, Float:newy, Float:newz, Float:newrotx, Float:newroty, Float:newrotz, newvirtual, newprice )
{
	if( avtomatinfo[ avtomatid ][ avalid ] == true )
	{
	    Delete3DTextLabel( avtomatinfo[ avtomatid ][ aLable ] );
	    if( newtype >= 0 && newtype <= 3 ) avtomatinfo[ avtomatid ][ atype ] = newtype;
	    else if( newtype< 0 ) avtomatinfo[ avtomatid ][ atype ] = 0;
	    else if( newtype > 3 ) avtomatinfo[avtomatid][ atype ] = 3;
	    avtomatinfo[ avtomatid ][ aX ] = newx;
	    avtomatinfo[ avtomatid ][ aY ] = newy;
	    avtomatinfo[ avtomatid ][ aZ ] = newz;
	    avtomatinfo[ avtomatid ][ arotX ] = newrotx;
	    avtomatinfo[ avtomatid ][ arotY ] = newroty;
	    avtomatinfo[ avtomatid ][ arotZ ] = newrotz;
	    avtomatinfo[ avtomatid ][ aprice ] = newprice;
    	avtomatinfo[ avtomatid ][ avirtual ] = newvirtual;
	    SetObjectPos( avtomatinfo[ avtomatid ][ aAvtomat ], newx, newy, newz - 0.5 );
	    SetObjectRot( avtomatinfo[ avtomatid ][ aAvtomat ], newrotx, newroty, newrotz );
		avtomatinfo[ avtomatid ][ aLable ] = Create3DTextLabel( newstring, newcolor, newx, newy, newz + 1.7, 50.0, newvirtual, 0 );
	    return 1;
	}
	return printf( "AVTOMATS-ERROR: Avtomat ID:%i not created yet.", avtomatid );
}

/*

	Функция: 
		destroyAllAvtomats() - удаляет все установленные на сервере автоматы
 	Функция не имеет параметров
	Функция не возвращает специальных значений.

*/

stock bool:destroyAllAvtomats()
{
	for( new i = 0; i <= avtid; i++ )
	{
	    if( avtomatinfo[ i ][ avalid ] == true )
			destroyAvtomat( i );
	}
	return true;
}

/*

	Функция: 
		getNumAvtomats() - считает сколько на сервере автоматов
 	Функция не имеет параметров
	Функция возвращает количество автоматовна сервере

*/
#define getNumAvtomats() avtid+1

/*

	 Колбэки:
		forward OnPlayerBuyDrink(playerid); // вызывается при покупке напитка в автомате
			ѕараметры:
				playerid - (int)ID игрока

		forward OnPlayerDrink(playerid); // вызывается когда игрок пьет напиток, который купил в автомате (d_avtomats.inc)
			ѕараметры:
				playerid - (int)ID игрока

		forward OnPlayerSmoke(playerid); // вызывается когда игрок курит сигарету, купленную в автомате (d_avtomats.inc)
			ѕараметры:
				playerid - (int)ID игрока

		forward OnPlayerBuyCigarettes(playerid, avtomatid, price); // вызывается когда игрок покупает сигарету в автомате (d_avtomats.inc)
			ѕараметры:
				playerid - (int)ID игрока
				avtomatid - (int)ID автомата, в котором игрок купил сигарету
				price - (int)цена сигареты

		forward OnPlayerBuySoda(playerid, avtomatid, price); // вызывается когда игрок покупает напиток в автомате (d_avtomats.inc)
			ѕараметры:
				playerid - (int)ID игрока
				avtomatid - (int)ID автомата, в котором игрок купил напиток
				price - (int)цена напитка

*/

//===============================================================
//
// 						Конец файла
//
//===============================================================