/******************************************************************************************************************************************

		-------------------------------------------------------------------------------------
			functions/d_checkpoints.inc -      
		-------------------------------------------------------------------------------------
				-------------------------------------------------------
					    SA-MP V0.3.7   
				-------------------------------------------------------

------------------------------------------------------------------------------------------------------------------------------		

	  :
		V2.2 BUILD 1000  02.03.2016

------------------------------------------------------------------------------------------------------------------------------	

	  :
		V1.0 BUILD 1000  02.04.2015

------------------------------------------------------------------------------------------------------------------------------

	 :
		10.10.2016 -   
		02.04.2015 -   
		04.03.2015 -      

------------------------------------------------------------------------------------------------------------------------------

	   :
		native setPlayerCheckpoint( playerid, Float: x, Float: y, Float: z, Float: radius, Float: viewradius, type,  style ); //    . 
		native deletePlayerCheckpoint( const playerid, const type ); //    
		native setCheckpointToAll( Float: x, Float: y, Float: z, Float: radius, Float: viewradius, type, style ); //    
		native deleteCheckpoint( type ); //    
		native setMinimumMapIconID(value); //  ID ,    (  0)
		native getCheckPointType(playerid); //  ID  

------------------------------------------------------------------------------------------------------------------------------

	    :
		      Dima-kun a.k.a Morino_Reigan
	
	 :
		   SA-MP SAMP-RUS.COM     
		SA-MP TEAM  San Andreas-MultiPlayer
		Rockstar North Games  Grand Theft Auto San Andreas

	            : http://samp-rus.com
	
*******************************************************************************************************************************************/

#if defined d_includes_checkpoints
	#endinput
#endif
#define  d_includes_checkpoints 1

/*

	:
		setPlayerCheckpoint( playerid, Float: x, Float: y, Float: z, Float: radius, Float: viewradius, type,  style ) -    . 
	:
		playerid - (int)ID ,     
		Float: x - (float)  
		Float: y - (float) Y 
		Float: z - (float) Z 
		Float: radius - (float) 
		Float: viewradius - (float),     
		type - (int) : ID 
		style - (int) : MAPICON_GLOBAL -     . MAPICON_LOCAL -    
	    .
	
*/

stock bool:setPlayerCheckpoint( playerid, Float: x, Float: y, Float: z, Float: radius, Float: viewradius, type, style )
{
	if( !IsPlayerConnected( playerid ) ) return false;
	for( new i = 0; i < MAX_CHECKPOINTS; i++ )
	{
	    if( PlayerCheckStreamer[ i ][ pcType ] == -1 )
	    {
			PlayerCheckStreamer[ i ][ pcR ] = viewradius;
			PlayerCheckStreamer[ i ][ pcX ] = x;
			PlayerCheckStreamer[ i ][ pcY ] = y;
			PlayerCheckStreamer[ i ][ pcZ ] = z;
			PlayerCheckStreamer[ i ][ pcFP ] = playerid;
			PlayerCheckStreamer[ i ][ pcRC ] = radius;
			PlayerCheckStreamer[ i ][ pcType ] = type;
			PlayerCheckStreamer[ i ][ pcStyle ] = style;
			if( style == MAPICON_GLOBAL ) SetPlayerMapIcon( playerid, MIN_MAPCONID + i, x, y, z, 0, 0xff0000ff, style );
			if( lastCHID < i ) lastCHID = i;
	    	break;
    	}
    }
	return true;
}


/*

	:
		deletePlayerCheckpoint( const playerid, const type ) -    
	:
		playerid - (int)ID ,     
		type - (int) : ID 
	    .
	
*/

stock bool:deletePlayerCheckpoint( const playerid, const type )
{
	for( new j = 0; j <= lastCHID; j++ )
	{
	    if( PlayerCheckStreamer[ i ][ pcType ] == type && PlayerCheckStreamer[ i ][ pcFP ] == playerid )
	    {
	        PlayerCheckStreamer[ i ][ pcR ] = 0.0;
			PlayerCheckStreamer[ i ][ pcX ] = 0.0;
			PlayerCheckStreamer[ i ][ pcY ] = 0.0;
			PlayerCheckStreamer[ i ][ pcZ ] = 0.0;
			PlayerCheckStreamer[ i ][ pcRC ] = 0.0;
			PlayerCheckStreamer[ i ][ pcFP ] = INVALID_PLAYER_ID;
			PlayerCheckStreamer[ i ][ pcType ] = -1;
			PlayerCheckStreamer[ i ][ pcStyle ] = -1;
			RemovePlayerMapIcon( playerid, MIN_MAPCONID + i );
			DisablePlayerCheckpoint( playerid );
			if( j == lastCHID ) lastCHID--;
	    }
	}
	return 1;
}


/*

	:
		setCheckpointToAll( Float: x, Float: y, Float: z, Float: radius, Float: viewradius, type, style ) -    
	:
		Float: x - (float)  
		Float: y - (float) Y 
		Float: z - (float) Z 
		Float: radius - (float) 
		Float: viewradius - (float),     
		type - (int) : ID 
		style - (int) : MAPICON_GLOBAL -     . MAPICON_LOCAL -    
	    .
	
*/

stock bool:setCheckpointToAll( Float: x, Float: y, Float: z, Float: radius, Float: viewradius, type, style )
{
	for( new i = 0, j = GetPlayerPoolSize(); i <= j; i++ )
		if( IsPlayerConnected( i ) )
			setPlayerCheckpoint( i, x, y, z, radius, viewradius, type, style );
	return true;
}


/*

	:
		deleteCheckpoint( type ) -    
	:
		type - (int)  : ID 
	    .
	
*/

stock bool:deleteCheckpoint( type )
{
	for( new i = 0, j = GetPlayerPoolSize(); i <= j; i++ )
		if( IsPlayerConnected( i ) )
	        deletePlayerCheckpoint( i, type );
	return true;
}


/*

	:
		setMinimumMapIconID(value) -  ID ,    (  0)
	:
		value - (int)  id .
	    .
	
*/


#define setMinimumMapIconID(%1) MIN_MAPCONID = %1

/*

	:
		getCheckPointType(playerid) -  ID   
	:
		playerid - (int)ID      ID 
	    .
	
*/

#define getCheckPointType(%1) gi:gPlayerCheckpointStatus[%1]


//=============================================================================================================================
//
// 															 
//
//=============================================================================================================================