/******************************************************************************************************************************************

		------------------------------------------------------------------------------------
			functions/d_servers.inc -    1.,    
							     .map
		------------------------------------------------------------------------------------

			--------------------------------------------------------
				    SA-MP V0.3.7   
			--------------------------------------------------------

------------------------------------------------------------------------------------------------------------------------------		

	  :
		V2.2 BUILD 1000  10.10.2016

------------------------------------------------------------------------------------------------------------------------------	

	  :
		V1.3 BUILD 1000  02.04.2016

------------------------------------------------------------------------------------------------------------------------------

	 :
		10.10.2016 -   
		02.04.2015 -   
		04.03.2015 -      
		
------------------------------------------------------------------------------------------------------------------------------

	   :
		native LoadMap( filename[], typestrim = 1, Float: viewdis = 350.0 ); //  
		native Unloadmap( mapid ); //  
		native UnloadAllMaps(); //   
		native getNumMaps(); //    

------------------------------------------------------------------------------------------------------------------------------

	    :
		      Dima-kun a.k.a Morino_Reigan
	
	 :
		   SA-MP SAMP-RUS.COM     
		SA-MP TEAM  San Andreas-MultiPlayer
		Rockstar North Games  Grand Theft Auto San Andreas

	            : http://samp-rus.com
	
*******************************************************************************************************************************************/

#if defined d_maps_included
	#endinput
#endif
#define d_maps_included

//===============================================================
//
// 	: loadMap(filename[], Float: viewdis ); //    .        ,     
//			:
//				filename[] - (string)  
//				Float: viewdis - (float),        (  350.0)
//				 ID  .
//				
//				,   :
//
//				MAP_NOTFOUND( -1 ); //    ,    .
//				MAP_TOOBIG_LEN( -2 ); //    .
//				MAX_MAX_LOADED( -3 ); //    .
//
//			  :
//					MidoStream, xObjects, rObjects.
//===============================================================

stock loadMap( filename[], Float: viewdis = 350.0 )
{
	if( loadedMaps == MAX_MAPS ) return MAX_MAX_LOADED;
	if( strlen( filename ) > 40 ) return MAP_TOOBIG_LEN;
	new File: file,
		string[ 256 ],
		tmp[ 50 ],
		_intVal[ 5 ],
		Float: _floatVal[ 6 ];
	loadedMaps++;
		
//===============================================================
//
// 	     scriptfiles/maps. 
// 	  		      :
// 	format( string, sizeof( string ), "maps/%s", filename );
//
//===============================================================

	format( string, 50, "maps/%s", filename );
	if( ( file = fopen( string, io_read ) ) )
	{
		while( fread( file, string ) )
		{
		
//===============================================================
//
// 			   . 
//
//===============================================================

			new start = strfind( string, "<", true ) - 1,
				end = strfind( string, ">", true ),
				tags = strfind( string, "</object>", true );
				
//===============================================================
//
// 			   . 
//
//===============================================================

			if( tags >= 0 ) strdel( string, tags, tags + 10 );
			tags = strfind( string, "</vehicle>", true );
			if( tags >= 0 ) strdel( string, tags, tags + 10 );
			tags = strfind( string, "</map>", true );
			if( tags >= 0 ) strdel( string, tags, tags + 6 );
			strdel( string, start, start + 1 );
			strdel( string, end - 1, end + 1 );

			tmp = strcharsplit( string, start, ' ' );
			
//===============================================================
//
// 			  .
//
//===============================================================

			if( !strcmp( tmp, "object", true ) )
			{
			
//===============================================================
//
// 			 ID  
//
//===============================================================

				start = strfind( string, "model", true ) - 1;
				tmp = strcharsplit( string, start, '=' );
				tmp = strcharsplit( string, start, ' ' );
				start = strfind( tmp, "\"", true );
				strdel( tmp, start, start + 1  );
				end = strfind( tmp, "\"", true );
				strdel( tmp, end, end + 1 );
				_intVal[ 0 ] = strval( tmp );
				
//===============================================================
//
// 			   
//
//===============================================================

				start = strfind( string, "posX", true ) - 1;
				tmp = strcharsplit( string, start, '=' );
				tmp = strcharsplit( string, start, ' ' );
				start = strfind( tmp, "\"", true );
				strdel( tmp, start, start + 1  );
				end = strfind( tmp, "\"", true );
				strdel( tmp, end, end + 1 );
				_floatVal[ 0 ] = floatstr( tmp );
				
//===============================================================
//
// 			   
//
//===============================================================

				start = strfind( string, "posY", true ) - 1;
				tmp = strcharsplit( string, start, '=' );
				tmp = strcharsplit( string, start, ' ' );
				start = strfind( tmp, "\"", true );
				strdel( tmp, start, start + 1  );
				end = strfind( tmp, "\"", true );
				strdel( tmp, end, end + 1 );
				_floatVal[ 1 ] = floatstr( tmp );
				
//===============================================================
//
// 			  Z 
//
//===============================================================

				start = strfind( string, "posZ", true ) - 1;
				tmp = strcharsplit( string, start, '=' );
				tmp = strcharsplit( string, start, ' ' );
				start = strfind( tmp, "\"", true );
				strdel( tmp, start, start + 1  );
				end = strfind( tmp, "\"", true );
				strdel( tmp, end, end + 1 );
				_floatVal[ 2 ] = floatstr( tmp );
				
//===============================================================
//
// 		      
//
//===============================================================

				start = strfind( string, "rotX", true ) - 1;
				tmp = strcharsplit( string, start, '=' );
				tmp = strcharsplit( string, start, ' ' );
				start = strfind( tmp, "\"", true );
				strdel( tmp, start, start + 1  );
				end = strfind( tmp, "\"", true );
				strdel( tmp, end, end + 1 );
				_floatVal[ 3 ] = floatstr( tmp );
				
//===============================================================
//
// 		      
//
//===============================================================

				start = strfind( string, "rotY", true ) - 1;
				tmp = strcharsplit( string, start, '=' );
				tmp = strcharsplit( string, start, ' ' );
				start = strfind( tmp, "\"", true );
				strdel( tmp, start, start + 1  );
				end = strfind( tmp, "\"", true );
				strdel( tmp, end, end + 1 );
				_floatVal[ 4 ] = floatstr( tmp );
				
//===============================================================
//
// 		      Z
//
//===============================================================

				start = strfind( string, "rotZ", true ) - 1;
				tmp = strcharsplit( string, start, '=' );
				tmp = strcharsplit( string, start, ' ' );
				start = strfind( tmp, "\"", true );
				strdel( tmp, start, start + 1  );
				end = strfind( tmp, "\"", true );
				strdel( tmp, end, end + 1 );
				_floatVal[ 5 ] = floatstr( tmp );
//===============================================================
//
// 	     
// 				   .
//
//===============================================================

				#if defined CreateStreamedObject
					MapInfo[ loadedMaps ][ _mobjects ][ loadedObj ] = CreateStreamedObject( _intVal[ 0 ], _floatVal[ 0 ], _floatVal[ 1 ], _floatVal[ 2 ], _floatVal[ 3 ], _floatVal[ 4 ], _floatVal[ 5 ], viewdis );
				#elseif defined CreateStreamObject
					MapInfo[ loadedMaps ][ _mobjects ][ loadedObj ] = CreateStreamObject( _intVal[ 0 ], _floatVal[ 0 ], _floatVal[ 1 ], _floatVal[ 2 ], _floatVal[ 3 ], _floatVal[ 4 ], _floatVal[ 5 ], viewdis );
				#elseif defined CreateDynamicObject
					MapInfo[ loadedMaps ][ _mobjects ][ loadedObj ] = CreateDynamicObject( _intVal[ 0 ], _floatVal[ 0 ], _floatVal[ 1 ], _floatVal[ 2 ], _floatVal[ 3 ], _floatVal[ 4 ], _floatVal[ 5 ], -1, -1, viewdis, 0.0 );
				#else
					MapInfo[ loadedMaps ][ _mobjects ][ loadedObj ] = CreateObject( _intVal[ 0 ], _floatVal[ 0 ], _floatVal[ 1 ], _floatVal[ 2 ], _floatVal[ 3 ], _floatVal[ 4 ], _floatVal[ 5 ], viewdis );
				#endif
					loadedObj++;
			}
			if( !strcmp( tmp, "vehicle", true ) )
			{
			
//===============================================================
//
// 			 ID  
//
//===============================================================

				start = strfind( string, "model", true ) - 1;
				tmp = strcharsplit( string, start, '=' );
				tmp = strcharsplit( string, start, ' ' );
				start = strfind( tmp, "\"", true );
				strdel( tmp, start, start + 1  );
				end = strfind( tmp, "\"", true );
				strdel( tmp, end, end + 1 );
				_intVal[ 0 ] = strval( tmp );
			
//===============================================================
//
// 			   
//
//===============================================================

				start = strfind( string, "posX", true ) - 1;
				tmp = strcharsplit( string, start, '=' );
				tmp = strcharsplit( string, start, ' ' );
				start = strfind( tmp, "\"", true );
				strdel( tmp, start, start + 1  );
				end = strfind( tmp, "\"", true );
				strdel( tmp, end, end + 1 );
				_floatVal[ 0 ] = floatstr( tmp );

//===============================================================
//
// 			   
//
//===============================================================

				start = strfind( string, "posY", true ) - 1;
				tmp = strcharsplit( string, start, '=' );
				tmp = strcharsplit( string, start, ' ' );
				start = strfind( tmp, "\"", true );
				strdel( tmp, start, start + 1  );
				end = strfind( tmp, "\"", true );
				strdel( tmp, end, end + 1 );
				_floatVal[ 1 ] = floatstr( tmp );

//===============================================================
//
// 			  Z 
//
//===============================================================

				start = strfind( string, "posZ", true ) - 1;
				tmp = strcharsplit( string, start, '=' );
				tmp = strcharsplit( string, start, ' ' );
				start = strfind( tmp, "\"", true );
				strdel( tmp, start, start + 1  );
				end = strfind( tmp, "\"", true );
				strdel( tmp, end, end + 1 );
				_floatVal[ 2 ] = floatstr( tmp );

//===============================================================
//
// 			    
//
//===============================================================

				start = strfind( string, "rotZ", true ) - 1;
				tmp = strcharsplit( string, start, '=' );
				tmp = strcharsplit( string, start, ' ' );
				start = strfind( tmp, "\"", true );
				strdel( tmp, start, start + 1  );
				end = strfind( tmp, "\"", true );
				strdel( tmp, end, end + 1 );
				_floatVal[ 3 ] = floatstr( tmp );

//===============================================================
//
// 					   
//
//===============================================================

				MapInfo[ loadedMaps ][ _mvehicles ][ loadedVehs ] = AddStaticVehicle( _intVal[ 0 ], _floatVal[ 0 ], _floatVal[ 1 ], _floatVal[ 2 ], _floatVal[ 3 ], -1, -1 );
				loadedVehs++;
			}
//===============================================================
//
// 		 ,      MTA:Race
//
//===============================================================

			if( !strcmp( tmp, "spawnpoint", true ) )
			{
			
//===============================================================
//
// 			 ID  
//
//===============================================================

				start = strfind( string, "vehicle", true ) - 1;
				tmp = strcharsplit( string, start, '=' );
				tmp = strcharsplit( string, start, ' ' );
				start = strfind( tmp, "\"", true );
				strdel( tmp, start, start + 1  );
				end = strfind( tmp, "\"", true );
				strdel( tmp, end, end + 1 );
				_intVal[ 0 ] = strval( tmp );
			
//===============================================================
//
// 			   
//
//===============================================================

				start = strfind( string, "posX", true ) - 1;
				tmp = strcharsplit( string, start, '=' );
				tmp = strcharsplit( string, start, ' ' );
				start = strfind( tmp, "\"", true );
				strdel( tmp, start, start + 1  );
				end = strfind( tmp, "\"", true );
				strdel( tmp, end, end + 1 );
				_floatVal[ 0 ] = floatstr( tmp );

//===============================================================
//
// 			   
//
//===============================================================

				start = strfind( string, "posY", true ) - 1;
				tmp = strcharsplit( string, start, '=' );
				tmp = strcharsplit( string, start, ' ' );
				start = strfind( tmp, "\"", true );
				strdel( tmp, start, start + 1  );
				end = strfind( tmp, "\"", true );
				strdel( tmp, end, end + 1 );
				_floatVal[ 1 ] = floatstr( tmp );

//===============================================================
//
// 			  Z 
//
//===============================================================

				start = strfind( string, "posZ", true ) - 1;
				tmp = strcharsplit( string, start, '=' );
				tmp = strcharsplit( string, start, ' ' );
				start = strfind( tmp, "\"", true );
				strdel( tmp, start, start + 1  );
				end = strfind( tmp, "\"", true );
				strdel( tmp, end, end + 1 );
				_floatVal[ 2 ] = floatstr( tmp );

//===============================================================
//
// 			    
//
//===============================================================

				start = strfind( string, "rotZ", true ) - 1;
				tmp = strcharsplit( string, start, '=' );
				tmp = strcharsplit( string, start, ' ' );
				start = strfind( tmp, "\"", true );
				strdel( tmp, start, start + 1  );
				end = strfind( tmp, "\"", true );
				strdel( tmp, end, end + 1 );
				_floatVal[ 3 ] = floatstr( tmp );

//===============================================================
//
// 					   
//
//===============================================================

				MapInfo[ loadedMaps ][ _mvehicles ] = AddStaticVehicle( _intVal[ 0 ], _floatVal[ 0 ], _floatVal[ 1 ], _floatVal[ 2 ], _floatVal[ 3 ], -1, -1 );
				loadedVehs++;
			}
		}
		
//===============================================================
//
// 			  
//
//===============================================================

		fclose( file );
		MapInfo[ loadedMaps ][ _mapValid ] = true;
		MapInfo[ loadedMaps ][ _mobjCount ] = loadedObj;
		MapInfo[ loadedMaps ][ _mvehCount ] = loadedVehs;
		mapcount++;
		printf( " %s .\n:%i\n:%i", filename, loadedObj, loadedVehs );
		return loadedMaps;
	}
	return MAP_NOTFOUND;
}

//===============================================================
//
// 	: bool: unloadmap( mapid ) -    
// 		:
//			mapid - ID   
// 	 true,   .  false,      .
//
//===============================================================

stock bool: unloadmap( _mapid )
{
	if( MapInfo[ _mapid ][ _mapValid ] == true )
	{
		for( new i = 0; i < MapInfo[ _mapid ][ _mobjCount ]; i++ )
		{
			#if defined DestroyStreamedObject
				DestroyStreamedObject( MapInfo[ _mapid ][ _mobjects ][ i ] );
			#elseif defined DestroyStreamObject
				DestroyStreamObject( MapInfo[ _mapid ][ _mobjects ][ i ] );
			#else
				DestroyObject( MapInfo[ _mapid ][ _mobjects ][ i ] );
			#endif
		}
		for( new v = 0; v < MapInfo[ _mapid ][ _mvehCount ]; v++ )
			DestroyVehicle( MapInfo[ _mapid ][ _mvehicles ][ v ] );
		MapInfo[ _mapid ][ _mapValid ] = false;
		mapcount--;
		return true;
	}
	return false;
}

//===============================================================
//
// 	: nloadAllMaps() -     
// 	   -  .
//
//===============================================================

stock bool: unloadAllMaps()
{
	for( new mapid = 0; mapid < MAX_MAPS; mapid++ )
	{
		if( MapInfo[ mapid ][ _mapValid ] == true )
		{
			for( new i = 0; i < MapInfo[ mapid ][ _mobjCount ]; i++ )
			{
				#if defined DestroyStreamedObject
					DestroyStreamedObject( MapInfo[ _mapid ][ _mobjects ][ i ] );
				#elseif defined DestroyStreamObject
					DestroyStreamObject( MapInfo[ _mapid ][ _mobjects ][ i ] );
				#else
					DestroyObject( MapInfo[ _mapid ][ _mobjects ][ i ] );
				#endif
			}
			for( new v = 0; v < MapInfo[ loadedMaps ][ _mvehCount ]; v++ )
				DestroyVehicle( MapInfo[ mapid ][ _mvehicles ][ v ] );
			MapInfo[ mapid ][ _mapValid ] = false;
			mapcount--;
		}
	}
	return true;
}

//===============================================================
//
// 	: getNumMaps() -    
// 	    .
//
//===============================================================

#define getNumMaps() mapcount;

stock DestroyStreamedObject( dID )
	return CallRemoteFunction( "DestroyStreamedObject", "i", dID );
stock DestroyStreamObject( id )
    return CallRemoteFunction( "Core_DestroyStreamObject", "i", id );

native DestroyDynamicObject(objectid);