/******************************************************************************************************************************************

		-----------------------------------------------------------------------
			functions/d_pickups.inc - СИСТЕМА АНАЛОГИЧНЫХ ПИКАПОВ КАК В МТА.
		-----------------------------------------------------------------------

			----------------------------------------------------------------
					ДЛЯ РАБОТЫ НЕОБХОДИМ СЕРВЕР SA-MP V0.3.7 И ВЫШЕ 
			----------------------------------------------------------------

------------------------------------------------------------------------------------------------------------------------------		

	ТЕКУЩАЯ ВЕРСИЯ СБОРНИКА:
		V2.2 BUILD 1000 ОТ 10.10.2016

------------------------------------------------------------------------------------------------------------------------------	

	ТЕКУЩАЯ ВЕРСИЯ БИБЛИОТЕКИ:
		V1.0 BUILD 1000 ОТ 02.04.2015

------------------------------------------------------------------------------------------------------------------------------

	ИСТОРИЯ СОБЫТИЙ:
		10.10.2016 - ОБНОВЛЕНИЕ СБОРНИКА БИБЛИОТЕК
		02.04.2015 - ОБНОВЛЕНИЕ СБОРНИКА БИБЛИОТЕК
		04.03.2015 - ВЫХОД ПЕРВОЙ ВЕРСИИ ДАННОГО СБОРНИКА БИБЛИОТЕК

------------------------------------------------------------------------------------------------------------------------------

	ФУНКЦИИ В ДАННОМ ИНКЛЮДЕ:
		native createMTAPickUp(pickmodel, Float: x, Float: y, Float: z, virtualworld, tcolor, newcar, pcolor1, pcolor2); // создаёт пикап.
		native destroyMTAPickup(pickupid); // удаляет пикап.
		native destroyAllMTAPickup(); // удаляет все пикапы.
		native isMTApickupValid(pickupid); // проверяет состояние пикапа 
		native updateMTAPickUp(pickupid, tcolor, newcar, vcolor1, vcolor2 ); // с помощью этой функции можно настроить функционал пикапа не удаляя пикап

------------------------------------------------------------------------------------------------------------------------------

	АВТОРСКИЕ ПРАВА К СБОРТНИКУ БИБЛИОТЕК:
		ВСЕ ПРАВА НА ЭТОТ СБОРНИК ПРИНАДЛЕЖАТ Dima-kun a.k.a Morino_Reigan
	
	ОТДЕЛЬНАЯ БЛАГОДАРНОСТЬ:
		ПОРТАЛУ РУССКОГО КОМЬЮНИТИ SA-MP SAMP-RUS.COM ЗА РАСПРОСТРАНЕНИЕ ДАННОГО СБОРНИКА БИБЛИОТЕК
		SA-MP TEAM ЗА San Andreas-MultiPlayer
		Rockstar North Games ЗА Grand Theft Auto San Andreas

	РАСПРОСТРАНЕНИЕ ДАННОГО СБОРНИКА БИБЛИОТЕК ВОЗМОЖНА ТОЛЬКО С СОХРАНЕНИЕМ ИМЕНИ АВТОРА И УКАЗАНИЕМ ИСТОЧНИКА: http://samp-rus.com
	
*******************************************************************************************************************************************/

#if defined d_includes_mtapickups
	#endinput
#endif
#define d_includes_mtapickups 1

/*

	Функция:
		createMTAPickUp( pickmodel, Float: x, Float: y, Float: z, virtualworld, tcolor, newcar, pcolor1, pcolor2 ) - создаёт пикап.
	Параметры:
		pickmodel - модель пикапа
		Float:x, Float:y, Float:z - позиции x,y,z пикапа
		virtualworld - виртуальный мир, в котором располагается пикап
		tcolor - цвет надписи над пикапом(hex)
		newcar - ID модели на которую заменяется машина(если 0, то машина будет восстановлена, а если 1, то покрашена в цвета color1 и color2, а если 2 - то машина будет взорвана)
		color1 - цвет машины №1
		color2 - цвет машины №2
	Функция вовращает ID созданного пикапа.

*/

stock createMTApickup( pickmodel, Float: x, Float: y, Float: z, virtualworld, tcolor, newcar, pcolor1, pcolor2 )
{
	if( pickup > MAX_MTA_PICKUPS ) return print( "MTA_Pickups Error: Too many pickups!" );
	switch( newcar )
	{
		case 0:
		{
			pickupInfo[ pickup ][ pid ] = CreatePickup( pickmodel, 14, x, y, z, virtualworld );
			CallRemoteFunction( "OnMTApickupCreate", "ii", pickup, PICKTYPE_REPAIR );
			pickupInfo[ pickup ][ tid ] = Create3DTextLabel( "Repair Car", tcolor, x, y, z + 0.7, 50.0, virtualworld, 1 );
			pickupInfo[ pickup ][ pctype ] = PICKTYPE_REPAIR;
			pickupInfo[ pickup ][ valid ] = 1;
		}
		case 1:
		{
			pickupInfo[ pickup ][ pid ] = CreatePickup( pickmodel, 14, x, y, z, virtualworld );
			CallRemoteFunction( "OnMTApickupCreate", "ii", pickup, PICKTYPE_CHANGECOLOR );
			pickupInfo[ pickup ][ tid ] = Create3DTextLabel( "Change color", tcolor, x, y, z + 0.7, 50.0, virtualworld, 1 );
			pickupInfo[ pickup ][ pctype ] = PICKTYPE_CHANGECOLOR;
			pickupInfo[ pickup ][ valid ] = 1;
			pickupInfo[ pickup ][ picolor1 ] = pcolor1;
			pickupInfo[ pickup ][ picolor2 ] = pcolor2;
		}
		case 2:
		{
			pickupInfo[ pickup ][ pid ] = CreatePickup( pickmodel, 14, x, y, z, virtualworld );
			CallRemoteFunction( "OnMTApickupCreate", "ii", pickup, PICKTYPE_BOOM );
			pickupInfo[ pickup ][ tid ] = Create3DTextLabel( "Boom", tcolor, x, y, z + 0.7, 50.0, virtualworld, 1 );
			pickupInfo[ pickup ][ pctype ] = PICKTYPE_BOOM;
			pickupInfo[ pickup ][ valid ] = 1;
		}
		default:
		{
		    pickupInfo[ pickup ][ pid ] = CreatePickup( pickmodel, 14, x, y, z, virtualworld );
		    pickupInfo[ pickup ][ tid ] = Create3DTextLabel( VehicleNameS[ newcar  - 400 ], tcolor, x, y, z + 0.7, 50.0, virtualworld, 1 );
			pickupInfo[ pickup ][ pctype ] = PICKTYPE_CHANGEMODEL;
			CallRemoteFunction( "OnMTApickupCreate", "ii", pickup, PICKTYPE_CHANGEMODEL );
			pickupInfo[ pickup ][ valid ] = 1;
			pickupInfo[ pickup ][ pnewcar ] = newcar;
			pickupInfo[ pickup ][ picolor1 ] = pcolor1;
			pickupInfo[ pickup ][ picolor2 ] = pcolor2;
		}
	}
	pickupInfo[ pickup ][ posx ] = x;
	pickupInfo[ pickup ][ posy ] = y;
	pickupInfo[ pickup ][ posz ] = z;
	pickupInfo[ pickup ][ pmodel ] = pickmodel;
	pickupInfo[ pickup ][ pvrtual ] = virtualworld;
	pickup++;
	return pickup - 1;
}

/*

	 Функция:
		destroyMTAPickup( pickupid ) - удаляет пикап.
	Параметры:
		pickupid - ID пикапа
	Функция возвращает 1 - если удален пикап, и 0 - если не удален.

*/

stock destroyMTAPickup( pickupid )
{
		if( pickupInfo[ pickupid ][ valid ] == 1 )
	    {
	    	DestroyPickup( pickupInfo[ pickupid ][ pid ] );
	    	pickupInfo[ pickupid ][ valid ] = 0;
	    	return 1;
		}
		return 0;
}

/*
	
	Функция:
		destroyAllMTAPickup() - удаляет все пикапы.
	Параметров нету.
	Функция не возвращает ничего принципиального.

*/

stock destroyAllMTAPickup()
{
    for(new i = 0; i <= pickup; i++ )
	{
	    if( pickupInfo[ i ][ valid ] == 1 )
	    {
	    	DestroyPickup( pickupInfo[ i ][ pid ] );
	    	pickupInfo[ i ][ valid ] = 0;
		}
	}
	return 1;
}

/*

	Функция:
		isMTApickupValid - проверяет состояние пикапа 
	Параметры:
		pickupid - ID пикапа
	Функция возвращает 1 если пикап существует, и 0 - если не существует.

*/

stock isMTApickupValid( pickupid )
	return pickupInfo[ pickupid ][ valid ];

/*

	Функция:
		updateMTAPickUp( pickupid, tcolor, newcar, vcolor1, vcolor2 ) - с помощью этой функции можно настроить функционал пикапа не удаляя пикап
	Параметры:
		pickupid - ID пикапа
		tcolor - цвет текста над пикапом(hex)
		newcar - ID модели на которую заменяется машина(если 0, то машина будет восстановлена, а если 1, то покрашена в цвета color1 и color2)
		color1 - цвет машины №1
		color2 - цвет машины №2
	Функция не вовзращает ничего принципиального.
			
*/

stock updateMTApickup( pickupid, tcolor, newcar, vcolor1, vcolor2 )
{
    if( pickupInfo[ pickupid ][ valid ] == 1 )
	{
		if( newcar == 0 )
		{
			pickupInfo[ pickupid ][ pctype ] = PICKTYPE_REPAIR;
			pickupInfo[ pickupid ][ valid ] = 1;
		}
		else if( newcar == 1 )
		{
			pickupInfo[ pickupid ][ pctype ] = PICKTYPE_CHANGECOLOR;
			pickupInfo[ pickupid ][ valid ] = 1;
			pickupInfo[ pickupid ][ picolor1 ] = vcolor1;
			pickupInfo[ pickupid ][ picolor2 ] = vcolor2;
		}
		else
		{
			pickupInfo[ pickupid ][ pctype ] = PICKTYPE_CHANGEMODEL;
			pickupInfo[ pickupid ][ valid ] = 1;
			pickupInfo[ pickupid ][ pnewcar ] = newcar;
		}
	}
	printf( "MTA-pickup: ID:%i update", pickupid );
	return 1;
}

public updatePickup( pickupid )
{
	DestroyPickup( pickupInfo[ pickupid ][ pid ] );
	pickupInfo[ pickupid ][ valid ] = 1;
	pickupInfo[ pickupid ][ pid ] = CreatePickup( pickupInfo[ pickupid ][ pmodel ], 14, pickupInfo[ pickupid ][ posx ], pickupInfo[ pickupid ][ posy ], pickupInfo[ pickupid ][ posz ], pickupInfo[ pickupid ][ pvrtual ] );
	return 1;
}

/*

	Колбэки:
		1. OnVehicleRepair  - вызывается при восстановлении машины
			Параметры:
				playerid - ID водителя
				vehicleid - ID восстановленной машиной
				pickupid - ID восстановившего пикапа
				
		2. OnVehicleChangeModel - вызывается при смене модели машины
			Параметры:
				playerid - ID водителя
				vehicleid - ID машины, которой меняют модель
				newmodel - Модель, присвоенная машине
				oldmodel - Модель, которая была до смены.
				
		3. OnMTApickupCreate - вызывается при создании пикапа.
			Параметры:
				pickupid - ID созданного пикапа
				pictype - Тип пикапа
				
		4.OnVehicleColoured - вызывается при смене цвета машины
			Параметры:
				playerid - ID водителя
				vehicleid - ID машины, которой меняют цвет
				pickupid - ID пикапа, сменившего цвет мащины
				newcolor1 - новый цвет машины №1
				newcolor2 - новый цвет машины №2
				
		5.OnVehicleBoom - вызывается при взрыве машины
			Параметры:
				playerid - ID водителя
				vehicleid - ID машины, которая взорвалась
				pickupid - ID восстановившего пикапа
*/

//# Типы пикапов
#define PICKUP_CHANGECOLOR	( 1 )
#define PICKUP_BOOM			( 2 )