/******************************************************************************************************************************************

		------------------------------------------------------------------
			functions/d_register.inc -   .
		------------------------------------------------------------------
			-----------------------------------------------------------
				    SA-MP V0.3.7   
			-----------------------------------------------------------

------------------------------------------------------------------------------------------------------------------------------		

	  :
		V2.2 BUILD 1000  10.10.2016

------------------------------------------------------------------------------------------------------------------------------	

	  :
		V1.0 BUILD 1000  02.04.2015

------------------------------------------------------------------------------------------------------------------------------

	 :
		10.10.2016 -   
		02.04.2015 -     :
			d_register.inc:
				native changeNickName(playerid, newname[]); //  
				native changePassword(playerid, newpass[]); //  
		04.03.2015 -      

------------------------------------------------------------------------------------------------------------------------------

	   :
		native setPlayerAccountDirectory(string[]); //      .
		native accountdirectory(); //      
		native isPlayerLogged(playerid); //       
		native isPlayerRegistred(playerid); //    
		native enebleNotLoggedSpawn(); //        
		native loadPlayerInfoString(File:file, line[]); //      
		native loadPlayerInfoInt(File:file, line[]); //     
		native loadPlayerInfoFloat(File:file, line[]); //       
		native savePlayerInfoInt(File:file, line[], valus); //      
		native savePlayerInfoString(File:file, line[], valus); //      
		native savePlayerInfoString(File:file, line[],  Float:valus); //      
		native loginPlayer(playerid, pass[]); //    
		native registerPlayer(playerid, pass[]); //   
		native savePlayer(playerid); //  
		native changeNickName(playerid, newname[]); //  
		native changePassword(playerid, newpass[]); //  

------------------------------------------------------------------------------------------------------------------------------

	    :
		      Dima-kun a.k.a Morino_Reigan
	
	 :
		   SA-MP SAMP-RUS.COM     
		SA-MP TEAM  San Andreas-MultiPlayer
		Rockstar North Games  Grand Theft Auto San Andreas

	            : http://samp-rus.com
	
*******************************************************************************************************************************************/

#if defined d_includes_register
	#endinput
#endif
#define  d_includes_register 1

/*

	:
		setPlayerAccountDirectory(string[]); //      .
	:
		string[] - . : Accounts/%s.acc
	    

*/

stock bool:setPlayerAccountDirectory( const string[] )
{
	if( strlen( string ) > sizeof( accdirectory ) ) return false;
	strmid( accdirectory, string, 0, strlen( string ), 255 );
	return true;
}

/*

	:
		accountdirectory(); //      
	   
	 

*/

#define accountdirectory() accdirectory

/*

	:
		isPlayerLogged(playerid); //       
	:
		playerid - ID  
	 true -     , false -  .

*/

#define isPlayerLogged(%1) gi:pllogged[%1]

/*

	:
		isPlayerRegistred(playerid); //    
	:
		playerid - ID  
	 true -  , false -  .

*/

#define isPlayerRegistred(%1) gi:plregged[%1]

/*

	:
		enebleNotLoggedSpawn(); //        
	   .
	    .

*/

#define enebleNotLoggedSpawn() plcannotlog = false

/*

	:
		loadPlayerInfoString(File:file, line[]); //      
	:
		File:file - ID   
		line[] -  
	      

*/

stock loadPlayerInfoString( File:file, const line[] )
{
	new
		cmpValue[ 255 ],
		parametr[ 100 ],
		idx;

	fread( file, cmpValue );
	parametr = strcharsplit( cmpValue, idx, '=' );
	if( !strcmp( parametr, line, true ) )
		parametr = strcharsplit( cmpValue, idx, ' ' );
	return parametr;
}

/*

	:
		loadPlayerInfoInt(File:file, line[]); //      
	:
		File:file - ID   
		line[] -  
	      .

*/

stock loadPlayerInfoInt( File:file, const line[] )
{
	new
		cmpValue[ 255 ],
		parametr[ 100 ],
		idx;

	fread( file, cmpValue );
	parametr = strcharsplit( cmpValue, idx, '=' );
	if( !strcmp( parametr, line, true ) )
		parametr = strcharsplit( cmpValue, idx, ' ' );
	return strval( parametr );
}

/*

	:
		loadPlayerInfoFloat(File:file, line[]); //        
	:
		File:file - ID   
		line[] -  
	      

*/

stock Float:loadPlayerInfoFloat( File:file, const line[] )
{
	new
		cmpValue[ 255 ],
		parametr[ 100 ],
		idx;

	fread( file, cmpValue );
	parametr = strcharsplit( cmpValue, idx, '=' );
	if( !strcmp( parametr, line, true ) )
		parametr = strcharsplit( cmpValue, idx, ' ' );
	return floatstr( parametr );
}

/*

	:
		savePlayerInfoInt(File:file, line[], valus); //      
	:
		File:file - ID   
		line[] -  
		valus -  
	    .

*/

stock bool:savePlayerInfoInt( File: file, const line[], const valus )
{
	new
		value[ 255 ];

	format( value, sizeof( value ), "%s=%i\r\n", line, valus ); fwrite( file, value );
	return true;
}

/*

	:
		savePlayerInfoString(File:file, line[], valus); //      
	:
		File:file - ID   
		line[] -  
		valus[] -  
	    .

*/

stock bool:savePlayerInfoString( File:file, const line[], const valus[] )
{
	new
		value[ 255 ];

	format( value, sizeof( value ), "%s=%s\r\n", line, valus); fwrite( file, value );
	return true;
}

/*

	:
		savePlayerInfoString(File:file, line[],  Float:valus); //      
	:
		File:file - ID   
		line[] -  
		Float:valus -  
	    

*/

stock bool:savePlayerInfoFloat( File:file, const line[], Float:valus )
{
	new
		value[ 255 ];

	format( value, sizeof( value ), "%s=%f\r\n", line, valus ); fwrite( file, value );
	return true;
}

/*

	:
		loginPlayer(playerid, pass[]); //    
	:
		playerid - ID ,   
		pass[] - ,  
	    

*/

stock bool:loginPlayer( const playerid, const pass[] )
{
	new
		reason,
		string[ 100 ],
		File: acc;

	format( string, sizeof( string ), accountdirectory(), getPlayerName( playerid ) );
	if( fexist( string ) )
	{
		if( gi:pllogged[ playerid ] == 0 )
		{
			acc = fopen( string, io_read );
			ss:PASSWORD[ playerid ] = loadPlayerInfoString( acc, "Password" );
			if ( !strcmp( gs:PASSWORD[ playerid ],  pass,  true,  strlen( gs:PASSWORD[playerid] ) ) && strlen( pass ) == strlen( gs:PASSWORD[playerid] ) )
			{
				si:Blocked[ playerid ] = loadPlayerInfoInt( acc, "Block" );
				if( gi:Blocked[ playerid ] )
					reason = REGISTER_ACCOUNT_BLOCKED;
				else
				{
					si:pllogged[ playerid ] = 1;
					reason = REGISTER_ACCOUNT_LOGGIN;
				}
			}
			else
				reason = REGISTER_ACCOUNT_WRONGPASS;
		}
		else
			reason = REGISTER_ACCOUNT_LOGGED;
	}
	else reason = REGISTER_ACCOUNT_NOUSER;
	CallRemoteFunction( "onPlayerLogin", "iii", playerid, reason, _:acc );
	if( _:acc != 0 ) fclose( acc );
	return true;
}

/*

	:
		registerPlayer(playerid, pass[]); //   
	:
		playerid - ID ,   
		pass[] - ,  
	    

*/

stock bool:registerPlayer( const playerid, password[] )
{
	new
		string[ 100 ],
		result,
		File: acc;

	format( string, sizeof( string ), accountdirectory(), getPlayerName( playerid ) );
	if( fexist( string ) )
		result = REGISTER_ACCOUNT_EXIST;
	else
	{
		if( strlen( password ) > MAX_PASSWORD )
			result = REGISTER_ACCOUNT_TOOLONGPASS;
		else
		{
			acc = fopen( string, io_append );
			savePlayerInfoString( acc, "Password", password );
			ss:PASSWORD[ playerid ] = password;
			savePlayerInfoInt( acc, "Block", 0 );
			result = REGISTER_ACCOUNT_DONE;
			si:plregged[ playerid ] = 1;
			si:pllogged[ playerid ] = 1;
		}
	}
	CallRemoteFunction( "onPlayerRegister", "iii",  playerid, result, _:acc );
	if( _:acc != 0 ) fclose( acc );
	return true;
}

/*

	:
		savePlayer(playerid); //  
	:
		playerid - ID ,    
	    

*/

stock bool:savePlayer( const playerid )
{
	new
		string[ 100 ],
		result,
		File: acc;

	format( string, sizeof( string ), accountdirectory(), getPlayerName( playerid ) );
	if( !fexist( string ) )
		result = REGISTER_ACCOUNT_NOUSER;
	else
	{
		if( gi:pllogged[ playerid ] == 1 )
		{
			acc = fopen( string, io_write );
			savePlayerInfoString( acc, "Password", gs:PASSWORD[ playerid ] );
			savePlayerInfoInt( acc, "Block", gi:Blocked[ playerid ] );
			result = REGISTER_ACCOUNT_SAVED;
		}
		else
			result = REGISTER_ACCOUNT_NOTLOGGED;
	}
	CallRemoteFunction( "onPlayerSave", "iii",  playerid, result, _:acc );
	if( _:acc != 0 ) fclose( acc );
	return true;
}

/*

	:
		changeNickName(playerid, newname[]); //  
	:
		playerid - ID ,    
		newname[] -  
	    .    onPlayerSave
 
*/

stock bool:changeNickName( const playerid, newname[] )
{
	if( strlen( newname ) > MAX_PLAYER_NAME ) return false;
	new
		string[ 100 ],
		result,
		File: acc;

	format( string, sizeof( string ), accountdirectory(), getPlayerName( playerid ) );
	if( !fexist( string ) )
		result = REGISTER_ACCOUNT_NOUSER;
	else
	{
		fremove( string );
		setPlayerName( playerid, newname );
		format( string, sizeof( string ), accountdirectory(), newname );
		if( gi:pllogged[ playerid ] == 1 )
		{
			acc = fopen( string, io_append );
			savePlayerInfoString( acc, "Password", gs:PASSWORD[ playerid ] );
			savePlayerInfoInt( acc, "Block", gi:Blocked[ playerid ] );
			result = REGISTER_ACCOUNT_SAVED;
		}
		else
			result = REGISTER_ACCOUNT_NOTLOGGED;
	}
	CallRemoteFunction( "onPlayerSave", "iii",  playerid, result, _:acc );
	if( _:acc != 0 ) fclose( acc );
	return true;
}

/*

	:
		changePassword(playerid, newpass[]); //  
	:
		playerid - ID ,    
		newname[] -  
	    .    onPlayerSave
 
*/

stock bool:changePassword( const playerid, newpass[] )
{
	if( gi:pllogged[ playerid ] != 1 ) return false;
	if( strlen( newpass ) < 1 || strlen( newpass ) > MAX_PASSWORD ) return false;
	new
		string[ 100 ],
		result,
		File: acc;

	format( string, sizeof( string ), accountdirectory(), getPlayerName( playerid ) );
	if( !fexist( string ) )
		result = REGISTER_ACCOUNT_NOUSER;
	else
	{
		if( gi:pllogged[ playerid ] == 1 )
		{
			acc = fopen( string, io_append );
			ss:PASSWORD[ playerid ] = newpass;
			savePlayerInfoString( acc, "Password", gs:PASSWORD[ playerid ] );
			savePlayerInfoInt( acc, "Block", gi:Blocked[ playerid ] );
			result = REGISTER_ACCOUNT_SAVED;
		}
		else
			result = REGISTER_ACCOUNT_NOTLOGGED;
	}
	CallRemoteFunction( "onPlayerSave", "iii",  playerid, result, _:acc );
	if( _:acc != 0 ) fclose( acc );
	return true;
}
/*

	:
		forward onPlayerLogin(playerid, result, File:account); //        
			:
				playerid - (int)ID 
				result - (int)  .
					  :
						REGISTER_ACCOUNT_LOGGIN -      
						REGISTER_ACCOUNT_WRONGPASS -    
						REGISTER_ACCOUNT_BLOCKED -   
						REGISTER_ACCOUNT_NOUSER -    
						REGISTER_ACCOUNT_LOGGED -      
				File:account - (file)ID  .

		forward onPlayerRegister(playerid, result, File:account); //    
		:
				playerid - (int)ID 
				result - (int)  .
					  :
						REGISTER_ACCOUNT_EXIST -      
						REGISTER_ACCOUNT_TOOLONGPASS -    
						REGISTER_ACCOUNT_DONE -   
				File:account - (file)ID  .

		forward onPlayerSave(playerid, result, File:account); //    
			:
				playerid - (int)ID 
				result - (int)  .
					  :
						REGISTER_ACCOUNT_SAVED -    
						REGISTER_ACCOUNT_NOUSER -    
						REGISTER_ACCOUNT_NOTLOGGED -      
				File:account - (file)ID  .
				
		forward onPlayerChangeName(playerid, result, File:account); //    
			:
				playerid - (int)ID 
				result - (int)  .
					  :
						REGISTER_ACCOUNT_SAVED -    
						REGISTER_ACCOUNT_NOUSER -    
						REGISTER_ACCOUNT_NOTLOGGED -      
				File:account - (file)ID  .

*/

//===============================================================
//
// 						 
//
//===============================================================