/******************************************************************************************************************************************

		----------------------------------------------------------------
			functions/d_servers.inc - ,   
				     .
		----------------------------------------------------------------

			-----------------------------------------------------------
				    SA-MP V0.3.7   
			-----------------------------------------------------------

------------------------------------------------------------------------------------------------------------------------------		

	  :
		V2.2 BUILD 1000  10.10.2016

------------------------------------------------------------------------------------------------------------------------------	

	  :
		V1.0 BUILD 1000  02.04.2015

------------------------------------------------------------------------------------------------------------------------------

	 :
		10.10.2016 -   
		02.04.2015 -   
		04.03.2015 -      
		
------------------------------------------------------------------------------------------------------------------------------

	   :
		native showSelectTable(playerid, selectid, min, max, hovercolor); //   
		native hideSelectTable(playerid); //   

------------------------------------------------------------------------------------------------------------------------------

	    :
		      Dima-kun a.k.a Morino_Reigan
	
	 :
		   SA-MP SAMP-RUS.COM     
		SA-MP TEAM  San Andreas-MultiPlayer
		Rockstar North Games  Grand Theft Auto San Andreas

	            : http://samp-rus.com
	
*******************************************************************************************************************************************/
#if defined d_includes_select
	#endinput
#endif
#define  d_includes_select 1

/*

	:
		showSelectTable(playerid, selectid, min, max, hovercolor) -   
	:
		playerid - ID ,    
		selectid - ID  ( 0  99999)
		min -   "" 
		max -   "" 
		hovercolor -     
	    .

*/

stock bool:showSelectTable( const playerid, const selectid, const min, const max, const hovercolor )
{
	if( gi:showIngSelectid[ playerid ] != INVALID_SELECT_ID ) return false;
	
    si:showIngSelectid[ playerid ] = selectid;
    SelectParams[ playerid ][ 0 ] = min;
    SelectParams[ playerid ][ 1 ] = max;
    si:showingSelect[ playerid ] = 0;
    
    Select[ playerid ][ 0 ] = CreatePlayerTextDraw( playerid,POSITION_X + 5.0,POSITION_Y + 2.5, " ~n~~n~~n~ ");
    PlayerTextDrawUseBox( playerid,Select[ playerid ][ 0 ], 1 );
    PlayerTextDrawBoxColor( playerid, Select[ playerid ][ 0 ], 0x00000099 );
    PlayerTextDrawTextSize( playerid, Select[ playerid ][ 0 ], POSITION_X + 305.0, 150.0 );
    PlayerTextDrawShow( playerid, Select[ playerid ][ 0 ] );
    //  ""
    Select[ playerid ][ 1 ] = CreatePlayerTextDraw( playerid,POSITION_X + 35.0,POSITION_Y + 9.5, "<<");
    PlayerTextDrawTextSize( playerid, Select[ playerid ][ 1 ], POSITION_X + 15.0, 40.0 );
    PlayerTextDrawLetterSize( playerid, Select[ playerid ][ 1 ], 0.7, 1.7 );
    PlayerTextDrawSetProportional( playerid, Select[ playerid ][ 1 ], 1 );
    PlayerTextDrawColor( playerid, Select[ playerid ][ 1 ], 0xFFFFFFFF );
    PlayerTextDrawSetOutline( playerid, Select[ playerid ][ 1 ], 1 );
    PlayerTextDrawAlignment( playerid, Select[ playerid ][ 1 ], 2 );
    PlayerTextDrawSetSelectable( playerid, Select[ playerid ][ 1 ], 1 );
    PlayerTextDrawShow( playerid, Select[ playerid ][ 1 ] );
    //  ""
    Select[ playerid ][ 2 ] = CreatePlayerTextDraw( playerid,POSITION_X + 100.0,POSITION_Y + 9.5, ">>");
    PlayerTextDrawTextSize( playerid, Select[ playerid ][ 2 ], POSITION_X + 15.0, 40.0 );
    PlayerTextDrawLetterSize( playerid, Select[ playerid ][ 2 ], 0.7, 1.7 );
    PlayerTextDrawSetProportional( playerid, Select[ playerid ][ 2 ], 1 );
    PlayerTextDrawColor( playerid, Select[ playerid ][ 2 ], 0xFFFFFFFF );
    PlayerTextDrawSetOutline( playerid, Select[ playerid ][ 2 ], 1 );
    PlayerTextDrawAlignment( playerid, Select[ playerid ][ 2 ], 2 );
    PlayerTextDrawSetSelectable( playerid, Select[ playerid ][ 2 ], 1 );
    PlayerTextDrawShow( playerid, Select[ playerid ][ 2 ] );
    //  ""
    Select[ playerid ][ 3 ] = CreatePlayerTextDraw( playerid,POSITION_X + 175.0,POSITION_Y + 9.5, "Select");
    PlayerTextDrawTextSize( playerid, Select[ playerid ][ 3 ], POSITION_X + 100.0, 40.0 );
    PlayerTextDrawLetterSize( playerid, Select[ playerid ][ 3 ], 0.7, 1.7 );
    PlayerTextDrawColor( playerid, Select[ playerid ][ 3 ], 0xFFFFFFFF );
    PlayerTextDrawSetOutline( playerid, Select[ playerid ][ 3 ], 1 );
    PlayerTextDrawAlignment( playerid, Select[ playerid ][ 3 ], 2 );
    PlayerTextDrawSetSelectable( playerid, Select[ playerid ][ 3 ], 1 );
    PlayerTextDrawShow( playerid, Select[ playerid ][ 3 ] );
    //  ""
    Select[ playerid ][ 4 ] = CreatePlayerTextDraw( playerid,POSITION_X + 260.0,POSITION_Y + 9.5, "Cancel");
    PlayerTextDrawTextSize( playerid, Select[ playerid ][ 4 ], POSITION_X + 100.0, 40.0 );
    PlayerTextDrawLetterSize( playerid, Select[ playerid ][ 4 ], 0.7, 1.7 );
    PlayerTextDrawColor( playerid, Select[ playerid ][ 4 ], 0xFFFFFFFF );
    PlayerTextDrawSetOutline( playerid, Select[ playerid ][ 4 ], 1 );
    PlayerTextDrawAlignment( playerid, Select[ playerid ][ 4 ], 2 );
    PlayerTextDrawSetSelectable( playerid, Select[ playerid ][ 4 ], 1 );
    PlayerTextDrawShow( playerid, Select[ playerid ][ 4 ] );
    SelectTextDraw( playerid, hovercolor );
    CallRemoteFunction( "onPlayerSelectShow", "ii", playerid, selectid );
	return true;
}

/*

	:
		hideSelectTable(playerid) -   
	:
		playerid - ID ,    
	    .

*/

stock hideSelectTable( const playerid )
{
    if( gi:showIngSelectid[ playerid ] == INVALID_SELECT_ID ) return false;
    si:showIngSelectid[ playerid ] = INVALID_SELECT_ID;
    for( new i = 0; i < 5; i++)
    {
    	PlayerTextDrawHide( playerid, Select[ playerid ][ i ] );
    	PlayerTextDrawDestroy( playerid, Select[ playerid ][ i ] );
	}
   	CancelSelectTextDraw( playerid );
	return true;
}

/*

	:
		forward onPlayerSelectShow(playerid, selectid); //      .
			:
				playerid - (int)ID 
				selectid - (int)ID  

		forward onPlayerSelect( playerid, selectid, selectpoint ); //     
			:
				playerid - (int)ID 
				selectid - (int)ID  

		forward onPlayerSelected( playerid, selectid, selectpoint ); //     
			:
				playerid - (int)ID 
				selectid - (int)ID  
				selectpoint - (int) ,  

		forward onPlayerCancel( playerid, oldselectid); //      "Cancel"
			:
				playerid - (int)ID 
				oldselectid - (int)ID
*/

//===============================================================
//
// 						 
//
//===============================================================