/******************************************************************************************************************************************

		------------------------------------------------------------------
			functions/d_vvars.inc -  PVar  
		------------------------------------------------------------------
		
			--------------------------------------------------------
				    SA-MP V0.3.7    
			--------------------------------------------------------

------------------------------------------------------------------------------------------------------------------------------		

	  :
		V2.2 BUILD 1000  10.10.2016

------------------------------------------------------------------------------------------------------------------------------	

	  :
		V1.0 BUILD 1000  02.04.2015

------------------------------------------------------------------------------------------------------------------------------

	 :
		10.10.2016 -   
		02.04.2015 -   
		04.03.2015 -      

------------------------------------------------------------------------------------------------------------------------------

	 :
		native setVVarInt(vehicleid, slot, value) -    
		native getVVarInt(vehicleid, slot) -     
		native setVVarFloat(vehicleid, slot, Float:value) -      
		native getVVarFloat(vehicleid, slot) -       
		native setVVarString(vehicleid, slot, Float:value) -     
		native getVVarString(vehicleid, slot) -      

	   :
		Integer: 
			vsi:slot[ vehicleid ] = value;  -    
			vgi:slot[ vehicleid ] 			-     
		Float:
			vsf:slot[ vehicleid ] = value; 	-      
			vgf:slot[ vehicleid ]			-       
		String:
			vss:slot[ vehicleid ] = "value"; -     
			vgs:slot[ vehicleid ]			 -      
------------------------------------------------------------------------------------------------------------------------------

	    :
		      Dima-kun a.k.a Morino_Reigan
	
	 :
		   SA-MP SAMP-RUS.COM     
		SA-MP TEAM  San Andreas-MultiPlayer
		Rockstar North Games  Grand Theft Auto San Andreas

	            : http://samp-rus.com
	
*******************************************************************************************************************************************/

#if defined d_includes_vvars
	#endinput
#endif
#define  d_includes_vvars 1

/*

	:
		setVVarInt(vehicleid, slot, value) -    
	:
		vehicleid - ID 
		slot -    ( 0  100)
		value - 
	    
	 : vsi:slot[ vehicleid ] = value;

*/

#define setVVarInt(%1,%2,%3) if( IsValidVehicle(%1) && %2 <= 100 ) vehVarInt[%1][%2]=%3
#define vsi:%1[%2]=%3; setVVarInt(%2,%1,%3);

/*

	:
		getVVarInt(vehicleid, slot) -     
	:
		vehicleid - ID 
		slot -    ( 0  100)
	      integer
	 : vgi:slot[ vehicleid ]

*/

#define getVVarInt(%1,%2) vehVarInt[%1][%2]
#define vgi:%1[%2] getVVarInt(%2,%1)

/*

	:
		setVVarFloat(vehicleid, slot, Float:value) -      
	:
		vehicleid - ID 
		slot -    ( 0  100)
		Float:value -  
	    . 
	 : vsf:slot[ vehicleid ] = value;

*/

#define setVVarFloat(%1,%2,%3) if( IsValidVehicle(%1) && %2 <= 100 ) vehVarFloat[%1][%2]=%3
#define vsf:%1[%2]=%3; setVVarFloat(%2,%1,%3);

/*

	:
		getVVarFloat(vehicleid, slot) -       
	:
		vehicleid - ID 
		slot -    ( 0  100)
	      float
	 : vgf:slot[ vehicleid ]

*/

#define getVVarFloat(%1,%2) vehVarFloat[%1][%2]
#define vgf:%1[%2] getVVarFloat(%2,%1)

/*

	:
		setVVarString(vehicleid, slot, Float:value) -     
	:
		vehicleid - ID 
		slot -    ( 0  100)
		value[] -  
	     
	 : vss:slot[ vehicleid ] = "value";

*/

#define setVVarString(%1,%2,%3) if( IsValidVehicle(%1) && %2 <= 100 ) strmid(vehVarString[%1][%2], %3, 0, strlen(%3), 255)
#define vss:%1[%2]=%3; setVVarString(%2,%1,%3);

/*

	:
		getVVarString(vehicleid, slot) -      
	:
		vehicleid - ID 
		slot -    ( 0  100)
	      float
	 : vgs:slot[ vehicleid ]

*/

#define getVVarString(%1,%2) vehVarString[%1][%2]
#define vgs:%1[%2] getVVarString(%2,%1)

new stichars[][] = { 
	"A","a","B","b","C","c","D","d","E","e","F","f","G","g","H",
	"h","I","i","J","j","K","k","L","l","M","m","N","n","O","o",
	"P","p","Q","q","R","r","S","s","T","t","V","v","W","w","X",
	"x","Y","y","Z","z","U","u"
};

new intchars[][] = { 
	"10","11","12","13","14","15","16","17","18","19","20","21","22","23","24",
	"25","26","27","28","29","30","31","32","33","34","35","36","37","38","39",
	"40","41","42","43","44","45","46","47","48","49","50","51","52","53","53",
	"54","55","56","57","58","59","60"
};

stock stringToInt( _string[  ] )
{
	if( !strlen( _string ) ) return 0xfff;
	new
		i = 0,
		rstring[ 100 ],
		chars[ 2 ],
		bool:done;

	do
	{
		done = false;
		format( chars, sizeof( chars ), "%c", _string[ i ] );
		for( new t = 0, u = sizeof( stichars ); t < u; t++ )
		{
			
			if( !strcmp( chars, stichars[ t ],  false ) )
			{
				strcat( rstring, intchars[ t ] );
				done = true;
			}
		}
		if( done == false )
			strcat( rstring, chars );
		i++;
	}while ( i < strlen( _string ) );
	return strval( rstring );
}

#pragma unused vehVarInt
#pragma unused vehVarFloat
#pragma unused vehVarString