/******************************************************************************************************************************************

		--------------------------------------------------------------------------
			functions/d_weather.inc -     
		--------------------------------------------------------------------------
			-------------------------------------------------------
				    SA-MP V0.3.7   
			-------------------------------------------------------

------------------------------------------------------------------------------------------------------------------------------		

	  :
		V2.2 BUILD 1000  10.10.2016

------------------------------------------------------------------------------------------------------------------------------	

	  :
		V1.0 BUILD 1000  10.10.2016

------------------------------------------------------------------------------------------------------------------------------

	 :
		10.10.2016 -   - d_weather.inc
		02.04.2015 -   
		04.03.2015 -      

------------------------------------------------------------------------------------------------------------------------------

	   :
		native addWeatherZone( weatherid, Float: posx1, Float: posy1, Float: posx2, Float: posy2 ); //  ,      
		native deleteWeatherZone( wzid ); //   
		native updateWeatherZone( wzid, weatherid ); //  ID     

------------------------------------------------------------------------------------------------------------------------------

	    :
		      Dima-kun a.k.a Morino_Reigan
	
	 :
		   SA-MP SAMP-RUS.COM     
		SA-MP TEAM  San Andreas-MultiPlayer
		Rockstar North Games  Grand Theft Auto San Andreas

	            : http://samp-rus.com
	
*******************************************************************************************************************************************/

#if defined d_includes_weather
	#endinput
#endif
#define  d_includes_weather 1
#define MAX_ZONES 50

enum wInfo
{
	vvalid,
	vweatherid,
	Float: vposx1,
	Float: vposy1,
	Float: vposx2,
	Float: vposy2,
}

new	
	weatherZone[ MAX_ZONES ][ wInfo ],
	addzones = -1;

/* 
	:
		addWeatherZone( weatherid, Float: posx1, Float: posy1, Float: posx2, Float: posy2 ); //  ,      
	:
		weatherid - (int) ID 
		Float: posx1 - (float)    
		Float: posy1 - (float)    
		Float: posx2 - (float)    
		Float: posy2 - (float)    
	  ID  

*/

stock addWeatherZone( weatherid, Float: posx1, Float: posy1, Float: posx2, Float: posy2 )
{	
	addzones++;
	weatherZone[ addzones ][ vweatherid ] = weatherid;
	weatherZone[ addzones ][ vposx1 ] = posx1;
	weatherZone[ addzones ][ vposy1 ] = posy1;
	weatherZone[ addzones ][ vposx2 ] = posx2;
	weatherZone[ addzones ][ vposy2 ] = posy2;
	weatherZone[ addzones ][ vvalid ] = 1;
	printf( "awz: weatherid:%i posx:%f valid:%i", weatherZone[ addzones ][ vweatherid ], weatherZone[ addzones ][ vposx1 ], weatherZone[ addzones ][ vvalid ] );
	return addzones;
}

/* 
	:
		deleteWeatherZone( wzid ); //   
	:
		wzid - (int) ID    
	  1   ,  0 -  .

*/

stock deleteWeatherZone( wzid )
{
	if( weatherZone[ wzid ][ vvalid ] == 1 )
	{
		weatherZone[ wzid ][ vposx1 ] = -1;
		weatherZone[ wzid ][ vposx1 ] = 0.0;
		weatherZone[ addzones ][ vposy1 ] = 0.0;
		weatherZone[ addzones ][ vposx2 ] = 0.0;
		weatherZone[ addzones ][ vposy2 ] = 0.0;
		weatherZone[ addzones ][ vvalid ] = 0;
		return 1;
	}
	return 0;
}

/* 
	:
		updateWeatherZone( wzid, weatherid ); //  ID     
	:
		wzid - (int) ID    
		weatherid - (int) ID 
	  1   ,  0 -  .

*/

stock updateWeatherZone( wzid, weatherid )
{
	if( weatherZone[ wzid ][ vvalid ] == 1 )
	{
		weatherZone[ wzid ][ vweatherid ] = weatherid;
		return 1;
	}
	return 0;
}

public d_checkWeatherZone()
{
	for( new i = 0, j = GetPlayerPoolSize(); i <= j; i++ )
	{
		if( IsPlayerConnected( i ) ) 
		{
			si:settedweather[ i ] = 0;
			for( new k = 0; k <= addzones; k++ )
			{
				if( weatherZone[ k ][ vvalid ] == 1 )
				{
					if( isPlayerInArea( i, weatherZone[ k ][ vposx1 ], weatherZone[ k ][ vposy1 ], weatherZone[ k ][ vposx2 ], weatherZone[ k ][ vposy2 ] ) )
					{
						SetPlayerWeather( i, weatherZone[ k ][ vweatherid ] );
						si:settedweather[ i ] = 1;
					}
					else
						if( gi:settedweather[ i ] == 0 )
							SetPlayerWeather( i, getServerWeather() );
				}
			}
		}
	}
	return 1;
}
//=============================================================================================================================
//
// 															 
//
//=============================================================================================================================