 /******************************************************************************************************************************************

		---------------------------------------------------------------------
			functions/d_admins.inc - ФУНКЦИЯ ДЛЯ АДМИНИСТРАТОРОВ СЕРВЕРА
		---------------------------------------------------------------------

			-----------------------------------------------------------
				ДЛЯ РАБОТЫ НЕОБХОДИМ СЕРВЕР SA-MP V0.3.7 И ВЫШЕ 
			-----------------------------------------------------------

------------------------------------------------------------------------------------------------------------------------------	

	ТЕКУЩАЯ ВЕРСИЯ СБОРНИКА:
		V2.2 BUILD 1000 ОТ 10.10.2016

------------------------------------------------------------------------------------------------------------------------------	

	ТЕКУЩАЯ ВЕРСИЯ БИБЛИОТЕКИ:
		V1.2 BUILD 1000 ОТ 02.04.2015

------------------------------------------------------------------------------------------------------------------------------

	ИСТОРИЯ СОБЫТИЙ:
		10.10.2016 - ОБНОВЛЕНИЕ СБОРНИКА БИБЛИОТЕК
		02.04.2015 - ОБНОВЛЕНИЕ СБОРНИКА БИБЛИОТЕК
		04.03.2015 - ВЫХОД ПЕРВОЙ ВЕРСИИ ДАННОГО СБОРНИКА БИБЛИОТЕК
		
------------------------------------------------------------------------------------------------------------------------------

	ОСНОВНЫЕ ФУНКЦИИ ДАННОЙ БИБЛИОТЕКИ:
		native toggleServerLog(bool:status); // указывает вести лог действий админа или нет
		native slapPlayer(playerid); // ѕинает игрока, отнимая при этом его здоровье
		native gotoPlayer(playerid, targetid); // “елепортировать игрока к другому игроку
		native getherePlayer(playerid, targetid); // “елепортировать другого игрока к игроку
		native gethereAll(playerid); // “елепортировать другого игрока к игроку
		native setPlayerMute(playerid, bool: statu ); // дает/забирает игрока возможность писать в общий чат
		native bool:isPlayerMuted(playerid); // узнает "заглушен" ли игрок.
		native BlowUpPlayer(targetid); // взорвать игрока
		native BlowUpVehicle(vehicleid); // взорвать машину
		native isAdvertising(text[]); // проверяет есть ли в тексте ссылки на сайты.
		native isIpAdress(string[]); // проверяет есть ли в тексте IP-адрес
		native bool:isAdminsOnline(); // узнает есть ли кто-нибудь из rcon админов онлайн
		native sendMessageToAdmins( color, msg[] ); // ќтправить сообщение RCON-админам
		native setAdminsColor(color); // устанавливает цвет для всех подключенных и пока не подключенных( оторые пишут RCON-пароль в клиенте) RCON-админов
		native cagePlayer(targetid); // создает клетку и помещает игрока в нее
		native unCagePlayer(targetid); // освободить игрока из клетки
		native reloadFS(fsname[]); // перезагрузить фильтрскрипт
		native runOffServer(); // выключить сервер
		native restartServer(); // перезагрузить сервер
		native sendMessageAsAdmin( message[] ); // отправить сообщение от имени администратора (Admin)
		native allowAdminTeleport(); // включает возможность телепортироваться rcon-админам по нажатию на карте.(возвращение удаленной функции)
		native crashPlayer(playerid); // вызывать crash клиента игрока.
		native togglePlayerFreezeEx(playerid, time); // замораживает игрока на определенное время

------------------------------------------------------------------------------------------------------------------------------

----------------------------------------------------------------------------------------------------------------------------------

	АВТОРСКИЕ ПРАВА К СБОРТНИКУ БИБЛИОТЕК:
		ВСЕ ПРАВА НА ЭТОТ СБОРНИК ПРИНАДЛЕЖАТ Dima-kun a.k.a Morino_Reigan
	
	ОТДЕЛЬНАЯ БЛАГОДАРНОСТЬ:
		ПОРТАЛУ РУССКОГО КОМЬЮНИТИ SA-MP SAMP-RUS.COM ЗА РАСПРОСТРАНЕНИЕ ДАННОГО СБОРНИКА БИБЛИОТЕК
		SA-MP TEAM ЗА San Andreas-MultiPlayer
		Rockstar North Games ЗА Grand Theft Auto San Andreas

	РАСПРОСТРАНЕНИЕ ДАННОГО СБОРНИКА БИБЛИОТЕК ВОЗМОЖНА ТОЛЬКО С СОХРАНЕНИЕМ ИМЕНИ АВТОРА И УКАЗАНИЕМ ИСТОЧНИКА: http://samp-rus.com
	
*******************************************************************************************************************************************/

#if defined d_includes_admins
	#endinput
#endif
#define d_includes_admins

/*

	Функция:
		toggleServerLog(bool:status) - указывает вести лог действий админа или нет
	ѕараметры:
		bool:status - true - вести / false - не вести.
	Функция не возвращает специфических значений.

*/

stock bool:toggleServerLog( bool:status )
{
	_gdebug = status;
	return true;
}

/*

	Функция:
		slapPlayer(playerid) - ѕинает игрока, отнимая при этом его здоровье
	ѕараметры:
		playerid - ID игрока, которого необходитмо пнуть
	Функция не возвращает специфических значений.

*/

stock bool:slapPlayer( const playerid )
{
	new
		Float: slx,
		Float: sly,
		Float: slz;

	givePlayerHealth( playerid, -5 );
	GetPlayerPos( playerid, slx, sly, slz );
	SetPlayerPos( playerid, slx, sly, slz + 5 );
	playSoundAll( 1130, slx, sly, slz + 5 );
	if( _gdebug == true ) printf( "AdmCmd: Player %s slapped ", getPlayerName( playerid ) );
	return true;
}

/*

	Функция:
		gotoPlayer(playerid, targetid) - “елепортировать игрока к другому игроку
	ѕараметры:
		playerid - ID телепортируемого игрока
		targetid - ID игрока к которому следует телепортировать игрока playerid
	Функция не возвращает специальных значений.

*/

stock bool:gotoPlayer( const playerid, const targetid )
{
	new
		Float: plocx,
		Float: plocy,
		Float: plocz;

	if ( IsPlayerConnected( targetid ) )
	{
		GetPlayerPos( targetid, plocx, plocy, plocz );
		if( _gdebug == true ) printf( "AdmCmd: %s teleported to к %s", getPlayerName( playerid ), getPlayerName( targetid ) );
		SetPlayerInterior( playerid, GetPlayerInterior( targetid ) );
		if ( GetPlayerState( playerid ) == PLAYER_STATE_DRIVER )
		{
			new
				tmpcar = GetPlayerVehicleID( playerid );

			SetVehiclePos( tmpcar, plocx, plocy + 4, plocz );
			PutPlayerInVehicle( playerid, tmpcar, 0 );
		}
		else
			SetPlayerPos( playerid, plocx, plocy + 2, plocz );
	}
	return true;
}

/*

	Функция:
		getherePlayer(playerid, targetid) - “елепортировать другого игрока к игроку
	ѕараметры:
		playerid - ID игрока к которому следует телепортировать игрока targetid
		targetid - ID телепортируемого игрока
	Функция не возвращает специальных значений.

*/

stock bool:getherePlayer( const playerid, const targetid )
{
	new
		Float: plocx,
		Float: plocy,
		Float: plocz;

	if ( IsPlayerConnected( targetid ) )
	{
		GetPlayerPos( playerid, plocx, plocy, plocz );
		if( _gdebug == true ) printf( "AdmCmd: %s teleported to к %s", getPlayerName( targetid ), getPlayerName( playerid ) );
		SetPlayerInterior( targetid, GetPlayerInterior( playerid ) );
		if ( GetPlayerState( targetid ) == PLAYER_STATE_DRIVER )
		{
			new
				tmpcar = GetPlayerVehicleID( targetid );

			SetVehiclePos( tmpcar, plocx, plocy + 4, plocz );
			PutPlayerInVehicle( targetid, tmpcar, 0 );
		}
		else
			SetPlayerPos( targetid, plocx, plocy + 2, plocz );
	}
	return true;
}

/*

	Функция:
		gethereAll(playerid) - “елепортировать другого игрока к игроку
	ѕараметры:
		playerid - ID игрока к которому следует телепортировать всех игроков
	Функция не возвращает специальных значений.

*/

stock bool:gethereAll( const playerid )
{
	new
		Float: plocx,
		Float: plocy,
		Float: plocz;

	if( _gdebug == true ) printf( "AdmCmd: %s teleported all to his", getPlayerName( playerid ) );
	for( new i = 0, j = GetPlayerPoolSize(); i <= j; i++ )
	{
		if ( IsPlayerConnected( i ) && i != playerid )
		{
			GetPlayerPos( playerid, plocx, plocy, plocz );
			SetPlayerInterior( targetid, GetPlayerInterior( playerid ) );
			if ( GetPlayerState( i ) == PLAYER_STATE_DRIVER )
			{
				new
					tmpcar = GetPlayerVehicleID( i );

				SetVehiclePos( tmpcar, plocx + ( random( 5 ) - random( 6 ) ), plocy + ( random( 5 ) - random( 6 ) ), plocz );
				PutPlayerInVehicle( i, tmpcar, 0 );
			}
			else
				SetPlayerPos( i, plocx + ( random( 5 ) - random( 6 ) ), plocy + ( random( 5 ) - random( 6 ) ), plocz );
		}
	}
	return true;
}

/*

	Функция:
		showRconAdmins() - “елепортировать игрока к другому игроку
	Ќет параметров.
	Функция возвращает массив с именами админов. –азмер массива - 256 ячеек.

*/

stock showRconAdmins( )
{
	new	
		admins[ 256 ],
		str[ MAX_PLAYER_NAME + 2 ];
	
	for( new i = 0, j = GetPlayerPoolSize(); i <= j; i++ )
	{
		if( strlen( admins ) >= sizeof( admins ) ) break;
		if( IsPlayerConnected( i ) && IsPlayerAdmin( i ) )
		{
			format( str, sizeof( str ), "%s\n", getPlayerName( i ) );
			strcat( admins, str );
		}
			//strmid( admins[ idx ], getPlayerName( i ), 0, strlen( getPlayerName( i ) ), 255 );
	}
	return admins;
}

/*

	Функция:
		setPlayerMute(playerid, bool: status) - дает/забирает игрока возможность писать в общий чат("заглушить")
	ѕараметры:
		playerid - ID игрока к которому следует телепортировать игрока targetid
		bool: status  - true - запретить, и false - разрешить писать
	Функция не возвращает специальных значений.

*/

#define setPlayerMute(%1,%2) si:plmuted[ %1 ] = %2

/*

	Функция:
		bool:isPlayerMuted(playerid) - узнает "заглушен" ли игрок.
	ѕараметры:
		playerid - ID игрока к которому следует телепортировать игрока targetid
	Функция возвращает true - если не "заглушен", и false - если не "заглушен".

*/

#define isPlayerMuted(%1) gi:plmuted[ %1 ]

/*

	Функция:
		BlowUpPlayer(targetid) - взорвать игрока
	ѕараметры:
		targetid - ID игрока которого следует взорвать
	Функция не возвращает специальных значений.

*/

stock bool:BlowUpPlayer( const targetid )
{
	new
		Float:pos[ 3 ];

	GetPlayerPos( targetid, pos[ 0 ], pos[ 1 ], pos[ 2 ] );
	CreateExplosion( pos[ 0 ], pos[ 1 ], pos[ 2 ], 3, 6.0 );
	return true;
}

/*

	Функция:
		BlowUpVehicle(vehicleid) - взорвать машину
	ѕараметры:
		vehicleid - ID машины которого следует взорвать
	Функция не возвращает специальных значений.

*/

stock bool:BlowUpVehicle( const vehicleid )
{
	new
		Float:pos[ 3 ];

	GetVehiclePos( vehicleid, pos[ 0 ], pos[ 1 ], pos[ 2 ] );
	CreateExplosion( pos[ 0 ], pos[ 1 ], pos[ 2 ], 3, 6.0 );
	return true;
}

/*

	Функция:
		isAdvertising(text[]) - проверяет есть ли в тексте ссылки на сайты.
	ѕараметры:
		text[] - проверяемый текст
	Функция возвращает true - если в тексте обнаружена ссылка на сайт, и false - если в тексте не обнаружено ссылок.

*/

stock bool:isAdvertising( const text[] )
{
    if( strfind( text , "www" , true ) != -1 || strfind( text , ".net" , true ) != -1 || strfind( text , ".ru" , true ) != -1
	|| strfind( text , ".com" , true ) != -1 || strfind( text , ". рф" , true ) != -1 || strfind( text , ".su" , true ) != -1
	|| strfind( text , ".biz" , true ) != -1 || strfind( text , ". ru" , true ) != -1 || strfind( text , ". net" , true ) != -1
	|| strfind( text , ". com" , true ) != -1 || strfind( text , ".рф" , true ) != -1 ) return true;
	return false;
}

/*

	Функция:
		isIpAdress(string[]) - проверяет есть ли в тексте IP-адрес
	ѕараметры:
		string[] - проверяемый текст
	Функция возвращает true - если в тексте обнаружен IP-адрес, и false - если в тексте не обнаружено IP-адресов.

*/

stock bool:isIpAdress( const string[] )
{
	new
		i,
		digits;

	if( ( i = strfind( string, ".", false, 0 ) ) >= 0 )
	{
		for( ++i; ; i++ )
		{
			switch( string[ i ] )
			{
				case ' ': if( digits > 0 ) break; else continue;
				case '0'..'9': digits++;
				default: break;
			}
		}
		if( digits >= 2 ) return true;
	}
	return false;
}

/*
	Функция:
		bool:isAdminsOnline() - узнает есть ли кто-нибудь из rcon админов онлайн
	¬озвращает true если есть, false если нету.
	
*/

stock bool:isAdminsOnline()
{
	for( new i = 0, j = GetPlayerPoolSize(); i <= j; i++ )
		if( IsPlayerConnected( i ) && IsPlayerAdmin( i ) ) return true;
	return false;
}

/*
	Функция:
		sendMessageToAdmins( color, msg[] ) - ќтправить сообщение RCON-админам
	ѕараметры:
		 color - цвет сообщения
		 msg[] - —ообщение
	Функция не возвращает специальных значений
	
*/

stock bool:sendMessageToAdmins( color, msg[] )
{
	for( new i = 0, j = GetPlayerPoolSize(); i <= j; i++ )
		if( IsPlayerConnected( i ) && IsPlayerAdmin( i ) )
			SendClientMessage( i, color, msg );
	return true;
}

/*

	Функция:
		setAdminsColor(color) - устанавливает цвет для всех подключенных и пока не подключенных( оторые пишут RCON-пароль в клиенте) RCON-админов
	ѕараметры:
		color - ÷вет(Hex)
	Функция не возвращает специальных значений.

*/

stock setAdminsColor( color )
{
	admincolor = color;
	for( new i = 0, j = GetPlayerPoolSize(); i <= j; i++ )
		if( IsPlayerConnected( i ) && IsPlayerAdmin( i ) ) 
			SetPlayerColor( i, color );
	return color;
}

/*

	Функция:
		cagePlayer(targetid) - создает клетку и помещает игрока в нее
	ѕараметры:
		targetid - ID игрока
	Функция не возвращает специальных значений.

*/

stock bool:cagePlayer( const targetid )
{
	if( gi:plCaged[ targetid ] == 1 ) return false;
	new 
		Float:pos[ 3 ];

	GetPlayerPos( targetid, pos[ 0 ], pos[ 1 ], pos[ 2 ] );
	si:plCage1[ targetid ] = CreateObject( 985, pos[ 0 ], pos[ 1 ], pos[ 2 ] + 10.0, 0, 0, 0 );
	si:plCage2[ targetid ] = CreateObject( 985, pos[ 0 ] + 4.0 ,pos[ 1 ] - 4.0, pos[ 2 ] + 10.0, 0, 0, 90 );
	si:plCage3[ targetid ] = CreateObject( 985, pos[ 0 ] - 4.0 , pos[ 1 ] - 4.0, pos[ 2 ] + 10.0, 0, 0, 90 );
	si:plCage4[ targetid ] = CreateObject( 985, pos[ 0 ], pos[ 1 ] - 8.0, pos[ 2 ] + 10.0, 0, 0, 0 );
	si:plCage5[ targetid ] = CreateObject( 985, pos[ 0 ], pos[ 1 ] - 4.0, pos[ 2 ] + 8.2, 90, 0, 0 );
	si:plCage6[ targetid ] = CreateObject( 985, pos[ 0 ], pos[ 1 ] - 4.0, pos[ 2 ] + 8.2, 90, 0, 180 );
	SetPlayerPos( targetid, pos[ 0 ], pos[ 1 ] - 2.2, pos[ 2 ] + 11.0 );
	si:plCaged[ targetid ] = 1;
	return true;
}

/*

	Функция:
		unCagePlayer( const targetid ) - освободить игрока из клетки
	ѕараметры:
		targetid - ID игрока
	Функция не возвращает специальных значений.

*/

stock bool:unCagePlayer( const targetid )
{
	if( gi:plCaged[ targetid ] == 0 ) return false;
	new 
		Float:pos[ 3 ];

	DestroyObject( gi:plCage1[ targetid ] );
	DestroyObject( gi:plCage2[ targetid ] );
	DestroyObject( gi:plCage3[ targetid ] );
	DestroyObject( gi:plCage4[ targetid ] );
	DestroyObject( gi:plCage5[ targetid ] );
	DestroyObject( gi:plCage6[ targetid ] );
	GetPlayerPos( targetid, pos[ 0 ], pos[ 1 ], pos[ 2 ] );
	SetPlayerPos( targetid, pos[ 0 ], pos[ 1 ] + 2.2, pos[ 2 ] - 9.9 );
	si:plCaged[ targetid ] = 0;
	return true;
}

/*

	Функция:
		reloadFS(fsname[]) - перезагрузить фильтрскрипт
	ѕараметры:
		fsname[] - название скрипта
	Функция не возвращает специальных значений.

*/

stock bool:reloadFS( const fsname[] )
{
	new
		string[ 100 ];

	format( string, sizeof( string ), "unloadfs %s", fsname );
	SendRconCommand( string );
	format( string, sizeof( string ), "loadfs %s", fsname );
	SendRconCommand( string );
	return true;
}

/*

	Функция:
		runOffServer() - выключить сервер
	Функция не имеет параметров
	Функция не возвращает специальных значений.

*/

#define runOffServer() SendRconCommand( "exit" )

/*

	Функция:
		restartServer() - перезагрузить сервер
	Функция не имеет параметров
	Функция не возвращает специальных значений.

*/

#define restartServer() SendRconCommand( "gmx" )

/*

	Функция:
		sendMessageAsAdmin( message[] ) - отправить сообщение от имени администратора (Admin)
	ѕараметров:
		message[] - текст сообщения
	Функция не возвращает специальных значений.

*/

stock sendMessageAsAdmin( const message[] )
{
	new 
		string[ 132 ];

	format( string, sizeof( string ), "say %s", message );
	return SendRconCommand( string );
}

/*

	Функция:
		allowAdminTeleport() - включает возможность телепортироваться rcon-админам по нажатию на карте.(возвращение удаленной функции)
	Функция не имеет параметров
	Функция не возвращает специальных значений.

*/

stock bool:allowAdminTeleport()
{
	adTeleport = true;
	return true;
}

/*

	Функция:
		crashPlayer(playerid) - вызывать crash клиента игрока.
	ѕараметры:
		playerid - ID игрока, для которого нужно установить умения.
	Функция не возвращает специальных значений.

*/

stock bool:crashPlayer( const playerid )
{
	new 
		Float: pos[ 3 ];

	GetPlayerPos( playerid, pos[ 0 ], pos[ 1 ], pos[ 2 ] );
	si:plCrashObj[ playerid ] = CreatePlayerObject( playerid, 385, pos[ 0 ], pos[ 1 ], pos[ 2 ], 0.0, 0.0, 0.0 );
	return true;
}

/*

 	Функция: 
		togglePlayerFreezeEx(playerid, time) - замораживает игрока на определенное время
 	ѕараметры:
		playerid - ID проверяемого игрока
		time - время заморозки в секундах
	Функция не возвращает специальных значений.

*/

stock bool:togglePlayerFreezeEx( const playerid, const time )
{
	if( gi:plFreezed[ playerid ] == 1 )
		return false;
	si:plFreezed[ playerid ] = 1;
	TogglePlayerControllable( playerid, false );
	SetTimerEx( "unFreeze", time * 1000, false, "i", playerid );
	return true;
}
//===============================================================
//
// 						 Конец файла
//
//===============================================================