/******************************************************************************************************************************************

		-----------------------------------------------------------------
			functions/d_players.inc -    .
		-----------------------------------------------------------------

			-------------------------------------------------------
				    SA-MP V0.3.7   
			-------------------------------------------------------

------------------------------------------------------------------------------------------------------------------------------		

	  :
		V2.2 BUILD 1000  10.10.2016

------------------------------------------------------------------------------------------------------------------------------	

	  :
		V1.2 BUILD 1000  10.10.2016

------------------------------------------------------------------------------------------------------------------------------

	 :
		10.10.2016 -    :
			d_players.inc:
				native isPlayerInArea( playerid, Float: posx1, Float:posy1, Float:posx2, Float:posy2 ); //         
		02.04.2015 -     :
			d_players.inc:
				native maxPlayerHealth(playerid, Float:amount); //      
				native getPlayerObjectPoolSize(playerid); //   ID  
				native getFreeAttachSlot(playerid); //     
				native togglePlayerControllable(playerid, bool:status, damage); // /    ()  
				native isPlayerControllable(playerid); //     ,  
		04.03.2015 -      
		
------------------------------------------------------------------------------------------------------------------------------

	   :
		native gpci(playerid, serial[], len); //  Serial-   . 
		native gpciEx(playerid); //    gpci
		native setPlayerSkillLevel(playerid,types,skil); //    . 
		native setPlayerSkillLevelToAll(types,skil); //      .
		native getPlayerSkillLevel(playerid,types); //       
		native getPlayerName(playerid); //   
		native getPlayerIp(playerid); //  IP- 
		native getPlayerVersion(playerid); //    
		native Float:getPlayerHealth(playerid); //      
		native givePlayerHealth(playerid,Float:health); //    
		native Float:getPlayerArmour(playerid); //     
		native givePlayerArmour(playerid,Float:armour)-     ,       100,   .
		native getPlayerID(name[]); //  ID   .
		native clearChatToPlayer(playerid); //     
		native clearChatToAll(); //     ,   
		native sendPersonalMessage(playerid,targetid,color,string[]); //      . 
		native getPlayerInfo(playerid, nickname[], &Float:x, &Float:y, &Float:z, &Float:FacingAngle, &Float:health, &Float:armour, &pstate, &interior, &virtual, &skin, &team, &ping, &color); //     
		native setPlayerColorForAll(color); //      
		native createPlayer3DtextLableEx(playerid,text[],color,Float:x=0.0,Float:y=0.0,Float:z=0.7,Float:DrawDistance=100.0,virtual=0,testLOS=0); // ,   
		native deletePlayer3DtextLableEx(playerid); //     .
		native updatePlayer3DtextLableEx(playerid,color,text[]); //     
		native isPlayherLableExists(playerid); //      
		native setPlayerMoney(playerid, amount); //     
		native givePlayerMoneyToPlayer(playerid, targetid, amount); //    .
		native givePlayerMoneyToPlayerEx(playerid, targetid, amount, Float: range); //   ,      
		native givePlayerHealthToPlayer(playerid, targetid, Float: amount); //    
		native givePlayerHealthToPlayerEx(playerid, targetid, Float: amount, Float: range); //   ,      
		native givePlayerArmourToPlayer(playerid, const targetid, Float: amount); //    
		native givePlayerArmourToPlayerEx(playerid, targetid, Float: amount, Float: range); //   ,      
		native setPlayerPosEx(playerid,Float:x,Float:y,Float:z,Float:FacingAngle,interior=0,virtual=0); //       .
		native getPlayerPosEx(playerid,&Float:x,&Float:y,&Float:z,&Float:FacingAngle,&interior,&virtual); //      ,  ,   
		native givePlayerWeaponEx(playerid,{id}); //   .
		native deletePlayerWeapon(playerid, gunid); //    
		native sendFormatMessage(playerid,color,const format[],{Float,_}:...); //    
		native sendFormatMessageToAll(color,const format[],{Float,_}:...); //       .
		native showInfoDialog(playerid, title[], test[]); //     
		native isDialogShowedForPlayer(playerid); //       
		native hideDialog(playerid); //   
		native givePlayerVehicle(playerid, modelid); //   
		native SendClientCheck(playerid, actionid, memaddr, memOffset, bytesCount);//    
		native rangeBan(playerid); //     IP-. : 127.0.**.**
		native arePlayersConnected(); //       1   
		native randomPlayer(); //  ID   .
		native getPlayerShopName(playerid); //   ,    
		native getPlayerFPS(playerid); //  FPS 
		native sendMessage(playerid, string[]); //   
		native clearMessages(playerid); //   
		native playSoundAll(playerid, soundid, Float: psx, Float: psy, Float: psz); //   
		native giveScoreToPlayer(playerid, score); //   
		native isPlayerJump(playerid); //       ,  .
		native isPlayerDropDown(playerid); //       ,  .
		native isPlayerSwiming(playerid); //       ,  .
		native tooglePlayerCameraUp(playerid, bool:toggle, Float:distanse); //       
		native isPlayerSpectating(playerid); //        (spectate)
		native maxPlayerHealth(playerid, Float:amount); //      
		native getPlayerObjectPoolSize(playerid); //   ID  
		native getFreeAttachSlot(playerid); //     
		native togglePlayerControllable(playerid, bool:status, damage); // /    ()  

------------------------------------------------------------------------------------------------------------------------------

	    :
		      Dima-kun a.k.a Morino_Reigan
	
	 :
		   SA-MP SAMP-RUS.COM     
		SA-MP TEAM  San Andreas-MultiPlayer
		Rockstar North Games  Grand Theft Auto San Andreas

	            : http://samp-rus.com
	
*******************************************************************************************************************************************/

#if defined d_includes_players
	#endinput
#endif
#define d_includes_players  1

/*

	:
		gpci(playerid, serial[], len) -  Serial-   . 
	:
		playerid - ID ,     Serial-
		serial[] - ,    Serial-
		len -  Serial-
	    .
	
*/

native gpci(playerid, serial[], len);

/*

	:
		gpciEx(playerid) -    gpci
	:
		playerid - ID ,     Serial-
	  Serial-
	
*/

#define gpciEx(%1) gs:pSerial[ %1 ]

/*

	:
		setPlayerSkillLevel(playerid,types,skil) -    . 
	:
		playerid - ID ,     .
		types -  (    FS ).
		skill -     
	    .
	
*/

stock setPlayerSkillLevel( const playerid, const types, const skill )
{
	SetPlayerSkillLevel( playerid, types, skill );
	switch( types )
	{
		case 0: si:plskillpistol[ playerid ] = skill; 
		case 1: si:plskillsenced[ playerid ] = skill;
		case 2: si:plskilldeagle[ playerid ] = skill;
		case 3: si:plskillshotgun[ playerid ] = skill;
		case 4: si:plskillsawnoff[ playerid ] = skill;
		case 5: si:plskillspas12[ playerid ] = skill;
		case 6: si:plskilluzi[ playerid ] = skill;
		case 7: si:plskillmp5[ playerid ] = skill;
		case 8: si:plskillak47[ playerid ] = skill;
		case 9: si:plskillm4[ playerid ] = skill;
		case 10: si:plskillrifle[ playerid ] = skill;
	}
	return 999;
}

/*

	:
		setPlayerSkillLevelToAll(types,skil) -      .
	:
		types -  (    FS ).
		skill -     
	    .
	
*/

#define setPlayerSkillLevelToAll(%1,%2) \
		for( new i = 0, j = GetPlayerPoolSize(); i <= j; i++ ) \
			if( IsPlayerConnected( i ) ) \
				setPlayerSkillLevel( i, %1, %2 )

/*

	:
		getPlayerSkillLevel(playerid,types) -       
	:
		playerid - ID ,     .
		types -  (    FS ).
	     ( ).

*/

stock getPlayerSkillLevel( const playerid, const types )
{
	switch( types )
	{
		case 0: return gi:plskillpistol[ playerid ];
		case 1: return gi:plskillsenced[ playerid ];
		case 2: return gi:plskilldeagle[ playerid ];
		case 3: return gi:plskillshotgun[ playerid ];
		case 4: return gi:plskillsawnoff[ playerid ];
		case 5: return gi:plskillspas12[ playerid ];
		case 6: return gi:plskilluzi[ playerid ];
		case 7: return gi:plskillmp5[ playerid ];
		case 8: return gi:plskillak47[ playerid ];
		case 9: return gi:plskillm4[ playerid ];
		case 10: return gi:plskillrifle[ playerid ];
		default:	return 0;
	}
	return 0;
}

/*

	:
		getPlayerName(playerid) -   
	:
		playerid - ID ,     
	   .

*/

#define getPlayerName(%1) gs:pname[ %1 ]

/*

	:
		setPlayerName(playerid, newname[]) -   
	:
		playerid - ID ,    
		newname[] -  
	    .

*/

stock bool:setPlayerName( const playerid, newname[] )
{
	SetPlayerName( playerid, newname );
	ss:pname[ playerid ] = newname;
	return true;
}

#define SetPlayerName setPlayerName

/*

	:
		getPlayerIp(playerid) -  IP- 
	:
		playerid - ID ,     
	  IP- .

*/

#define getPlayerIp(%1) gs:pip[ %1 ]

/*

	:
		getPlayerVersion(playerid) -    
	:
		playerid - ID ,     
	    .

*/

#define getPlayerVersion(%1) gs:plVersion[ %1 ]

/*

	:
		Float:getPlayerHealth(playerid) -      
	:
		playerid - ID ,      
	     .

*/

stock Float:getPlayerHealth( const playerid )
{
	new 
		Float:phealth;

	GetPlayerHealth( playerid, phealth );
	return phealth;
}

/*

	:
		givePlayerHealth(playerid,Float:health) -    
	:
		playerid - ID ,    
		Float:health -  
	    .

*/

stock givePlayerHealth( const playerid, Float:health )
{
	new 
		Float:phealth;

	GetPlayerHealth( playerid, phealth );
	if( phealth + health >= 100) return SetPlayerHealth( playerid, 100 );
	SetPlayerHealth(playerid, phealth + health );
	return 1;
}

/*
	:
		Float:getPlayerArmour(playerid) -     
	:
		playerid - ID 
	      (Float)

*/

stock Float:getPlayerArmour( const playerid )
{
	new 
		Float:armour;

	GetPlayerArmour( playerid, armour );
	return armour;
}

/*

	:
		givePlayerArmour(playerid,Float:armour)-     ,       100,   .
	:
		playerid - ID 
		Float:armour -  
	    .

*/

stock givePlayerArmour( const playerid, Float:armour )
{
	new 
		Float:parmour;

	GetPlayerArmour( playerid, parmour );
	if( parmour + armour >= 100 )return SetPlayerArmour( playerid, 100.0 );
	SetPlayerArmour( playerid, parmour + armour );
	return 1;
}

/*
	:
		getPlayerID(name[]) -  ID   .
	:
		name[] - (!) 
	  ID  ,  INVALID_PLAYER_ID.
	
*/

stock getPlayerID( const name[] )
{
	new
		pname[ MAX_PLAYER_NAME ];
	for( new i = 0, j = GetPlayerPoolSize(); i <= j; i++ )
	{
		if( IsPlayerConnected( i ) )
		{
			GetPlayerName( i, pname, sizeof( pname ) );
			if( !strcmp( name, pname, true) ) return i;
		}
	}
	return INVALID_PLAYER_ID;
}

/*

	:
		clearChatToPlayer(playerid) -     
	:
		playerid - ID 
	    .

*/

#define clearChatToPlayer(%1) for( new i = 0; i < 20; i++ ) SendClientMessage( playerid, 0xffffff, " " )

/*

	:
		clearChatToAll() -     ,   
	 .
	    .

*/

#define clearChatToAll() for( new i = 0; i < 20; i++ ) SendClientMessageToAll( 0xfffffff," " )

/*
	
	:
		sendPersonalMessage(playerid,targetid,color,string[]) -      . 
	:
		playerid - ID  
		targetid - ID  
		color -  
		string[] -  (   ! ..   )
	    .

*/

stock bool:sendPersonalMessage( const playerid, const targetid, const color, const string[] )
{
	if( IsPlayerConnected( playerid ) && IsPlayerConnected( targetid ) )
	{
		new 
			str[ 128 ];
		format( str, sizeof( str ), "*PM-sent to:%s(ID:%i): %s", getPlayerName( targetid ), targetid, string );
		SendClientMessage( playerid, color, str );
		format( str, sizeof( str ), "*PM-received from:%s(ID:%i): %s", getPlayerName( playerid ), playerid, string );
		SendClientMessage( targetid, color, str );
		return true;
	}
	return false;
}

/*

	:
		getPlayerInfo(playerid, nickname[], &Float:x, &Float:y, &Float:z, &Float:FacingAngle, &Float:health, &Float:armour, &pstate, &interior, &virtual, &skin, &team, &ping, &color); //     
	:
		playerid - ID 
		nickname[] -  
		Float:x -  
		Float:y -  Y
		Float:z -  Z
		Float:FacingAngle -   
		Float:health - 
		Float:armour - 
		interior - ID 
		virtual - ID  
		skin - ID 
		team - ID 
		ping -  
		color-  
	   .

*/

stock getPlayerInfo( const playerid, const nickname[], &Float:x, &Float:y, &Float:z, &Float:FacingAngle, &Float:health, &Float:armour, &pstate, &interior, &virtual, &skin, &team, &ping, &color )
{
	#pragma unused nickname
	if( IsPlayerConnected( playerid ) )
	{
		new
			pname[ MAX_PLAYER_NAME ],
			i = 0,
			j;

		GetPlayerName( playerid, pname, sizeof( pname ) );
		j = strlen( pname );
		while( i < j )
		{
			setarg( 1, i, pname[ i ] );
			i++;
		}
		GetPlayerPos( playerid, x, y, z );
		GetPlayerFacingAngle( playerid, FacingAngle );
		GetPlayerHealth( playerid, health );
		GetPlayerArmour( playerid, armour );
		pstate = GetPlayerState( playerid );
		interior = GetPlayerInterior( playerid );
		virtual = GetPlayerVirtualWorld( playerid );
		skin = GetPlayerSkin( playerid );
		team = GetPlayerTeam( playerid );
		ping = GetPlayerPing( playerid );
		color = GetPlayerColor( playerid );
		return 1;
	}
	return INVALID_PLAYER_ID;
}

/*

	:
		setPlayerColorForAll(color) -      
	:
		color - (Hex)
	    .

*/

#define setPlayerColorForAll(%1) \
	for( new i = 0, j = GetPlayerPoolSize(); i <= j; i++ ) \
		if( IsPlayerConnected( i ) ) \
			SetPlayerColor( i, %1 )

/*

	:
		createPlayer3DtextLableEx(playerid,text[],color,Float:x=0.0,Float:y=0.0,Float:z=0.7,Float:DrawDistance=100.0,virtual=0,testLOS=0) - ,   
	:
		playerid - ID ,     
		text[] - (Text 3D)
		color -  
		Float:x -  
		Float:y -  Y
		Float:z -  Z 
		Float:DrawDistance -  
		virtual -  
		testLOS -     .
	    .        .
	
*/

stock bool:createPlayer3DtextLableEx( const playerid, text[], const color, Float:x = 0.0, Float:y = 0.0, Float:z = 0.7, Float:DrawDistance = 100.0, virtual = 0, testLOS = 0 )
{
	if( !IsPlayerConnected( playerid ) && gi:pltextLable[ playerid ] == USE ) return false;
	si:pllable[ playerid ] = _:Create3DTextLabel( text, color, 0.0, 0.0, 0.0, DrawDistance, virtual, testLOS );
	Attach3DTextLabelToPlayer( Text3D:gi:pllable[ playerid ], playerid, x, y, z );
	si:pltextLable[ playerid ] = USE;
	return true;
}

/*

	:
		deletePlayer3DtextLableEx(playerid) -     .
	:
		playerid - ID 
	    .

*/

stock bool:deletePlayer3DtextLableEx( const playerid )
{
	if( !IsPlayerConnected( playerid ) && gi:pltextLable[ playerid ] == NOT_USE ) return false;
	Delete3DTextLabel( Text3D:gi:pllable[ playerid ] );
	si:pltextLable[ playerid ] = NOT_USE;
	return true;
}

/*

	:
		updatePlayer3DtextLableEx(playerid,color,text[]) -     
	:
		playerid - ID 
		color -  
		text[] - 
	    .

*/

stock bool:updatePlayer3DtextLableEx( const playerid, const color, const text[] )
{
	if( !IsPlayerConnected( playerid ) && gi:pltextLable[ playerid ] == NOT_USE ) return false;
	Update3DTextLabelText( Text3D:gi:pllable[ playerid ], color, text );
	return true;
}

/*

	:
		isPlayherLableExists(playerid) -      
	:
		playerid - ID 
	  true -      , false -  

*/
#define isPlayherLableExists(%1) gi:pltextLable[ %1 ]

/*

	:
		setPlayerMoney(playerid, amount) -     
	:
		playerid - ID ,   
		amount -  
	    .

*/

stock bool:setPlayerMoney( const playerid, const amount )
{
	if( !IsPlayerConnected( playerid ) ) return false;
	ResetPlayerMoney( playerid );
	GivePlayerMoney( playerid, amount );
	return true;
}

/*

	:
		givePlayerMoneyToPlayer(playerid, targetid, amount) -    .
	:
		playerid - ID ,   
		targetid - ID ,   
		amount -  
	    .

*/

stock bool:givePlayerMoneyToPlayer( const playerid, const targetid, const amount )
{
	if( !IsPlayerConnected( targetid ) || !IsPlayerConnected( playerid ) )return false;
	if( GetPlayerMoney( playerid ) < amount ) return false;
	GivePlayerMoney( playerid, -amount );
	GivePlayerMoney( targetid, amount );
	return true;
}

/*

	:
		givePlayerMoneyToPlayerEx(playerid, targetid, amount, Float: range) -   ,      
	:
		playerid - ID ,   
		targetid - ID ,   
		amount -  
		Float: range -   .
	    .

*/

stock bool:givePlayerMoneyToPlayerEx( const playerid, const targetid, const amount, Float: range )
{
	if( !IsPlayerConnected( targetid ) || !IsPlayerConnected( playerid ) )return false;
	if( GetPlayerMoney( playerid ) < amount ) return false;
	new 
		Float:pos[ 3 ];
	GetPlayerPos( targetid, pos[ 0 ], pos[ 1 ], pos[ 2 ] );
	if( !IsPlayerInRangeOfPoint( playerid, range, pos[ 0 ], pos[ 1 ], pos[ 2 ] ) ) return false;
	GivePlayerMoney( playerid, -amount );
	GivePlayerMoney( targetid, amount );
	return true;
}

/*

	:
		givePlayerHealthToPlayer(playerid, targetid, Float: amount) -    
	:
		playerid - ID ,   
		targetid - ID ,   
		amount -  
	    .

*/

stock bool:givePlayerHealthToPlayer( const playerid, const targetid, Float: amount )
{
	if( !IsPlayerConnected( targetid ) || !IsPlayerConnected( playerid ) )return false;
	new 
		Float: health;
	GetPlayerHealth( playerid, health );
	if( health < amount ) return false;
	givePlayerHealth( playerid, -amount );
	givePlayerHealth( targetid, amount );
	return true;
}

/*

	:
		givePlayerHealthToPlayerEx(playerid, targetid, Float: amount, Float: range) -   ,      
	:
		playerid - ID ,   
		targetid - ID ,   
		amount -  
		Float: range -   .
	    .

*/

stock bool:givePlayerHealthToPlayerEx( const playerid, const targetid, Float: amount, Float: range )
{
	if( !IsPlayerConnected( targetid ) || !IsPlayerConnected( playerid ) )return false;
	new 
		Float: health,
		Float:pos[ 3 ];
	GetPlayerHealth( playerid, health );
	if( health < amount ) return false;
	GetPlayerPos( targetid, pos[ 0 ], pos[ 1 ], pos[ 2 ] );
	if( !IsPlayerInRangeOfPoint( playerid, range, pos[ 0 ], pos[ 1 ], pos[ 2 ] ) ) return false;
	givePlayerHealth( playerid, -amount );
	givePlayerHealth( targetid, amount );
	return true;
}

/*

	:
		givePlayerArmourToPlayer(playerid, targetid, Float: amount) -    
	:
		playerid - ID ,   
		targetid - ID ,   
		amount -  
	    .

*/

stock bool:givePlayerArmourToPlayer( const playerid, const targetid, Float: amount )
{
	if( !IsPlayerConnected( targetid ) || !IsPlayerConnected( playerid ) )return false;
	new 
		Float: armour;
	GetPlayerHealth( playerid, armour );
	if( armour < amount ) return false;
	givePlayerArmour( playerid, -amount );
	givePlayerArmour( targetid, amount );
	return true;
}

/*

	:
		givePlayerArmourToPlayerEx(playerid, targetid, Float: amount, Float: range) -   ,      
	:
		playerid - ID ,   
		targetid - ID ,   
		amount -  
		Float: range -   .
	    .

*/

stock bool:givePlayerArmourToPlayerEx( const playerid, const targetid, Float: amount, Float: range )
{
	if( !IsPlayerConnected( targetid ) || !IsPlayerConnected( playerid ) )return false;
	new 
		Float: armour,
		Float:pos[ 3 ];
	GetPlayerHealth( playerid, armour );
	if( armour < amount ) return false;
	GetPlayerPos( targetid, pos[ 0 ], pos[ 1 ], pos[ 2 ] );
	if( !IsPlayerInRangeOfPoint( playerid, range, pos[ 0 ], pos[ 1 ], pos[ 2 ] ) ) return false;
	givePlayerArmour( playerid, -amount );
	givePlayerArmour( targetid, amount );
	return true;
}

/*

	:
		setPlayerPosEx(playerid,Float:x,Float:y,Float:z,Float:FacingAngle,interior=0,virtual=0) -       .
	:
		playerid - ID ,      
		Float:x -  
		Float:y -  Y
		Float:z -  Z
		Float:FacingAngle -   
		interior - ID (  )
		virtual - ID  (  )
	    

*/

stock bool:setPlayerPosEx( const playerid, Float:x, Float:y, Float:z, Float:FacingAngle, const interior = 0, const virtual = 0 )
{
	SetPlayerPos( playerid, x, y, z);
	SetPlayerFacingAngle( playerid, FacingAngle );
	SetPlayerInterior( playerid, interior );
	SetPlayerVirtualWorld( playerid, virtual );
	return true;
}

/*

	:
		getPlayerPosEx(playerid,&Float:x,&Float:y,&Float:z,&Float:FacingAngle,&interior,&virtual) -      ,  ,   
	
		playerid - ID 
		Float:x -  
		Float:y -  Y
		Float:z -  Z
		Float:FacingAngle -   
		interior - ID 
		virtual - ID  
	      , ID   ID  ,     .

*/

stock bool:getPlayerPosEx( const playerid, &Float:x, &Float:y, &Float:z, &Float:FacingAngle, &interior, &virtual )
{
	GetPlayerPos( playerid, x, y, z );
	GetPlayerFacingAngle( playerid, FacingAngle );
	interior=GetPlayerInterior( playerid );
	virtual=GetPlayerVirtualWorld( playerid );
	return true;
}

/*

	:
		givePlayerWeaponEx(playerid,{id}) -   .
	:
		playerid - ID ,    
		{id} -  ,  ,  .
	  Stepashka,  sk47
	    .

*/

stock givePlayerWeaponEx( ... )
{ 
	if( numargs() % 2 == 0 ) return 0; 
	for( new i = 1; i < numargs(); i++ ) 
	{ 
		if ( getarg( i + 1 ) && getarg( i ) ) 
		{ 
			GivePlayerWeapon( getarg( 0 ), getarg( i ), getarg( i + 1 ) ); 
			i++; 
		} 
	} 
	return 1; 
}

/*

	:
		deletePlayerWeapon(playerid, gunid) -    
	:
		playerid - ID ,    
		gunid - ID  
	    .

*/

stock bool:deletePlayerWeapon( const playerid, const gunid )
{
	new
		pgun[ 13 ],
		pammo[ 13 ];

	for( new i = 0; i < 13; i++ )
		GetPlayerWeaponData( playerid, i, pgun[ i ], pammo[ i ] );
	ResetPlayerWeapons( playerid );
	for( new i = 0; i < 13; i++ )
	{
		if( pgun[ i ] != 0 && pammo[ i ] > 0 )
		{
			if( pgun[ i ] != gunid )
				GivePlayerWeapon( playerid, pgun[ i ], pammo[ i ] );
		}
	}
	return true;
}
/*

	:
		sendFormatedMessage(playerid,color,const format[],{Float,_}:...) -    
	:
		playerid - ID ,   
		color -  
		format[] - 
		{Float,_}:... - 
	    .

*/

#define sendFormatedMessage(%0,%1,%2,%3)\
do{\
format(SITIRING , sizeof (SITIRING ), (%2), %3);\
SendClientMessage((%0),(%1), SITIRING );\
}\
while (False) 

/*

	:
		sendFormatedMessageToAll(color,const format[],{Float,_}:...) -       .
	:
		color -  
		format[] - 
		{Float,_}:... - 
	    .

*/

#define sendFormatedMessageToAll(%1,%2,%3)\
do{\
format(SITIRING , sizeof (SITIRING ), (%2), %3);\
SendClientMessageToAll((%1), SITIRING );\
}\
while (False)


/*

	:
		showInfoDialog(playerid, title[], test[]) -     
	:
		playerid - ID ,    .
		title[] -  
		test[] -  
	    .

*/

#define showInfoDialog(%0, %1, %2) ShowPlayerDialog( %0, 999999, DIALOG_STYLE_MSGBOX, %1, %2, "Ok", "" )

stock e_showPlayerDialog( const playerid, const dialogid, const style, title[], text[], button1[], button2[] )
{
	ShowPlayerDialog( playerid, dialogid, style, title, text, button1, button2 );
	si:pldialog[ playerid ] = 1;
	return 1;
}

/*

	:
		isDialogShowedForPlayer(playerid) -       
	:
		playerid - ID  
	  tru  ,  false  .

*/

#define isDialogShowedForPlayer(%1) gi:pldialog[ %1 ];

/*

	:
		hideDialog(playerid) -   
	:
		playerid - ID 
	    .

*/

stock hideDialog( const playerid )
{
	si:pldialog[ playerid ] = 0;
	ShowPlayerDialog( playerid, -1, 1, " ", " ", " ", "" );
	return 1;
}

#define ShowPlayerDialog e_showPlayerDialog

/*

	:
		SendClientCheck(playerid, actionid, memaddr, memOffset, bytesCount) -    
	:
		playerid - ID  
		actionid -  
		memaddr -    
		memOffset -  
		bytesCount -   
	    ,    OnClientCheckResponse(playerid, actionid, memaddr, retndata)
	     .
	
*/

native SendClientCheck(playerid, actionid, memaddr, memOffset, bytesCount);

/*

	:
		givePlayerVehicle(playerid, modelid) -   
	:
		playerid - ID ,    
		modelid - ID  
	 true   , false -  

*/

stock bool: givePlayerVehicle( const playerid, const modelid )
{
    if( !IsPlayerInAnyVehicle( playerid ) && modelid > 399 && modelid < 612 )
    {
        new Float:x, Float:y, Float:z, Float:a, vehicle;
        GetPlayerPos( playerid, x, y, z );
        GetPlayerFacingAngle( playerid, a );
        vehicle = CreateVehicle( modelid, x, y, z, a, -1, -1, 50000 );
        PutPlayerInVehicle( playerid, vehicle, 0 );
		return true;
    }
	return false;
}

/*

	:
		rangeBan(playerid) -     IP-. : 127.0.**.**
	:
		playerid - ID ,   
	    .

*/

stock rangeBan( const playerid )
{
    new 
		pos, 
		string[ 32 ];
    GetPlayerIp( playerid, string, 16 );
    pos = strfind( string, ".", false, 0 );
    pos = strfind( string, ".", false, pos + 1 );
    strmid( string, string, 0, pos + 1, 16 );
    format( string, 32, "banip %s*.*", string );
    return SendRconCommand( string );
}

/*

	:
		arePlayersConnected() -       1   
	  true    1   false   

*/

stock bool: arePlayersConnected()
{
    for( new i = 0, j = GetPlayerPoolSize(); i <= j; i++ )
        if( IsPlayerConnected( i ) ) return true;
    return false;
}

/*

	:
		randomPlayer() -  ID   .
	  INVALID_PLAYER_ID     

*/

stock randomPlayer()
{
    new 
		p = INVALID_PLAYER_ID;
    if( ArePlayersConnected() )
    {
        while( !IsPlayerConnected( p ) )
            p = random( GetPlayerPoolSize() + 1 );
        return p;
    }
    else 
		return INVALID_PLAYER_ID;
}

/*

	:
		getPlayerShopName(playerid) -   ,    
	:
		playerid - ID 
	    http://wiki.sa-mp.com/wiki/ShopNames

*/

stock getPlayerShopName( const playerid )
{
	new	
		result[ 24 ];
	
	if( IsPlayerInRangeOfPoint( playerid, 30.0, 374.0000, -119.6410, 1001.4922 ) ) result = "FDPIZA";
	else if( IsPlayerInRangeOfPoint( playerid, 30.0, 375.5660, -68.2220, 1001.5151 ) ) result = "FDBURG";
	else if( IsPlayerInRangeOfPoint( playerid, 30.0, 368.7890, -6.8570, 1001.8516 ) ) result = "FDCHICK";
	else if( IsPlayerInRangeOfPoint( playerid, 30.0, 296.5395, -38.2739, 1001.515 ) ) result = "AMMUN1";
	else if( IsPlayerInRangeOfPoint( playerid, 30.0, 295.7359, -80.6865, 1001.5156 ) ) result = "AMMUN2";
	else if( IsPlayerInRangeOfPoint( playerid, 30.0, 290.2011, -109.5698, 1001.5156 ) ) result = "AMMUN3";
	else if( IsPlayerInRangeOfPoint( playerid, 30.0, 308.1619, -141.2549, 999.6016 ) ) result = "AMMUN4";
	else if( IsPlayerInRangeOfPoint( playerid, 30.0, 312.7883, -166.0069, 999.6010 ) ) result = "AMMUN5";
	else result = "Unknown";
	return result;
}

/*

	:
		getPlayerFPS(playerid) -  FPS 
	:
		playerid - (int)ID ,     FPS
	  FPS    .

*/

stock getPlayerFPS( const playerid )
{
    SetPVarInt( playerid, "DrunkL", GetPlayerDrunkLevel( playerid ) );
    if( GetPVarInt( playerid, "DrunkL" ) < 100 )
        SetPlayerDrunkLevel( playerid, 2000 );
    else
    {
        if( GetPVarInt( playerid, "LDrunkL" ) != GetPVarInt( playerid, "DrunkL" ) )
        {
            SetPVarInt( playerid, "FPS", ( GetPVarInt( playerid, "LDrunkL" ) - GetPVarInt( playerid, "DrunkL" ) ) );
            SetPVarInt( playerid, "LDrunkL", GetPVarInt( playerid, "DrunkL" ) );
            if( GetPVarInt( playerid, "FPS" ) > 0 && GetPVarInt( playerid, "FPS" ) < 256 )
                return GetPVarInt( playerid, "FPS" ) - 1;
        }
    }
    return 0;
} 

/*

 	: 
		sendMessage(playerid, string[]) -   
 	:
		playerid - ID ,    
		string[] -  .    ~r~  .)
	    .

*/

stock bool:sendMessage( const playerid, string[] )
{
	for( new i = 5; i > 0; i-- )
		strmid( playerMessages[ playerid ][ i ], playerMessages[ playerid ][ i - 1 ], 0, strlen( playerMessages[ playerid ][ i - 1 ] ), 255 );
	strmid( playerMessages[ playerid ][ 0 ], toRus( string ), 0, strlen( string ), 255 );
	for( new i = 0; i < 6; i++ )
		PlayerTextDrawSetString( playerid, messages[ playerid ][ i ], playerMessages[ playerid ][ i ] );
	return true;
}

/*

 	: 
		clearMessages(playerid) -   
 	:
		playerid - ID ,    
	    .

*/

stock bool:clearMessages( const playerid )
{
	for( new i = 0; i < 6; i++ )
		strmid( playerMessages[ playerid ][ i ], "", 0, 0, 255 );
    for( new i = 0; i < 6; i++ )
		PlayerTextDrawSetString( playerid, messages[ playerid ][ i ], playerMessages[ playerid ][ i ] );
	return true;
}

/*

 	: 
		playSoundAll(playerid, soundid, Float: psx, Float: psy, Float: psz) -   
 	:
		soundid - ID 
		Float: psx -  X 
		Float: psy -  Y 
		Float: psz -  Z 
	    .

*/

stock bool: playSoundAll( const soundid, Float: psx, Float: psy, Float: psz )
{
	for( new i = 0, j = GetPlayerPoolSize(); i <= j; i++ )
		if( IsPlayerConnected( i ) )
			PlayerPlaySound( i, soundid, psx, psy, psz );
	return true;
}

/*

 	: 
		giveScoreToPlayer(playerid, score) -   
 	:
		playerid - ID ,     
		score -   
	    .

*/

#define giveScoreToPlayer(%0,%1) SetPlayerScore( %0, GetPlayerScore( %0 ) + %1 )

/*

 	: 
		isPlayerJump(playerid) -       ,  .
 	:
		playerid - ID  
	 true -  , false - .

*/

stock bool:isPlayerJump( const playerid )
{

	new
		index = GetPlayerAnimationIndex( playerid ),
		animlib[ 32 ],
        animname[ 32 ];

	if( index )
    {
        GetAnimationName( index, animlib, 32, animname, 32 );
        if( !strcmp( animname, "JUMP_GLIDE", true ) ) return true;
    }
	return false;
}

/*

 	: 
		isPlayerDropDown(playerid) -       ,  .
 	:
		playerid - ID  
	 true -  , false - .

*/

stock bool:isPlayerDropDown( const playerid )
{

	new
		index = GetPlayerAnimationIndex( playerid ),
		animlib[ 32 ],
        animname[ 32 ];

	if( index )
    {
        GetAnimationName( index, animlib, 32, animname, 32 );
        if( !strcmp( animname, "FALL_FALL", true ) ) return true;
    }
	return false;
}

/*

 	: 
		isPlayerSwiming(playerid) -       ,  .
 	:
		playerid - ID  
	 true -  , false - .

*/

stock bool:isPlayerSwiming( const playerid )
{

	new
		index = GetPlayerAnimationIndex( playerid ),
		animlib[ 32 ],
        animname[ 32 ];

	if( index )
    {
        GetAnimationName( index, animlib, 32, animname, 32 );
        if( !strcmp( animlib, "SWIM", true ) ) return true;
    }
	return false;
}

/*

 	: 
		tooglePlayerCameraUp(playerid, bool:toggle, Float:distanse) -       
 	:
		playerid - ID 
		bool:toggle - ,  .  true - , false - .
		Float:distanse -     .
	    .

*/

stock tooglePlayerCameraUp( playerid, bool:toggle, Float:distanse )
{
	if( toggle == false )
	{
		si:pCam[ playerid ] = 0;
		SetCameraBehindPlayer( playerid );
	}
	else
	{
		si:pCam[ playerid ] = 1;
		sf:pDist[ playerid ] = distanse;
    }
	return 1;
}

/*

 	: 
		isPlayerSpectating(playerid) -        (spectate)
 	:
		playerid - (ID 
	  1 -       (spectate), 0 -  .

*/

#define isPlayerSpectating(%1) GetPlayerState(%1) == PLAYER_STATE_SPECTATING

/* 
	:
		maxPlayerHealth(playerid, Float:amount); //      
	:
		playerid - ID 
		Float:amount -     
	    

*/

#define maxPlayerHealth(%1,%2) sf:maxplayerhealth[%1] = %2

/* 
	:
		getPlayerObjectPoolSize(playerid); //   ID  
	:
		playerid - ID 
	   ID   .     ,   INVALID_OBJECT_ID

*/

stock getPlayerObjectPoolSize( const playerid )
{
	new
		num = CreatePlayerObject( playerid, 19522, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 );

	DestroyPlayerObject( playerid, num );
	if( num <= 1 ) 
		return INVALID_OBJECT_ID;
	else
		return num - 1;
}

/* 
	:
		getFreeAttachSlot(playerid); //     
	:
		playerid - ID 
	      .    ,   -1

*/

stock getFreeAttachSlot( const playerid ) 
{ 
    for( new i = 9; i < 10; i++ ) 
    { 
        if( IsPlayerAttachedObjectSlotUsed( playerid, i ) ) continue; 
        return i; 
    } 
    return -1; 
}

/* 
	:
		togglePlayerControllable(playerid, bool:status, damage); // /    ()  
	:
		playerid - ID 
		bool:status - true - /false -   
		damage - 1 - \ 0   
	      .    ,   -1

*/

stock bool:togglePlayerControllable( const playerid, bool:status, damage = 0 )
{
	if( !IsPlayerConnected( playerid ) ) return false;
	TogglePlayerControllable( playerid, status );
	si:getDamageTC[ playerid ] = damage;
	si:playerTC[ playerid ] = ( status == true ) ? ( 0 ) : ( 1 );
	return true;
} 

#define TogglePlayerControllable(%1,%2) togglePlayerControllable(%1,%2,0)

/* 
	:
		isPlayerControllable(playerid); //     ,  
	:
		playerid - (int)ID 
	  1    ,  0    

*/

#define isPlayerControllable(%1) gi:playerTC[%1]

/* 
	:
		isPlayerInArea( playerid, Float: posx1, Float:posy1, Float:posx2, Float:posy2 ); //         
	:
		playerid - (int) ID 
		Float: posx1 - (float)    
		Float: posy1 - (float)    
		Float: posx2 - (float)    
		Float: posy2 - (float)    
	  1    ,  0    

*/

stock isPlayerInArea( playerid, Float: posx1, Float:posy1, Float:posx2, Float:posy2 )
{
	new 
		Float: pos[ 3 ];

	GetPlayerPos( playerid, pos[ 0 ], pos[ 1 ], pos[ 2 ] );
	if( pos[ 0 ] >= posx1 && pos[ 0 ] <= posx2 && pos[ 1 ] <= posy1 && pos[ 1 ] >= posy2 ) 
		return 1;
	return 0;
}
//===============================================================
//
// 						 
//
//===============================================================