/******************************************************************************************************************************************

		-----------------------------------------------------------------
			functions/d_servers.inc -    
		-----------------------------------------------------------------

			--------------------------------------------------------
				    SA-MP V0.3.7   
			--------------------------------------------------------

------------------------------------------------------------------------------------------------------------------------------		

	  :
		V2.2 BUILD 1000  10.10.2016

------------------------------------------------------------------------------------------------------------------------------	

	  :
		V1.5 BUILD 1000  02.04.2015

------------------------------------------------------------------------------------------------------------------------------

	 :
		10.10.2016 -   
		02.04.2015 -     :
			d_servers.inc:
				native getWeaponModel(weaponid); //   .
				native createStaticWeapon(gunid, ammo, type, Float:posx, Float:posy, Float:posz, virtualworld); //   ,       .
				native destroyWeapon(gunpickupid); //    
				native updateWeaponPickup(gunpickupid, newgunid, newammo, newtype, Float:newposx, Float:newposy, Float:newposz, newvirtualworld); //   ,       .
				native getCountPickupedWeapon(gunpickupid); //         
				native isWeaponPickupValid(gunpickupid); //         ID
				native getWeaponPickupCount(); //     
				native setSpawnWeapons( {{id}, {ammo}}... ); //      .
				native enebleHeadShot(bool:status); //         
				native maxHealth(Float:amount); //      
				native getObjectPoolSize(); //   ID 
		04.03.2015 -      
		
------------------------------------------------------------------------------------------------------------------------------

	   :
		native lockServer(bool:param); //  
		native getGameModeText(); //    .
		native getGravity(); //     
		native getServerWeather(); // ID ,      .
		native getWeaponModel(weaponid); //   .
		native getWeaponSlot(weaponid); //      ID .
		native isPickupWeaponModel(modelid); //   ,      .
		native getWeaponName(weaponid); //     
		native createStaticWeapon(gunid, ammo, type, Float:posx, Float:posy, Float:posz, virtualworld); //   ,       .
		native destroyWeapon(gunpickupid); //    
		native updateWeaponPickup(gunpickupid, newgunid, newammo, newtype, Float:newposx, Float:newposy, Float:newposz, newvirtualworld); //   ,       .
		native getCountPickupedWeapon(gunpickupid); //         
		native isWeaponPickupValid(gunpickupid); //         ID
		native getWeaponPickupCount(); //     
		native setSpawnWeapons( {{id}, {ammo}}... ); //      .
		native getFileInfo(filename[],&lines,&bytes); //     .
		native randomEx(min,max); //       .
		native createTeleportPoint(teleportid,Float:x,Float:y,Float:z,Float:newx,Float:newy,Float:newz,Float:newFacingAngle,interior=0,virtual=0,bool:isvehicle=false); //   .
		native destroyTeleportPoint(tppointid); //   
		native isValidTeleportPoint(tppointid); //     .
		native updateTeleportPoint(e_ptp,Float:x,Float:y,Float:z,Float:newx,Float:newy,Float:newz,Float:newFacingAngle,interior=0,virtual=0,bool:isvehicle=false); //    
		native setRPNamesOnly(); //     Non-RP 
		native strcharsplit(const string[], &index, seperator=' '); //  strtok,   
		native Float:floatRandom(Float:val); //        0  val
		native Float:floatRandomEx(Float:min,Float:max); //        min  max
		native isEmail( string[] ); //      e-mail
		native abs( num ); //    num
		native preLoadAnim( const  playerid, animlib[] ); //      animlib.
		native givePlayerMoneyToAll( amount ); //   
		native givePlayerHealthToAll( Float: amount ); //   
		native givePlayerArmourToAll( amount ); //    
		native isPlayerNameOnline( const nickname[] ); //         
		native fwriteEx( filename[], string[] ); //    .   !
		native floatToString( Float: val ); //        
		native floatToInt( Float: val ); //        
		native Float:getTeamHealth( teamid ); //     (SetPlayerTeam)
		native getTime( ); //    
		native getRandomFromInput( arg1, arg2, ... argN ); //      
		native disableCapsLock( text[] ); //      .
		native toRus( string[] )); //      
		native fwriteRUS( File:file, string[] ); //      
		native fcopy(target[], copy[]); //  
		native fmove(target[], olddir[], newdir[]); //  
		native log( filename[], string[] ); //   
		native enebleVehicleDamage(); //     
		native setDisabledWeapons( ... ); //    (   SA-MP   0.3)
		native isValidSkin(skinid); //    ID .
		native getDeathReason(reason); //   
		native disableBadword(word[]); //   
		native enebleHeadShot(bool:status); //         
		native maxHealth(Float:amount); //      
		native getObjectPoolSize(); //      

------------------------------------------------------------------------------------------------------------------------------

	    :
		      Dima-kun a.k.a Morino_Reigan
	
	 :
		   SA-MP SAMP-RUS.COM     
		SA-MP TEAM  San Andreas-MultiPlayer
		Rockstar North Games  Grand Theft Auto San Andreas

	            : http://samp-rus.com
	
*******************************************************************************************************************************************/

#if defined d_includes_server
	#endinput
#endif
#define d_includes_server  1

/*

	:
		lockServer(bool:param); //  
	:
		bool:param - \  (true\false)

	    

*/

#define lockServer(%1) serverLocked = %1

/*

	:
		getGameModeText(); //    .
	    .

*/

stock getGameModeText()
{
	new str[ 64 ]; 
	GetServerVarAsString( "gamemodetext", str, sizeof( str ) ); 
	return str;
}

/*

	:
		getGravity(); //     
	    .

*/

stock getGravity()
{
	new 
		str[ 64 ]; 
	GetServerVarAsString( "gravity", str, sizeof( str ) ); 
	return str; 
}

/*

	:
		getServerWeather(); //  ID ,      .
	    .

*/

#define getServerWeather() GetServerVarAsInt("weather")

/*
	
	:
		getWeaponModel(weaponid); //   .
	:
		weaponid - ID (0-50)
	   .
	
*/

stock getWeaponModel( const weaponid )
{
	switch( weaponid )
	{
		case 1: return 331;
		case 2..8: return weaponid + 331;
		case 9: return 341;
		case 10..15: return weaponid + 311;
		case 16,17,18: return weaponid + 326;
		case 22..29: return weaponid + 324;
		case 30,31: return weaponid + 325;
		case 33..45: return weaponid + 324;
		case 46: return 371;
		default:return 0;
	}
	return 0;
}

/*
	
	:
		getWeaponSlot(weaponid); //      ID .
	:
		weaponid - ID (0-50)
	  ID .
	
*/

stock getWeaponSlot( weaponid )
{
	switch( weaponid )
	{
		case 0,1:return 0;
		case 2..9: return 1;
		case 22,23,24:return 2;
		case 25,26,27:return 3;
		case 28,29,32:return 4;
		case 30,31:return 5;
		case 33,34:return 6;
		case 35,36,37,38:return 7;
		case 16,17,18,39:return 8;
		case 41,42,43:return 9;
		case 10..15:return 10;
		case 44,45,46:return 11;
		default:return 12;
	}
	return 12;
}

/*

	:
		isPickupWeaponModel(modelid); //   ,      .
	:
		modelid -  
	  1(true)  ,  0(false) -  .

*/

#define isPickupWeaponModel(%1)  %1 > 320 && %1 < 372

/*

	:
		getWeaponName(weaponid); //     
	:
		weaponid - ID (0-50)
	      

*/

stock getWeaponName( weaponid )
{
	new 
		weanr[ 50 ];
	switch ( weaponid ) 
	{
		case 0: weanr = "";
		case 1: weanr = "";
		case 2: weanr = " ";
		case 3: weanr = " ";
		case 4: weanr = "";
		case 5: weanr = " ";
		case 6: weanr = "";
		case 7: weanr = " ";
		case 8: weanr = "";
		case 9: weanr = "";
		case 10: weanr = "";
		case 11: weanr = "";
		case 12: weanr = "";
		case 13: weanr = "";
		case 14: weanr = " ";
		case 15: weanr = "";
		case 16: weanr = "";
		case 17: weanr = " ";
		case 18: weanr = " ";
		case 19: weanr = "";
		case 20: weanr = "";
		case 21: weanr = "";
		case 22: weanr = "";
		case 23: weanr = "  ";
		case 24: weanr = " ";
		case 25: weanr = "";
		case 26: weanr = "";
		case 27: weanr = " ";
		case 28: weanr = " 10";
		case 29: weanr = "5";
		case 30: weanr = "";
		case 31: weanr = "4";
		case 32: weanr = "9";
		case 33: weanr = " ";
		case 34: weanr = " ";
		case 35: weanr = "";
		case 36: weanr = " ";
		case 37: weanr = "";
		case 38: weanr = "";
		case 39: weanr = "";
		case 40: weanr = "";
		case 41: weanr = "";
		case 42: weanr = "";
		case 43: weanr = "";
		case 44: weanr = "";
		case 45: weanr = "";
		case 46: weanr = "";
		case 47: weanr = "";
		case 48: weanr = "";
		case 49: weanr = "";
		case 50: weanr = " ";
		default:weanr = "Unknown";
	}
	return weanr;
}

/*
	
	:
		createStaticWeapon(gunid, ammo, type, Float:posx, Float:posy, Float:posz, virtualworld); //   ,       .
	:
		gunid - ID (0-50)
		ammo -    
		type -    (http://wiki.sa-mp.com/wiki/PickupTypes)
		Float:posx -  X 
		Float:posy -  Y 
		Float:posz -  Z 
		virtualworld -  
	  ID .
	
*/

stock createStaticWeapon( _gunid, _ammo, _type, Float:_posx, Float:_posy, Float:_posz, _virtualworld = 0 )
{
	if( wpickid >= MAX_GUNPICKUP ) return INVALID_GUN_PICKUP_ID;
	gunPickInfo[ wpickid ][ wPickupid ] = CreatePickup( getWeaponModel( _gunid ), _type, _posx, _posy, _posz, _virtualworld );
	gunPickInfo[ wpickid ][ wGunid ] = _gunid;
	switch( _gunid )
	{
		case 1..19: _ammo -= 1;
		case 22: _ammo -= 10;
		case 23: _ammo -= 10;
		case 24: _ammo -= 10;
		case 25: _ammo -= 100;
		case 26: _ammo -= 100;
		case 27: _ammo -= 10;
		case 28: _ammo -= 60;
		case 29: _ammo -= 160;
		case 30: _ammo -= 260;
		case 31: _ammo -= 80;
		case 32: _ammo -= 60;
		case 33: _ammo -= 20;
		case 34: _ammo -= 10;
		case 35: _ammo -= 4;
		case 36: _ammo -= 3;
		case 37: _ammo += 80;
		case 39: _ammo -= 5;
		case 38: _ammo -= 500;
		case 41: _ammo -= 500;
		case 42: _ammo -= 500;
		case 43: _ammo -= 36;
		case 44..46: _ammo -= 1;
	}
	gunPickInfo[ wpickid ][ wAmmo ] = _ammo;
	gunPickInfo[ wpickid ][ wCountpick ] = 0;
	gunPickInfo[ wpickid ][ wStatus ] = true;
	wpickid++;
	return wpickid;
}

/*
	
	:
		destroyWeapon(gunpickupid); //    
	:
		gunpickupid - ID   
	  1     INVALID_GUN_PICKUP_ID -     
	
*/

stock destroyWeapon( const gunpickupid )
{
	if( gunPickInfo[ gunpickupid ][ wStatus ] != true ) return INVALID_GUN_PICKUP_ID;
	DestroyPickup( gunPickInfo[ gunpickupid ][ wPickupid ] );
	gunPickInfo[ wpickid ][ wStatus ] = false;
	return 1;
}

/*
	
	:
		updateWeaponPickup(gunpickupid, newgunid, newammo, newtype, Float:newposx, Float:newposy, Float:newposz, newvirtualworld); //   ,       .
	:
		gunpickupid - ID   
		newgunid - ID (0-50)
		newammo -    
		newtype -    (http://wiki.sa-mp.com/wiki/PickupTypes)
		Float:newposx -  X 
		Float:newposy -  Y 
		Float:newposz -  Z 
		newvirtualworld -  
	  1     INVALID_GUN_PICKUP_ID -     .
	
*/

stock updateWeaponPickup( const gunpickupid, _newgunid, _newammo, _newtype, Float:_newposx, Float:_newposy, Float:_newposz, _newvirtualworld )
{
	if( gunPickInfo[ gunpickupid ][ wStatus ] != true ) return INVALID_GUN_PICKUP_ID;
	DestroyPickup( gunPickInfo[ gunpickupid ][ wPickupid ] );
	gunPickInfo[ gunpickupid ][ wPickupid ] = CreatePickup( getWeaponModel( _gunid ), _newtype, _newposx, _newposy, _newposz, _newvirtualworld );
	gunPickInfo[ gunpickupid ][ wGunid ] = _newgunid;
	gunPickInfo[ gunpickupid ][ wAmmo ] = _newammo;
	gunPickInfo[ gunpickupid ][ wCountpick ] = 0;
	gunPickInfo[ gunpickupid ][ wStatus ] = true;
	return 1;
}

/*
	
	:
		getCountPickupedWeapon(gunpickupid); //         
	:
		gunpickupid - ID   
	      
	
*/

#define getCountPickupedWeapon(%1) gunPickInfo[ %1 ][ wCountpick ]

/*
	
	:
		isWeaponPickupValid(gunpickupid); //         ID
	:
		gunpickupid - ID   
	  true    false  
	
*/

#define isWeaponPickupValid(%1) gunPickInfo[ %1 ][ wStatus ]

/*
	
	:
		getWeaponPickupCount(); //     
	   .
	
*/

#define getWeaponPickupCount() wpickid

/*

	:
		getFileInfo(filename[],&lines,&bytes); //     .
	:
		filename[] -  
		lines -     
		bytes -    ( )
	     

*/

stock bool:getFileInfo( filename[], &lines, &bytes )
{
	new 
		count,
		File:file,
		idx[ 100 ];
	if( ( file = fopen( filename, io_read ) ) )
	{
		while( fread( file, idx ) )count++;
		fclose( file );
		lines = count;
		bytes = flength( file );
		return true;
	}
	return false;
}

/*

	:
		randomEx(min,max); //       .
	:
		min -  ,   
		max -  ,   
	   ,   .

*/

#define randomEx(%1,%2) (random( %2 - %1 ) + %1 )

/*

	:
		createTeleportPoint(teleportid,Float:x,Float:y,Float:z,Float:newx,Float:newy,Float:newz,Float:newFacingAngle,interior=0,virtual=0,bool:isvehicle=false); //   .
	:
		teleportid - ID  (  ! !       !)
		Float:x -    
		Float:y -  Y  
		Float:z -  Z  
		Float:newx -    
		Float:newy -  Y  
		Float:newz -  Z  
		Float:newFacingAngle -  
		interior - ID ( .  :0)
		virtual - ID  ( .  :0)
		bool:isvehicle -        (false)      (true)
	    .

*/

stock createTeleportPoint( e_ptp, Float:x, Float:y, Float:z, Float:newx, Float:newy, Float:newz, Float:newFacingAngle, interior=0, virtual=0, bool:isvehicle = false )
{
	if(teleportPoints[ e_ptp ][ tpstatus ] == false )
	{
		teleportPoints[ e_ptp ][ tpstatus ] = true;
		teleportPoints[ e_ptp ][ tpx ] = newx;
		teleportPoints[ e_ptp ][ tpy ] = newy;
		teleportPoints[ e_ptp ][ tpz ] = newz;
		teleportPoints[ e_ptp ][ tpFacingAngle ] = newFacingAngle;
		teleportPoints[ e_ptp ][ tpinterior ] = interior;
		teleportPoints[ e_ptp ][ tpvirtual ] = virtual;
		teleportPoints[ e_ptp ][ tpisvehicle ] = isvehicle;
		if( isvehicle == false )teleportPoints[ e_ptp ][ tppickup ] = CreatePickup( 1318, 2, x, y, z );
		if( isvehicle == true )teleportPoints[ e_ptp ][ tppickup ] = CreatePickup( 1318, 14, x, y, z );
		return e_ptp;
	}
	return 1;
}

/*

	:
		destroyTeleportPoint(tppointid); //   
	:
		teleportid - ID  
	    .

*/

stock destroyTeleportPoint( tppointid )
{
	if( teleportPoints[ tppointid ][ tpstatus ] == true )
	{
		DestroyPickup( teleportPoints[ tppointid ][ tppickup ] );
		teleportPoints[ tppointid ][ tpstatus ] = false;
		return 1;
	}
	return 0;
}

/*

	:
		isValidTeleportPoint(tppointid); //     .
	:
		teleportid - ID  
	  true    false   .

*/

#define isValidTeleportPoint(%1) teleportPoints[%1][ tpstatus ]

/*

	:
		updateTeleportPoint(e_ptp,Float:x,Float:y,Float:z,Float:newx,Float:newy,Float:newz,Float:newFacingAngle,interior=0,virtual=0,bool:isvehicle=false); //    
	:
		teleportid - ID  (    ID,   (-1))
		Float:x -    
		Float:y -  Y  
		Float:z -  Z  
		Float:newx -    
		Float:newy -  Y  
		Float:newz -  Z  
		Float:newFacingAngle -  
		interior - ID ( .  :0)
		virtual - ID  ( .  :0)
		bool:isvehicle -        (false)      (true)
	    .

*/

stock updateTeleportPoint( e_ptp, Float:x, Float:y, Float:z, Float:newx, Float:newy, Float:newz, Float:newFacingAngle, interior=0, virtual=0, bool:isvehicle = false )
{
	if( teleportPoints[ e_ptp ][ tpstatus ] == true )
	{
		DestroyPickup( teleportPoints[ e_ptp ][ tppickup ] );
		teleportPoints[ e_ptp ][ tpx ] = newx;
		teleportPoints[ e_ptp ][ tpy ] = newy;
		teleportPoints[ e_ptp ][ tpz ] = newz;
		teleportPoints[ e_ptp ][ tpFacingAngle ] = newFacingAngle;
		teleportPoints[ e_ptp ][ tpinterior ] = interior;
		teleportPoints[ e_ptp ][ tpvirtual ] = virtual;
		teleportPoints[ e_ptp ][ tpisvehicle ] = isvehicle;
		if( isvehicle == false )teleportPoints[ e_ptp ][ tppickup ]=CreatePickup( 1318, 2, x, y, z );
		if(isvehicle == true )teleportPoints[ e_ptp ][ tppickup ] = CreatePickup( 1318, 14, x, y, z );
		return e_ptp;
	}
	return 1;
}

/*

	:
		setRPNamesOnly(); //     Non-RP 
	   
	    .

*/

#define setRPNamesOnly() rpnames = true

/*

	:
		strcharsplit(const string[], &index, seperator=' '); //  strtok,   
	:
		const string[] -    
		&index -     
		seperator=' ' - .
	    seperator  seperator

*/

stock strcharsplit( const string[], &index, seperator=' ' )
{
	new 
		result[ 20 ], 
		i = 0;
	
	if( index != 0 && string[ index ] != '\0' ) index++;
	while( string[ index ] && string[ index ] != seperator && string[ index ] != '\r' && string[ index ] != '\n' )
	{
		result[ i++ ] = string[ index++ ];
	}
	return result;
}

/*

	:
		Float:floatRandom(Float:val); //        0  val
	:
		Float:val -  
	    float
	
*/

#define floatRandom(%1) float( random( floatround( %1 ) * 100 ) ) / 100

/*

	:
		Float:floatRandomEx(Float:min,Float:max); //        min  max
	:
		Float:min -  
		Float:max -  
	    float  min  max
	
*/

stock Float:floatRandomEx( Float:min, Float:max )
{
	if( min > max ) return 0.0;
	new	
		maxval = floatround( max ) * 100,
		minval = floatround( min ) * 100,
		val;
	do
	{
		val = random( maxval );
	}
	while( val < minval );
	return float( val ) / 100;
}

/*

	:
		isEmail( string[] ); //      e-mail
	:
		string -  
	  true  string - e-mail  false  
*/

stock bool: isEmail( const string[] )
{
	if( strfind( string, "@", true, -1 ) == -1 ) return false;
	new 
		part[ 3 ][ 50 ],
		idx = 0;
	part[ 0 ] = strcharsplit( string, idx, '@' );
	part[ 1 ] = strcharsplit( string, idx, '.' );
	part[ 2 ] = strcharsplit( string, idx, '.' );
	if( strlen( part[ 0 ] ) < 3 ) return false;
	if( strlen( part[ 1 ] ) < 2 ) return false;
	if( strlen( part[ 2 ] ) < 2 ) return false;
	return true;
}

/*

	:
		abs( num ); //    num
	:
		num -   .

*/

#define abs(%0) (%0 < 0) ? (-(%0)) : (%0)

/*

	:
		preLoadAnim( const  playerid, animlib[] ); //      animlib.
	:
		playerid - ID     
		animlib -  .

*/

#define preLoadAnim(%0,%1) ApplyAnimation( %0, %1, "null", 0.0, 0, 0, 0, 0, 0 )

/*

	:
		givePlayerMoneyToAll( amount ); //   
	:
		amount -  
	    .

*/

#define givePlayerMoneyToAll(%1) for( new i = 0, j = GetPlayerPoolSize(); i <= j; i++ ) \
		if( IsPlayerConnected( i ) ) \
			GivePlayerMoney( i, %1 )


/*

	:
		givePlayerHealthToAll( Float: amount ); //   
	:
		amount -  
	    .

*/

#define givePlayerHealthToAll(%1) for( new i = 0, j = GetPlayerPoolSize(); i <= j; i++ ) \
	if( IsPlayerConnected( i ) ) \
			givePlayerHealth( i, %1 )

/*

	:
		givePlayerArmourToAll( amount ); //    
	:
		amount -  
	    .

*/

#define givePlayerArmourToAll(%1) for( new i = 0, j = GetPlayerPoolSize(); i <= j; i++ ) \
	if( IsPlayerConnected( i ) ) \
		givePlayerArmour( i, %1 )

/*

	:
		isPlayerNameOnline( const nickname[] ); //         
	:
		nickname[] -  
	 true    ,  false -  .

*/

stock bool: isPlayerNameOnline( const nickname[ MAX_PLAYER_NAME ] )
{
	new 
		string[ MAX_PLAYER_NAME ];

	for( new i = 0, j = GetPlayerPoolSize(); i <= j; i++ )
	{
		if( IsPlayerConnected( i ) )
			if( !strcmp( getPlayerName( i ), nickname, true ) ) 
				return true;
	}
	return false;
}

/*

	:
		fwriteEx( filename[], string[] ); //    .   !
	:
		filename[] -  
		string[] -  
	    .

*/

stock fwriteEx( filename[], string[] )
{
	new 
		hour,
		minute,
		sec,
		str[ 256 ],
		File: file;

	gettime( hour, minute, sec );
	format( str, 64, "logs/%s.log", filename );
	file = fopen( stringer, io_append );
	format( str, 158, "[LOGS]: [%d:%d:%d]  %s\r\n", hour, minute, sec, string );
	for( new io = 0; io < strlen( str ); io++ )
		fputchar( file, str[ io ], false );
	fclose( file );
}

/*

	:
		floatToString( Float: val ); //        
	:
		Float: val -     
	     .

*/

stock floatToString( Float: val )
{
	new
		str[ 256 ];

	format( str, sizeof( str ), "%.0f", val );
	return str;
}

/*

	:
		floatToInt( Float: val ); //        
	:
		Float: val -     
	      .

*/

#define floatToInt(%1) strval( floatToString( %1 ) )

/*

	:
		Float:getTeamHealth( teamid )  -     (SetPlayerTeam)
	:
		teamid - ID 
	     .

*/

stock Float:getTeamHealth( teamid )
{
	new	
			Float: health,
			Float: thealth;

	for( new i = 0, j = GetPlayerPoolSize(); i <= j; i++ )
	{
		if( IsPlayerConnected( i ) && GetPlayerTeam( playerid ) = teamid )
		{
			GetPlayerHealth( i, health );
			thealth += health;
		}
	}
	return thealth;
}

/*

	:
		getTime( ); //    
	    ::

*/

stock getTime( )
{
    new
		string[ 9 ],
		var[ 3 ];   
    gettime( var[ 0 ], var[ 1 ], var[ 2 ] );
    format( string, sizeof( string ), "%02d:%02d:%02d", var[ 0 ], var[ 1 ], var[ 2 ] );
    return string;
}

/*

	:
		getRandomFromInput( arg1, arg2, ... argN ); //      
	   argN.

*/

stock getRandomFromInput(...)
{
    new 
		input[ 100 ], 
		generate;
    if( numargs() == 0 ) return -1;
    for( new i = 0, j = numargs(); i < j; i++ )
        input[ i ] = getarg( i );
    generate = random( numargs() );
    return input[ generate ];
}

/*

	:
		disableCapsLock( text[] ); //      .
	:
		text[] -  
	   .

*/

#define disableCapsLock(%0); new caps; while ( %0[ ++caps ] ){ if( 'A' <=%0[ caps ] <= 'Z' ) %0[ caps ] |= 0x20; if( '' <= %0[ caps ] <= '' ) %0[ caps ] |= 0x20; }

/*

	: toRus( string[] ); //      
 	:
		string[] -  .
	     

*/

stock toRus( string[] )
{
	new
		result[ 128 ];

	for ( new i = 0; i < 128; i++ )
	{
		switch ( string[ i ] )
		{
			case '': result[ i ] = 'a';
			case '': result[ i ] = 'A';
			case '': result[ i ] = '';
			case '': result[ i ] = '';
			case '': result[ i ] = '';
			case '': result[ i ] = '';
			case '': result[ i ] = '';
			case '': result[ i ] = '';
			case '': result[ i ] = '';
			case '': result[ i ] = '';
			case '': result[ i ] = 'e';
			case '': result[ i ] = 'E';
			case '': result[ i ] = 'e';
			case '': result[ i ] = 'E';
			case '': result[ i ] = '';
			case '': result[ i ] = '';
			case '': result[ i ] = '';
			case '': result[ i ] = '';
			case '': result[ i ] = '';
			case '': result[ i ] = '';
			case '': result[ i ] = '';
			case '': result[ i ] = '';
			case '': result[ i ] = 'k';
			case '': result[ i ] = 'K';
			case '': result[ i ] = '';
			case '': result[ i ] = '';
			case '': result[ i ] = '';
			case '': result[ i ] = 'M';
			case '': result[ i ] = '';
			case '': result[ i ] = '';
			case '': result[ i ] = 'o';
			case '': result[ i ] = 'O';
			case '': result[ i ] = '';
			case '': result[ i ] = '';
			case '': result[ i ] = 'p';
			case '': result[ i ] = 'P';
			case '': result[ i ] = 'c';
			case '': result[ i ] = 'C';
			case '': result[ i ] = '';
			case '': result[ i ] = '';
			case '': result[ i ] = 'y';
			case '': result[ i ] = 'Y';
			case '': result[ i ] = '';
			case '': result[ i ] = '';
			case '': result[ i ] = 'x';
			case '': result[ i ] = 'X';
			case '': result[ i ] = '';
			case '': result[ i ] = '';
			case '': result[ i ] = '';
			case '': result[ i ] = '';
			case '': result[ i ] = '';
			case '': result[ i ] = '';
			case '': result[ i ] = '';
			case '': result[ i ] = '';
			case '': result[ i ] = '';
			case '': result[ i ] = '';
			case '': result[ i ] = '';
			case '': result[ i ] = '';
			case '': result[ i ] = '';
			case '': result[ i ] = '';
			case '': result[ i ] = '';
			case '': result[ i ] = '';
			case '': result[ i ] = '';
			case '': result[ i ] = '';
			case '': result[ i ] = '';
			case '': result[ i ] = '';
			default: result[ i ] = string[ i ];
		}
	}
	return result;
}

/*

	: 
		fwriteRUS( File:file, string[] ); //      
 	:
		File:file -  ,     
		string[] -  .
	    

*/

stock bool:fwriteRUS( File:file, string[] )  
{
	for( new i, j = strlen( string ) ; i < j; i++ )  
		fputchar( file, string[ i ], false );  
	return true;  
}

/*

	: 
		fcopy(target[], copy[]); //  
 	:
		target[] -    
		copy[] -     
	    

*/

stock bool:fcopy( const target[], const copy[] )
{
	if( !fexist( target ) ) return false;
	new
		File:targets = fopen( target, io_read ),
		File:copys = fopen( copy, io_append ),
		string[ 128 ];

	while( fread( targets, string ) )
		fwriteRUS( copys, string );
	fclose( targets );
	fclose( copys );
	return true;
}

/*

	: 
		fmove(target[], olddir[], newdir[]); //  
 	:
		target[] -     
		 olddir[] -    (   ). 
		 newdir[] -     (   ).
	    

*/

stock bool:fmove( const target[], const olddir[], const newdir[] )
{
	if( !fexist( target ) ) return false;
	new
		File:targets,
		File:moves,
		string[ 128 ];

	if( !strcmp( olddir[ strlen( olddir ); // 1 ], "/", true ) )
		format( string, sizeof( string ), "%s%s", olddir, target );
	else
		format( string, sizeof( string ), "%s/%s", olddir, target );
	targets = fopen( target, io_read );
	if( !strcmp( newdir[ strlen( newdir ); // 1 ], "/", true ) )
		format( string, sizeof( string ), "%s%s", newdir, target );
	else
		format( string, sizeof( string ), "%s/%s", newdir, target );
	moves = fopen( string, io_append );
	while( fread( targets, string ) )
		fwriteRUS( moves, string );
	fclose( targets );
	if( !strcmp( olddir[ strlen( olddir ); // 1 ], "/", true ) )
		format( string, sizeof( string ), "%s%s", olddir, target );
	else
		format( string, sizeof( string ), "%s/%s", olddir, target );
	fremove( string );
	fclose( moves );
	return true;
}

/*

	: 
		log( filename[], string[] ); //   
 	:
		filename[] - (string) 
		string[] - (string)   
	    

*/

stock log( const filename[], string[] )
{     
	new 
		File: lFile; 
		
	lFile = fopen( filename, io_append );     
	fwriteRUS( lFile, string );     
	fclose( lFile );     
	return 1; 
}

/*

	: 
		enebleVehicleDamage(); //     
 	   
	    

*/

#define enebleVehicleDamage() vehDamage = true

/*

	: 
		setDisabledWeapons( ... ); //    (   SA-MP   0.3)
 	:
		{...} -    ID ,   .  41 !
	    .

*/

stock bool:setDisabledWeapons( ... )
{
	new 
		argnum = numargs();

    if( argnum <= 0 || argnum > sizeof( pBadWeap ) ) return false;
    for( new i = 0; i < argnum; i++ )
        pBadWeap[ i ] = getarg( i );
	return true;
}

/*

	:
		setSpawnWeapons( {{id}, {ammo}}... ) -      .
	:
		{id} -  ,  
		{ammo} -  
	    .

*/

stock bool:setSpawnWeapons( ... )
{
	new 
		argnum = numargs();

	for( new i = 0; i < argnum; i++ ) 
	{
		if( spgunid >= sizeof( spawnGun ) ) break;
		if ( getarg( i + 1 ) && getarg( i ) ) 
		{
			spawnGun[ spgunid ][ spGunid ] = getarg( i );
			spawnGun[ spgunid ][ spAmmo ] = getarg( i + 1 );
			spgunid++;
			i++; 
		} 
	}
	return true;
}

/*

	: 
		isValidSkin(skinid); //    ID .
 	:
		skinid -  ID 
	  true -     , false -   

*/

#define isValidSkin(%1) %1 >= 0 && %1 < 74 || %1 >= 74 && %1 < 300

/*

	: 
		numPlayers(); //     
 	   .
	     

*/

#define numPlayers() GetPlayerPoolSize() + 1

/*

 	: 
		getDeathReason(reason); //   
 	:
		reason -  
	     

*/

stock getDeathReason( const reason )
{
	new
		result[ 32 ];

	switch( reason )
	{
		case 0: result = "";
		case 1: result = "";
		case 2: result = "  ";
		case 3: result = "";
		case 4: result = "";
		case 5: result = " ";
		case 6: result = "";
		case 7: result = "";
		case 8: result = "";
		case 9: result = "";
		case 10: result = "";
		case 11: result = "";
		case 12: result = "";
		case 13: result = "";
		case 14: result = "";
		case 15: result = "";
		case 16: result = "";
		case 17: result = " ";
		case 18: result = " ";
		case 22: result = "";
		case 23: result = "  ";
		case 24: result = " ";
		case 25: result = "";
		case 26: result = "";
		case 27: result = " ";
		case 28: result = "";
		case 29: result = "-5";
		case 30: result = "-47";
		case 31: result = "4";
		case 32: result = "9";
		case 33: result = "";
		case 34: result = " ";
		case 35: result = "";
		case 36: result = "";
		case 37: result = "";
		case 38: result = "";
		case 39: result = "";
		case 40: result = "";
		case 41: result = "  ";
		case 42: result = "";
		case 47: result = " ";
		case 49: result = " ";
		case 50: result = " ";
		case 51: result = "";
		case 53: result = "";
		case 54: result = "";
		case 255: result = "";
		default: result = " ";
	}
	return result;
}

/*

 	: 
		setStartMoney(amount); //    
 	:
		amount -     
	    .

*/

#define setStartMoney(%1) startmoney = %1

/* 
	:
		disableBadword(word[]); //   
	:
		word[] -  
	  *   

	  forum.sa-mp.com/showthread.php?t=38965&page=29

*/
 
#define disableBadword(%1) for(new i=0; i<strlen(text); i++) if(strfind(text[i], %1, true) == 0) for(new a=0; a<256; a++) if (a >= i && a < i+strlen(%1)) text[a] = '*'

/* 
	:
		enebleHeadShot(bool:status); //         
	:
		bool:status - true -  \ false - 
	    

*/

#define enebleHeadShot(%1) headshot = %1

/* 
	:
		maxHealth(Float:amount); //      
	:
		Float:amount -     
	    

*/

#define maxHealth(%1) maxhealth = %1

/* 
	:
		getObjectPoolSize(); //   ID 
	   
	   ID  .     ,   INVALID_OBJECT_ID

*/

stock getObjectPoolSize()
{
	new
		num = CreateObject( 19522, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 );

	DestroyObject( num );
	if( num <= 1 ) 
		return INVALID_OBJECT_ID;
	else
		return num - 1;
}

/* 
	:
		getPickupPoolSize(); //   ID 
	   
	   ID  .     ,   INVALID_PICKUP_ID

*/

stock getPickupPoolSize()
{
	new
		num = CreatePickup( 1318, 2, 0.0, 0.0, 0.0, -1 );

	DestroyPickup( num );
	if( num == 0 ) 
		return INVALID_PICKUP_ID;
	else
		return num - 1;
}

//===============================================================
//
// 						 
//
//===============================================================