/******************************************************************************************************************************************

		-----------------------------------------------------------------
			functions/d_vehicles.inc -    .
		-----------------------------------------------------------------

			-------------------------------------------------------
				    SA-MP V0.3.7   
			-------------------------------------------------------

------------------------------------------------------------------------------------------------------------------------------		

	  :
		V2.1 BUILD 1000  10.10.2016

------------------------------------------------------------------------------------------------------------------------------	

	  :
		V1.4 BUILD 1000  02.04.2015

------------------------------------------------------------------------------------------------------------------------------

	 :
		10.10.2016 -   
		02.04.2015 -     :
			d_vehicles.inc:
				native getVehicleNumberPlate(vehicleid); //     
				native getVehiclePaintjob(vehicleid); //   
				native getVehicleColor(vehicleid, color1, color2); //   
		04.03.2015 -      
		
------------------------------------------------------------------------------------------------------------------------------

	   :
		native IsValidVehicle(vehicleid); //     ,  
		native getVehicleInterior(vehicleid); //      
		native setVehiclePosEx(vehicleid,Float:x,Float:y,Float:z,Float:RotateAngle,interior=0,virtual=0); //   ,   
		native getVehicleInfo(vehicleid,&Float:x,&Float:y,&Float:z,&Float:RotateAngle,&Float:health,&interior,&virtual,&model); //    
		native turnCarEngine(vehicleid, status); // \  
		native isCarEngineRunned(vehicleid); //    .
		native turnCarLights(vehicleid, status); // \ 
		native isCarLightsOn(vehicleid); //     
		native turnCarAlarm(vehicleid, status); // \   
		native isCarAlarmActive(vehicleid); //   
		native turnCarDoors(vehicleid, status); // \   
		native isCarDoorsOpen(vehicleid); //   
		native turnCarBonnet(vehicleid, status); // \  
		native isCarBonnetOpen(vehicleid); //   
		native turnCarBoot(vehicleid, status); // \  
		native isCarBootOpen(vehicleid); //   
		native turnCarObjective(vehicleid, status); //    
		native isCarObjective(vehicleid); //    
		native createVehicle3DtextLableEx(vehicleid,text[],color,Float:x=0.0,Float:y=0.0,Float:z=0.7,Float:DrawDistance=100.0,virtual=0,testLOS=0); //    
		native deleteVehicle3DtextLableEx(vehicleid); //     
		native updateVehicle3DtextLableEx(vehicleid,color,text[]); //     
		native getVehicleName(vehicleid); //   .
		native stopVehicle(vehicleid); //   
		native getVehicleSpeed(vehicleid); //   .
		native setVehicleSpeed(vehicleid, Float:speed); //    .
		native addVehicleComponentEx(vehicleid, {id}); //    
		native removeVehicleComponentEx(vehicleid, {id}); //     
		native giveVehicleHealth(vehicleid, Float: amount); //      
		native isValidVehicleModel(modelid); //    ID  
		native getCoordBonetVehicle(vehicleid, &Float: x, &Float:y, &Float:z); //    
		native getCoordBootVehicle(vehicleid, &Float:x, &Float:y, &Float:z); //    
		native goBust(playerid, speed); //  ,    .
		native getVehicleSeat(vehicleid, seat); //        
		native bool:isVehicleOccupied(vehicleid); //      ,  
		native getVehicleIDbyName(vehname[]); //  ID     
		native getVehicleNumbyName(vehname[]); //        
		native getVehicleCount(); //      
		native flipVehicle(vehicleid); //    
		native getVehicleNumberPlate(vehicleid); //     
		native getVehiclePaintjob(vehicleid); //   
		native getVehicleColor(vehicleid, color1, color2); //   

------------------------------------------------------------------------------------------------------------------------------
	    :
		      Dima-kun a.k.a Morino_Reigan
	
	 :
		   SA-MP SAMP-RUS.COM     
		SA-MP TEAM  San Andreas-MultiPlayer
		Rockstar North Games  Grand Theft Auto San Andreas

	            : http://samp-rus.com
	
*******************************************************************************************************************************************/

#if defined d_includes_vehicles
	#endinput
#endif
#define d_includes_vehicles  1

/*

	:
		IsValidVehicle( vehicleid ); //     ,  
	:
		vehicleid - ID 
	  1      0 -   

*/

native IsValidVehicle( vehicleid );

/*

	:
		getVehicleInterior(vehicleid); //      
	:
		vehicleid - ID 
	  ID .

*/

#define getVehicleInterior(%1) vehicleInfo[%1][ e_vint ]

/*

	:
		setVehicleInterior(vehicleid,interior); //    
	:
		vehicleid - ID 
		interior - ID 
	    

*/

stock bool:setVehicleInterior( const vehicleid, const interior )
{
	if( !IsValidVehicle( vehicleid ) ) return false;
	vehicleInfo[ vehicleid ][ e_vint ] = interior;
	LinkVehicleToInterior( vehicleid, vehicleInfo[ vehicleid ][ e_vint ] );
	return true;
}

/*

	:
		setVehiclePosEx(vehicleid,Float:x,Float:y,Float:z,Float:RotateAngle,interior=0,virtual=0); //   ,   
	:
		vehicleid - ID 
		Float:x -  
		Float:y -  Y
		Float:z -  Z
		Float:RotateAngle -   
		interior - ID 
		virtual - ID  
	    .

*/

stock bool:setVehiclePosEx( vehicleid, Float:x, Float:y, Float:z, Float:RotateAngle, interior = 0, virtual = 0 )
{
	if( !IsValidVehicle( vehicleid ) ) return false;
	SetVehiclePos( vehicleid, x, y, z );
	SetVehicleZAngle( vehicleid, RotateAngle );
	SetVehicleInterior( vehicleid, interior );
	SetVehicleVirtualWorld( vehicleid, virtual );
	return true;
}

/*

	:
		getVehicleInfo(vehicleid,&Float:x,&Float:y,&Float:z,&Float:RotateAngle,&Float:health,&interior,&virtual,&model); //    
	:
		vehicleid - ID 
		Float:x -  
		Float:y -  Y
		Float:z -  Z
		Float:RotateAngle -  
		Float:health - 
		interior - ID 
		virtual - ID  
		model-  
	     .

*/

stock bool:getVehicleInfo( vehicleid, &Float:x, &Float:y, &Float:z, &Float:RotateAngle, &Float:health, &interior, &virtual, &model )
{
	if( !IsValidVehicle( vehicleid ) ) return false;
	GetVehiclePos( vehicleid, x ,y, z );
	GetVehicleZAngle( vehicleid, RotateAngle );
	GetVehicleHealth( vehicleid, health );
	interior = getVehicleInterior( vehicleid );
	virtual = GetVehicleVirtualWorld( vehicleid );
	model = GetVehicleModel( vehicleid );
	return true;
}

/*

	:
		turnCarEngine(vehicleid, status); // \  
	:
		vehicleid - ID 
		status - \  (1\0)
	    .

*/

stock bool:turnCarEngine( vehicleid, status )
{
	if( !IsValidVehicle( vehicleid ) ) return false;
	new eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective;
   	GetVehicleParamsEx( vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective );
    SetVehicleParamsEx( vehicleid, status, elights, ealarm, edoors, ebonnet, eboot, eobjective );
	return true;
}

/*

	:
		isCarEngineRunned(vehicleid); //    .
	:
		vehicleid - ID 
	  : 1 -  0 

*/

stock bool:isCarEngineRunned( vehicleid )
{
	if( !IsValidVehicle( vehicleid ) ) return false;
	new eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective;
    GetVehicleParamsEx( vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective );
	return ( eengine == VEHICLE_PARAMS_ON ) ? true : false;
}

/*

	:
		turnCarLights(vehicleid, status); // \ 
	:
		vehicleid - ID 
		status - \  (1\0)
	    .

*/

stock bool:turnCarLights( vehicleid, status )
{
	if( !IsValidVehicle( vehicleid ) ) return false;
	new eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective;
    GetVehicleParamsEx( vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective );
    SetVehicleParamsEx( vehicleid, eengine, status, ealarm, edoors, ebonnet, eboot, eobjective );
	return true;
}

/*

	:
		isCarLightsOn(vehicleid); //     
	:
		vehicleid - ID 
	   : (1),  (0)

*/

stock bool:isCarLightsOn( vehicleid )
{
	if( !IsValidVehicle( vehicleid ) ) return false;
	new eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective;
    GetVehicleParamsEx( vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective );
	return ( elights == VEHICLE_PARAMS_ON ) ? true: false;
}

/*

	:
		turnCarAlarm(vehicleid, status); // \   
	:
		vehicleid - ID 
		status - \  (1\0)
	    .

*/

stock bool:turnCarAlarm( vehicleid, status )
{
	if( !IsValidVehicle( vehicleid ) ) return false;
	new eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective;
    GetVehicleParamsEx( vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective );
	SetVehicleParamsEx( vehicleid, eengine, elights, status, edoors, ebonnet, eboot, eobjective );
	return true;
}

/*

	:
		isCarAlarmActive(vehicleid); //   
	:
		vehicleid - ID 
	   : (1),  (0)

*/

stock bool:isCarAlarmActive( vehicleid )
{
	if( !IsValidVehicle( vehicleid ) ) return false;
	new eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective;
    GetVehicleParamsEx( vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective );
	return ( ealarm==VEHICLE_PARAMS_ON ) ? true : false;
}

/*

	:
		turnCarDoors(vehicleid, status); // \   
	:
		vehicleid - ID 
		status - \  (1\0)
	    .

*/

stock bool:turnCarDoors( vehicleid, status )
{
	if( !IsValidVehicle( vehicleid ) ) return false;
	new eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective;
    GetVehicleParamsEx( vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective );
    SetVehicleParamsEx( vehicleid, eengine, elights, ealarm, status, ebonnet, eboot, eobjective );
	return true;
}

/*

	:
		isCarDoorsOpen(vehicleid); //   
	:
		vehicleid - ID 
	   : (1),  (0)

*/

stock bool:isCarDoorsOpen( vehicleid )
{
	if( !IsValidVehicle( vehicleid ) ) return false;
	new eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective;
    GetVehicleParamsEx( vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective );
	return ( edoors == VEHICLE_PARAMS_ON ) ? true : false;
}

/*

	:
		turnCarBonnet(vehicleid, status); // \  
	:
		vehicleid - ID 
		status - \  (1\0)
	    .

*/

stock bool:turnCarBonnet( vehicleid, status )
{
	if( !IsValidVehicle( vehicleid ) ) return false;
	new eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective;
    GetVehicleParamsEx( vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective );
    SetVehicleParamsEx( vehicleid, eengine, elights, ealarm, edoors, status, eboot, eobjective );
	return true;
}

/*

	:
		isCarBonnetOpen(vehicleid); //   
	:
		vehicleid - ID 
	   : (1),  (0)

*/

stock bool:isCarBonnetOpen( vehicleid )
{
	if( !IsValidVehicle( vehicleid ) ) return false;
	new eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective;
    GetVehicleParamsEx(vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective);
	return ( ebonnet == VEHICLE_PARAMS_ON) ? true : false;
}

/*

	:
		turnCarBoot(vehicleid, status); // \  
	:
		vehicleid - ID 
		status - \  (1\0)
	    .

*/

stock bool:turnCarBoot( vehicleid, status )
{
	if( !IsValidVehicle( vehicleid ) ) return false;
	new eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective;
    GetVehicleParamsEx( vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective );
   	SetVehicleParamsEx( vehicleid, eengine, elights, ealarm, edoors, ebonnet, status, eobjective );
	return true;
}

/*

	:
		isCarBootOpen(vehicleid); //   
	:
		vehicleid - ID 
	   : (1),  (0)

*/

stock bool:isCarBootOpen( vehicleid )
{
	if( !IsValidVehicle( vehicleid ) ) return false;
	new eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective;
    GetVehicleParamsEx( vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective );
	return ( eboot== VEHICLE_PARAMS_ON ) ? true: false;
}

/*

	:
		turnCarObjective(vehicleid, status); //    
	:
		vehicleid - ID 
		status - \  \ \ (1\0)
	    .

*/

stock bool:turnCarObjective( vehicleid, status )
{
	if( !IsValidVehicle( vehicleid ) ) return false;
	new eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective;
    GetVehicleParamsEx( vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective );
    SetVehicleParamsEx( vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, status );
	return true;
}

/*

	:
		isCarObjective(vehicleid); //    
	:
		vehicleid - ID 
	   :  (1),   (0)

*/

stock bool:isCarObjective( vehicleid )
{
	if( !IsValidVehicle( vehicleid ) ) return false;
	new eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective;
    GetVehicleParamsEx( vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective );
	return ( eboot == VEHICLE_PARAMS_ON ) ? true : false ;
}

/*

	:
		createVehicle3DtextLableEx(vehicleid,text[],color,Float:x=0.0,Float:y=0.0,Float:z=0.7,Float:DrawDistance=100.0,virtual=0,testLOS=0); //    
	:
		vehicleid - ID ,     
		text[] - (Text 3D)
		color -  
		Float:x -  
		Float:y -  Y
		Float:z -  Z 
		Float:DrawDistance -  
		virtual -  
		testLOS -     .
	    .        .

*/

stock bool:createVehicle3DtextLableEx( const vehicleid, text[], color, Float:x=0.0, Float:y=0.0, Float:z=0.7, Float:DrawDistance=100.0, virtual=0, testLOS=0 )
{
	if( !IsValidVehicle( vehicleid ) || vehicleInfo[ vehicleid ][ vtextLable ] == USE ) return false;
	vehicleInfo[ vehicleid ][ vlabel ] = Create3DTextLabel( text, color, 0.0, 0.0, 0.0, DrawDistance, virtual, testLOS );
	Attach3DTextLabelToVehicle( vehicleInfo[ vehicleid ][ vlabel ], vehicleid, x, y, z );
	vehicleInfo[ vehicleid ][ vtextLable ] = USE;
	return true;
}

/*

	:
		deleteVehicle3DtextLableEx(vehicleid)  -     
	:
		playerid - ID 
	    .

*/

stock bool:deleteVehicle3DtextLableEx( const vehicleid )
{
	if( !IsValidVehicle( vehicleid ) || vehicleInfo[ vehicleid ][ vtextLable ] == NOT_USE ) return false;
	Delete3DTextLabel( vehicleInfo[ vehicleid ][ vlabel ] );
	vehicleInfo[ vehicleid ][ vtextLable ] = NOT_USE;
	return true;
}

/*

	:
		updateVehicle3DtextLableEx(vehicleid,color,text[]); //    
	:
		vehicleid - ID 
		color -  
		text[] - 
	    .

*/

stock bool:updateVehicle3DtextLableEx( const vehicleid, color, text[] )
{
	if( vehicleInfo[ vehicleid ][ vtextLable ] == NOT_USE ) return 0;
	if( !IsValidVehicle( vehicleid ) ) return false;
	Update3DTextLabelText( vehicleInfo[ vehicleid ][ vlabel ], color, text );
	return true;
}

/*

	:
		getVehicleName(vehicleid); //   .
	:
		vehicleid - ID 
	   .

*/

stock getVehicleName( const vehicleid )
{
	new 
		result[ 50 ],
		modelid;

	if( !IsValidVehicle( vehicleid ) ) 
		strmid( result, "Error vehicleid", 0, strlen( "Error vehicleid" ), 255 );
	else
	{
		modelid = GetVehicleModel( vehicleid );
		strmid( result, VehNames[ modelid - 400 ], 0, strlen( VehNames[ modelid - 400 ] ), 255 );
	}
	return result;
}

/*

	:
		stopVehicle(vehicleid); //   
	:
		vehicleid - ID    .
	    .

*/

#define stopVehicle(%1) SetVehicleVelocity( %1, 0.0, 0.0, 0.0 )

/*

	:
		GetVehicleSpeed(vehicleid); //   .
	:
		vehicleid - ID    .
	    .

*/

stock getVehicleSpeed( const vehicleid )
{
	if( !IsValidVehicle( vehicleid ) ) return false;
    new 
		Float:Vx,
		Float:Vy,
		Float:Vz,
		Float:rtn; 

    GetVehicleVelocity( vehicleid, Vx, Vy, Vz ); 
    rtn = floatsqroot( Vx * Vx + Vy * Vy + Vz * Vz ); 
    return floatround( rtn * 100 ); 
}

/*

	:
		setVehicleSpeed(vehicleid, Float:speed); //    .
	:
		vehicleid - ID .
		Float:speed -  .
	    .

*/

stock bool:setVehicleSpeed( const vehicleid, Float: speed )
{
	if( !IsValidVehicle( vehicleid ) ) return false;
	new 
		Float: x1, 
		Float: y1, 
		Float: z1, 
		Float: x2, 
		Float: y2, 
		Float: z2, 
		Float: a; 

	GetVehicleVelocity( vehicleid, x1, y1, z1 ); 
	GetVehiclePos( vehicleid, x2, y2, z2 ); 
	GetVehicleZAngle( vehicleid, a ); 
	a = 360 - a; 
	x1 = ( floatsin( a, degrees ) * ( speed / 100 ) + floatcos( a, degrees ) * 0 + x2 ); // x2; 
	y1 = ( floatcos( a, degrees ) * ( speed/ 100 ) + floatsin( a, degrees ) * 0 + y2 ); // y2; 
	SetVehicleVelocity( vehicleid, x1, y1, z1 ); 
	return true;
}

/*

	:
		addVehicleComponentEx(vehicleid, {id}); //    
	:
		vehicleid - ID ,    
		{id} -  ,     
	    .

*/

stock bool:addVehicleComponentEx( ... )
{ 
	if ( numargs() % 2 == 0 ) return false; 
	for ( new i = 1; i < numargs(); i++ ) 
	{ 
		if ( getarg( i ) ) 
			AddVehicleComponent( getarg( 0 ), getarg( i ) ); 
	}
	return true; 
}

/*
	
	:
		removeVehicleComponentEx(vehicleid, {id}); //     
	:
		vehicleid - ID ,    
		{id} -  ,     
	    .

*/

stock bool:removeVehicleComponentEx( ... )
{
	if ( numargs() % 2 == 0 ) return false;
	for ( new i = 1; i < numargs(); i++ )
	{
		if ( getarg( i ) )
			RemoveVehicleComponent( getarg( 0 ), getarg( i ) );
	}
	return true;
}

/*

	:
		giveVehicleHealth(vehicleid, Float: amount); //      
	:
		vehicleid - ID ,    
		Float: amount -   
	    .

*/

stock bool:giveVehicleHealth( const vehicleid, Float: amount )
{
	if( !IsValidVehicle( vehicleid ) ) return false;
	new 
		Float:vhealth;

	GetVehicleHealth( vehicleid, vhealth );
	SetVehicleHealth( vehicleid, vhealth + amount );
	return true;
}

/*

	:
		isValidVehicleModel(modelid); //    ID  
	:
		modelid -  ID 
	 true -     false -   .

*/

#define IsValidVehicleModel(%1) (400 <= %1 && %1 <= 611)

/*

	:
		getCoordBonetVehicle(vehicleid, &Float: x, &Float:y, &Float:z); //    
	:
		vehicleid - ID 
		Float: x -  
		Float: y -  Y
		Float: z -  Z
	     X,Y,Z

	  pawno.su
*/

stock bool:getCoordBonetVehicle( const vehicleid, &Float: x, &Float:y, &Float: z ) 
{
	if( !IsValidVehicle( vehicleid ) ) return false;
    new
		Float: angle,
		Float: distance;

    GetVehicleModelInfo( GetVehicleModel( vehicleid ), 1, x, distance, z );
    distance = distance / 2 + 0.1;
    GetVehiclePos( vehicleid, x, y, z );
    GetVehicleZAngle( vehicleid, angle );
    x -= distance * floatsin( -angle + 180, degrees );
    y -= distance * floatcos( -angle + 180, degrees );
    return true; 
} 

/*

	:
		getCoordBootVehicle(vehicleid, &Float:x, &Float:y, &Float:z); //    
	:
		vehicleid - ID 
		Float: x -  
		Float: y -  Y
		Float: z -  Z
	     X,Y,Z

	  pawno.su
*/

stock bool:getCoordBootVehicle( const vehicleid, &Float:x, &Float:y, &Float:z )
{
	if( !IsValidVehicle( vehicleid ) ) return false;
    new 
		Float: angle,
		Float: distance; 

    GetVehicleModelInfo( GetVehicleModel( vehicleid ), 1, x, distance, z );
    distance = distance / 2 + 0.1;
    GetVehiclePos( vehicleid, x, y, z );
    GetVehicleZAngle( vehicleid, angle );
    x += distance * floatsin( -angle + 180, degrees);
    y += distance * floatcos( -angle + 180, degrees);
    return true;
}

/*

	:
		goBust(playerid, speed); //  ,    .
	:
		playerid - ID   
		speed -   
	    .

*/

#define goBust(%1,%2) if( IsPlayerInAnyVehicle( %1 ) ) \
		setVehicleSpeed( GetPlayerVehicleID( %1 ), %2 )

/*

	:
		getVehicleSeat(vehicleid, seat); //        .
	:
		vehicleid - ID 
		seat - ID 
	  ID ,     .

*/

stock getVehicleSeat( const vehicleid, const seat )
{
	if( !IsValidVehicle( vehicleid ) ) return INVALID_PLAYER_ID;
    for( new i = 0, j = GetPlayerPoolSize(); i <= j; i++ )
		if( IsPlayerConnected( i ) )
			if( IsPlayerInVehicle( i, vehicleid ) )
				if( GetPlayerVehicleSeat( i ) == seat ) 
					return i;
    return INVALID_PLAYER_ID;
} 

/*

	:
		bool:isVehicleOccupied(vehicleid); //      ,  
	:
		vehicleid - ID 
	  true -     , false -  

*/

stock bool:isVehicleOccupied( const vehicleid )
{
	for( new i = 0, j = GetPlayerPoolSize(); i <= j; i++ )
		if( IsPlayerConnected( i ) && GetPlayerVehicleID( i ) == vehicleid && GetPlayerVehicleSeat( i ) == 0 )
			return true;
	return false;
}

/*

	:
		getVehicleIDbyName(vehname[]); //  ID     
	:
		vehname[] -  
	  ID  ,  INVALID_VEHICLE_ID -     .

*/

stock getVehicleIDbyName( const vehname[] )
{
	for( new i = 0; i < 215; i++ )
	{
		if( !strcmp( VehNames[ i ], vehname, true ) )
			return i + 400;
	}
	return INVALID_VEHICLE_ID;
}

/*

	:
		getVehicleNumbyName(vehname[]); //        
	:
		vehname[] -  
	    .

*/

stock getVehicleNumbyName( const vehname[] )
{
	new
		num = 0;

	for( new i = 0, j = GetVehiclePoolSize(); i <= j; i++ )
	{
		if( !strcmp( getVehicleName( i ), vehname, true ) )
			num++;
	}
	return num;
}

/*

	:
		getVehicleNumbyModel(modelid); //        
	:
		modelid  - ID  
	    .

*/

stock getVehicleNumbyModel( const modelid )
{
	new
		num = 0;

	for( new i = 0, j = GetVehiclePoolSize(); i <= j; i++ )
	{
		if( GetVehicleModel( i ) == modelid )
			num++;
	}
	return num;
}

/*

	:
		flipVehicle(vehicleid); //    
	:
		vehicleid  - ID 
	    

*/

stock bool:flipVehicle( const vehicleid )
{
	if( !IsValidVehicle( vehicleid ) ) return false;
	new
		Float:pos[ 4 ];

	GetVehiclePos( vehicleid, pos[ 0 ], pos[ 1 ], pos[ 2 ] );
	GetVehicleZAngle( vehicleid, pos[ 3 ] );	
	SetVehiclePos( vehicleid, pos[ 0 ], pos[ 1 ], pos[ 2 ] );
	SetVehicleZAngle( vehicleid, pos[ 3 ] );
	return true;
}

stock bool:setVehicleNumberPlate( vehicleid, string[] )
{
	if( !IsValidVehicle( vehicleid ) ) return false;
	string( vehicleInfo[ vehicleid ][ vnumPlate ], string, 0, strlen( string ), 255 );
	SetVehicleNumberPlate( vehicleid, string );
	return true;
}

#define SetVehicleNumberPlate setVehicleNumberPlate

/*

	:
		getVehicleNumberPlate(vehicleid); //     
	:
		vehicleid  - ID 
	      

*/
#define getVehicleNumberPlate(%1) vehicleInfo[%1][vnumPlate]

stock bool:changeVehiclePaintjob( vehicleid, paintjob )
{
	if( !IsValidVehicle( vehicleid ) ) return false;
	ChangeVehiclePaintjob( vehicleid, paintjob );
	vehicleInfo[ vehicleid ][ vPaintjob ] = paintjob;
	return true;
}

#define ChangeVehiclePaintjob changeVehiclePaintjob

/*

	:
		getVehiclePaintjob(vehicleid); //   
	:
		vehicleid  - ID 
	 ID  .

*/

#define getVehiclePaintjob(%1) vehicleInfo[%1][vPaintjob]

stock bool:changeVehicleColor( vehicleid, _color1, _color2 )
{
	if( !IsValidVehicle( vehicleid ) ) return false;
	ChangeVehicleColor( vehicleid, _color1, _color2 );
	vehicleInfo[ vehicleid ][ vColor1 ] = _color1;
	vehicleInfo[ vehicleid ][ vColor2 ] = _color2;
	return true;
}

#define ChangeVehicleColor changeVehicleColor

/*

	:
		getVehicleColor(vehicleid, &color1, &color2); //   
	:
		vehicleid  - ID 
		color1 - ID  1
		color2 - ID  2
	 ID  .

*/

stock bool:getVehicleColor( vehicleid, &_color1, &_color2 )
{
	if( !IsValidVehicle( vehicleid ) ) return false;
	_color1 = vehicleInfo[ vehicleid ][ vColor1 ];
	_color2 = vehicleInfo[ vehicleid ][ vColor2 ];
	return true;
}

//===============================================================
//
// 						 
//
//===============================================================