#include <a_samp>

// This is a comment
// uncomment the line below if you want to write a filterscript
//#define FILTERSCRIPT

#define TEAM_1 1
#define TEAM_2 2
#define COLOR_TEAM1 0xCD3333AA
#define COLOR_RED 0xCD3333AA
#define COLOR_TEAM2 0x0000EEAA
#define COLOR_GREY 0xBEBEBEAA

forward SetPlayerTeamFromClass(playerid, classid);
forward SetPlayerToTeamColor(playerid);
forward WeaponBuyHealth(playerid);
forward WeaponBuyArmour(playerid);
forward WeaponBuyMP(playerid);
forward WeaponBuyShotgun(playerid);
forward WeaponBuyM4(playerid);
forward WeaponBuyAK47(playerid);
forward WeaponBuySniper(playerid);

new gTeam[MAX_PLAYERS];
new Menu:teleportmenu;

#if defined FILTERSCRIPT

public OnFilterScriptInit()
{
	print("\n--------------------------------------");
	print(" Flagstaff's Tankwar");
	print("--------------------------------------\n");
	return 1;
}

public OnFilterScriptExit()
{
	return 1;
}

#else

main()
{
	print("\n----------------------------------");
	print(" Flagstaff's Tankwar");
	print("----------------------------------\n");
}

#endif

public OnGameModeInit()
{
	// Don't use these lines if it's a filterscript
	SetGameModeText("Tankwar v1.0");
	
	teleportmenu = CreateMenu("Weapon Menu", 2, 200.0, 150.0, 120.0, 50.0);
	AddMenuItem(teleportmenu, 0, "Heal");
	AddMenuItem(teleportmenu, 0, "Armour");
	AddMenuItem(teleportmenu, 0, "MP");
	AddMenuItem(teleportmenu, 0, "Shotgun");
	AddMenuItem(teleportmenu, 0, "M4");
	AddMenuItem(teleportmenu, 0, "AK-47");
	AddMenuItem(teleportmenu, 0, "Sniper");
	
	AddMenuItem(teleportmenu, 1, "$100");
	AddMenuItem(teleportmenu, 1, "$200");
	AddMenuItem(teleportmenu, 1, "$800");
	AddMenuItem(teleportmenu, 1, "$1000");
	AddMenuItem(teleportmenu, 1, "$2000");
	AddMenuItem(teleportmenu, 1, "$2000");
	AddMenuItem(teleportmenu, 1, "$5000");
	
	AddPlayerClass(287,373.7629,853.3892,28.1261,38.6544,4,1,24,60,0,0); // spawn team1
	AddPlayerClass(121,391.3173,876.2011,24.6035,78.4481,4,1,24,60,0,0); // spawn team1
	AddPlayerClass(122,391.3173,876.2011,24.6035,78.4481,4,1,24,60,0,0); // spawn team1
	AddPlayerClass(124,-854.9866,1535.1597,22.4814,268.2198,4,1,24,60,0,0); // spawn team2
	AddPlayerClass(127,-854.9866,1535.1597,22.4814,268.2198,4,1,24,60,0,0); // spawn team2
	AddPlayerClass(111,-854.9866,1535.1597,22.4814,268.2198,4,1,24,60,0,0); // spawn team2
	AddStaticVehicle(432,384.3261,902.6671,20.6393,87.1138,0,0); // panzer team1
	AddStaticVehicle(432,373.2944,881.0258,20.4121,157.7101,0,0); // panzer team 1
	AddStaticVehicle(432,358.7848,850.7956,20.1254,40.7378,0,0); // panzer team 1
	AddStaticVehicle(425,311.5202,892.9248,20.9753,336.1884,0,0); // hunter team1
	AddStaticVehicle(470,381.0673,916.7415,21.8736,89.8117,0,0); // patriot team1
	AddStaticVehicle(470,393.2584,907.5440,21.2945,83.9850,0,0); // patriot team1
	AddStaticVehicle(470,337.3618,910.6219,20.4035,302.5062,0,0); // patriot team1
	AddStaticVehicle(470,341.0407,903.8127,20.3996,301.8743,0,0); // patriot team1
	AddStaticVehicle(425,-862.1478,1547.9609,23.8457,59.8487,0,0); // hunter team2
	AddStaticVehicle(470,-840.7137,1600.6638,26.8756,281.6017,0,0); // patriot team2
	AddStaticVehicle(470,-836.9003,1593.5768,26.6318,97.7544,0,0); // patriot team2
	AddStaticVehicle(470,-865.8761,1605.2498,27.1837,241.3829,0,0); // patriot team2
	AddStaticVehicle(470,-851.8813,1619.8533,26.9501,148.9967,0,0); // patriot team2
	AddStaticVehicle(432,-880.7773,1592.4977,27.3645,237.3492,0,0); // panzer team2
	AddStaticVehicle(432,-878.1304,1572.9314,26.7279,342.3716,0,0); // panzer team2
	AddStaticVehicle(432,-863.8113,1622.8361,26.9715,209.5260,0,0); // panzer 2
	AddStaticVehicle(470,-744.6581,1258.8877,13.4470,46.4056,0,0); // pati
	AddStaticVehicle(470,-701.5397,1017.6739,12.4001,292.3842,0,0); // pati
	AddStaticVehicle(470,-279.8321,1077.3313,19.6549,3.4478,0,0); // pati
	AddStaticVehicle(470,-86.9061,1216.4626,19.7253,94.5670,0,0); // pati
	AddStaticVehicle(470,-1.1458,1085.8940,19.7301,175.6844,0,0); // pati
	AddStaticVehicle(470,-426.5501,1453.2395,34.3844,97.3332,0,0); // pati
	AddStaticVehicle(470,-354.9675,1527.7664,75.3502,79.7498,0,0); // pati
	AddStaticVehicle(470,-84.1999,1433.2574,9.3638,179.2735,0,0); // pati
	AddStaticVehicle(470,330.8590,1406.1285,6.9878,266.7112,0,0); // pati
	AddStaticVehicle(470,585.4576,1644.1914,6.9857,245.4121,0,0); // pati
	AddStaticVehicle(470,759.4739,1120.5867,28.3291,103.0476,0,0); // pati
	return 1;
}

public OnGameModeExit()
{
	return 1;
}

public OnPlayerRequestClass(playerid, classid)
{
	SetPlayerPos(playerid, 1958.3783, 1343.1572, 15.3746);
	SetPlayerCameraPos(playerid, 1958.3783, 1343.1572, 15.3746);
	SetPlayerCameraLookAt(playerid, 1958.3783, 1343.1572, 15.3746);
	SetPlayerTeamFromClass(playerid, classid);
	return 1;
}

public OnPlayerRequestSpawn(playerid)
{
	return 1;
}

public OnPlayerConnect(playerid)
{
	SendClientMessage(playerid, COLOR_TEAM2, "** Welcome to Flagstaff's =TANKWAR=");
	SendClientMessage(playerid, COLOR_TEAM2, "** Type /help for game help or");
	SendClientMessage(playerid, COLOR_TEAM2, "** /cmds for game commands! ! GOOD LUCK !");
	return 1;
}

public OnPlayerDisconnect(playerid, reason)
{
	return 1;
}

public OnPlayerSpawn(playerid)
{
	ResetPlayerMoney(playerid);
	GivePlayerMoney(playerid, 8000);
    SetPlayerToTeamColor(playerid);
    SetPlayerWorldBounds(playerid,824.8166,-933.8829,1714.7688,604.9297);
	return 1;
}

public OnPlayerDeath(playerid, killerid, reason)
{
	SetPlayerScore(playerid, -1);
	SetPlayerScore(killerid, 1);
	return 1;
}

public OnVehicleSpawn(vehicleid)
{
	return 1;
}

public OnVehicleDeath(vehicleid, killerid)
{
	return 1;
}

public OnPlayerText(playerid, text[])
{
	return 1;
}

public OnPlayerPrivmsg(playerid, recieverid, text[])
{
	return 1;
}

public OnPlayerCommandText(playerid, cmdtext[])
{
	if(strcmp(cmdtext, "/buy", true) == 0)
	{
    	ShowMenuForPlayer(teleportmenu, playerid);
    	return 1;
	}
	if(strcmp(cmdtext, "/help", true) == 0)
	{
		SendClientMessage(playerid, COLOR_TEAM2, "Welcome to Flagstaff's =TANKWAR=");
		SendClientMessage(playerid, COLOR_TEAM2, "Type /cmds for game commands!");
		SendClientMessage(playerid, COLOR_TEAM2, "Good Luck!");
		}
	if(strcmp(cmdtext, "/cmds", true) == 0)
	{
		SendClientMessage(playerid, COLOR_RED, "** Commands:");
		SendClientMessage(playerid, COLOR_RED, "** /help for Game help");
		SendClientMessage(playerid, COLOR_RED, "** /buy for buy some weapons!");
		SendClientMessage(playerid, COLOR_RED, "** /kill to kill yourself!");
		}
	if(strcmp(cmdtext, "/kill", true) == 0)
	{
		SendClientMessage(playerid, COLOR_RED, "**You killed yourself**");
		SetPlayerHealth(playerid, 0);
		}
// ADMINCOMMANDS----------------------------------------------------------------------
	if(IsPlayerAdmin(playerid))
	{
	    if(strcmp(cmdtext, "/rules", true) == 0)
	    {
	    	GameTextForAll("No cheating and abusing please!", 5, 3);
	    	}
		}
	return 0;
}

public OnPlayerInfoChange(playerid)
{
	return 1;
}

public OnPlayerEnterVehicle(playerid, vehicleid, ispassenger)
{
	return 1;
}

public OnPlayerExitedMenu(playerid)
{
	return 1;
}

public SetPlayerTeamFromClass(playerid, classid)
{
	if (classid == 3 || 4 || 5)
	{
		gTeam[playerid] = TEAM_1;
	}
	else if (classid == 0 || 1 || 2)
	{
		gTeam[playerid] = TEAM_2;
	}
}


public SetPlayerToTeamColor(playerid)
{
	if (gTeam[playerid] == TEAM_1)
	{
		SetPlayerColor(playerid, COLOR_TEAM1);
	}
	else if (gTeam[playerid] == TEAM_2)
	{
		SetPlayerColor(playerid, COLOR_TEAM2);
	}
}

public OnPlayerExitVehicle(playerid, vehicleid)
{
	return 1;
}

public OnPlayerStateChange(playerid, newstate, oldstate)
{
	return 1;
}

public OnPlayerEnterCheckpoint(playerid)
{
	return 1;
}

public OnPlayerLeaveCheckpoint(playerid)
{
	return 1;
}

public OnPlayerEnterRaceCheckpoint(playerid)
{
	return 1;
}

public OnPlayerLeaveRaceCheckpoint(playerid)
{
	return 1;
}

public OnRconCommand(cmd[])
{
	return 1;
}

public OnObjectMoved(objectid)
{
	return 1;
}

public OnPlayerObjectMoved(playerid, objectid)
{
	return 1;
}

public OnPlayerPickUpPickup(playerid, pickupid)
{
	return 1;
}

public WeaponBuyHealth(playerid)
{
if(GetPlayerMoney(playerid)>=100){
GivePlayerMoney(playerid, -100);
SetPlayerHealth(playerid, 100);
}
else if(GetPlayerMoney(playerid)<100){
SendClientMessage(playerid, COLOR_RED, "You can't afford that!");
}
return 1;
}

public WeaponBuyArmour(playerid)
{
if(GetPlayerMoney(playerid)>=200){
GivePlayerMoney(playerid, -200);
SetPlayerArmour(playerid, 100);
}
else if(GetPlayerMoney(playerid)<200){
SendClientMessage(playerid, COLOR_RED, "You can't afford that!");
}
return 1;
}

public WeaponBuyMP(playerid)
{
if(GetPlayerMoney(playerid)>=800){
GivePlayerMoney(playerid, -800);
GivePlayerWeapon(playerid,29,600);
}
else if(GetPlayerMoney(playerid)<800){
SendClientMessage(playerid, COLOR_RED, "You can't afford that!");
}
return 1;
}

public WeaponBuyShotgun(playerid)
{
if(GetPlayerMoney(playerid)>=1000){
GivePlayerMoney(playerid, -1000);
GivePlayerWeapon(playerid,25,30);
}
else if(GetPlayerMoney(playerid)<1000){
SendClientMessage(playerid, COLOR_RED, "You can't afford that!");
}
return 1;
}

public WeaponBuyM4(playerid)
{
if(GetPlayerMoney(playerid)>=2000){
GivePlayerMoney(playerid, -2000);
GivePlayerWeapon(playerid,31,1000);
}
else if(GetPlayerMoney(playerid)<2000){
SendClientMessage(playerid, COLOR_RED, "You can't afford that!");
}
return 1;
}

public WeaponBuyAK47(playerid)
{
if(GetPlayerMoney(playerid)>=2000){
GivePlayerMoney(playerid, -2000);
GivePlayerWeapon(playerid,30,1000);
}
else if(GetPlayerMoney(playerid)<2000){
SendClientMessage(playerid, COLOR_RED, "You can't afford that!");
}
return 1;
}

public WeaponBuySniper(playerid)
{
if(GetPlayerMoney(playerid)>=5000){
GivePlayerMoney(playerid, -5000);
GivePlayerWeapon(playerid,34,30);
}
else if(GetPlayerMoney(playerid)<5000){
SendClientMessage(playerid, COLOR_RED, "You can't afford that!");
}
return 1;
}
//------------------------------------------------------------------------------
public OnPlayerSelectedMenuRow(playerid, row)
	{
    new Menu:Current = GetPlayerMenu(playerid);
  	if(Current == teleportmenu) {
	new Float:x;
	new Float:y;
	new Float:z;
	GetPlayerPos(playerid, x, y, z);
	TogglePlayerControllable(playerid, 1);
    switch(row)
	{
	case 0: WeaponBuyHealth(playerid);
	}
    switch(row)
	{
	case 1: WeaponBuyArmour(playerid);
	}
    switch(row)
	{
	case 2: WeaponBuyMP(playerid);
	}
    switch(row)
	{
    case 3: WeaponBuyShotgun(playerid);
	}
	switch(row)
	{
    case 4: WeaponBuyM4(playerid);
	}
	switch(row)
	{
    case 5: WeaponBuyAK47(playerid);
	}
	switch(row)
	{
	case 6: WeaponBuySniper(playerid);
	}
	}
	}
