/*-------------------------------------------------------------------------------------------------------------	*/
/*  iPLEOMAX's Outrun race system. Similar to NFS UG2 outrun race.												*/
/* Made from scratch. You will need zcmd & sscanf to use this.													*/
/*-------------------------------------------------------------------------------------------------------------	*/

#include <a_samp>
#include <zcmd>
#include <sscanf2>

#define COLOR_RED 0xAA3333AA
#define COLOR_LIGHTBLUE 0x33CCFFAA
#define COLOR_WHITE 0xFFFFFFAA
#define COLOR_BRIGHTRED 0xFF0000AA
#define COLOR_LIGHTGREEN 0x24FF0AB9

new ORTimer;
new Float:VVX[MAX_PLAYERS];
new Float:VVY[MAX_PLAYERS];
new Float:VVZ[MAX_PLAYERS];
new Float:SPD[MAX_PLAYERS];

public OnFilterScriptInit()
{
	ORTimer = SetTimer("ORCheck",300,true);
	return true;
}

public OnFilterScriptExit()
{
   	KillTimer(ORTimer);
	return true;
}

public OnPlayerConnect(playerid)
{
	SetPVarInt(playerid, "LR", -1);
	SetPVarInt(playerid, "LRRequest",-1);
	SetPVarInt(playerid, "bet",0);
	return true;
}

public OnPlayerDeath(playerid, killerid, reason)
{
	if(GetPVarInt(playerid, "LRRequest") != -1)
	{
	    SendClientMessage(playerid, COLOR_BRIGHTRED, "You lost the Outrun race..");
	    SetPVarInt(playerid, "ORLoser", 1);
	}
	return true;
}

public OnPlayerStateChange(playerid, newstate, oldstate)
{
	if(GetPVarInt(playerid, "LRRequest") != -1)
	{
	    SendClientMessage(playerid, COLOR_BRIGHTRED, "You lost the Outrun because you exited the vehicle.");
	    SetPVarInt(playerid, "ORLoser", 1);
	}
	return true;
}

public OnPlayerDisconnect(playerid, reason)
{
	if(GetPVarInt(playerid, "LRRequest") != -1)
	{
	    SetPVarInt(playerid, "ORLoser", 1);
	}
	return true;
}

forward ORCheck();
public ORCheck()
{
	for(new i=0; i<MAX_PLAYERS; i++)
	{
	    if(IsPlayerConnected(i) && !IsPlayerNPC(i) && GetPVarInt(i, "LR") != -1)
	    {
	        new r;
			r = GetPVarInt(i,"LR");
	        if(GetPVarInt(r, "ORLoser") == 1) ORLoser(r);
			if(GetPVarInt(i, "ORLoser") == 1) ORLoser(i);
	        if(IsPlayerInAnyVehicle(i))
	        {
				new Float:FX, Float:FY;
				GetXYInFrontOfPlayer(i, FX, FY, 13);
				new Float:X, Float:Y, Float:Z;
				GetPlayerPos(i,X,Y,Z);
				new Float:X2, Float:Y2, Float:Z2;
				GetPlayerPos(r,X2,Y2,Z2);
				new Float:VZA, Float:VZAB;
				GetVehicleZAngle(GetPlayerVehicleID(i),VZA);
				GetVehicleZAngle(GetPlayerVehicleID(r),VZAB);
				if(!IsPlayerInRangeOfPoint(r,120,X,Y,Z))
				{
					GameTextForPlayer(i,"~g~~n~~n~~n~~n~~n~~n~~n~You are far ahead...",2000,3);
					GameTextForPlayer(r,"~r~~n~~n~~n~~n~~n~~n~~n~Your Rival is far ahead!",2000,3);
				}
				if(!IsPlayerInRangeOfPoint(r,300,X,Y,Z))
				{
					ORLoser(r);
				}
				GetVehicleVelocity(GetPlayerVehicleID(i), VVX[i],VVY[i], VVZ[i]);
				GetVehicleVelocity(GetPlayerVehicleID(r), VVX[r],VVY[r], VVZ[r]);
				SPD[i] = floatsqroot(((VVX[i]*VVX[i])+(VVY[i]*VVY[i]))+(VVZ[i]*VVZ[i]))*100;
				SPD[r] = floatsqroot(((VVX[r]*VVX[r])+(VVY[r]*VVY[r]))+(VVZ[r]*VVZ[r]))*100;
				if(IsPlayerInRangeOfPoint(r,15,FX,FY,Z))
				{
					if(VZA >= VZAB-60 && VZA <= VZAB+60)
					{
						GameTextForPlayer(i,"~r~~n~~n~~n~~n~~n~~n~~n~Your Rival has the Lead!",1000,3);
						GameTextForPlayer(r,"~g~~n~~n~~n~~n~~n~~n~~n~You are leading now.",1000,3);
						SetPVarInt(r,"LR",i);
						SetPVarInt(i,"LR",-1);
					}
				}
				if(IsPlayerInRangeOfPoint(r,25,X,Y,Z))
				{
					if(SPD[i]+25 < SPD[r])
					{
						GameTextForPlayer(i,"~r~~n~~n~~n~~n~~n~~n~~n~Your Rival has the Lead!",1000,3);
						GameTextForPlayer(r,"~g~~n~~n~~n~~n~~n~~n~~n~You are leading now.",1000,3);
						SetPVarInt(r,"LR",i);
						SetPVarInt(i,"LR",-1);
					}
				}
	        }
	        return true;
	    }
	}
	return true;
}

forward ORLoser(playerid);
public ORLoser(playerid)
{
	new r;
	r = GetPVarInt(playerid, "LRRequest");
	GameTextForPlayer(playerid,"~r~~n~~n~~n~~n~~n~~n~You Lost the challenge...",5000,3);
	GameTextForPlayer(r,"~g~~n~~n~~n~~n~~n~~n~] You Won the challenge!",5000,3);
	SetPVarInt(r, "LRRequest",-1);
	SetPVarInt(playerid, "LRRequest",-1);
	SetPVarInt(playerid,"LR", -1);
	SetPVarInt(r,"LR", -1);
	SetPVarInt(playerid, "ORLoser", 0);
	SetPVarInt(r, "ORLoser", 0);
	new bet, msg1[10], msg2[10];
	bet = GetPVarInt(playerid,"bet");
	GivePlayerMoney(r, bet);
	GivePlayerMoney(playerid, -bet);
	format(msg2,10,"Bet Lost. %i$",-bet);
	format(msg1,10,"Bet Won. +%i$",bet);
	SendClientMessage(playerid,COLOR_BRIGHTRED,msg2);
	SendClientMessage(r,COLOR_LIGHTGREEN,msg1);
	new ORmessage[512];
	format(ORmessage,sizeof(ORmessage),"* %s won an Outrun race against %s with bet %i $",GetName(r),GetName(playerid),bet);
	SendClientMessageToAll(COLOR_LIGHTBLUE, ORmessage);
	return true;
}

public OnDialogResponse(playerid, dialogid, response, listitem, inputtext[])
{
    switch(dialogid)
    {
        case 1337:
        {
            if(!response)
            {
                new PID;
                PID = GetPVarInt(playerid, "LRRequest");
                TogglePlayerControllable(PID, true);
                SendClientMessage(PID,COLOR_BRIGHTRED,"Sorry, the player is not interested to race.");
                SetPVarInt(playerid, "LRRequest",-1);
                return true;
            }
            else
            {
                new PID;
                PID = GetPVarInt(playerid, "LRRequest");
                SetPVarInt(PID,"LR",playerid);
                TogglePlayerControllable(PID, true);
                new Float:X, Float:Y, Float:Z, Float:VZ;
                GetVehiclePos(GetPlayerVehicleID(PID),X,Y,Z);
                GetXYInFrontOfPlayer(PID, X,Y,-8);
                SetVehiclePos(GetPlayerVehicleID(playerid),X,Y,Z+0.2);
                GetVehicleZAngle(GetPlayerVehicleID(PID),VZ);
                SetVehicleZAngle(GetPlayerVehicleID(playerid),VZ);
                GameTextForPlayer(PID,"~g~Race Accepted.. Run!",3000,3);
                GameTextForPlayer(playerid,"~g~Now follow him!",3000,3);
			}
        }
	}
	return true;
}

CMD:outrunhelp(playerid, params[])
{
	SendClientMessage(playerid, COLOR_LIGHTBLUE, "[_ Outrun Race Help _]");
	SendClientMessage(playerid, COLOR_WHITE, "> Use /challenge [Player ID] [Bet Amount $] to begin an outrun race.");
	SendClientMessage(playerid, COLOR_WHITE, "> The race is simple, go as far as possible ahead from your rival to win the race.");
	SendClientMessage(playerid, COLOR_WHITE, "> Just overtake your rival to take the lead.");
	SendClientMessage(playerid, COLOR_WHITE, " iPLEOMAX.");
	return true;
}

CMD:challenge(playerid, params[])
{
	new rplayer, bet;
	if(!sscanf(params,"ui",rplayer,bet))
	{
	    if(IsPlayerConnected(rplayer) && !IsPlayerNPC(playerid))
	    {
	    if(IsPlayerInAnyVehicle(rplayer))
	    {
	    if(IsPlayerInAnyVehicle(playerid))
	    {
		if(bet <= 50000 && bet >= 5000)
		{
		if(GetPlayerMoney(playerid) >= bet)
		{
		if(GetPVarInt(rplayer,"LRRequest") == -1)
		{
		if(GetPVarInt(rplayer,"LR") == -1)
		{
		new Float:X,Float:Y,Float:Z;
		GetPlayerPos(playerid,X,Y,Z);
		if(IsPlayerInRangeOfPoint(rplayer,16,X,Y,Z))
		{
		new msg[24];
		format(msg,24,"Bet: %i $",bet);
		SendClientMessage(playerid,COLOR_LIGHTBLUE,msg);
		SetPVarInt(playerid,"bet",bet);
		SetPVarInt(rplayer,"bet",bet);
		SetPVarInt(rplayer, "LRRequest", playerid);
		SetPVarInt(playerid, "LRRequest", rplayer);
		new info[160], pname[MAX_PLAYER_NAME];
		GetPlayerName(playerid,pname,sizeof(pname));
		format(info,160,"%s is asking you to start a challenege race\n with a bet of $%i, do you want to do this?",pname,bet);
		ShowPlayerDialog(rplayer, 1337, DIALOG_STYLE_MSGBOX,"Challenge Race:",info,"Ofcouse","Nope");
		TogglePlayerControllable(playerid,false);
		} else SendClientMessage(playerid, COLOR_BRIGHTRED, "You should be near to that player.");
		} else SendClientMessage(playerid, COLOR_BRIGHTRED, "Player is currently racing.");
		} else SendClientMessage(playerid, COLOR_BRIGHTRED, "Player is already invited by someone.");
		} else SendClientMessage(playerid, COLOR_BRIGHTRED, "You don't have that much money..");
		} else SendClientMessage(playerid, COLOR_RED, "Min Amount: $5,000 Max Amount: $50,000");
		} else SendClientMessage(playerid, COLOR_BRIGHTRED, "You need a vehicle to challenge someone.");
		} else SendClientMessage(playerid, COLOR_BRIGHTRED, "The player you want to challenge doesn't have a vehicle.");
		} else SendClientMessage(playerid, COLOR_RED, "Player is not connected.");
	} else SendClientMessage(playerid, COLOR_RED, "Usage: /challenge [Player ID] [Bet Amount]");
	return true;
}

// Thanks a bunch to Y_Less for this function. =)
GetXYInFrontOfPlayer(playerid, &Float:x, &Float:y, Float:distance)
{                                                 // Created by Y_Less

    new Float:a;

    GetPlayerPos(playerid, x, y, a);
    GetPlayerFacingAngle(playerid, a);

    if (GetPlayerVehicleID(playerid)) {
        GetVehicleZAngle(GetPlayerVehicleID(playerid), a);
    }

    x += (distance * floatsin(-a, degrees));
    y += (distance * floatcos(-a, degrees));
}

stock GetName(playerid)
{
	new playername[MAX_PLAYER_NAME];
	GetPlayerName(playerid, playername,sizeof(playername));
	return playername;
}
