
local modShops = { }

function loadModShops( )
    local file_root = xmlLoadFile( "modshops.xml" )
    local shop_node = xmlFindSubNode( file_root, "shop", 0 )
    local i = 1
    while shop_node do
        local name = xmlNodeGetAttribute( shop_node, "name" )
        local pos_node = xmlFindSubNode( shop_node, "position", 0 )
        modShops[ i ] = { }
        modShops[ i ].posX = tonumber( xmlNodeGetAttribute( pos_node, "X" ) )
        modShops[ i ].posY = tonumber( xmlNodeGetAttribute( pos_node, "Y" ) )
        modShops[ i ].posZ = tonumber( xmlNodeGetAttribute( pos_node, "Z" ) )
        shop_node = xmlFindSubNode( file_root, "shop", i )
        i = i + 1
    end
    xmlUnloadFile( file_root )
end
addEventHandler( "onClientResourceStart", getResourceRootElement( getThisResource( ) ), loadModShops )

addEventHandler( "onClientElementStreamIn", getResourceRootElement( getThisResource() ),
    function( )
        if getElementType( source ) == 'marker' then
            for k,v in ipairs( modShops ) do
                local x, y, z = getElementPosition( source )
                if getDistanceBetweenPoints3D( x, y, z, modShops[ k ].posX, modShops[ k ].posY, modShops[ k ].posZ ) < 0.05 then
                    local blip = createBlipAttachedTo( source, 27 )
                    setElementParent( blip, source )
                end
            end
        end
    end
)


addEventHandler( "onClientElementStreamOut", getResourceRootElement( getThisResource() ),
    function( )
        if getElementType( source ) == 'marker' then
            for k,v in ipairs( modShops ) do
                local x, y, z = getElementPosition( source )
                if getDistanceBetweenPoints3D( x, y, z, modShops[ k ].posX, modShops[ k ].posY, modShops[ k ].posZ ) < 0.05 then
                    destroyElement( getElementChild( source, 0 ) )
                    return
                end
            end
        end
    end
)


