-- client script
-- MTA:SA Deathmatch 1.0 Developer preview 2 compatible

ObjClientDragandDrop = {}
ObjClientDragandDrop.__index = ObjClientDragandDrop

function ObjClientDragandDrop.create(player)
  local _objClientDragandDrop = {}
  setmetatable(_objClientDragandDrop, ObjClientDragandDrop)
  _objClientDragandDrop._resourceMapRoot = false
  _objClientDragandDrop._source = player
  _objClientDragandDrop._screenX = 0
  _objClientDragandDrop._screenY = 0
  _objClientDragandDrop._isModeEnabled = false
  _objClientDragandDrop._isRotationEnabled = false
  _objClientDragandDrop._corona = false
  _objClientDragandDrop._arrow = false
  _objClientDragandDrop._selectedElement = false
  _objClientDragandDrop._guiElementPosition = false
  _objClientDragandDrop._guiElementRotation = false
  _objClientDragandDrop._funcInput = nil
  _objClientDragandDrop._funcElementDataChange = nil
  return _objClientDragandDrop
end

function ObjClientDragandDrop:getRound(num, idp)
  return tonumber(string.format("%." .. (idp or 0) .. "f", num))
end

function ObjClientDragandDrop:getRotationByType(selectedElementType)
  if (selectedElementType == "vehicle") then
    return getVehicleRotation(self._selectedElement)
  else
    return getObjectRotation(self._selectedElement)
  end
end

function ObjClientDragandDrop:setRotationByType(selectedElementType, rotX, rotY, rotZ)
  if (selectedElementType == "vehicle") then
    setVehicleRotation(self._selectedElement, rotX, rotY, rotZ)
  else
    setObjectRotation(self._selectedElement, rotX, rotY, rotZ)
  end
end

function ObjClientDragandDrop:regDragandDrop(resourceMapRoot)
  self._resourceMapRoot = resourceMapRoot
  self._screenX, self._screenY = guiGetScreenSize()
  self._funcInput =
    function (key, keyState)
      local x, y, z = 0, 0, 0
      local rotX, rotY, rotZ = 0, 0, 0
      if (keyState == "down") then
        if (key == "F2") then
          if (self._guiElementPosition) then
            guiSetVisible(self._guiElementPosition, not guiGetVisible(self._guiElementPosition))
          end
          if (self._guiElementRotation) then
            guiSetVisible(self._guiElementRotation, not guiGetVisible(self._guiElementRotation))
          end
        end
        if (key == "F3") then
          self._isRotationEnabled = not self._isRotationEnabled
        end
        if (self._selectedElement) then
          rotX, rotY, rotZ = self:getRotationByType(getElementType(self._selectedElement))
          if (key == "mouse1") then
            detachElementFromElement(self._arrow, self._selectedElement)
            setElementParent(self._arrow, self._resourceMapRoot)
            setElementCollisionsEnabled(self._selectedElement, true)
            x, y, z = getElementPosition(self._selectedElement)
            self._selectedElement = false
            unbindKey("mouse1", "down", self._funcInput)
            guiSetText(self._guiElementPosition, "")
            guiSetText(self._guiElementRotation, "")
            triggerServerEvent("callbackServerDragandDrop", self._source, "funcDropElement", {["posX"] = x, ["posY"] = y, ["posZ"] = z, ["rotX"] = rotX, ["rotY"] = rotY, ["rotZ"] = rotZ})
          end
          if (self._isModeEnabled and self._isRotationEnabled) then
            if (key == "mouse_wheel_up") then
              if (getKeyState("lctrl")) then
                if ((rotX + 30) > 360) then
                  rotX = 0
                else
                  rotX = rotX + 30
                end
              elseif ((rotZ + 30) > 360) then
                rotZ = 0
              else
                rotZ = rotZ + 30
              end
            end
            if (key == "mouse_wheel_down") then
              if (getKeyState("lctrl")) then
                if ((rotX - 30) < 0) then
                  rotX = 359
                else
                  rotX = rotX - 30
                end
              elseif ((rotZ - 30) < 0) then
                rotZ = 359
              else
                rotZ = rotZ - 30
              end
            end
            if (key == "space") then
              rotX, rotY, rotZ = 0, 0, 0
            end
            if (key == "mouse_wheel_up" or key == "mouse_wheel_down" or key == "space") then
              self:setRotationByType(getElementType(self._selectedElement), rotX, rotY, rotZ)
            end
          end
        end
      end
    end
  self._funcElementDataChange =
    function (dataName)
      local zPosOffset = 0
      if (dataName == "draganddrop.selectingPlayer") then
        if (getElementData(source, dataName) == getPlayerName(self._source)) then
          zPosOffset = getElementDistanceFromCentreOfMassToBaseOfModel(source)
          setElementCollisionsEnabled(source, false)
          setElementParent(self._arrow, source)
          attachElementToElement(self._arrow, source, 0, 0, 0.5 + zPosOffset, 0, 0, 0)
          self._selectedElement = source
          bindKey("mouse1", "down", self._funcInput)
          playSoundFrontEnd(41)
        end
      end
    end
  self._guiElementPosition = guiCreateLabel(0, 0, 0, 0, "", false, nil)
  guiSetFont(self._guiElementPosition, "default-small")
  guiSetVisible(self._guiElementPosition, false)
  self._guiElementRotation = guiCreateLabel(0, 0, 0, 0, "", false, nil)
  guiSetFont(self._guiElementRotation, "default-small")
  guiSetVisible(self._guiElementRotation, false)
  bindKey("F2", "down", self._funcInput)
  bindKey("F3", "down", self._funcInput)
  bindKey("mouse_wheel_up", "down", self._funcInput)
  bindKey("mouse_wheel_down", "down", self._funcInput)
  bindKey("space", "down", self._funcInput)
  addEventHandler("onClientElementDataChange", self._resourceMapRoot, self._funcElementDataChange, true)
  outputChatBox("* Drag and Drop client script loaded")
end

function ObjClientDragandDrop:unregDragandDrop()
  unbindKey("F2", "down", self._funcInput)
  unbindKey("F3", "down", self._funcInput)
  unbindKey("mouse_wheel_up", "down", self._funcInput)
  unbindKey("mouse_wheel_down", "down", self._funcInput)
  unbindKey("space", "down", self._funcInput)
end

function ObjClientDragandDrop:dragElement(cursorX, cursorY)
  local worldX, worldY, worldZ = 0, 0, 0
  local rotX, rotY, rotZ = 0, 0, 0
  local depth = 0
  local distance = 0
  cursorX = self._screenX * (cursorX / 1)
  cursorY = self._screenY * (cursorY / 1)
  depth = (math.abs(cursorY - self._screenY) / self._screenY) * 100
  depth = 50.0 * ((depth / 100) * (depth / 100))
  worldX, worldY, worldZ = getWorldFromScreenPosition(cursorX, cursorY, depth)
  collision, pX, pY, pZ, element = processLineOfSight(worldX, worldY, worldZ + 5.0, worldX, worldY, -100, true, true, true, true, false, true, true, true, nil)
  if (self._selectedElement) then
    distance = getElementDistanceFromCentreOfMassToBaseOfModel(self._selectedElement)
    if (collision and getKeyState("lshift")) then
      worldZ = pZ + distance
    end
    if (getElementType(self._selectedElement) == "vehicle") then
      setVehicleFrozen(self._selectedElement, true)
    end
    if (self._guiElementPosition) then
      guiSetText(self._guiElementPosition, self:getRound(worldX, 6) .. " " .. self:getRound(worldY, 6) .. " " .. self:getRound(worldZ, 6))
      guiSetSize(self._guiElementPosition, guiLabelGetTextExtent(self._guiElementPosition), guiLabelGetFontHeight(self._guiElementPosition), false)
      guiSetPosition(self._guiElementPosition, cursorX, cursorY - (guiLabelGetFontHeight(self._guiElementPosition) / 2), false)
    end
    rotX, rotY, rotZ = self:getRotationByType(getElementType(self._selectedElement))
    if (self._guiElementRotation) then
      guiSetText(self._guiElementRotation, self:getRound(rotX, 6) .. " " .. self:getRound(rotY, 6) .. " " .. self:getRound(rotZ, 6))
      guiSetSize(self._guiElementRotation, guiLabelGetTextExtent(self._guiElementRotation), guiLabelGetFontHeight(self._guiElementRotation), false)
      guiSetPosition(self._guiElementRotation, cursorX, cursorY + (guiLabelGetFontHeight(self._guiElementRotation) / 2), false)
    end
    setElementPosition(self._selectedElement, worldX, worldY, worldZ)
  end
  setElementPosition(self._corona, worldX, worldY, pZ)
  if (getElementParent(self._arrow) ~= self._selectedElement) then
    setElementPosition(self._arrow, worldX, worldY, pZ + 1.5)
  end
end

function ObjClientDragandDrop:rotateElement()
  local rotX, rotY, rotZ = 0, 0, 0
  if (self._selectedElement and self._isModeEnabled and self._isRotationEnabled) then
    rotX, rotY, rotZ = self:getRotationByType(getElementType(self._selectedElement))
    if (getKeyState("mouse2")) then
      if (getKeyState("arrow_l")) then
        if ((rotX - 0.5) < 0) then
          rotX = 359
        else
          rotX = rotX - 0.5
        end
      elseif (getKeyState("arrow_r")) then
        if ((rotX + 0.5) > 360) then
          rotX = 0
        else
          rotX = rotX + 0.5
        end
      elseif (getKeyState("arrow_d")) then
        if ((rotZ - 0.5) < 0) then
          rotZ = 359
        else
          rotZ = rotZ - 0.5
        end
      elseif (getKeyState("arrow_u")) then
        if ((rotZ + 0.5) > 360) then
          rotZ = 0
        else
          rotZ = rotZ + 0.5
        end
      end
    end
    self:setRotationByType(getElementType(self._selectedElement), rotX, rotY, rotZ)
  end
end

function ObjClientDragandDrop:callbackRender()
  local cursorX, cursorY = 0, 0
  if (self._corona and self._arrow and isCursorShowing()) then
    cursorX, cursorY = getCursorPosition()
    self:dragElement(cursorX, cursorY)
  end
  self:rotateElement()
end

function ObjClientDragandDrop:callbackCursorMove(cursorX, cursorY)
  if (self._corona and self._arrow and not isCursorShowing()) then
    self:dragElement(cursorX, cursorY)
  end
end

function ObjClientDragandDrop:callbackFunc(request, ...)
  if (request == "funcSetDragandDropMode") then
    self._isModeEnabled = arg[1].isModeEnabled
    if (self._isModeEnabled) then
      self._corona = createMarker(0, 0, -100, "corona", 1.0, 255, 255, 0, 125)
      self._arrow = createMarker(0, 0, -100, "arrow", 1.0, 255, 0, 0, 255)
    else
      destroyElement(self._corona)
      self._corona = nil
      destroyElement(self._arrow)
      self._arrow = nil
    end
  end
end

-- Author: Ace_Gambit