-- server script
-- MTA:SA Deathmatch 1.0 Developer preview 2 compatible

local objDragandDrop = nil

local resource = getThisResource()
local resourceRoot = getResourceRootElement(resource)
local resourceMapRoot = getRootElement()

-- callbacks
function callbackResourceStart()
  outputDebugString("* " .. getResourceInfo(resource, "name") .. " " .. getResourceInfo(resource, "version") .. " by " .. getResourceInfo(resource, "author"))
  outputDebugString("* " .. getResourceInfo(resource, "description"))
  objDragandDrop = ObjDragandDrop.create(resource)
  objDragandDrop:regDragandDrop(resourceMapRoot)
end

function callbackResourceStop()
  if (resourceMapRoot) then
    objDragandDrop:unregDragandDrop()
  end
  outputDebugString("* Drag and Drop resource stopped")
end

function callbackPlayerQuit(reason)
  objDragandDrop:unregPlayerAsEditor(source)
end

function callbackClientChangeNick(oldNick, newNick)
  objDragandDrop:unregPlayerAsEditor(source)
  objDragandDrop:callbackFunc("funcSetDragandDropMode", source, false)
end

function callbackFunc(request, ...)
  objDragandDrop:callbackFunc(request, source, arg[1])
end

-- exports

function regPlayerAsEditor(player)
  objDragandDrop:regPlayerAsEditor(player)
end

function unregPlayerAsEditor(player)
  objDragandDrop:unregPlayerAsEditor(player)
end

addEventHandler("onResourceStart", resourceRoot, callbackResourceStart)
addEventHandler("onResourceStop", resourceRoot, callbackResourceStop)
addEventHandler("onPlayerQuit", resourceRoot, callbackPlayerQuit)
addEventHandler("onClientChangeNick", resourceRoot, callbackClientChangeNick)
-- custom events
addEvent("callbackServerDragandDrop", true)
addEventHandler("callbackServerDragandDrop", resourceMapRoot, callbackFunc)

-- Author: Ace_Gambit