-- server script
-- MTA:SA Deathmatch 1.0 Developer preview 2 compatible

ObjDragandDrop = {}
ObjDragandDrop.__index = ObjDragandDrop

function ObjDragandDrop.create(resource)
  local _objDragandDrop = {}
  setmetatable(_objDragandDrop, ObjDragandDrop)
  _objDragandDrop._resource = resource
  _objDragandDrop._resourceMapRoot = false
  _objDragandDrop._runStandAlone = false
  _objDragandDrop._isModeEnabled = {}
  _objDragandDrop._playerElements = {}
  _objDragandDrop._funcInput = nil
  _objDragandDrop._funcElementClicked = nil
  _objDragandDrop._funcPlayerJoin = nil
  _objDragandDrop._funcFreePlayerElement = nil
  return _objDragandDrop
end

function ObjDragandDrop:regDragandDrop(resourceMapRoot)
  self._resourceMapRoot = resourceMapRoot
  self._runStandAlone = get(getResourceName(self._resource) .. ".runstandalone")
  self._funcInput =
    function (source, key, keyState)
      local isModeEnabled = self._isModeEnabled[source] or false
      if (keyState == "down") then
        if (isCursorShowing(source) or isModeEnabled) then
          if (key == "F1") then
            self._isModeEnabled[source] = not isModeEnabled
            self:callbackFunc("funcSetDragandDropMode", source, self._isModeEnabled[source])
          end
        end
      end
    end
  self._funcElementClicked =
    function (mouseButton, buttonState, playerWhoClicked, clickPosX, clickPosY, clickPosZ)
      local data = ""
      local playerElement = self._playerElements[playerWhoClicked] or false
      local isModeEnabled = self._isModeEnabled[playerWhoClicked] or false
      local occupant = false
      if (isElement(source) and buttonState == "down" and isModeEnabled) then
        data = getElementData(source, "draganddrop.selectingPlayer") or ""
        if (getElementType(source) ~= "player" and data == "" and not playerElement) then
          self._playerElements[playerWhoClicked] = source
          if (getElementType(source) == "vehicle") then
            for seat = 1, getVehicleMaxPassengers(source) do
              occupant = getVehicleOccupant(source, seat)
              if (occupant) then
                removePlayerFromVehicle(source, occupant)
              end
            end
            setVehicleLocked(source, true)
            setVehicleDamageProof(source, true)
          end
          setElementData(source, "draganddrop.selectingPlayer", getClientName(playerWhoClicked))
        else
          playSoundFrontEnd(playerWhoClicked, 15)
        end
      end
    end
  self._funcPlayerJoin =
    function ()
      self:regPlayerAsEditor(source)
    end
  self._funcFreePlayerElement =
    function (source)
      self:callbackFunc("funcFreePlayerElement", source)
    end
  for _, player in ipairs(getElementsByType("player", self._resourceMapRoot)) do
    self:regPlayerAsEditor(player)
  end
  addEventHandler("onElementClicked", self._resourceMapRoot, self._funcElementClicked)
  if (self._runStandAlone) then
    addEventHandler("onPlayerJoin", self._resourceMapRoot, self._funcPlayerJoin)
  end
end

function ObjDragandDrop:unregDragandDrop()
  removeEventHandler("onElementClicked", self._resourceMapRoot, self._funcElementClicked)
end

function ObjDragandDrop:regPlayerAsEditor(player)
  bindKey(player, "F1", "down", self._funcInput)
end

function ObjDragandDrop:unregPlayerAsEditor(player)
  local playerElement = self._playerElements[player] or false
  unbindKey(player, "F1", "down", self._funcInput)
  self._isModeEnabled[player] = false
  if (playerElement) then
    setElementData(playerElement, "draganddrop.selectingPlayer", "")
  end
  self:callbackFunc("funcFreePlayerElement", player)
end

function ObjDragandDrop:callbackFunc(request, source, ...)
  local playerElement = self._playerElements[source] or false
  if (request == "funcSetDragandDropMode") then
    triggerClientEvent(source, "callbackClientDragandDrop", source, "funcSetDragandDropMode", {["isModeEnabled"] = arg[1]})
  end
  if (request == "funcDropElement") then
    if (playerElement) then
      setElementPosition(playerElement, arg[1].posX, arg[1].posY, arg[1].posZ)
      if (getElementType(playerElement) == "vehicle") then
        setVehicleRotation(playerElement, arg[1].rotX, arg[1].rotY, arg[1].rotZ)
        setVehicleFrozen(playerElement, false)
        setVehicleLocked(playerElement, false)
        setVehicleDamageProof(playerElement, false)
      else
        setObjectRotation(playerElement, arg[1].rotX, arg[1].rotY, arg[1].rotZ)
      end
      setElementData(playerElement, "draganddrop.selectingPlayer", "")
      setTimer(self._funcFreePlayerElement, 500, 1, source)
      playSoundFrontEnd(source, 33)
    end
  end
  if (request == "funcFreePlayerElement") then
    self._playerElements[source] = false
  end
end

-- Author: Ace_Gambit