-- client script
-- MTA:SA Deathmatch 1.0 Developer preview 2 compatible

local objClientDragandDrop = nil

local resource = getThisResource()
local root = getRootElement()
local player = getLocalPlayer()
local isFirstSpawn = true

-- callbacks
function callbackClientPlayerSpawn()
  if (source == player and isFirstSpawn) then
    isFirstSpawn = false
    objClientDragandDrop = ObjClientDragandDrop.create(player)
    objClientDragandDrop:regDragandDrop(root)
  end
end

function callbackRender()
  objClientDragandDrop:callbackRender()
end

function callbackResourceStop(stoppedResource)
  if (stoppedResource == resource) then
    objClientDragandDrop:unregDragandDrop()
  end
end

function callbackCursorMove(cursorX, cursorY, absoluteX, absoluteY, worldX, worldY, worldZ)
  objClientDragandDrop:callbackCursorMove(cursorX, cursorY)
end

function callbackFunc(request, ...)
  objClientDragandDrop:callbackFunc(request, arg[1])
end

addEventHandler("onClientPlayerSpawn", player, callbackClientPlayerSpawn)
addEventHandler("onClientRender", root, callbackRender)
addEventHandler("onClientResourceStop", root, callbackResourceStop)
addEventHandler("onClientCursorMove", root, callbackCursorMove, true)
-- custom events
addEvent("callbackClientDragandDrop", true)
addEventHandler("callbackClientDragandDrop", root, callbackFunc)

-- Author: Ace_Gambit