/*
	xStreamer by Boylett
 */

#if defined _xstreamer_included
	#endinput
#endif
#define _xstreamer_included
#pragma library xstreamer

#include <a_samp>

//------------------------------------------------------------------------------

#if !defined OBJECT_TIMER
#define OBJECT_TIMER 350
#endif

//------------------------------------------------------------------------------

native ConnectPlayer(playerid);
native DisconnectPlayer(playerid);
native StreamObjects(playerid,Float:x,Float:y,Float:z,virtualworld,interior);
native UpdateMovingObjects();

native xStreamer_Filterscript();

//------------------------------------------------------------------------------

forward sampCreatePlayerObject(playerid,modelid,Float:x,Float:y,Float:z,Float:rx,Float:ry,Float:rz);
forward sampDestroyPlayerObject(playerid,objectid);
forward sampMovePlayerObject(playerid, objectid, Float:X, Float:Y, Float:Z, Float:Speed);
forward sampStopPlayerObject(playerid,objectid);

forward xStreamer_Run();

//------------------------------------------------------------------------------

public sampCreatePlayerObject(playerid,modelid,Float:x,Float:y,Float:z,Float:rx,Float:ry,Float:rz)
{
	//printf("CreatePlayerObject(%d,%d,%f,%f,%f,%f,%f,%f)",playerid,modelid,x,y,z,rx,ry,rz);
	return CreatePlayerObject(playerid,modelid,x,y,z,rx,ry,rz);
}

public sampDestroyPlayerObject(playerid,objectid)
{
	//printf("DestroyPlayerObject(%d,%d)",playerid,objectid);
	return DestroyPlayerObject(playerid,objectid);
}

public sampMovePlayerObject(playerid, objectid, Float:X, Float:Y, Float:Z, Float:Speed)
{
	//printf("MovePlayerObject(%d,%d,%f,%f,%f,%f)",playerid, objectid, X, Y, Z, Speed);
	return MovePlayerObject(playerid, objectid, X, Y, Z, Speed);
}

public sampStopPlayerObject(playerid,objectid)
{
	printf("StopPlayerObject(%d,%d)",playerid,objectid);
	return StopPlayerObject(playerid,objectid);
}

public xStreamer_Run()
{
    UpdateMovingObjects();
	for(new i = 0; i < MAX_PLAYERS; i++)
	{
		if(IsPlayerConnected(i))
		{
			new
				Float:x,
				Float:y,
				Float:z;
			GetPlayerPos(i,x,y,z);
			StreamObjects(i,x,y,z,GetPlayerVirtualWorld(i),GetPlayerInterior(i));
		}
	}
	return 1;
}

public OnFilterScriptInit()
{
	SetTimer("xStreamer_Run",OBJECT_TIMER,1);
	xStreamer_Filterscript();
	return 1;
}

public OnPlayerConnect(playerid)
{
	ConnectPlayer(playerid);
	return 1;
}

public OnPlayerDisconnect(playerid,reason)
{
	DisconnectPlayer(playerid);
	return 1;
}
