#include <a_samp>


#define dcmd(%1,%2,%3) if ((strcmp((%3)[1], #%1, true, (%2)) == 0) && ((((%3)[(%2) + 1] == 0) && (dcmd_%1(playerid, "")))||(((%3)[(%2) + 1] == 32) && (dcmd_%1(playerid, (%3)[(%2) + 2]))))) return 1
new Float:ShipSpeed=0.0;
new ShipDriver = -1;
new ShipIcon;
new Ship;
new PlayerDocked[200];
new Float:PlayerDockData[200][3];

Float:GetXYInFrontOfPlayer(playerid, &Float:x, &Float:y, Float:distance)
{
	new Float:a;
	GetPlayerPos(playerid, x, y, a);
	if (IsPlayerInAnyVehicle(playerid)) GetVehicleZAngle(GetPlayerVehicleID(playerid), a);
	else GetPlayerFacingAngle(playerid, a);
	x += (distance * floatsin(-a, degrees));
	y += (distance * floatcos(-a, degrees));
	return a;
}

IsPlayerInCube(playerid, Float:xmin, Float:ymin, Float:zmin, Float:xmax, Float:ymax, Float:zmax)
{
	new Float:x, Float:y, Float:z;
	GetPlayerPos(playerid, x, y, z);
	if(x > xmin && y > ymin && z > zmin && x < xmax && y < ymax && z < zmax)return 1;
	return 0;
}

Float:GetXYZInFrontOfPos(&Float:x, &Float:y, &Float:Z, Float:rZ, Float:distance) // By Luby - Based on Mike's GetXYInFrontOfPlayer
{
	x += (distance * floatsin(rZ, degrees));
	y += (distance * floatcos(rZ, degrees));
	Z = Z;
	return rZ;
}

public OnFilterScriptInit()
{
	SetTimer("ShipIconUpdate", 500, true);
	Ship = CreateObject(8493, -1372.4438,-48.2332,90.5917, 0.0, 0.0, 138.3808);
}

public OnFilterScriptExit()
{
	DestroyObject(Ship);
}

forward ShipIconUpdate();
public ShipIconUpdate()
{
	new Float:X, Float:Y, Float:Z;
	GetObjectPos(Ship, X, Y, Z);
	for(new playerid=0;playerid<200;playerid++)
	{
		RemovePlayerMapIcon(playerid, ShipIcon);
		ShipIcon = SetPlayerMapIcon(playerid, 1,X,Y,Z, 5, 0xAAFFAAFF);
		if(PlayerDocked[playerid])
		{
			SetPlayerHealth(playerid, 100.0);
			SetPlayerPos(playerid, X+PlayerDockData[playerid][0], Y+PlayerDockData[playerid][1], Z+PlayerDockData[playerid][2]);
		}
	}
	return 1;
}

public OnPlayerUpdate(playerid)
{
	if(ShipDriver == playerid)
	{
		new Float:X, Float:Y, Float:Z, Float:rX, Float:rY, Float:rZ;
		GetObjectPos(Ship, X, Y, Z);
		SetPlayerHealth(ShipDriver, 100.0);
		GetObjectRot(Ship, rX, rY, rZ);
		SetPlayerPos(ShipDriver,X,Y,Z-10);
		SetPlayerFacingAngle(ShipDriver,rZ);
		GetXYInFrontOfPlayer(ShipDriver, X, Y, -75.0);
		GetObjectPos(Ship, X, Y, Z);
		SetPlayerCameraLookAt(ShipDriver, X, Y, Z);
		GetXYInFrontOfPlayer(ShipDriver, X, Y, -75.0);
		new keys, updown, leftright;
		GetPlayerKeys(playerid, keys, updown, leftright);
		if(keys & 8 || keys & 32)SetPlayerCameraPos(ShipDriver, X, Y, Z-5);else SetPlayerCameraPos(ShipDriver,X, Y, Z+20);
		if(leftright == KEY_LEFT)
		{
			GetObjectRot(Ship, rX, rY, rZ);
			SetObjectRot(Ship, rX, rY, rZ+2.0);
			GetObjectRot(Ship, rX, rY, rZ);
			GetObjectPos(Ship, X, Y, Z);
			SetPlayerFacingAngle(ShipDriver,rZ);
			GetXYInFrontOfPlayer(ShipDriver, X, Y, 5000.0);
			MoveObject(Ship, X, Y, Z, ShipSpeed);
		}
		if(leftright == KEY_RIGHT)
		{
			GetObjectRot(Ship, rX, rY, rZ);
			SetObjectRot(Ship, rX, rY, rZ-2.0);
			GetObjectRot(Ship, rX, rY, rZ);
			SetPlayerFacingAngle(ShipDriver,rZ);
			GetXYInFrontOfPlayer(ShipDriver, X, Y, 5000.0);
			MoveObject(Ship, X, Y, Z, ShipSpeed);
		}
		if(updown == KEY_UP)
		{
			GetXYInFrontOfPlayer(ShipDriver, X, Y, 5000.0);
			ShipSpeed+=0.5;
			MoveObject(Ship, X, Y, Z, ShipSpeed);
		}
		if(updown == KEY_DOWN)
		{
			GetXYInFrontOfPlayer(ShipDriver, X, Y, 5000.0);
			ShipSpeed-=0.5;
			MoveObject(Ship, X, Y, Z, ShipSpeed);
		}
		if(keys & 8)
		{
			GetObjectPos(Ship, X, Y, Z);
			SetObjectPos(Ship, X, Y, Z-1);
			GetObjectPos(Ship, X, Y, Z);
			GetXYInFrontOfPlayer(ShipDriver, X, Y, 5000.0);
			MoveObject(Ship, X, Y, Z, ShipSpeed);
		}
		if(keys & 32)
		{
			GetObjectPos(Ship, X, Y, Z);
			SetObjectPos(Ship, X, Y, Z+1);
			GetObjectPos(Ship, X, Y, Z);
			GetXYInFrontOfPlayer(ShipDriver, X, Y, 5000.0);
			MoveObject(Ship, X, Y, Z, ShipSpeed);
		}
	}
	return true;
}

public OnPlayerCommandText(playerid, cmdtext[])
{
	dcmd(dock,     4,cmdtext);
	dcmd(undock,   6,cmdtext);
	dcmd(ship,     4,cmdtext);
	dcmd(shipster, 8,cmdtext);
	return 0;
}

dcmd_shipster(playerid, params[])
{
	#pragma unused params
	new Float:X, Float:Y, Float:Z, Float:rX, Float:rY, Float:rZ;
	GetObjectRot(Ship, rX, rY, rZ);
	GetObjectPos(Ship, X, Y, Z);
	if(playerid == ShipDriver)
	{
		TogglePlayerControllable(playerid, false);
		SendClientMessage(playerid, 0xAAFFFAAFF, "  ");
		TogglePlayerControllable(playerid, true);
		ShipDriver = -1;
		SetCameraBehindPlayer(playerid);
		StopObject(Ship);
		ShipSpeed=0.0;
	}
	else
	{
		if(IsPlayerInCube(playerid, X-25.0, Y-25.0, Z-15.0, X+25.0, Y+25.0, Z+15.0))
		{
			if(ShipDriver==-1)
			{
				ShipDriver = playerid;
				TogglePlayerControllable(playerid, false);
				SendClientMessage(playerid, 0xAAFFFAAFF, "Hello there!");
				SendClientMessage(playerid, 0xAAFFFAAFF, "Use left and right arrows to turn the ship and up & down to change speed and jump & sprint to go up and down.");
				GetXYZInFrontOfPos(X, Y, Z, rZ+85, 5000.0);
				MoveObject(Ship, X, Y, Z, ShipSpeed);
			}
			else SendClientMessage(playerid, 0xAAFFFAAFF, "-   !");
		}
		else SendClientMessage(playerid, 0xAAFFFAAFF, "    !");
	}
	return true;
}

dcmd_ship(playerid, params[])
{
	#pragma unused params
	new Float:X, Float:Y, Float:Z, Float:rX, Float:rY, Float:rZ;
	GetObjectRot(Ship, rX, rY, rZ);
	GetObjectPos(Ship, X, Y, Z);
	GetXYZInFrontOfPos(X, Y, Z, rZ+90, 5.0);
	GameTextForPlayer(playerid,"~w~Hello on ~r~Pirate Ship!~w~.",4000,5);
	if(IsPlayerInAnyVehicle(playerid))
	{
		SetVehiclePos(GetPlayerVehicleID(playerid),X,Y,Z-10);
	}
	else
	{
		SetPlayerPos(playerid,X,Y,Z-10);
	}
	return true;
}

dcmd_dock(playerid, params[])
{
	#pragma unused params
	new Float:oX, Float:oY, Float:oZ;
	new Float:pX, Float:pY, Float:pZ;
	new Float:dX, Float:dY, Float:dZ;
	GetObjectPos(Ship, oX, oY, oZ);
	if(IsPlayerInCube(playerid, oX-25.0, oY-25.0, oZ-15.0, oX+25.0, oY+25.0, oZ+15.0))
	{
		GetPlayerPos(playerid, pX, pY, pZ);
		dX=floatsub(pX, oX);
		dY=floatsub(pY, oY);
		dZ=floatsub(pZ, oZ);
		PlayerDocked[playerid]=true;
		PlayerDockData[playerid][0]=dX;
		PlayerDockData[playerid][1]=dY;
		PlayerDockData[playerid][2]=dZ;
	}
	return true;
}

dcmd_undock(playerid, params[])
{
	#pragma unused params
	PlayerDocked[playerid]=false;
	return true;
}
