/**
* YMessage Announcer System
*
* By Alex "Y_Less" Cole
* v 0.4 - (c) 2006
*
* To use:
*
* Paste this script into PAWNO (found in "/samp/pawno" if you have
* a server) and save.  Then close and re-open pawno and this file (there is
* a bug with new files apparently, I don't know but better to be safe than
* sorry).  Then press F5 and copy the .amx from the directory you saved the
* .pwn in to your "samp/filterscripts" directory.  Then make sure you have a
* folder called "scriptfiles" at the same level as "gamemodes" and
* "filterscripts".  You will need a file called "Y_Messages.txt", the format
* of which is as follows:

<number of messages> <minimum message delay (in milliseconds)>
<color in HEX>
{
<first message>
}
{
<second
message>
}
{
<etc>
}

*
* Example:
*

2 60000
FF00FFFF
{
Woo, this is a message
}
{
And this is
a multi-line message
}

*
* Just do that and you should be away
*/

#include <a_samp>

#if !defined INVAILD_PLAYER_ID
	#define INVALID_PLAYER_ID 255 // Fix for other peoples bad code apparently
#endif

#define DELAY_TIME 30 // Now in seconds
#define FILE_NAME "Y_Messages.txt"
#define COLOR 0x00FF00FF

#define MAX_LINES 10

#define COLOR_MSG 0x0000FFFF
#define COLOR_ANNOUNCE 0x00FF00FF
#define COLOR_WARN 0xFF0000FF

#define HELP(%1) SendClientMessage(playerid, COLOR_MSG, %1);
#define MSG(%1) SendClientMessage(playerid, COLOR_ANNOUNCE, %1);
#define WARN(%1) SendClientMessage(playerid, COLOR_WARN, %1);

new gDelay = DELAY_TIME;

//new gLastUpdate = -1;

new gLastCall = 0;
new gColor = COLOR;

new record = INVALID_PLAYER_ID;

new recording[MAX_LINES][128];

public OnFilterScriptInit()
{
	// Do my usual fancy stuff here
	print("\r\n====================================");
	print("|                                  |");
	print("|     YMessage Announcer System    |");
	print("|     -------------------------    |");
	print("|                                  |");
	print("| By Alex \"Y_Less\" Cole - (c) 2006 |");
	print("|               v0.3               |");
	print("====================================\r\n");

	ShowRandomMessage(false);

	gLastCall = mktime();

	printf("%d, %d", gLastCall, gDelay);

	return 0;
}

public OnPlayerConnect(playerid)
{
	CheckRand();
	return 0;
}

CheckRand()
{
	//printf("%d, %d", h, h - gLastCall);

	new h = mktime();

	if ((h - gLastCall) > gDelay)
	{
		ShowRandomMessage();
		gLastCall = h;
	}
}

hexstr(string[])
{
	new ret = 0;
	for (new i = 0, j = 28; i < 8; i++, j -= 4)
	{
	    new k = string[i];
		if (k >= '0' && k <= '9')
		{
		    ret += (k - 0x30) << j;
		}
		else if (k >= 'A' && k <= 'F')
		{
		    ret += (k - 0x37) << j;
		}
		else if (k >= 'a' && k <= 'f')
		{
		    ret += (k - 0x57) << j;
		}
		else
		{
		    return 0;
		}
	}
	return ret;
}

ReadMessage(message, File:fileh, playerid)
{
	new count = 0, ok = 0;
	new string[256];
	//printf("hi %d", message);
	while (fread(fileh, string))
	{
	    //printf("%s %d", string, count);
	    if (string[0] == '}')
		{
		    //print("hi");
			if (ok)
			{
				break;
			}
			else
			{
				count++;
			}
		}
	    else if (string[0] == '{' && count == message)
		{
		    //print("end");
			ok = 1;
		}
	    else if (ok)
		{
			if (playerid == INVALID_PLAYER_ID)
			{
				SendClientMessageToAll(gColor, string);
			}
			else
			{
				SendClientMessage(playerid, gColor, string);
			}
		}
	}
}

ShowRandomMessage(a = true, b = -1)
{
	new text[512];
	new num, index;
	new File:yfile;
	//print("go");

	if (fexist(FILE_NAME))
	{
	    if ((yfile = fopen(FILE_NAME, io_read)))
	    {
		    fread(yfile, text);
		    num = strval(strtok(text, index));
		    if (a)
		    {
			    fread(yfile, text);
			    num = (b == -1) ? random(num) : b;
			    ReadMessage(num, yfile, INVALID_PLAYER_ID);
			}
			else
			{
				gDelay = strval(strtok(text, index));
				//printf("%d", gDelay);
			    fread(yfile, text);
			    if (strlen(text) == 10)
				{
					if (!(gColor = hexstr(text))) gColor = COLOR;
				}
			}

			fclose(yfile);
		}
		else
		{
		    print("yAd Error: Could not open file");
		}
	}
	else
	{
	    print("yAd Error: Messages file not found");
	}
}

strtok(const string[], &index)
{
	new length = strlen(string);
	while ((index < length) && (string[index] <= ' '))
	{
		index++;
	}

	new offset = index;
	new result[32];
	while ((index < length) && (string[index] > ' ') && ((index - offset) < (sizeof (result) - 1)))
	{
		result[index - offset] = string[index];
		index++;
	}
	result[index - offset] = EOS;
	return result;
}

public OnPlayerRequestClass(playerid, classid)
{
	CheckRand();
	return 0;
}

public OnPlayerDisconnect(playerid)
{
	if (record == playerid)
	{
	    record = INVALID_PLAYER_ID;
	    for (new i = 0; i < MAX_LINES; i++)
	    {
	    	recording[i][0] = 0;
	    }
	}
	CheckRand();
	return 0;
}

public OnPlayerSpawn(playerid)
{
	CheckRand();
	return 0;
}

public OnPlayerDeath(playerid, killerid, reason)
{
	CheckRand();
	return 0;
}

public OnVehicleSpawn(vehicleid)
{
	CheckRand();
	return 0;
}

public OnVehicleDeath(vehicleid, killerid)
{
	CheckRand();
	return 0;
}

public OnPlayerText(playerid, text[])
{
	new retval = 1;
	CheckRand();
	if (playerid == record)
	{
	    new i;
	    for (i = 0; i < MAX_LINES; i++)
	    {
	        if (recording[i][0] == 0)
	        {
				strmid(recording[i], text, 0, strlen (text));
			    MSG("Line recorded")
			    //MSG(recording[i])
				break;
	        }
	    }
	    if (i == MAX_LINES)
	    {
	        WARN("Max lines reached")
	    }
	    retval = 0;
	}
	return retval;
}

public OnPlayerCommandText(playerid, cmdtext[])
{
	if (IsPlayerAdmin(playerid))
	{
		if (strcmp(cmdtext, "/ymsg", false, 5) == 0)
		{
			if (!cmdtext[5] || !checkpar(playerid, cmdtext[6]))
			{
				MSG("ymsg triggered")
				ShowRandomMessage();
			}
			return 1;
		}
	}
	CheckRand();
	return 0;
}

#define TEMP_FILE "ymsg.temp.remove"

savefile(playerid)
{
	new File:rfile;
	new File:test;
	if ((rfile = fopen(FILE_NAME, io_read)))
	{
	    test = fopen(TEMP_FILE, io_write);
	    new text[256], i = 0;
	    while (fread(rfile, text))
	    {
	        switch (i)
	        {
	            case 0:
	            {
		            new index = 0;
		            new num;
					num = strval(strtok(text, index));
		            if (record == playerid) num++;
	                format(text, sizeof (text), "%d %d\r\n", num, gDelay);
	            }
	            case 1:
	            {
					format(text, sizeof (text), "%s\r\n", makehexstr(gColor));
	            }
	        }
			fwrite(test, text);
	        i++;
	    }
	    fclose(rfile);
        fwrite(test, "\r\n");

	    if (record == playerid)
	    {
	        fwrite(test, "{\r\n");
	        for (i = 0; i < MAX_LINES; i++)
	        {
				if (recording[i][0])
				{
				    fwrite(test, recording[i]);
				    fwrite(test, "\r\n");
				}
	        }
	        fwrite(test, "}\r\n");

		    record = INVALID_PLAYER_ID;
		    for (i = 0; i < MAX_LINES; i++)
		    {
		    	recording[i][0] = 0;
		    }
		}
	    fclose(test);
	    fremove(FILE_NAME);

	    rfile = fopen(FILE_NAME, io_write);
	    test = fopen(TEMP_FILE, io_read);
	    while (fread(test, text))
	    {
            fwrite(rfile, text);
	    }
	    fclose(rfile);
	    fclose(test);
	    fremove(TEMP_FILE);
	}
	else
	{
	    WARN("Could not open file")
	    return 0;
	}
	return 1;
}

makehexstr(num)
{
	new work;
	new string[10];
	for (new i = 0; i < 8; i++)
	{
	    work = (num & (0b1111 << (i * 4))) >>> (i * 4);
	    string[7 - i] = (work > 9) ? work + 0x37 : work + 0x30; //((work >= 0) ? work + 0x30 : work + 0x47);
	}
	return string;
}

checkpar(playerid, text[])
{
	printf("%s", text);
	if (IsInteger(text))
	{
		ShowRandomMessage(false, strval(text));
		return 1;
	}
	else
	{
		new tmp[32];
		new index = 0;
		tmp = strtok(text, index);
		if (strcmp(tmp, "delay", true) == 0)
		{
		    if (IsInteger(text[index + 1]))
		    {
		        gDelay = strval(strtok(text, index));
		        MSG("Delay time updated, type \"/ymsg save\" to save")
		        printf("%d", gDelay);
		    }
		    else
		    {
		        WARN("Invalid delay value")
		    }
			return 1;
		}
		else if (strcmp(tmp, "record", true) == 0)
		{
		    if (record == INVALID_PLAYER_ID)
		    {
		        record = playerid;
		        new text2[128];
		        format(text2, sizeof (text2), "Recording started, type normally to record - %d lines max", MAX_LINES);
		        MSG(text2)
		        MSG("Type \"/ymsg save\" to save when done or \"/ymsg view\" to view")
				//printf("%d", record);
		    }
		    else
		    {
		        WARN("Recording already in progress, type \"/ymsg save\"")
		        WARN("to save or \"ymsg cancel\" to cancel if by you")
		    }
			return 1;
		}
		else if (strcmp(tmp, "reload", true) == 0)
		{
		    ShowRandomMessage(false);
		    MSG("Message settings reloaded")
		}
		else if (strcmp(tmp, "cancel", true) == 0)
		{
		    if (record == playerid)
		    {
			    record = INVALID_PLAYER_ID;
			    for (new i = 0; i < MAX_LINES; i++)
			    {
			    	recording[i][0] = 0;
			    }
			    MSG("Recording cancelled")
		    }
		    else
		    {
		        WARN("Access denied")
		    }
			return 1;
		}
		else if (strcmp(tmp, "save", true) == 0)
		{
			if (savefile(playerid))
			{
			    MSG("Settings saved")
			}
			else
			{
			    MSG("Save error")
			}
			return 1;
		}
		else if (strcmp(tmp, "color", true) == 0)
		{
		    tmp = strtok(text, index);
		    if (strlen(tmp) == 8 && IsHex(tmp))
		    {
		        gColor = hexstr(tmp);
		        MSG("Color updated")
		    }
		    else
		    {
		        WARN("Invalid color code")
		    }
			return 1;
		}
		else if (strcmp(tmp, "view", true) == 0)
		{
			if (record == playerid)
			{
				MSG("Your recorded text:")
				for (new i = 0; i < MAX_LINES; i++)
				{
					if (recording[i][0])
					{
						SendClientMessage(playerid, gColor, recording[i]);
					}
				}
			}
			else
			{
				WARN("Access denied")
			}
		}
	}
	return 0;
}

public OnPlayerInfoChange(playerid)
{
	CheckRand();
	return 0;
}

public OnPlayerEnterVehicle(playerid, vehicleid, ispassenger)
{
	CheckRand();
	return 0;
}

public OnPlayerExitVehicle(playerid, vehicleid)
{
	CheckRand();
	return 0;
}

public OnPlayerStateChange(playerid, newstate, oldstate)
{
	CheckRand();
	return 0;
}

public OnPlayerEnterCheckpoint(playerid)
{
	CheckRand();
	return 0;
}

public OnPlayerLeaveCheckpoint(playerid)
{
	CheckRand();
	return 0;
}

IsInteger(string[])
{
	for (new i = 0, j = strlen(string); i < j; i++)
	{
	    if (string[i] > '9' || string[i] < '0') return 0;
	}
	return 1;
}

IsHex(string[])
{
	for (new i = 0, j = strlen(string); i < j; i++)
	{
	    if ((string[i] > '9' || string[i] < '0') && (string[i] > 'F' || string[i] < 'A') && (string[i] > 'f' || string[i] < 'a')) return 0;
	}
	return 1;
}

mktime()
{
	static days_of_month[12] = {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

	new hour, minute, second;
	gettime(hour, minute, second);
	new timestamp;

	timestamp = second + minute * 60 + hour * 3600;

	getdate(hour, minute, second);

	if (((hour % 4 == 0) && (hour % 100 != 0)) || (hour % 400 == 0))
	{
		days_of_month[1] = 29;
	}
	else
	{
		days_of_month[1] = 28;
	}

 	if (minute > 1) { // No January Calculation, because its always the 0 past months
		for (new i = 0; i < minute - 1; i++)
		{
			second += days_of_month[i];
		}
	}

	timestamp += second * 86400;
	// printf("Days this hour: %d",days_this_year);

	for (new j = 1970; j < hour; j++)
	{
		timestamp += 31536000;
		if (((hour % 4 == 0) && (hour % 100 != 0)) || (hour % 400 == 0)) timestamp += 86400; // Schaltjahr + 1 Tag
	}

	return timestamp;
}
