--necropolis-main.lua

--	NECROPOLIS
--	City of the Dead
--	veaudaux@gmail.com

--This script controls the spawning of enemy zombie peds.

--Thanks to Alexander Blade for ALICE, the WaitForPlayerPoolCreation and WaitForValidPlayer functions, and his advice.
--Also, big thanks to zBobG at GTAForums.com for talking Lua and Alice with me, and
--ZAZ for his helpful input.

PLAYER_ID, PLAYER_CHAR = 0
local playIndex = {}
local playrGrp = {}
GROUP_ID = 0

local allZombies = {}

local ZcharDec = {}
local ZcombatDec = {}

local x = {}  local y = {}  local z = {}

LOAD_CHAR_DECISION_MAKER(3, ZcharDec)
LOAD_COMBAT_DECISION_MAKER(3, ZcombatDec)
SET_DECISION_MAKER_ATTRIBUTE_CAUTION(ZcharDec.a, 2)
SET_DECISION_MAKER_ATTRIBUTE_CAUTION(ZcombatDec.a, 2)

FoundLowest = 0
Lowest = 1
TotalCount = 0
DoesFall = 0
LivingTotal = 0

function WaitForPlayerPoolCreation()
	while (IsPlayerPoolCreated() == 0) do
		Wait(2000)
	end
end

function WaitForValidPlayer()
	PLAYER_CHAR = 0
		repeat
			PLAYER_ID = _GET_PLAYER_ID()
				if (PLAYER_ID >= 0) then
					while true do
						if _IS_PLAYER_PLAYING(PLAYER_ID) == 0
						then Wait(1000)
						else break
						end
				end
			local p = {}
			_GET_PLAYER_CHAR(PLAYER_ID, p)
			PLAYER_CHAR = p.a
				if (PLAYER_CHAR <= 0) then
					Wait(1000)
				end
		end
		until (PLAYER_CHAR > 0)
end

function SetPlayIndex() -- Puts the Player Index into a var called "playIndex"
	PLAYER_ID = _GET_PLAYER_ID()
	playIndex = _CONVERT_INT_TO_PLAYERINDEX(PLAYER_ID)
end

function SetPlayGroup() -- Puts the Player's group ID into a var called "GROUP_ID"
	GET_PLAYER_GROUP(playIndex, playrGrp)
	GROUP_ID = playrGrp.a
end

function Zombify(newZombie, FallDown) -- Make a ped into a Zombie
	REQUEST_ANIMS("move_injured_lower")

	intnewZombie = newZombie.a
	if (DOES_CHAR_EXIST(intnewZombie) == 1) then -- Just check one more time to make sure we've either found or spawned somebody. If we start passing the following commands to a non-existant pointer, we're gonna crash the game. That's bad.
		if (IS_CHAR_DEAD(intnewZombie) == 0) then -- If they're not dead
			SET_CHAR_DECISION_MAKER(intnewZombie, ZcharDec.a)
			SET_COMBAT_DECISION_MAKER(intnewZombie, ZcombatDec.a)
			while true do
				if (HAVE_ANIMS_LOADED("move_injured_lower") == 1) then
					break
				else
					Wait(100)
				end
			end
			SET_ANIM_GROUP_FOR_CHAR(intnewZombie, "move_injured_lower")
			SET_AMBIENT_VOICE_NAME(intnewZombie, "M_ZOMBIE") -- RAAAAAAR!!
			ALLOW_TARGET_WHEN_INJURED(intnewZombie, 1)
			SET_CHAR_AS_ENEMY(intnewZombie, 1)
			TASK_SET_IGNORE_WEAPON_RANGE_FLAG(intnewZombie, 1)
			SET_SENSE_RANGE(intnewZombie, f(100.0))
			SET_PED_WONT_ATTACK_PLAYER_WITHOUT_WANTED_LEVEL(intnewZombie, 0)
			SET_CHAR_ALLOWED_TO_DUCK(intnewZombie, 0)
			SET_PED_DONT_DO_EVASIVE_DIVES(intnewZombie, 1)
			SET_CHAR_WILL_USE_COVER(intnewZombie, 0)
			SET_CHAR_WILL_USE_CARS_IN_COMBAT(intnewZombie, 0)
			SET_CHAR_IS_TARGET_PRIORITY(intnewZombie, 1)
			SET_BLOCKING_OF_NON_TEMPORARY_EVENTS(intnewZombie, 0)
			if (FallDown == 1) then
				TASK_FALL_AND_GET_UP(intnewZombie)
			end
			SET_CHAR_RELATIONSHIP_GROUP(intnewZombie, 23) -- add them to group 23
			TASK_COMBAT_HATED_TARGETS_AROUND_CHAR(intnewZombie, f(30.0)) -- KILL! KILL! KILL!
			TotalCount = TotalCount + 1 -- add 1 to the count of total zombies
			allZombies[TotalCount] = newZombie -- add them to the table
--local blip = {} -- sometimes during testing I like adding radar blips, just to see where the zombies are and make sure they're spawning properly. uncomment these two lines to enable that.
--ADD_BLIP_FOR_CHAR(intnewZombie, blip)
			SET_CHAR_DIES_INSTANTLY_IN_WATER(intnewZombie, 1) -- the only thing worse than a running zombie is a swimming one.
		end
	end
	Wait(500)
end

function GetAPed(ex, why, zee) -- gets a nearby ped, and if it can't find one, make one
	local FoundAPed = {}
	local NoPedFound = {}

	BEGIN_CHAR_SEARCH_CRITERIA()
	END_CHAR_SEARCH_CRITERIA()
	ALLOW_SCENARIO_PEDS_TO_BE_RETURNED_BY_NEXT_COMMAND(0)
	GET_RANDOM_CHAR_IN_AREA_OFFSET_NO_SAVE(f(ex),f(why),f(zee),f(20.0),f(20.0),f(100.0),FoundAPed) -- before we resort to spawning though, we want to see if there's an existing ped in the area we can convert to an enemy

	intFoundAPed = FoundAPed.a

	if (DOES_CHAR_EXIST(intFoundAPed) == 1) then
		SET_CHAR_AS_MISSION_CHAR(intFoundAPed, 1)
		FoundAPed.fall = 1 --This is a flag I added that determines whether or not the ped plays the "fall down and get back up" animation during zombification. It's on for pre-existing peds and off for ones we have to make from scratch.
		return FoundAPed
	else
		if (IS_CHAR_IN_WATER(PLAYER_CHAR) == 0) then -- since the zombies don't swim, it's no point spawning them when the player is swimming
			local car = {}
			if (IS_CHAR_IN_ANY_CAR(PLAYER_CHAR) == 1) then	-- the random numbers generated here are used
				spawnX = math.random(-10, 10)				-- to determine placement for the zombies. if the
				spawnY = math.random(100, 150)				-- player is in a car, we want them way out in front.
			else											-- but on foot, we want them to show up closer.
				if (math.random(5) == 1) then
					spawnX = math.random(-15, 15)
					spawnY = math.random(50, 100)
				else
					spawnX = math.random(-15, 15)
					spawnY = math.random(-15, -2)
				end
			end

			local InteriorKey = {}
			GET_OFFSET_FROM_CHAR_IN_WORLD_COORDS(PLAYER_CHAR, f(spawnX), f(spawnY), 0, x, y, z)
			GET_GROUND_Z_FOR_3D_COORD(x.b, y.b, z.b, z)
			if (CAN_CREATE_RANDOM_CHAR(0,0) == 1) then
				CREATE_RANDOM_CHAR(x.b, y.b, z.b, FoundAPed)
			else
				if LivingTotal < 10 then -- if there's less than 10 zombies right now, and we were unable to make a random char (I'm not actually sure why sometimes it can't create a char - I think it may have to do with having no peds in memory at the time) then we'll spawn a person the hard way.
					WhichModel = math.random(3) -- randomly select one of the 3 specified models.
					if WhichModel == 1 then
						local hash = GET_HASH_KEY("m_m_alcoholic")
						REQUEST_MODEL(hash)
						while HAS_MODEL_LOADED(hash) == 0 do Wait(100) end
					elseif WhichModel == 2 then
						local hash = GET_HASH_KEY("m_m_genbum_01")
						REQUEST_MODEL(hash)
						while HAS_MODEL_LOADED(hash) == 0 do Wait(100) end
					else
						local hash = GET_HASH_KEY("f_y_hooker_03")
						REQUEST_MODEL(hash)
						while HAS_MODEL_LOADED(hash) == 0 do Wait(100) end
					end
					CREATE_CHAR(23, hash, x.b, y.b, z.b, FoundAPed, 1)
				end
			end

			intFoundAPed = FoundAPed.a

			if (DOES_CHAR_EXIST(intFoundAPed) == 0) then
					return NoPedFound
			else
				SET_BLOCKING_OF_NON_TEMPORARY_EVENTS(intFoundAPed, 1)
				GET_CHAR_COORDINATES(intFoundAPed, x, y, z)
				GET_INTERIOR_AT_COORDS(x.b, y.b, z.b, InteriorKey)
				if (InteriorKey.a ~= 0) then
					SET_ROOM_FOR_CHAR_BY_KEY(intFoundAPed, InteriorKey) -- if we don't set the interior key, and the player is inside an interior, you end up with invisible zombies. funny, but probably not fun for our poor end users.
				end
				return FoundAPed
			end
		end
		return NoPedFound
	end
end

function main()
	WaitForPlayerPoolCreation()
	WaitForValidPlayer()
	SetPlayIndex()

	if PLAYER_CHAR <= 0 then return end

	local gametime = {}

	SET_RELATIONSHIP(5, 1, 23) -- make CIVMALE enemies with group 23
	SET_RELATIONSHIP(5, 23, 1) -- make group 23 enemies with CIVMALE
	SET_RELATIONSHIP(5, 2, 23) -- CIVFEMALE enemies with group 23
	SET_RELATIONSHIP(5, 23, 2) -- group 23 enemies with CIVFEMALE
	SET_RELATIONSHIP(5, 0, 23) -- then make group 23 enemies (5) with the player (0)
	SET_RELATIONSHIP(5, 23, 0) -- make the player (0) enemies (5) with group 23
	SET_RELATIONSHIP(2, 23, 23)

	math.randomseed( os.time() )


	while true do
		ZombieSpawn = 0
		local c = {}

		if LivingTotal < 30 then -- Right now, it's capped at 30 zombies at a time. This number may need tweaking.
				GET_CHAR_COORDINATES(PLAYER_CHAR, x, y, z) -- where you at?
				c = GetAPed(x.b, y.b, z.b)
				Zombify(c, c.fall)
		end

		FoundLowest = 0
		Count = Lowest
		LivingTotal = 0

		while (Count < TotalCount) do -- I'm looping through the zombie table checking for ones that are dead or too far away
			Slot = Count
			local DeadCheck = {}
			DeadCheck = allZombies[Slot]
			intDeadCheck = DeadCheck.a
			if (DOES_CHAR_EXIST(intDeadCheck) == 1) then
				if FoundLowest == 0 then -- this stores the first slot we find an existing ped in - that way we don't waste time in future loops checking slots we already know are empty
					FoundLowest = 1
					Lowest = Count
				end
				if (IS_CHAR_INJURED(intDeadCheck) == 1) or (IS_CHAR_DEAD(intDeadCheck) == 1) then -- If this zombie is dead or injured
					MARK_CHAR_AS_NO_LONGER_NEEDED(DeadCheck) -- get rid of them
				else
					LivingTotal = LivingTotal + 1
					local PlayInteriorKey = {}										-- This is a trouble area. This is a dance
					GET_INTERIOR_FROM_CHAR(PLAYER_CHAR, PlayInteriorKey)			-- I'm doing to account for zombies that get spawned
					if (PlayInteriorKey.a ~= 0) then								-- outside while the player is inside. Their interior
						SET_ROOM_FOR_CHAR_BY_KEY(intDeadCheck, PlayInteriorKey)		-- key is wrong, which makes for ped statues. So I do
						SET_LOAD_COLLISION_FOR_CHAR_FLAG(intDeadCheck, 1)			-- all this during the loop so they eventally unfreeze.
					else															-- But I'd rather they not freeze in the first place.
						CLEAR_ROOM_FOR_CHAR(intDeadCheck)							-- Unfortunately, the native to get the interior key for
					end																-- particular coords doesn't always work as expected.

					if IS_CHAR_ON_SCREEN(intDeadCheck) == 0 then -- if they're not on the screen, there's a chance they're off in the distance somewhere
						local playx = {}  local playy = {}  local playz = {}
						local pedx = {}  local pedy = {}  local pedz = {}
						GET_CHAR_COORDINATES(PLAYER_CHAR, playx, playy, playz)
						GET_CHAR_COORDINATES(intDeadCheck, pedx, pedy, pedz)
						distance = VDIST(playx.b, playy.b, playz.b, pedx.b, pedy.b, pedz.b)
						if (distance > 1090000000) then -- if they're too far away, pick some closer coords and move them toward the player
							if (IS_CHAR_IN_ANY_CAR(PLAYER_CHAR) == 1) then
								spawnX = math.random(-10, 10)
								spawnY = math.random(100, 150)
							else
								if (math.random(5) == 1) then
									spawnX = math.random(-15, 15)
									spawnY = math.random(50, 100)
								else
									spawnX = math.random(-15, 15)
									spawnY = math.random(-15, -2)
								end
							end

							CLEAR_CHAR_TASKS(intDeadCheck)
							GET_OFFSET_FROM_CHAR_IN_WORLD_COORDS(PLAYER_CHAR, f(spawnX), f(spawnY), 0, x, y, z) -- use spawnX and spawnY to generate coords for a spawned ped
							GET_GROUND_Z_FOR_3D_COORD(x.b, y.b, z.b, z)
							SET_CHAR_COORDINATES(intDeadCheck, x.b, y.b, z.b)
							TASK_COMBAT_HATED_TARGETS_AROUND_CHAR(intDeadCheck, f(30.0))
						end
					end
				end
			end
			Count = Count + 1
		end
	end
end

main();
