--necropolis-misson.lua

--	NECROPOLIS
--	City of the Dead
--	veaudaux@gmail.com

--This script controls the safe house, survivors, and markets.

--Thanks to Alexander Blade for ALICE, the WaitForPlayerPoolCreation and WaitForValidPlayer functions, and his advice.
--Also, big thanks to zBobG at GTAForums.com for talking Lua and Alice with me, and
--ZAZ for his helpful input.

PLAYER_ID, PLAYER_CHAR = 0

local x = {}  local y = {}  local z = {}

local playIndex = {}
local playrGrp = {}
local AllMarkets = {}
local AllSurvivors = {}
GROUP_ID = 0

local SafeHouse = {}
local SafeHouseBlip = {}

local ThisMarket = {}

MarketX = 0
MarketY = 0
MarketZ = 0
PedX = 0
PedY = 0
PedZ = 0

CurrentMission = 0
TotalStores = 0
TotalSurvivors = 0
MarkedStore = 0
SpawnedPeds = 0
MissionComplete = 0
RescuedCount = 0
OpenPrison = 0

function WaitForPlayerPoolCreation()
	while (IsPlayerPoolCreated() == 0) do
		Wait(2000)
	end
end

function WaitForValidPlayer()
	PLAYER_CHAR = 0
		repeat
			PLAYER_ID = _GET_PLAYER_ID()
				if (PLAYER_ID >= 0) then
					while true do
						if _IS_PLAYER_PLAYING(PLAYER_ID) == 0
						then Wait(1000)
						else break
						end
				end
			local p = {}
			_GET_PLAYER_CHAR(PLAYER_ID, p)
			PLAYER_CHAR = p.a
				if (PLAYER_CHAR <= 0) then
					Wait(1000)
				end
		end
		until (PLAYER_CHAR > 0)
end

function SetPlayIndex()
	PLAYER_ID = _GET_PLAYER_ID()
	playIndex = _CONVERT_INT_TO_PLAYERINDEX(PLAYER_ID)
end

function SetPlayGroup()
	GET_PLAYER_GROUP(playIndex, playrGrp)
	GROUP_ID = playrGrp.a
end

function AddStore(storeX, storeY, storeZ) -- This function adds a store to the list of locations to select from randomly.
	TotalStores = TotalStores + 1
	local TempMarket = {}
	TempMarket.x = storeX
	TempMarket.y = storeY
	TempMarket.z = storeZ
	TempMarket.used = 0
	AllMarkets[TotalStores] = TempMarket
end

function MarkStore() -- This function picks a random store from the list and marks it as the objective.
	local MarketBlip = {}
	TriedStores = 0
	math.randomseed( os.time() )
	math.random(); math.random(); math.random()
	while true do
		WhichMarket = math.random(TotalStores)
		TriedStores = TriedStores + 1
		if (AllMarkets[WhichMarket].used ~= 1) then
			AllMarkets[WhichMarket].used = 1
			break
		end

		if (TriedStores == TotalStores) then
			WhichMarket = 1
			while (WhichMarket <= TotalStores) do
				if AllMarkets[WhichMarket].used ~= 1 then
					break
				else
					AllMarkets[WhichMarket].used = 0
					WhichMarket = WhichMarket + 1
				end
			end
		end
	end

	MarketX = AllMarkets[WhichMarket].x
	MarketY = AllMarkets[WhichMarket].y
	MarketZ = AllMarkets[WhichMarket].z

	local hash = GET_HASH_KEY("CJ_GOLF_BALL")
	REQUEST_MODEL(hash)
	CREATE_OBJECT(hash, f(MarketX), f(MarketY), f(MarketZ), ThisMarket)
	FREEZE_OBJECT_POSITION(ThisMarket.a, 1)
	ADD_BLIP_FOR_OBJECT(ThisMarket.a, MarketBlip)
	SET_OBJECT_VISIBLE(ThisMarket.a, 0)
	CHANGE_BLIP_NAME_FROM_ASCII(MarketBlip.a, "Market")
	FLASH_BLIP(MarketBlip.a, 1)
	PRINT_STRING_WITH_LITERAL_STRING_NOW("STRING","Go and retrieve supplies from the Market",5000,1)
	Wait(5000)
	FLASH_BLIP(MarketBlip.a, 0)

	MarkedStore = 1
end


function AddSurvivor(pedmodel, pedname, gender, weapon, voice, greeting, idleanimgroup, idleanim, pedX, pedY, pedZ, heading, CustomAppearance, zeroCom, oneCom, twoCom, threeCom, fourCom, fiveCom, sevenCom, zeroTex, oneTex, twoTex, threeTex, fourTex, fiveTex, sevenTex)
-- this function adds a survivor to the list of survivors to spawn. the idleanim stuff broke somewhere along the way, and I never fixed it, so none of the
-- survivors currently use it.
	TotalSurvivors = TotalSurvivors + 1
	local TempSurvivor = {}
	TempSurvivor.model = pedmodel
	TempSurvivor.charname = pedname
	TempSurvivor.gender = gender
	TempSurvivor.weapon = weapon
	TempSurvivor.voice = voice
	TempSurvivor.greeting = greeting
	TempSurvivor.idleanimgroup = idleanimgroup
	TempSurvivor.idleanim = idleanim
	TempSurvivor.x = pedX
	TempSurvivor.y = pedY
	TempSurvivor.z = pedZ
	TempSurvivor.heading = heading
	TempSurvivor.alive = 1
	TempSurvivor.rescued = 0
	TempSurvivor.ingroup = 0
	TempSurvivor.a = 0
	TempSurvivor.b = 0
	TempSurvivor.blipID = 0
	TempSurvivor.CustomAppearance = CustomAppearance
	TempSurvivor.zeroCom = zeroCom
	TempSurvivor.oneCom = oneCom
	TempSurvivor.twoCom = twoCom
	TempSurvivor.threeCom = threeCom
	TempSurvivor.fourCom = fourCom
	TempSurvivor.fiveCom = fiveCom
	TempSurvivor.sevenCom = sevenCom
	TempSurvivor.zeroTex = zeroTex
	TempSurvivor.oneTex = oneTex
	TempSurvivor.twoTex = twoTex
	TempSurvivor.threeTex = threeTex
	TempSurvivor.fourTex = fourTex
	TempSurvivor.fiveTex = fiveTex
	TempSurvivor.sevenTex = sevenTex
	AllSurvivors[TotalSurvivors] = TempSurvivor
end

function SetCustomAppearance(char, zeroCom, oneCom, twoCom, threeCom, fourCom, fiveCom, sevenCom, zeroTex, oneTex, twoTex, threeTex, fourTex, fiveTex, sevenTex)
-- This function is used to customize the appearance of a ped, and to make sure their appearance stays consistent through safehouse respawns
	SET_CHAR_COMPONENT_VARIATION(char, 0, zeroCom, zeroTex)
	SET_CHAR_COMPONENT_VARIATION(char, 1, oneCom, oneTex)
	SET_CHAR_COMPONENT_VARIATION(char, 2, twoCom, twoTex)
	SET_CHAR_COMPONENT_VARIATION(char, 3, threeCom, threeTex)
	SET_CHAR_COMPONENT_VARIATION(char, 4, fourCom, fourTex)
	SET_CHAR_COMPONENT_VARIATION(char, 5, fiveCom, fiveTex)
	SET_CHAR_COMPONENT_VARIATION(char, 7, sevenCom, sevenTex)
end

function SpawnSurvivors() -- This one spawns all the survivors in the list
	local SurvivorBlip = {}
	local ThisSurvivor = {}
	PedCount = 1
	while (PedCount <= TotalSurvivors) do
		if (AllSurvivors[PedCount].rescued == 0) then
			ThisModel = AllSurvivors[PedCount].model
			local hash = GET_HASH_KEY(ThisModel)
			REQUEST_MODEL(hash)
			while HAS_MODEL_LOADED(hash) == 0 do Wait(100) end
			CREATE_CHAR(AllSurvivors[PedCount].gender, hash, f(AllSurvivors[PedCount].x), f(AllSurvivors[PedCount].y), f(AllSurvivors[PedCount].z), ThisSurvivor, 1)
			while DOES_CHAR_EXIST(ThisSurvivor.a) == 0 do Wait(100) end

			AllSurvivors[PedCount].a = ThisSurvivor.a
			AllSurvivors[PedCount].b = ThisSurvivor.b

			SET_BLOCKING_OF_NON_TEMPORARY_EVENTS(AllSurvivors[PedCount].a, 1)
			SET_CHAR_VISIBLE(AllSurvivors[PedCount].a, 0)


			GIVE_WEAPON_TO_CHAR(AllSurvivors[PedCount].a, AllSurvivors[PedCount].weapon,30000,0)
			TASK_SET_IGNORE_WEAPON_RANGE_FLAG(AllSurvivors[PedCount].a, 1)
			SET_CHAR_INVINCIBLE(AllSurvivors[PedCount].a, 1)

			if AllSurvivors[PedCount].voice ~= 0 then
				SET_AMBIENT_VOICE_NAME(AllSurvivors[PedCount].a, AllSurvivors[PedCount].voice)
			else

			end

			if AllSurvivors[PedCount].CustomAppearance == 1 then
				SetCustomAppearance(AllSurvivors[PedCount].a, AllSurvivors[PedCount].zeroCom, AllSurvivors[PedCount].oneCom, AllSurvivors[PedCount].twoCom, AllSurvivors[PedCount].threeCom, AllSurvivors[PedCount].fourCom, AllSurvivors[PedCount].fiveCom, AllSurvivors[PedCount].sevenCom, AllSurvivors[PedCount].zeroTex, AllSurvivors[PedCount].oneTex, AllSurvivors[PedCount].twoTex, AllSurvivors[PedCount].threeTex, AllSurvivors[PedCount].fourTex, AllSurvivors[PedCount].fiveTex, AllSurvivors[PedCount].sevenTex)
			else
				AllSurvivors[PedCount].zeroCom = GET_CHAR_DRAWABLE_VARIATION(AllSurvivors[PedCount].a, 0)
				AllSurvivors[PedCount].oneCom = GET_CHAR_DRAWABLE_VARIATION(AllSurvivors[PedCount].a, 1)
				AllSurvivors[PedCount].twoCom = GET_CHAR_DRAWABLE_VARIATION(AllSurvivors[PedCount].a, 2)
				AllSurvivors[PedCount].threeCom = GET_CHAR_DRAWABLE_VARIATION(AllSurvivors[PedCount].a, 3)
				AllSurvivors[PedCount].fourCom = GET_CHAR_DRAWABLE_VARIATION(AllSurvivors[PedCount].a, 4)
				AllSurvivors[PedCount].fiveCom = GET_CHAR_DRAWABLE_VARIATION(AllSurvivors[PedCount].a, 5)
				AllSurvivors[PedCount].sevenCom = GET_CHAR_DRAWABLE_VARIATION(AllSurvivors[PedCount].a, 7)
				AllSurvivors[PedCount].zeroTex = GET_CHAR_TEXTURE_VARIATION(AllSurvivors[PedCount].a, 0)
				AllSurvivors[PedCount].oneTex = GET_CHAR_TEXTURE_VARIATION(AllSurvivors[PedCount].a, 1)
				AllSurvivors[PedCount].twoTex = GET_CHAR_TEXTURE_VARIATION(AllSurvivors[PedCount].a, 2)
				AllSurvivors[PedCount].threeTex = GET_CHAR_TEXTURE_VARIATION(AllSurvivors[PedCount].a, 3)
				AllSurvivors[PedCount].fourTex = GET_CHAR_TEXTURE_VARIATION(AllSurvivors[PedCount].a, 4)
				AllSurvivors[PedCount].fiveTex = GET_CHAR_TEXTURE_VARIATION(AllSurvivors[PedCount].a, 5)
				AllSurvivors[PedCount].sevenTex = GET_CHAR_TEXTURE_VARIATION(AllSurvivors[PedCount].a, 7)
			end

			SET_PED_PATH_MAY_DROP_FROM_HEIGHT(AllSurvivors[PedCount].a, 0)
			SET_PED_PATH_MAY_USE_CLIMBOVERS(AllSurvivors[PedCount].a, 0)
			SET_PED_PATH_MAY_USE_LADDERS(AllSurvivors[PedCount].a, 0)

			MARK_MODEL_AS_NO_LONGER_NEEDED(hash)
		end
	PedCount = PedCount + 1
	end

	PedCount = 1
	while (PedCount <= TotalSurvivors) do
		ADD_BLIP_FOR_CHAR(AllSurvivors[PedCount].a, SurvivorBlip)
		SET_BLIP_AS_SHORT_RANGE(SurvivorBlip.a, 1)
		CHANGE_BLIP_DISPLAY(SurvivorBlip.a, 5) -- You could comment this line out to see all survivors on the map. But that's cheating.
		AllSurvivors[PedCount].blipID = SurvivorBlip.a
		if AllSurvivors[PedCount].gender == 1 then
			CHANGE_BLIP_SPRITE(SurvivorBlip.a, 63)
		else
			CHANGE_BLIP_SPRITE(SurvivorBlip.a, 64)
		end
		CHANGE_BLIP_COLOUR(SurvivorBlip.a, 4)
		SET_BLIP_AS_FRIENDLY(SurvivorBlip.a, 1)
		CHANGE_BLIP_NAME_FROM_ASCII(SurvivorBlip.a, AllSurvivors[PedCount].charname)
		SET_CHAR_VISIBLE(AllSurvivors[PedCount].a, 1)
		SET_BLOCKING_OF_NON_TEMPORARY_EVENTS(AllSurvivors[PedCount].a, 0)
		TASK_STAND_GUARD(AllSurvivors[PedCount].a, f(AllSurvivors[PedCount].x), f(AllSurvivors[PedCount].y), f(AllSurvivors[PedCount].z), f(AllSurvivors[PedCount].heading), f(15.00), 0, -1)
		PedCount = PedCount + 1
	end

	SpawnedPeds = 1
end

function SpecialAbilityMsg(LiveOrDead, Name)	-- Some survivors have special abilities. This function notifies you that the ability is
	if LiveOrDead == 1 then					-- available when the ped is rescued, and no longer available when the ped dies.
		if Name == "Sparky" then
			Wait(5000)
			Status = "Sparky can repair your vehicle during safe house stays."
			PRINT_STRING_WITH_LITERAL_STRING_NOW("STRING",Status,5000,1)
		end
		if Name == "Doc" then
			Wait(5000)
			Status = "The doc can more quickly restore your health during safe house stays."
			PRINT_STRING_WITH_LITERAL_STRING_NOW("STRING",Status,5000,1)
		end
		if Name == "Mickey" then
			Wait(5000)
			Status = "Mickey will provide you with upgraded weaponry and additional ammunition during safe house stays."
			PRINT_STRING_WITH_LITERAL_STRING_NOW("STRING",Status,5000,1)
		end
		if Name == "Dick" then
			Wait(5000)
			Status = "Dick will provide you with a sniper rifle and ammunition during safe house stays."
			PRINT_STRING_WITH_LITERAL_STRING_NOW("STRING",Status,5000,1)
		end
	else
		if Name == "Sparky" then
			Wait(5000)
			Status = "Your vehicles will no longer be repaired during safe house stays."
			PRINT_STRING_WITH_LITERAL_STRING_NOW("STRING",Status,5000,1)
		end
		if Name == "Doc" then
			Wait(5000)
			Status = "The doc will no longer be able to tend your wounds during safe house stays."
			PRINT_STRING_WITH_LITERAL_STRING_NOW("STRING",Status,5000,1)
		end
	end
end

function ActivateSpecialAbility() -- This function is called during safehouse stays, and is what makes the survivor special ability "magic" happen.
	if AllSurvivors[4].rescued == 1 and AllSurvivors[4].alive == 1 then --Sparky fixes the last car you were in
		local LastCar = {}
		GET_PLAYERS_LAST_CAR_NO_SAVE(LastCar)
		if DOES_VEHICLE_EXIST(LastCar.a) == 1 then
			SET_CAR_AS_MISSION_CAR(LastCar.a)
			FIX_CAR(LastCar.a)
			MARK_CAR_AS_NO_LONGER_NEEDED(LastCar)
		end
	end

	if AllSurvivors[8].rescued == 1 then -- Dick gives you a sniper rifle and ammo
		if HAS_CHAR_GOT_WEAPON(PLAYER_CHAR, 17) == 0 then
			GIVE_WEAPON_TO_CHAR(PLAYER_CHAR, 17, 20, 0)
		else
			local Ammo = {}
			GET_AMMO_IN_CHAR_WEAPON(PLAYER_CHAR, 17, Ammo)
			if Ammo.a < 20 then
				SET_CHAR_AMMO(PLAYER_CHAR, 17, 20)
			end
		end
	end

	if AllSurvivors[8].rescued == 1 and AllSurvivors[8].alive == 1 then -- Dick on the roof of the garage, sniping
		local ThisSurvivor = {}
		if DOES_CHAR_EXIST(AllSurvivors[8].a) == 0 then
			ThisModel = AllSurvivors[8].model
			local hash = GET_HASH_KEY(ThisModel)
			REQUEST_MODEL(hash)
			while HAS_MODEL_LOADED(hash) == 0 do Wait(100) end
			CREATE_CHAR(AllSurvivors[8].gender, hash, f(-973.775390625), f(1888.1394042969), f(26.998819351196), ThisSurvivor, 1)
			while DOES_CHAR_EXIST(ThisSurvivor.a) == 0 do Wait(100) end
			FREEZE_CHAR_POSITION(ThisSurvivor.a, 1)

			AllSurvivors[8].a = ThisSurvivor.a
			AllSurvivors[8].b = ThisSurvivor.b
			GIVE_WEAPON_TO_CHAR(AllSurvivors[8].a, AllSurvivors[8].weapon,30000,0)
			TASK_SET_IGNORE_WEAPON_RANGE_FLAG(AllSurvivors[8].a, 1)
			SET_CHAR_INVINCIBLE(AllSurvivors[8].a, 1)
			SetCustomAppearance(AllSurvivors[8].a, AllSurvivors[8].zeroCom, AllSurvivors[8].oneCom, AllSurvivors[8].twoCom, AllSurvivors[8].threeCom, AllSurvivors[8].fourCom, AllSurvivors[8].fiveCom, AllSurvivors[8].sevenCom, AllSurvivors[8].zeroTex, AllSurvivors[8].oneTex, AllSurvivors[8].twoTex, AllSurvivors[8].threeTex, AllSurvivors[8].fourTex, AllSurvivors[8].fiveTex, AllSurvivors[8].sevenTex)
			SET_PED_PATH_MAY_DROP_FROM_HEIGHT(AllSurvivors[8].a, 0)
			SET_PED_PATH_MAY_USE_CLIMBOVERS(AllSurvivors[8].a, 0)
			SET_PED_PATH_MAY_USE_LADDERS(AllSurvivors[8].a, 0)
			TASK_STAND_GUARD(AllSurvivors[8].a, f(-973.775390625), f(1888.1394042969), f(26.998819351196), f(131.50), f(15.00), 0, -1)
			MARK_MODEL_AS_NO_LONGER_NEEDED(hash)
		end
	end

	if AllSurvivors[12].rescued == 1 then --Mickey gives you guns and ammo
		if HAS_CHAR_GOT_WEAPON(PLAYER_CHAR, 9) == 0 then
			GIVE_WEAPON_TO_CHAR(PLAYER_CHAR, 9, 135, 0)
		else
			local Ammo = {}
			GET_AMMO_IN_CHAR_WEAPON(PLAYER_CHAR, 9, Ammo)
			if Ammo.a < 135 then
				SET_CHAR_AMMO(PLAYER_CHAR, 9, 135)
			end
		end

		if HAS_CHAR_GOT_WEAPON(PLAYER_CHAR, 11) == 0 then
			GIVE_WEAPON_TO_CHAR(PLAYER_CHAR, 11, 30, 0)
		else
			local Ammo = {}
			GET_AMMO_IN_CHAR_WEAPON(PLAYER_CHAR, 11, Ammo)
			if Ammo.a < 30 then
				SET_CHAR_AMMO(PLAYER_CHAR, 11, 30)
			end
		end

		if HAS_CHAR_GOT_WEAPON(PLAYER_CHAR, 15) == 0 then
			GIVE_WEAPON_TO_CHAR(PLAYER_CHAR, 15, 90, 0)
		else
			local Ammo = {}
			GET_AMMO_IN_CHAR_WEAPON(PLAYER_CHAR, 15, Ammo)
			if Ammo.a < 90 then
				SET_CHAR_AMMO(PLAYER_CHAR, 15, 90)
			end
		end

		if HAS_CHAR_GOT_WEAPON(PLAYER_CHAR, 5) == 0 then
			GIVE_WEAPON_TO_CHAR(PLAYER_CHAR, 5, 15, 0)
		else
			local Ammo = {}
			GET_AMMO_IN_CHAR_WEAPON(PLAYER_CHAR, 5, Ammo)
			if Ammo.a < 10 then
				SET_CHAR_AMMO(PLAYER_CHAR, 5, 15)
			end
		end

	else
		if HAS_CHAR_GOT_WEAPON(PLAYER_CHAR, 7) == 0 then
			GIVE_WEAPON_TO_CHAR(PLAYER_CHAR, 7, 51, 0)
		else
			local Ammo = {}
			GET_AMMO_IN_CHAR_WEAPON(PLAYER_CHAR, 7, Ammo)
			if Ammo.a < 51 then
				SET_CHAR_AMMO(PLAYER_CHAR, 7, 51)
			end
		end

		if HAS_CHAR_GOT_WEAPON(PLAYER_CHAR, 10) == 0 then
			GIVE_WEAPON_TO_CHAR(PLAYER_CHAR, 10, 16, 0)
		else
			local Ammo = {}
			GET_AMMO_IN_CHAR_WEAPON(PLAYER_CHAR, 10, Ammo)
			if Ammo.a < 16 then
				SET_CHAR_AMMO(PLAYER_CHAR, 10, 16)
			end
		end

		if HAS_CHAR_GOT_WEAPON(PLAYER_CHAR, 5) == 0 then
			GIVE_WEAPON_TO_CHAR(PLAYER_CHAR, 5, 5, 0)
		else
			local Ammo = {}
			GET_AMMO_IN_CHAR_WEAPON(PLAYER_CHAR, 5, Ammo)
			if Ammo.a < 5 then
				SET_CHAR_AMMO(PLAYER_CHAR, 5, 5)
			end
		end

	end

	if AllSurvivors[13].rescued == 1 and AllSurvivors[13].alive == 1 then --Doc refills your health
		SET_CHAR_HEALTH(PLAYER_CHAR, 200)
	else
		local PlayerHealth = {}
		GET_CHAR_HEALTH(PLAYER_CHAR, PlayerHealth)
		PlayerHealth.a = PlayerHealth.a + 25
		if PlayerHealth.a > 200 then PlayerHealth.a = 200 end
		SET_CHAR_HEALTH(PLAYER_CHAR, PlayerHealth.a)
	end
end

function RescueSurvivor(count) -- This function does all the necessary work to add a survivor to your group.
	local players = {}  local npcs = {}
	GET_GROUP_SIZE(GROUP_ID, players, npcs)

	if (npcs.a < 3) then

		if (npcs.a == 2) then
			Status = "Rescued " .. AllSurvivors[count].charname .. ". That makes three. Return to the Safe House."
			PRINT_STRING_WITH_LITERAL_STRING_NOW("STRING",Status,5000,1)
		else
			Status = "Rescued " .. AllSurvivors[count].charname .. ". You can continue searching for survivors, or return to the Safe House."
			PRINT_STRING_WITH_LITERAL_STRING_NOW("STRING",Status,5000,1)
		end

		CLEAR_CHAR_TASKS(AllSurvivors[count].a)

		if AllSurvivors[count].greeting ~= 0 then
			SAY_AMBIENT_SPEECH(AllSurvivors[count].a, AllSurvivors[count].greeting, 1, 1, 2)
		end

		SET_GROUP_MEMBER(GROUP_ID, AllSurvivors[count].a)

		SET_CHAR_INVINCIBLE(AllSurvivors[count].a, 0)
		SET_CHAR_MAX_HEALTH(AllSurvivors[count].a, 600) -- set their max health to 600
		SET_CHAR_HEALTH(AllSurvivors[count].a, 600) -- and heal them to full

		CHANGE_BLIP_SPRITE(AllSurvivors[count].blipID, 0)
		CHANGE_BLIP_SCALE(AllSurvivors[count].blipID, f(0.75))
		SET_BLIP_AS_SHORT_RANGE(AllSurvivors[count].blipID, 0)
		CHANGE_BLIP_DISPLAY(AllSurvivors[count].blipID, 2)

		SET_GROUP_SEPARATION_RANGE(GROUP_ID, f(9999.0))
		SET_CHAR_NEVER_LEAVES_GROUP(AllSurvivors[count].a, 1)
		SET_CHAR_NEVER_TARGETTED(AllSurvivors[count].a, 1)
		SET_CHAR_SUFFERS_CRITICAL_HITS(AllSurvivors[count].a, 0)
		SET_CHAR_ACCURACY(AllSurvivors[count].a, 100)
		SET_CHAR_WILL_MOVE_WHEN_INJURED(AllSurvivors[count].a, 1)
		SET_PED_DIES_WHEN_INJURED(AllSurvivors[count].a, 1)
		SET_PED_PATH_MAY_DROP_FROM_HEIGHT(AllSurvivors[count].a, 1)
		SET_PED_PATH_MAY_USE_CLIMBOVERS(AllSurvivors[count].a, 1)
		SET_PED_PATH_MAY_USE_LADDERS (AllSurvivors[count].a, 1)
		SET_CHAR_WILL_DO_DRIVEBYS(AllSurvivors[count].a, 1)
		SET_CHAR_PROVIDE_COVERING_FIRE(AllSurvivors[count].a, 1)

		AllSurvivors[count].rescued = 1
		AllSurvivors[count].ingroup = 1

		if CurrentMission == 2 then
			MissionComplete = 1
		end

		RescuedCount = RescuedCount + 1
		CLEAR_CHAR_TASKS(AllSurvivors[count].a)
		SpecialAbilityMsg(1, AllSurvivors[count].charname)
	else
		PRINT_STRING_WITH_LITERAL_STRING_NOW("STRING","Your group is full. You'll have to come back for this one.",5000,1)
	end
end

function RemoveSurvivors() -- This despawns all the survivors once you get back to the safehouse.
	PedCount = 1
	while (PedCount <= TotalSurvivors) do
		if (AllSurvivors[PedCount].ingroup == 1) then
			AllSurvivors[PedCount].ingroup = 0
			MARK_CHAR_AS_NO_LONGER_NEEDED(AllSurvivors[PedCount])
			REMOVE_CHAR_ELEGANTLY(AllSurvivors[PedCount])
			CLEAR_AREA_OF_CHARS(f(-986.76525878906), f(1882.9345703125), f(22.283061981201), f(30.00))
		end
		PedCount = PedCount + 1
	end
end

function AddCompanion() -- This adds a random survivor (out of those that have been rescued) to your group as a body guard during safehouse stays.
	local players = {}  local npcs = {}
	local ThisSurvivor = {}
	local SurvivorBlip = {}
	GET_GROUP_SIZE(GROUP_ID, players, npcs)

	if npcs.a < 1 then
		math.randomseed( os.time() )
		math.random(); math.random(); math.random()
		PedCount = 1
		RandomPed = math.random(TotalSurvivors)

		while (PedCount <= TotalSurvivors) do
			if RandomPed ~= 8 and AllSurvivors[RandomPed].rescued == 1 and AllSurvivors[RandomPed].alive == 1 then
				ThisModel = AllSurvivors[RandomPed].model
				local hash = GET_HASH_KEY(ThisModel)
				REQUEST_MODEL(hash)
				while HAS_MODEL_LOADED(hash) == 0 do Wait(100) end
				GET_OFFSET_FROM_CHAR_IN_WORLD_COORDS(PLAYER_CHAR, 0, f(5), 0, x, y, z)
				CREATE_CHAR(AllSurvivors[RandomPed].gender, hash, x.b, y.b, z.b, ThisSurvivor, 1)
				while DOES_CHAR_EXIST(ThisSurvivor.a) == 0 do Wait(100) end
				MARK_MODEL_AS_NO_LONGER_NEEDED(hash)
				AllSurvivors[RandomPed].a = ThisSurvivor.a
				AllSurvivors[RandomPed].b = ThisSurvivor.b
				ADD_BLIP_FOR_CHAR(ThisSurvivor.a, SurvivorBlip)
				AllSurvivors[RandomPed].blipID = SurvivorBlip.a
				CHANGE_BLIP_COLOUR(SurvivorBlip.a, 4)
				SET_BLIP_AS_FRIENDLY(SurvivorBlip.a, 1)
				CHANGE_BLIP_SCALE(SurvivorBlip.a, f(0.75))
				CHANGE_BLIP_NAME_FROM_ASCII(SurvivorBlip.a, AllSurvivors[RandomPed].charname)
				SetCustomAppearance(AllSurvivors[RandomPed].a, AllSurvivors[RandomPed].zeroCom, AllSurvivors[RandomPed].oneCom, AllSurvivors[RandomPed].twoCom, AllSurvivors[RandomPed].threeCom, AllSurvivors[RandomPed].fourCom, AllSurvivors[RandomPed].fiveCom, AllSurvivors[RandomPed].sevenCom, AllSurvivors[RandomPed].zeroTex, AllSurvivors[RandomPed].oneTex, AllSurvivors[RandomPed].twoTex, AllSurvivors[RandomPed].threeTex, AllSurvivors[RandomPed].fourTex, AllSurvivors[RandomPed].fiveTex, AllSurvivors[RandomPed].sevenTex)
				if AllSurvivors[PedCount].voice ~= 0 then
					SET_AMBIENT_VOICE_NAME(AllSurvivors[RandomPed].a, AllSurvivors[RandomPed].voice)
				end
				SET_CHAR_MAX_HEALTH(AllSurvivors[RandomPed].a, 600)
				SET_CHAR_HEALTH(AllSurvivors[RandomPed].a, 600)
				SET_LOAD_COLLISION_FOR_CHAR_FLAG(AllSurvivors[RandomPed].a, 1)
				GIVE_WEAPON_TO_CHAR(AllSurvivors[RandomPed].a,AllSurvivors[RandomPed].weapon,30000,0)
				SET_GROUP_MEMBER(GROUP_ID, AllSurvivors[RandomPed].a)
				SET_GROUP_SEPARATION_RANGE(GROUP_ID, f(9999.0))
				SET_CHAR_NEVER_LEAVES_GROUP(AllSurvivors[RandomPed].a, 1)
				SET_CHAR_NEVER_TARGETTED(AllSurvivors[RandomPed].a, 1)
				SET_CHAR_SUFFERS_CRITICAL_HITS(AllSurvivors[RandomPed].a, 0)
				SET_CHAR_ACCURACY(AllSurvivors[RandomPed].a, 100)
				SET_CHAR_WILL_MOVE_WHEN_INJURED(AllSurvivors[RandomPed].a, 1)
				SET_PED_DIES_WHEN_INJURED(AllSurvivors[RandomPed].a, 1)
				SET_PED_PATH_MAY_DROP_FROM_HEIGHT(AllSurvivors[RandomPed].a, 1)
				SET_PED_PATH_MAY_USE_CLIMBOVERS(AllSurvivors[RandomPed].a, 1)
				SET_PED_PATH_MAY_USE_LADDERS (AllSurvivors[RandomPed].a, 1)
				AllSurvivors[RandomPed].ingroup = 1
				break
			else
				RandomPed = RandomPed + 1
				if RandomPed > TotalSurvivors then
					RandomPed = 1
				end
			end
			PedCount = PedCount + 1
		end
	end
end

function main()
    WaitForPlayerPoolCreation()
    WaitForValidPlayer()
    SetPlayIndex()
	SetPlayGroup()

	SET_RELATIONSHIP(1, 1, 0)
	SET_RELATIONSHIP(1, 2, 0)
	SET_RELATIONSHIP(1, 1, 1)
	SET_RELATIONSHIP(1, 1, 2)
	SET_RELATIONSHIP(1, 2, 1)
	SET_RELATIONSHIP(1, 2, 2)


	SET_PLAYER_CONTROL(playIndex, 0)
	DO_SCREEN_FADE_OUT(1000)
	Wait(1000)
	SET_MISSION_FLAG(1)
	SET_CHAR_COORDINATES(PLAYER_CHAR, f(481.81866455078), f(-88.740127563477), f(9.2555894851685))
	SET_CHAR_HEADING(PLAYER_CHAR, f(325.0))

	REMOVE_ALL_PICKUPS_OF_TYPE(15)
	REMOVE_ALL_PICKUPS_OF_TYPE(2)
	REMOVE_ALL_PICKUPS_OF_TYPE(3)

	REMOVE_ALL_CHAR_WEAPONS(PLAYER_CHAR)
	GIVE_WEAPON_TO_CHAR(PLAYER_CHAR,1,30000,0)
	GIVE_WEAPON_TO_CHAR(PLAYER_CHAR,5,5,0)
	GIVE_WEAPON_TO_CHAR(PLAYER_CHAR,10,16,0)
	GIVE_WEAPON_TO_CHAR(PLAYER_CHAR,7,51,0)

	local hash = GET_HASH_KEY("CJ_GOLF_BALL")
	REQUEST_MODEL(hash)
	while HAS_MODEL_LOADED(hash) == 0 do Wait(100) end
	CREATE_OBJECT(hash, f(-987.65686034156), f(1883.2431640625), f(22.283061981201), SafeHouse)
	FREEZE_OBJECT_POSITION(SafeHouse.a, 1)
	ADD_BLIP_FOR_OBJECT(SafeHouse.a, SafeHouseBlip)
	SET_OBJECT_VISIBLE(SafeHouse.a, 0)
	CHANGE_BLIP_SPRITE(SafeHouseBlip.a, 29)
	CHANGE_BLIP_NAME_FROM_ASCII(SafeHouseBlip.a, "Safe House")

	SET_TIME_OF_DAY(21, 1)

	REQUEST_ANIMS("get_up")
	while HAVE_ANIMS_LOADED("get_up") == 0 do Wait(100) end
	TASK_PLAY_ANIM(PLAYER_CHAR, "get_up_slow", "get_up", f(2), 0, 0, 0, 0, -1)
	SET_CAM_BEHIND_PED(PLAYER_CHAR)
	DO_SCREEN_FADE_IN(1000)
	Wait(3000)
	SET_PLAYER_CONTROL(playIndex, 1)

	SET_MESSAGES_WAITING(0)
	SET_TOTAL_NUMBER_OF_MISSIONS(0)
	ALLOW_EMERGENCY_SERVICES(0)
	SET_CREATE_RANDOM_COPS(0)


	SET_STATE_OF_CLOSEST_DOOR_OF_TYPE(807349477, f(1057.40), f(86.10), f(34.50), 1, f(0.00)) -- opens the door to the gun shop where Mickey is

	FLASH_BLIP(SafeHouseBlip.a, 1)
	MissionComplete = 1
	PRINT_STRING_WITH_LITERAL_STRING_NOW("STRING","Make your way to the Safe House.",5000,1)
	Wait(5000)
	FLASH_BLIP(SafeHouseBlip.a, 0)

	SET_THIS_SCRIPT_CAN_REMOVE_BLIPS_CREATED_BY_ANY_SCRIPT(1)

	local ThisBlip = {}
	BlipType = 0

	while BlipType < 95 do -- I'm looping through and removing any blips from the map that I can.
		if BlipType ~= 6 and BlipType ~= 7 and BlipType ~= 29 then -- besides the player arrow, the compass N, and the safehouse icon
			ThisBlip = GET_FIRST_BLIP_INFO_ID(BlipType)
			if ThisBlip ~= 0 then
				REMOVE_BLIP(ThisBlip)

				while true do
					ThisBlip = GET_NEXT_BLIP_INFO_ID(BlipType)
					if ThisBlip ~= 0 then
						REMOVE_BLIP(ThisBlip)
					else
						break
					end
				end
			end
		end
		BlipType = BlipType + 1
	end


	while true do
		local gametime = {}
		local gameday = {}
		local heading = {}
		local distance = {}

		if IS_OBJECT_ON_SCREEN(SafeHouse.a) == 1 then
			GET_CHAR_COORDINATES(PLAYER_CHAR, x, y, z)
			GET_DISTANCE_BETWEEN_COORDS_3D(x.b, y.b, z.b, f(-987.65686034156), f(1883.2431640625), f(23.281768798828), distance)
			if (distance.a < 1058000000) or IsKeyPressed(9) == 1 then

--
--
--	SAFE HOUSE STAY
--
--
				SET_PLAYER_CONTROL(playIndex, 0)
				SET_EVERYONE_IGNORE_PLAYER(playIndex, 1)
				DO_SCREEN_FADE_OUT(1000)
				Wait(1000)
				RemoveSurvivors()
				if (GET_CHAR_DRAWABLE_VARIATION(PLAYER_CHAR, 3) == 3) then
					SET_CHAR_COMPONENT_VARIATION(PLAYER_CHAR, 3, 0, 0)
				end
				SET_CHAR_COORDINATES(PLAYER_CHAR, f(-983.63690185547), f(1882.2795410156), f(22.323406219482))
				SET_CHAR_HEADING(PLAYER_CHAR, f(256.00))
				SET_CAM_BEHIND_PED(PLAYER_CHAR)
				GET_TIME_OF_DAY(gametime, gameday)
				NewTime = gametime.a + 6
				if (NewTime > 24) then
					NewTime = (NewTime - 24)
				end

				FORWARD_TO_TIME_OF_DAY(NewTime, gameday.a)

				SET_CAR_DENSITY_MULTIPLIER(f(0.00)) -- Clear the streets for that great deserted feel
				SET_PED_DENSITY_MULTIPLIER(f(0.00))
				SET_PARKED_CAR_DENSITY_MULTIPLIER(f(0.2))

				if MissionComplete == 1 then
					CurrentMission = CurrentMission + 1

					if CurrentMission > 2 then
						CurrentMission = 1
					end

					MissionComplete = 0

					if MarkedStore == 1 then
						MarkedStore = 0
					end
				end

				AddCompanion()

				ActivateSpecialAbility()

				DO_SCREEN_FADE_IN(1000)
				--Wait(1000)
				SET_PLAYER_CONTROL(playIndex, 1)
				SET_EVERYONE_IGNORE_PLAYER(playIndex, 0)
				Wait(2000)

				if CurrentMission == 1 and MarkedStore == 0 then -- If they're on Mission 1 (market) and we haven't marked a store yet, do so.
					MarkStore()
				end

				if CurrentMission == 2 then -- if they're on Mission 2 (survivors), let them know what they're supposed to be doing.
					if TotalSurvivors > 0 then
						if TotalSurvivors ~= 1 then
							Status = "Search for survivors. There are " .. tostring(TotalSurvivors - RescuedCount) .. " remaining."
						else
							Status = "Search for survivors. There is 1 remaining."
						end
						PRINT_STRING_WITH_LITERAL_STRING_NOW("STRING",Status,5000,1)
					else
						MissionComplete = 1
					end
				end

				if CurrentMission == 2 and SpawnedPeds == 0 then -- If they're on Mission 2 and we haven't spawned the survivors yet, do so.
					SpawnSurvivors()
				end

				if SpawnedPeds == 1 and AllSurvivors[14].rescued == 0 then -- if we've spawned the peds and they haven't rescued Eddie yet, set a
					OpenPrison = 1											-- flag to open the prison doors
				else
					OpenPrison = 0
				end

			end
		end

		if CurrentMission == 1 and MarkedStore == 1 and MissionComplete == 0 then -- if they're on Mission 1, we've marked the store, and they haven't
			local storedistance = {}												-- been there yet, start seeing if they're at the store.
			if IS_OBJECT_ON_SCREEN(ThisMarket.a) == 1 then
				GET_CHAR_COORDINATES(PLAYER_CHAR, x, y, z)
				GET_DISTANCE_BETWEEN_COORDS_3D(x.b, y.b, z.b, f(MarketX), f(MarketY), f(MarketZ), storedistance)
				if (storedistance.a < 1058000000) then
					if MissionComplete == 0 then -- and if they are, add the backpack and other fun stuff
						SET_PLAYER_CONTROL(playIndex, 0)
						SET_EVERYONE_IGNORE_PLAYER(playIndex, 1)
						--DO_SCREEN_FADE_OUT(1000)
						Wait(1000)
						DELETE_OBJECT(ThisMarket)

						SET_CAM_BEHIND_PED(PLAYER_CHAR)
						GET_CHAR_HEADING(PLAYER_CHAR, heading)
						RotatedHeading = heading.b + f(180.00)
						if RotatedHeading > f(360) then
							RotatedHeading = (RotatedHeading - f(360))
						end
						SET_CHAR_HEADING(PLAYER_CHAR, f(RotatedHeading))
						GET_TIME_OF_DAY(gametime, gameday)
						NewTime = gametime.a + 2
						if (NewTime > 24) then
							NewTime = (NewTime - 24)
						end
						FORWARD_TO_TIME_OF_DAY(NewTime, gameday.a)
						SET_CHAR_COMPONENT_VARIATION(PLAYER_CHAR, 3, 3, 0)
						SET_DRAW_PLAYER_COMPONENT(3, 1)
						MissionComplete = 1
						DO_SCREEN_FADE_IN(1000)
						SET_PLAYER_CONTROL(playIndex, 1)
						SET_EVERYONE_IGNORE_PLAYER(playIndex, 0)
						PRINT_STRING_WITH_LITERAL_STRING_NOW("STRING","Return the supplies to the Safe House",5000,1)
					end
				end
			end
		end

		if SpawnedPeds == 1 then -- if we've spawned the survivors

			if OpenPrison == 1 then
					SET_HEADING_OF_CLOSEST_OBJECT_OF_TYPE(f(-1141), f(-372), f(4), f(125.00), 880887899) -- open the prison. This _works_, but not prettily. I can't ever seem to find an angle for the prison door that doesn't look bad.
			end

			PedCount = 1
			while (PedCount <= TotalSurvivors) do
				if DOES_CHAR_EXIST(AllSurvivors[PedCount].a) == 1 then
					if AllSurvivors[PedCount].rescued == 0 then -- if they're not rescued, see if the player is near them
						if IS_CHAR_ON_SCREEN(AllSurvivors[PedCount].a) == 1 then
							local Surx = {}  local Sury = {}  local Surz = {}
							local Playx = {}  local Playy = {}  local Playz = {}
							local SurvivorDistance = {}
							GET_CHAR_COORDINATES(AllSurvivors[PedCount].a, Surx, Sury, Surz)
							GET_CHAR_COORDINATES(PLAYER_CHAR, Playx, Playy, Playz)
							GET_DISTANCE_BETWEEN_COORDS_3D(Surx.b, Sury.b, Surz.b, Playx.b, Playy.b, Playz.b, SurvivorDistance)
							if (SurvivorDistance.a < 1077000000) then
								RescueSurvivor(PedCount)
							end
						else
							SET_CHAR_COORDINATES(AllSurvivors[PedCount].a, f(AllSurvivors[PedCount].x), f(AllSurvivors[PedCount].y), f(AllSurvivors[PedCount].z))
						end
					end

					if (AllSurvivors[PedCount].ingroup == 1) then -- if they're in the group, make sure they're not dead
						intDeadCheck = AllSurvivors[PedCount].a
						if IS_CHAR_DEAD(intDeadCheck) == 1 or IS_CHAR_INJURED(intDeadCheck) == 1 then
							Status = AllSurvivors[PedCount].charname .. " has been injured."
							PRINT_STRING_WITH_LITERAL_STRING_NOW("STRING",Status,5000,1)
							AllSurvivors[PedCount].ingroup = 0
							AllSurvivors[PedCount].alive = 0
							REMOVE_BLIP(AllSurvivors[PedCount].blipID)
							MARK_CHAR_AS_NO_LONGER_NEEDED(AllSurvivors[PedCount])
							SpecialAbilityMsg(0, AllSurvivors[PedCount].charname)
						end
					end
				end

				PedCount = PedCount + 1

			end
		end
	end
end


-- Add all the stores to the list.
AddStore(-1122.2161865234, 1259.0651855469, 24.556758880615)
AddStore(-1084.2779541016, 1341.3344726563, 24.729766845703)
AddStore(-345.23440551758, 243.1234588623, 14.751362800598)
AddStore(-337.37698364258, 1432.2238769531, 12.52840423584)
AddStore(536.03375244141, 1757.9458007813, 33.398246765137)
AddStore(473.84918212891, 1440.1364746094, 9.9798288345337)
AddStore(1435.7370605469, 166.82096862793, 26.971912384033)
AddStore(1265.0144042969, -155.70217895508, 27.566299438477)
AddStore(902.00213623047, -589.98681640625, 13.972413063049)
AddStore(1140.1080322266, -554.76507568359, 13.78694152832)
AddStore(1078.0936279297, -469.22494506836, 13.739429473877)
AddStore(1075.8002929688, 49.184558865408, 34.078987121582)
AddStore(1122.3891601563, 678.07006835938, 37.554859161377)
AddStore(937.73345947266, 41.475666046143, 27.39307975769)

--Add all the survivors to the list.
--AddSurvivor(pedmodel, pedname, gender, weapon, voice, greeting, idleanimgroup, idleanim, pedX, pedY, pedZ, heading, CustomAppearance, zeroCom, oneCom, twoCom, threeCom, fourCom, fiveCom, sevenCom, zeroTex, oneTex, twoTex, threeTex, fourTex, fiveTex, sevenTex)
-- Model, Name, Gender, Weapon, Voice, Greeting, AnimGroup (Not Used), AnimName (Not Used), X, Y, Z, Heading, Custom Appearance, Component 1, 2, 3, 4, 5, 7, Texture 1, 2, 3, 4, 5, 7
AddSurvivor("M_M_CRACKHEAD", "Bubbles", 1, 3, "M_M_CRACKHEAD", "JACKING_CAR_BACK", 0, 0, -1168.5573730469, -558.33832714844, 3.1242787837982, 166.41279602051, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
AddSurvivor("F_Y_STRIPPERC01", "Cherry", 2, 7, "F_Y_STRIPPER_01_BS2", "SURPRISED", 0, 0, 1152.08, 1669.39, 15.72, 0.00, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0)
AddSurvivor("M_Y_DORK_02", "George", 1, 12, "M_Y_DORK_02_BN1", "FIGHT_RUN", "missvlad4", "exhausted_loop", -1569.4229736328, 451.86947631836, 24.948965072632, 15.991188049316, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
AddSurvivor("M_Y_MECHANIC_02", "Sparky", 1, 10, 0, "SAVED", 0, 0, 626.78118896484, 1479.6442871094, 12.863621711731, 159.19625854492, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
AddSurvivor("F_Y_STREET_02", "Sam", 2, 9, "F_Y_STREET_02", "SURPRISED", 0, 0, -897.50598144531, 1511.3675537109, 30.699691772461, 45.00, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
AddSurvivor("M_Y_DRUG_01", "Javier", 1, 13, "M_Y_DRUG_01_BN1", "BUMP", 0, 0, -539.67346191406, 1286.888671875, 113.5433496094, 24.967903137207, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
AddSurvivor("F_O_PORIENT_01", "Ling", 2, 1, "F_O_PORIENT_01", "SAVED", 0, 0, -10.989531517029, -377.09906005859, 12.093002319336, 179.26631164551, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
AddSurvivor("M_M_GUNNUT_01", "Dick", 1, 17, "M_M_GUNNUT_01", "BUMP", 0, 0, -441.89916992188, 1440.9916992188, 37.900485992432, 90, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
AddSurvivor("M_Y_HARLEM_01", "Jerome", 1, 13, "M_Y_HARLEM_01", "SURPRISED", 0, 0, -125.2282333374, 1507.248046875, 101.78469085693, 126.5552444458, 1, 0, 0, 1, 0, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0)
AddSurvivor("M_M_SECURITYMAN", "Winston", 1, 7, "M_M_SECURITYMAN", "MOBILE_INTRO", 0, 0, -419.25561523438, -76.185737609863, 15.538116455078, 36.7165184021, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
AddSurvivor("M_Y_GBIK_LO_01", "Spider", 1, 10, "M_Y_GBIK_HI_01_FULL_01", "MOBILE_INTRO", 0, 0, 1376.3250732422, 193.68511962891, 35.688652038574, 351.78408813477, 1, 0, 1, 0, 0, 0, 0, 1, 2, 1, 1, 0, 0, 0, 0)
AddSurvivor("M_Y_BOUNCER_01", "Mickey", 1, 15, "M_Y_BOUNCER_01", "FOLLOWED_NO", 0, 0, 1068.0135498047, 92.174850463867, 34.251281738281, 111.15854644775, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0)
AddSurvivor("M_M_DODGYDOC", "Doc", 1, 3, "M_M_FACTORY_01", "SAVED", 0, 0, 1243.4555664063, 188.23429870605, 33.553344726563, 263.64724731445, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
AddSurvivor("M_Y_PRISON", "Eddie", 1, 5, "PI_ED_LOW", "BUMP", 0, 0, -1139.6687011719, -324.14407348633, 8.294490814209, 52.100475311279, 1, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0)
AddSurvivor("M_M_PINDUS_02", "Ben", 1, 14, "M_M_PINDUS_02", "THANKS", 0, 0, 1581.0142822266, 863.88922119141, 85.888305664063, 289.07257080078, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)


main();
