--necropolis-nofly.lua

--	NECROPOLIS
--	City of the Dead
--	veaudaux@gmail.com

--Don't get in that helicopter.

--Thanks to Alexander Blade for ALICE, the WaitForPlayerPoolCreation and WaitForValidPlayer functions, and his advice.
--Also, big thanks to zBobG at GTAForums.com for talking Lua and Alice with me, and
--ZAZ for his helpful input.

PLAYER_ID, PLAYER_CHAR = 0
local playIndex = {}
local playrGrp = {}
GROUP_ID = 0

local allSWAT = {}

local swatDec = {}
local swatCombatDec = {}

local x = {}  local y = {}  local z = {}

LOAD_CHAR_DECISION_MAKER(2, swatDec)
LOAD_COMBAT_DECISION_MAKER(9, swatCombatDec)

FoundLowest = 0
Lowest = 0
TotalCount = 0

function WaitForPlayerPoolCreation()
	while (IsPlayerPoolCreated() == 0) do
		Wait(2000)
	end
end

function WaitForValidPlayer()
	PLAYER_CHAR = 0
		repeat
			PLAYER_ID = _GET_PLAYER_ID()
				if (PLAYER_ID >= 0) then
					while true do
						if _IS_PLAYER_PLAYING(PLAYER_ID) == 0
						then Wait(1000)
						else break
						end
				end
			local p = {}
			_GET_PLAYER_CHAR(PLAYER_ID, p)
			PLAYER_CHAR = p.a
				if (PLAYER_CHAR <= 0) then
					Wait(1000)
				end
		end
		until (PLAYER_CHAR > 0)
end

function SetPlayIndex() -- Puts the Player Index into a var called "playIndex"
	PLAYER_ID = _GET_PLAYER_ID()
	playIndex = _CONVERT_INT_TO_PLAYERINDEX(PLAYER_ID)
end

function main()
	WaitForPlayerPoolCreation()
	WaitForValidPlayer()
	SetPlayIndex()

	SET_RELATIONSHIP(5, 0, 24) -- then make group 23 enemies (5) with the player (0)
	SET_RELATIONSHIP(5, 24, 0) -- make the player (0) enemies (5) with group 23

	math.randomseed( os.time() )

	while true do
		if (IS_CHAR_IN_ANY_HELI(PLAYER_CHAR) == 1) then -- if the char is in a helicopter, spawn pissed off swat guys with bazookas.
			local hash = GET_HASH_KEY("M_Y_SWAT")		 -- most of this code is lifted from the GetAPed function in necropolis-main, so look there
			REQUEST_MODEL(hash)							-- for more detailed comments.
			while HAS_MODEL_LOADED(hash) == 0 do Wait(100) end
			local x = {}  local y = {}  local z = {}
			GET_CHAR_COORDINATES(PLAYER_CHAR, x, y, z)
			spawnX = math.random(-10, 10)
			spawnY = math.random(30, 100)
			GET_OFFSET_FROM_CHAR_IN_WORLD_COORDS(PLAYER_CHAR, f(spawnX), f(spawnY), 0, x, y, z)
			GET_GROUND_Z_FOR_3D_COORD(x.b, y.b, z.b, z)
			local c = {}
			CREATE_CHAR(2, hash, x.b, y.b, z.b, c, 1)
			TotalCount = TotalCount + 1
			allSWAT[TotalCount] = c
			SWATid = allSWAT[TotalCount].a
			if (DOES_CHAR_EXIST(SWATid) == 1) then
				GIVE_WEAPON_TO_CHAR(SWATid,18,30000,0)
				SET_CHAR_INVINCIBLE(SWATid, 1)
				SET_CHAR_ACCURACY(SWATid, 100)
				SET_CHAR_RELATIONSHIP_GROUP(SWATid, 24)
				TASK_SET_IGNORE_WEAPON_RANGE_FLAG(PissedPed, 1)
				SET_SENSE_RANGE(SWATid, f(700.0))
				SET_PED_WONT_ATTACK_PLAYER_WITHOUT_WANTED_LEVEL(SWATid, 0)
				TASK_COMBAT_HATED_TARGETS_AROUND_CHAR(SWATid, f(200.0)) -- KILL! KILL! KILL!
			end
			MARK_MODEL_AS_NO_LONGER_NEEDED(hash)
		end

		LivingTotal = 0
		Count = Lowest

		while (Count < TotalCount) do
			Slot = Count + 1
			local DeadCheck = {}
			DeadCheck = allSWAT[Slot]
			intDeadCheck = DeadCheck.a
			if (DOES_CHAR_EXIST(intDeadCheck) == 1) then
				if FoundLowest == 0 then
					FoundLowest = 1
					Lowest = Count
				end
				if (IS_CHAR_INJURED(intDeadCheck) == 1) then
					MARK_CHAR_AS_NO_LONGER_NEEDED(DeadCheck)
				else
					LivingTotal = LivingTotal + 1
					local playx = {}  local playy = {}  local playz = {}
					local pedx = {}  local pedy = {}  local pedz = {}
					GET_CHAR_COORDINATES(PLAYER_CHAR, playx, playy, playz)
					GET_CHAR_COORDINATES(intDeadCheck, pedx, pedy, pedz)
					distance = VDIST(playx.b, playy.b, playz.b, pedx.b, pedy.b, pedz.b)
					if (distance > 1120000000) then
						MARK_CHAR_AS_NO_LONGER_NEEDED(DeadCheck)
					end
				end
			end
			Count = Count + 1
		end

		Wait(500)

	end
end

main();
