--necropolis-police.lua

--	NECROPOLIS
--	City of the Dead
--	veaudaux@gmail.com

--This script controls the player's wanted level.

--Thanks to Alexander Blade for ALICE, the WaitForPlayerPoolCreation and WaitForValidPlayer functions, and his advice.
--Also, big thanks to zBobG at GTAForums.com for talking Lua and Alice with me, and
--ZAZ for his helpful input.

PLAYER_ID, PLAYER_CHAR = 0
local playIndex = {}
local playrGrp = {}
GROUP_ID = 0

function WaitForPlayerPoolCreation()
	while (IsPlayerPoolCreated() == 0) do
		Wait(2000)
	end
end

function WaitForValidPlayer()
	PLAYER_CHAR = 0
		repeat
			PLAYER_ID = _GET_PLAYER_ID()
				if (PLAYER_ID >= 0) then
					while true do
						if _IS_PLAYER_PLAYING(PLAYER_ID) == 0
						then Wait(1000)
						else break
						end
				end
			local p = {}
			_GET_PLAYER_CHAR(PLAYER_ID, p)
			PLAYER_CHAR = p.a
				if (PLAYER_CHAR <= 0) then
					Wait(1000)
				end
		end
		until (PLAYER_CHAR > 0)
end

function SetPlayIndex()
	PLAYER_ID = _GET_PLAYER_ID()
	playIndex = _CONVERT_INT_TO_PLAYERINDEX(PLAYER_ID)
end


function main()
    WaitForPlayerPoolCreation()
    WaitForValidPlayer()
    SetPlayIndex()
	local x = {}  local y = {}  local z = {}
	GET_CHAR_COORDINATES(PLAYER_CHAR, x, y, z) -- where you at?
	CLEAR_AREA_OF_COPS(x.b, y.b, z.b, f(100.0))

	SET_CREATE_RANDOM_COPS(0)
	DONT_DISPATCH_COPS_FOR_PLAYER(playIndex, 1)
	Wait(1000)

	while true do -- this is easy, if they're in a boat or a heli, set a wanted level. if not, and they don't have more than 4 stars, clear the wanted level. otherwise cops come after you for shooting zombies.
		if (IS_CHAR_IN_ANY_HELI(PLAYER_CHAR) == 0) and (IS_CHAR_IN_ANY_BOAT(PLAYER_CHAR) == 0) then
			if (IS_WANTED_LEVEL_GREATER(playIndex, 0) == 1) and (IS_WANTED_LEVEL_GREATER(playIndex, 4) == 0) then
				CLEAR_WANTED_LEVEL()
				SET_CREATE_RANDOM_COPS(0)
				DONT_DISPATCH_COPS_FOR_PLAYER(playIndex, 1)
			end
		else
			DONT_DISPATCH_COPS_FOR_PLAYER(playIndex, 0)
			ALTER_WANTED_LEVEL(playIndex, 6)
			APPLY_WANTED_LEVEL_CHANGE_NOW()
			SET_CREATE_RANDOM_COPS(1)
			Wait(1000)
		end
	end

end

main();
