/*

oooooooooo.  oooooo   oooo       oooooooooooo ooooooooo.   oooooooooooo oooooooooo.
`888'   `Y8b  `888.   .8'        `888'     `8 `888   `Y88. `888'     `8 `888'   `Y8b
 888     888   `888. .8'          888          888   .d88'  888          888      888
 888oooo888'    `888.8'           888oooo8     888ooo88P'   888oooo8     888      888
 888    `88b     `888'            888    "     888`88b.     888    "     888      888
 888    .88P      888             888          888  `88b.   888       o  888     d88'
o888bood8P'      o888o           o888o        o888o  o888o o888ooooood8 o888bood8P'

*/


#include <a_samp>

//Parametre of script
#define MAX_TP 100 //Maximum number of teleportation
#define TPFILE "teleportation.cfg" // file name save the teleportation
#define TPINLINE 10 // Number of TP display on a line in the /tplist
#define SAVETIME 1800000 // Time of timer save tlporation (in MS)
#define COLOR_WHITE  	 0xFFFFFFFF
#define COLOR_GREY  	 0x8D8D8DFF
#define COLOR_GREEN 	 0x429D3DFF
#define COLOR_RED   	 0xBD0000FF

forward SauvegardeTP();

enum TpEnum
{
	Float:PosX,
	Float:PosY,
	Float:PosZ,
	Float:PosA,
	TpName[30],
	TPValid,
}

new TPInfo[MAX_TP][TpEnum];

public OnFilterScriptInit()
{
	print("\n--------------------------------------");
	print(" [FS] Teleportation dynamique By MrFredo  ");
	print("--------------------------------------\n");
	
	if(fexist(TPFILE))
	{
 		print("\n-------------[LOAD TELEPORTATION]-------------\n");
   		new File:TPFile = fopen(TPFILE, io_read);
	    new tpstring[256];
	    new Field[5][128];
	    new NbTP = 0;
   		while(fread(TPFile, tpstring, sizeof(tpstring)))
   		{
   		    if(NbTP >= MAX_TP) break;
	    	if(split(tpstring, Field, ',') == 5)
		    {
		        strmid(TPInfo[NbTP][TpName],   Field[0],0,strlen(Field[0]),30);
				TPInfo[NbTP][PosX]	= floatstr(Field[1]);
				TPInfo[NbTP][PosY]	= floatstr(Field[2]);
				TPInfo[NbTP][PosZ]	= floatstr(Field[3]);
				TPInfo[NbTP][PosA]	= floatstr(Field[4]);
				TPInfo[NbTP][TPValid]  		 = 1;
				printf("Teleportation: %s load",TPInfo[NbTP][TpName]);
				NbTP++;
			}
		}
		fclose(TPFile);
		print("\n");
	}
	else printf("ERROR: The file save teleportation does not exist!");
	
	SetTimer("SauvegardeTP",SAVETIME,1);
	return 1;
}
public OnFilterScriptExit()
{
	SauvegardeTP();
	return 1;
}
public OnPlayerConnect(playerid)
{
	new playername[MAX_PLAYER_NAME],string[128];
	GetPlayerName(playerid,playername,sizeof(playername));
	format(string,sizeof(string),"Hello %s, This server uses [FS] Teleportation dynamique By mister-fred!",playername);
	SendClientMessage(playerid,COLOR_GREEN,string);
}

public OnPlayerCommandText(playerid, cmdtext[])
{
	new cmd[128],string[128],tmp[128];
	new idx;
	cmd = strtok(cmdtext, idx);
	if(strcmp(cmd, "/tp", true) == 0)
	{
		tmp = strtok(cmdtext,idx);
		if(!strlen(tmp))
		{
			SendClientMessage(playerid,COLOR_WHITE,"USE: /tp [name]");
			SendClientMessage(playerid,COLOR_GREY,"Type: /tplist , to see the entire list of the teleportation");
		    return 1;
		}
		for(new t=0;t<MAX_TP;t++)
		{
			if(TPInfo[t][TPValid] == 1)
			{
			    if(strcmp(tmp,TPInfo[t][TpName],true) == 0)
			    {
					if(IsPlayerInAnyVehicle(playerid))
					{
						SetVehiclePos(GetPlayerVehicleID(playerid),TPInfo[t][PosX],TPInfo[t][PosY],TPInfo[t][PosZ]);
			        	SetVehicleZAngle(GetPlayerVehicleID(playerid),TPInfo[t][PosA]);
					}
					else
					{
						SetPlayerPos(playerid,TPInfo[t][PosX],TPInfo[t][PosY],TPInfo[t][PosZ]);
			        	SetPlayerFacingAngle(playerid,TPInfo[t][PosA]);
					}
					format(string,sizeof(string),"~w~Go to %s",TPInfo[t][TpName]);
					GameTextForPlayer(playerid,string,2000,5);
			        return 1;
			    }
			}
		}
		SendClientMessage(playerid,COLOR_GREY,"The name of teleportation does not exist. Type: /tplist , to see the entire list of the teleportation!");
		return 1;
	}
	if(strcmp(cmd, "/addtp",true) == 0)
	{
	    if(!IsPlayerAdmin(playerid))
	    {
	        SendClientMessage(playerid,COLOR_GREY,"You are not allowed to use this command!");
	        return 1;
	    }
		tmp = strtok(cmdtext,idx);
		if(!strlen(tmp))
		{
		    SendClientMessage(playerid,COLOR_WHITE,"USE: /addtp [name]");
		    return 1;
		}
		if(strlen(tmp) > 30)
		{
		    SendClientMessage(playerid,COLOR_RED,"The name of the teleportation can not exceed the 30 character!");
		    return 1;
		}
		for(new t=0;t<MAX_TP;t++)
		{
			if(TPInfo[t][TPValid] == 1)
			{
			    if(strcmp(tmp,TPInfo[t][TpName],true) == 0)
			    {
			        SendClientMessage(playerid,COLOR_RED,"The name of the teleportation already exist");
			        return 1;
			    }
			}
		}
		new Float:x,Float:y,Float:z,Float:a;
		GetPlayerPos(playerid,x,y,z);
		GetPlayerFacingAngle(playerid,a);
		for(new t=0;t<MAX_TP;t++)
		{
		    if(TPInfo[t][TPValid] == 0)
		    {
		        TPInfo[t][PosX] = x;
		        TPInfo[t][PosY] = y;
		        TPInfo[t][PosZ] = z;
		        TPInfo[t][PosA] = a;
		        TPInfo[t][TPValid] = 1;
		        strmid(TPInfo[t][TpName],tmp,0,strlen(tmp),30);
		        SendClientMessage(playerid,COLOR_GREEN,"Type: /tplist , to see the entire list of the teleportation");
		        SauvegardeTP();
		        return 1;
		    }
		}
		SendClientMessage(playerid,COLOR_RED,"An error occurred, the maximum number of tlporation was achieved!");
		return 1;
	}
	if(strcmp(cmd,"/deletetp",true) == 0)
	{
	    if(!IsPlayerAdmin(playerid))
	    {
	        SendClientMessage(playerid,COLOR_GREY,"You are not allowed to use this command!");
	        return 1;
	    }
		tmp = strtok(cmdtext,idx);
		if(!strlen(tmp))
		{
			SendClientMessage(playerid,COLOR_WHITE,"USE: /deletetp [name]");
			SendClientMessage(playerid,COLOR_GREY,"Type: /tplist , to see the entire list of the teleportation");
		    return 1;
		}
		for(new t=0;t<MAX_TP;t++)
		{
			if(TPInfo[t][TPValid] == 1)
			{
			    if(strcmp(tmp,TPInfo[t][TpName],true) == 0)
			    {
			        TPInfo[t][TPValid] = 0;
			        TPInfo[t][PosX] = 0;
			        TPInfo[t][PosY] = 0;
			        TPInfo[t][PosZ] = 0;
			        TPInfo[t][PosA] = 0;
			        SendClientMessage(playerid,COLOR_GREEN,"TP suprimer avec succes!");
			        SauvegardeTP();
			        return 1;
			    }
			}
		}
		SendClientMessage(playerid,COLOR_GREY,"The name of teleportation does not exist. Type: /tplist , to see the entire list of the teleportation!");
	    return 1;
	}
	if(strcmp(cmd,"/tplist",true) == 0)
	{
		new tcount = 0,tp=0;
		new numrow = 0;
		for(new t=0;t<MAX_TP;t++)
		{
			if(TPInfo[t][TPValid] == 1)
			{
			    numrow++;
			}
		}
		if(numrow > 0)
		{
		    SendClientMessage(playerid,COLOR_WHITE,"____________[TELEPORTATION]____________");
			for(new t=0;t<MAX_TP;t++)
			{
				if(TPInfo[t][TPValid] == 1)
				{
					format(string,sizeof(string),"%s %s,",string,TPInfo[t][TpName]);
	   				tp++;
		 			if(tp == TPINLINE || tcount == numrow-1)
		  			{
		  		    	strdel(string,strlen(string)-1,strlen(string));
						SendClientMessage(playerid,COLOR_WHITE,string);
						format(string,sizeof(string),"");
						tp = 0;
					}
	    			tcount++;
				}
			}
			SendClientMessage(playerid,COLOR_WHITE,"__________________________________________");
		}
		else SendClientMessage(playerid,COLOR_RED,"none teleportation!");
		return 1;
	}
	return 0;
}

// Fonction

public SauvegardeTP()
{
	new File:TPFile = fopen(TPFILE, io_write);
	new tpstring[256];
	for(new t=0;t<MAX_TP;t++)
	{
 		if(TPInfo[t][TPValid] == 1)
   		{
			format(tpstring, sizeof(tpstring), "%s,%f,%f,%f,%f\r\n",
			    TPInfo[t][TpName],TPInfo[t][PosX],TPInfo[t][PosY],TPInfo[t][PosZ],TPInfo[t][PosA]);
			fwrite(TPFile, tpstring);
			printf("---- TP %d save! ----",t);
		}
	}
	fclose(TPFile);
}

split(const strsrc[], strdest[][], delimiter)
{
	new i, li,aNum,len;
	while(i <= strlen(strsrc))
	{
	    if(strsrc[i]==delimiter || i==strlen(strsrc))
		{
	        len = strmid(strdest[aNum], strsrc, li, i, 128);
	        strdest[aNum][len] = 0;
	        li = i+1;
	        aNum++;
		}
		i++;
	}
	return aNum;
}

strtok(const string[], &index,seperator=' ')
{
	new length = strlen(string);
	new offset = index;
	new result[128];
	while ((index < length) && (string[index] != seperator) && ((index - offset) < (sizeof(result) - 1)))
	{
		result[index - offset] = string[index];
		index++;
	}

	result[index - offset] = EOS;
	if ((index < length) && (string[index] == seperator))
	{
		index++;
	}
	return result;
}
