//////////////////////////// FlyCam by Abhinav //////////////////
///////////////////////////  Version 1.0 ///////////////////////
////////////////////////////////////////////////////////////////


#include <a_samp>
#define Red 0xFF0000FF
#define Color1 0xBF90B3FF

new mess[128];

new bool:CamMode[MAX_PLAYERS]=false;
new bool:CamFreezeP[MAX_PLAYERS]=false;

new bool:InvertX[MAX_PLAYERS]=false;
new bool:InvertY[MAX_PLAYERS]=false;

new TimerID[MAX_PLAYERS]=0;
new Float:CamSpeed[MAX_PLAYERS]=0.2;

new Float:x[MAX_PLAYERS],Float:y[MAX_PLAYERS],Float:z[MAX_PLAYERS],Float:a[MAX_PLAYERS];
new Float:Camx[MAX_PLAYERS],Float:Camy[MAX_PLAYERS],Float:Camz[MAX_PLAYERS];

new Float:SaveCamX[MAX_PLAYERS],Float:SaveCamY[MAX_PLAYERS],Float:SaveCamZ[MAX_PLAYERS];
new Float:SaveCamRotX[MAX_PLAYERS],Float:SaveCamRotY[MAX_PLAYERS],Float:SaveCamRotZ[MAX_PLAYERS];
new bool:CamSave[MAX_PLAYERS]=false;

new Float:CamRotX[MAX_PLAYERS]=0.0;
new Float:CamRotY[MAX_PLAYERS]=0.0;
new Float:CamRotZ[MAX_PLAYERS]=0.0;

forward CameraMode(playerid);

public OnFilterScriptInit()
{
	print("\n-----------------------");
	print(" FlyCam v1.0 by Abhinav");
    print("-----------------------\n");
	return 1;
}

public OnFilterScriptExit()
{
	return 1;
}

public OnPlayerConnect(playerid)
{
	SendClientMessage(playerid,Color1, "This Server is using Abhinav's FlyCam Filterscript v1.0. Type /camhelp for FlyCam Commands");
	ResetAll(playerid);
	return 1;
}

public OnPlayerDisconnect(playerid, reason)
{
	ResetAll(playerid);
	return 1;
}

public OnPlayerSpawn(playerid)
{
    ResetAll(playerid);
	return 1;
}

public OnPlayerEnterVehicle(playerid, vehicleid, ispassenger)
{
	if(CamMode[playerid]){
	    KillTimer(TimerID[playerid]);
		SetCameraBehindPlayer(playerid);
		CamMode[playerid]=false;
		CamFreezeP[playerid]=false;
		ResetAll(playerid);
		GameTextForPlayer(playerid,"~r~ FlyCam mode OFF",100,1);
		SendClientMessage(playerid,Red,"FlyCam mode was turned off.(NOTE: FlyCam is only supported in non-vehicles mode only.)");
	}
	return 1;
}

public OnPlayerDeath(playerid, killerid, reason)
{
	ResetAll(playerid);
	return 1;
}

public OnPlayerCommandText(playerid, cmdtext[])
{
    if (!strcmp("/camhelp", cmdtext, true, 8))
	{
		SendClientMessage(playerid,Color1,"--------------------- Fly Cam v1.0 By Abhinav ---------------------");
		SendClientMessage(playerid,Color1,"/camera - Toggle FlyCam ON|OFF");
		SendClientMessage(playerid,Color1,"/camspeed - Change the Camera's moving speed.");
		SendClientMessage(playerid,Color1,"/campa - Toggle player movable while in FlyCam mode.");
		SendClientMessage(playerid,Color1,"/cam<save|load|unset> - Save,Load or Unset your camera postions.");
		SendClientMessage(playerid,Color1,"/camtele - Teleport to the Camera.");
		SendClientMessage(playerid,Color1,"/caminx - Invert FlyCam X axis of movement.");
		SendClientMessage(playerid,Color1,"/caminy - Invert FlyCam Y axis of movement");
		SendClientMessage(playerid,Color1,"/caminxy - Invert FlyCam XY axis of movement");
		SendClientMessage(playerid,Color1,"-------------------------------------------------------------------");
	    return 1;
	}
	if (!strcmp("/camera", cmdtext, true, 7))
	{
		if(!CamMode[playerid]){
		    if(IsPlayerInAnyVehicle(playerid)) return SendClientMessage(playerid,Red," FlyCam is currently un-supported for vehicles mode.");
			CamMode[playerid]=true;
			CamFreezeP[playerid]=true;
	  		GetPlayerPos(playerid,x[playerid],y[playerid],z[playerid]);
			GetPlayerFacingAngle(playerid,a[playerid]);
			SetPlayerCameraPos(playerid,x[playerid],y[playerid],z[playerid]+55);
			Camx[playerid]=x[playerid]+0.00001;
			Camy[playerid]=y[playerid]+0.001;
			Camz[playerid]=z[playerid]+54;
			SetPlayerCameraLookAt(playerid,Camx[playerid],Camy[playerid],Camz[playerid]);
			TimerID[playerid]=SetTimerEx("CameraMode",10,1,"%i",playerid);
			GameTextForPlayer(playerid,"~g~ FlyCam mode ON",100,1);
			return 1;
		}
		else{
		    KillTimer(TimerID[playerid]);
			SetCameraBehindPlayer(playerid);
			CamMode[playerid]=false;
			CamFreezeP[playerid]=false;
			ResetAll(playerid);
			GameTextForPlayer(playerid,"~r~ FlyCam mode OFF",100,1);
			return 1;
		}
	}
	
	if (!strcmp("/camspeed", cmdtext, true, 9))
	{
	    if(!CamMode[playerid]) return SendClientMessage(playerid,Red,"You are not in FlyCam Mode");
		if(cmdtext[9] == 0) {
			CamSpeed[playerid]=0.2;
	        SendClientMessage(playerid, Color1, "Your camera speed has been set to deafult, i.e. 0.2");
	        SendClientMessage(playerid, Red, "USAGE: /setcamworld [Speed] (Default is 0.2)");
            return 1;
        }
   		CamSpeed[playerid]=floatstr(cmdtext[10]);
        format(mess,128,"Your camera speed has been set to %f.(Deafult is 0.2)",CamSpeed[playerid]);
        SendClientMessage(playerid, Color1,mess);
		return 1;
	}
	
	if (!strcmp("/campa", cmdtext, true, 5))
	{
	    if(!CamMode[playerid]) return SendClientMessage(playerid,Red,"You are not in FlyCam Mode");
		if(CamFreezeP[playerid]) {
			CamFreezeP[playerid]=false;
	        SendClientMessage(playerid, Color1, "You are now moveables. (NOTE: Moving may be annoying while in camera mode)");
            return 1;
        }
        else{
        	CamFreezeP[playerid]=true;
	        SendClientMessage(playerid, Color1, "You are now freezed. (NOTE: Moving may be annoying while in camera mode)");
            return 1;
        }
	}
	
	if (!strcmp("/camtele", cmdtext, true, 8))
	{
	    if(!CamMode[playerid]) return SendClientMessage(playerid,Red,"You are not in FlyCam Mode");
	    CamFreezeP[playerid]=false;
	    Teleport(playerid,Camx[playerid],Camy[playerid],Camz[playerid]);
	    SendClientMessage(playerid,Color1,"You have been successfully teleported to the FlyCam postion. Enjoy!");
		return 1;
	}
	
	if (!strcmp("/caminxy", cmdtext, true, 8))
	{
	    if(!CamMode[playerid]) return SendClientMessage(playerid,Red,"You are not in FlyCam Mode");
	    if(InvertY[playerid]){
    	    InvertY[playerid]=false;
		}
		else{
		    InvertY[playerid]=true;
		}
		
	    if(InvertX[playerid]){
    	    InvertX[playerid]=false;
		}
		else{
		    InvertX[playerid]=true;
		}
		SendClientMessage(playerid,Color1,"You have inverted the XY axis of movement of FlyCam successfully.");
	    return 1;
	}
	if (!strcmp("/caminx", cmdtext, true, 7))
	{
	    if(!CamMode[playerid]) return SendClientMessage(playerid,Red,"You are not in FlyCam Mode");
	    if(InvertX[playerid]){
    	    InvertX[playerid]=false;
		}
		else{
		    InvertX[playerid]=true;
		}
		SendClientMessage(playerid,Color1,"You have inverted the X axis of movement of FlyCam successfully.");
	    return 1;
	}
	
	if (!strcmp("/caminy", cmdtext, true, 7))
	{
	    if(!CamMode[playerid]) return SendClientMessage(playerid,Red,"You are not in FlyCam Mode");
	    if(InvertY[playerid]){
    	    InvertY[playerid]=false;
		}
		else{
		    InvertY[playerid]=true;
		}
		SendClientMessage(playerid,Color1,"You have inverted the Y axis of movement of FlyCam successfully.");
	    return 1;
	}
	
	if (!strcmp("/camsave", cmdtext, true, 8))
	{
	    if(!CamMode[playerid]) return SendClientMessage(playerid,Red,"You are not in FlyCam Mode");
		CamSave[playerid]=true;
		SaveCamX[playerid]=Camx[playerid];
		SaveCamY[playerid]=Camy[playerid];
		SaveCamZ[playerid]=Camz[playerid];
		SaveCamRotX[playerid]=CamRotX[playerid];
		SaveCamRotY[playerid]=CamRotY[playerid];
		SaveCamRotZ[playerid]=CamRotZ[playerid];
		SendClientMessage(playerid,Color1,"FlyCam position saved! Type /camload to get back to this position");
		return 1;
	}
	
	if (!strcmp("/camload", cmdtext, true, 8))
	{
	    if(!CamMode[playerid]) return SendClientMessage(playerid,Red,"You are not in FlyCam Mode");
       	if(CamSave[playerid]){
			Camx[playerid]=SaveCamX[playerid];
			Camy[playerid]=SaveCamY[playerid];
			Camz[playerid]=SaveCamZ[playerid];

			CamRotX[playerid]=SaveCamRotX[playerid];
			CamRotY[playerid]=SaveCamRotY[playerid];
			CamRotZ[playerid]=SaveCamRotZ[playerid];
			SetPlayerCameraLookAt(playerid,Camx[playerid]+CamRotX[playerid],Camy[playerid]+CamRotY[playerid],Camz[playerid]+CamRotZ[playerid]-1);
        	SetPlayerCameraPos(playerid,Camx[playerid],Camy[playerid],Camz[playerid]);
			SendClientMessage(playerid,Color1,"FlyCam saved postion loaded sucessfully!");
			return 1;
		}
		else{
			SendClientMessage(playerid,Red,"No FlyCam postion saved");
			return 1;
		}
		
	}
	
	if (!strcmp("/camunset", cmdtext, true, 9))
	{
	    if(!CamMode[playerid]) return SendClientMessage(playerid,Red,"You are not in FlyCam Mode");
	    if(CamSave[playerid]){
	        CamSave[playerid]=false;
	        SendClientMessage(playerid,Color1,"FlyCam saved postion cleared!");
	        return 1;
		}
	    else{
			SendClientMessage(playerid,Red,"No FlyCam postion saved");
	        return 1;
	    }
	    
	}
	return 0;
}

public CameraMode(playerid){
	if(IsPlayerConnected(playerid) && CamMode[playerid]){
        new keys, updown, leftright;
		GetPlayerKeys(playerid, keys, updown, leftright);
		GetPlayerPos(playerid,x[playerid],y[playerid],z[playerid]);
		if(CamFreezeP[playerid]){
			Teleport(playerid,x[playerid],y[playerid],z[playerid]);
		}
        if(updown == KEY_UP)
        {
            if(InvertX[playerid]){
              	Camx[playerid]=Camx[playerid]-CamSpeed[playerid];
			}
			else{
			    Camx[playerid]=Camx[playerid]+CamSpeed[playerid];
			}
			
			Camy[playerid]=Camy[playerid];
			Camz[playerid]=Camz[playerid];
   			SetPlayerCameraLookAt(playerid,Camx[playerid]+CamRotX[playerid],Camy[playerid]+CamRotY[playerid],Camz[playerid]+CamRotZ[playerid]-1);
        	SetPlayerCameraPos(playerid,Camx[playerid],Camy[playerid],Camz[playerid]);
			
        }
        if(updown == KEY_DOWN)
        {
            if(InvertX[playerid]){
              	Camx[playerid]=Camx[playerid]+CamSpeed[playerid];
			}
			else{
			    Camx[playerid]=Camx[playerid]-CamSpeed[playerid];
			}
			Camy[playerid]=Camy[playerid];
			Camz[playerid]=Camz[playerid];
			SetPlayerCameraPos(playerid,Camx[playerid],Camy[playerid],Camz[playerid]);
   			SetPlayerCameraLookAt(playerid,Camx[playerid]+CamRotX[playerid],Camy[playerid]+CamRotY[playerid],Camz[playerid]+CamRotZ[playerid]-1);

        }
        if(leftright == KEY_LEFT)
        {
        	
        	Camx[playerid]=Camx[playerid];
            if(InvertY[playerid]){
              	Camy[playerid]=Camy[playerid]-CamSpeed[playerid];
			}
			else{
			    Camy[playerid]=Camy[playerid]+CamSpeed[playerid];
			}
			Camz[playerid]=Camz[playerid];
			SetPlayerCameraPos(playerid,Camx[playerid],Camy[playerid],Camz[playerid]);
   			SetPlayerCameraLookAt(playerid,Camx[playerid]+CamRotX[playerid],Camy[playerid]+CamRotY[playerid],Camz[playerid]+CamRotZ[playerid]-1);

        }
        if(leftright == KEY_RIGHT)
        {

        	Camx[playerid]=Camx[playerid];
            if(InvertY[playerid]){
              	Camy[playerid]=Camy[playerid]+CamSpeed[playerid];
			}
			else{
			    Camy[playerid]=Camy[playerid]-CamSpeed[playerid];
			}
			Camz[playerid]=Camz[playerid];
			SetPlayerCameraPos(playerid,Camx[playerid],Camy[playerid],Camz[playerid]);
   			SetPlayerCameraLookAt(playerid,Camx[playerid]+CamRotX[playerid],Camy[playerid]+CamRotY[playerid],Camz[playerid]+CamRotZ[playerid]-1);

        }
        if(keys == KEY_CROUCH && Camz[playerid]>=0)
        {
           	Camx[playerid]=Camx[playerid];
			Camy[playerid]=Camy[playerid];
			Camz[playerid]=Camz[playerid]-CamSpeed[playerid];
			SetPlayerCameraPos(playerid,Camx[playerid],Camy[playerid],Camz[playerid]);
   			SetPlayerCameraLookAt(playerid,Camx[playerid]+CamRotX[playerid],Camy[playerid]+CamRotY[playerid],Camz[playerid]+CamRotZ[playerid]-1);
        }
        if(keys == KEY_JUMP && Camz[playerid]<=1500)
        {
           	Camx[playerid]=Camx[playerid];
			Camy[playerid]=Camy[playerid];
			Camz[playerid]=Camz[playerid]+CamSpeed[playerid];
			SetPlayerCameraPos(playerid,Camx[playerid],Camy[playerid],Camz[playerid]);
   			SetPlayerCameraLookAt(playerid,Camx[playerid]+CamRotX[playerid],Camy[playerid]+CamRotY[playerid],Camz[playerid]+CamRotZ[playerid]-1);
        }
        if(keys == KEY_WALK && CamRotX[playerid]<=9.0)
        {
            CamRotX[playerid]=CamRotX[playerid]+0.01;
			SetPlayerCameraPos(playerid,Camx[playerid],Camy[playerid],Camz[playerid]);
   			SetPlayerCameraLookAt(playerid,Camx[playerid]+CamRotX[playerid],Camy[playerid]+CamRotY[playerid],Camz[playerid]+CamRotZ[playerid]-1);
        }
        if(keys == KEY_SPRINT && CamRotX[playerid]>=-9.0)
        {
            CamRotX[playerid]=CamRotX[playerid]-0.01;
			SetPlayerCameraPos(playerid,Camx[playerid],Camy[playerid],Camz[playerid]);
   			SetPlayerCameraLookAt(playerid,Camx[playerid]+CamRotX[playerid],Camy[playerid]+CamRotY[playerid],Camz[playerid]+CamRotZ[playerid]-1);
        }
        if(keys == KEY_LOOK_BEHIND && CamRotY[playerid]<=9.0)
        {
            CamRotY[playerid]=CamRotY[playerid]+0.01;
			SetPlayerCameraPos(playerid,Camx[playerid],Camy[playerid],Camz[playerid]);
   			SetPlayerCameraLookAt(playerid,Camx[playerid]+CamRotX[playerid],Camy[playerid]+CamRotY[playerid],Camz[playerid]+CamRotZ[playerid]-1);
        }
        if(keys == KEY_HANDBRAKE && CamRotY[playerid]>=-9.0)
        {
            CamRotY[playerid]=CamRotY[playerid]-0.01;
			SetPlayerCameraPos(playerid,Camx[playerid],Camy[playerid],Camz[playerid]);
   			SetPlayerCameraLookAt(playerid,Camx[playerid]+CamRotX[playerid],Camy[playerid]+CamRotY[playerid],Camz[playerid]+CamRotZ[playerid]-1);
        }
	}
	return 1;
}

ResetAll(playerid){
	CamMode[playerid]=false;
	CamFreezeP[playerid]=false;
	TimerID[playerid]=0;
	CamSpeed[playerid]=0.2;
	CamRotX[playerid]=0.0;
	CamRotY[playerid]=0.0;
	CamSave[playerid]=false;
	return 1;
}

Teleport(playerid,Float:x1,Float:y1,Float:z1){
	SetPlayerPos(playerid,x1,y1,z1);
	SetPlayerInterior(playerid,0);
	return 1;
}
