//-------------------------------------------------
//
//  Simple photo gallery script.
//  by Lj - 2009.
//
//-------------------------------------------------

#include <a_samp>
#define KEY_AIM 128

enum SavePosENUM { Float:picX, Float:picY, Float:picZ, Float:picA, SavedPos };
new SavePos[MAX_PLAYERS][SavePosENUM];
new PosI[MAX_PLAYERS];

enum LastPosENUM { Float:X, Float:Y, Float:Z, Float:A };
new LastPos[MAX_PLAYERS][LastPosENUM];
new Pos2I[MAX_PLAYERS];

new Beepy;
new IsViewing[MAX_PLAYERS];
new Clear;

forward AutoClear(playerid);
forward Beep(playerid);

#define COLOR_RED 0xFF0000AA
#define COLOR_SYSTEM 0xEFEFF7AA
//-------------------------------------------------

public OnFilterScriptInit()
{
	return 1;
}

public OnPlayerCommandText(playerid, cmdtext[])
{
    if(strcmp(cmdtext, "/viewphoto", true) == 0)
	{
	    if(SavePos[playerid][SavedPos] == 0)
		{
			SendClientMessage(playerid, COLOR_SYSTEM, ">> You haven't taken a photo. - You can take one by equipting a camera, aiming and pressing the FIRE key on your mouse.");
		}
		else
		{
		    GetPlayerPos(playerid, LastPos[playerid][X], LastPos[playerid][Y], LastPos[playerid][Z]);
			GetPlayerFacingAngle(playerid, LastPos[playerid][A]);
			Pos2I[playerid] = (GetPlayerInterior(playerid));
		    TogglePlayerControllable(playerid, false);
		    SetPlayerPos(playerid, SavePos[playerid][picX], SavePos[playerid][picY], SavePos[playerid][picZ]+10);
			SetPlayerCameraPos(playerid, SavePos[playerid][picX], SavePos[playerid][picY], SavePos[playerid][picZ]);
			#define DISTANCE 10.0
			SetPlayerCameraLookAt(playerid, SavePos[playerid][picX] + DISTANCE * floatsin(-SavePos[playerid][picA], degrees), SavePos[playerid][picY] + DISTANCE * floatcos(-SavePos[playerid][picA], degrees), SavePos[playerid][picZ]);
			SetPlayerInterior(playerid, PosI[playerid]);
			Clear = SetTimerEx("AutoClear", 8000, false, "i", playerid);
			SendClientMessage(playerid, COLOR_SYSTEM, ">>     8 . -     .");
			Beepy = SetTimerEx("Beep", 1000, true, "i", playerid);
			ResetPlayerWeapons(playerid);
			IsViewing[playerid] = 1;
			SetPlayerVirtualWorld(playerid, 6);
		}
	    return 1;
	}
	return 0;
}


public OnPlayerKeyStateChange(playerid, newkeys, oldkeys)
{
	if (GetPlayerWeapon(playerid) == 43 && newkeys & KEY_FIRE && oldkeys & KEY_AIM)
	{
	    GetPlayerPos(playerid, SavePos[playerid][picX], SavePos[playerid][picY], SavePos[playerid][picZ]);
		GetPlayerFacingAngle(playerid, SavePos[playerid][picA]);
		PosI[playerid] = (GetPlayerInterior(playerid));
		SavePos[playerid][SavedPos] = 1;
		GameTextForPlayer(playerid, "~w~Photo Taken! ~n~~r~/viewphoto ~w~to view it!", 2500, 5);
	}
	if (IsViewing[playerid] == 1 && newkeys & KEY_FIRE)
	{
		SetPlayerPos(playerid, LastPos[playerid][X], LastPos[playerid][Y], LastPos[playerid][Z]);
		SetPlayerFacingAngle(playerid, LastPos[playerid][A]);
    	SetCameraBehindPlayer(playerid);
    	SetPlayerInterior(playerid, Pos2I[playerid]);
    	TogglePlayerControllable(playerid, true);
    	KillTimer(Beepy);
    	KillTimer(Clear);
    	GivePlayerWeapon(playerid, 43, 10);
    	SetPlayerVirtualWorld(playerid, 0);
	}
	return 1;
}

public AutoClear(playerid)
{
    SetPlayerPos(playerid, LastPos[playerid][X], LastPos[playerid][Y], LastPos[playerid][Z]);
	SetPlayerFacingAngle(playerid, LastPos[playerid][A]);
    SetCameraBehindPlayer(playerid);
    SetPlayerInterior(playerid, Pos2I[playerid]);
    TogglePlayerControllable(playerid, true);
    KillTimer(Beepy);
    GameTextForPlayer(playerid, "~w~Photo Reset!", 2500, 5);
    GivePlayerWeapon(playerid, 43, 10);
    SavePos[playerid][SavedPos] = 0;
    SetPlayerVirtualWorld(playerid, 0);
	return 1;
}

public Beep(playerid)
{
    PlayerPlaySound(playerid, 1137, 0.0, 0.0, 0.0);
	return 1;
}
